/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage.row;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.bloom.BloomFilter;
import org.apache.hudi.common.bloom.BloomFilterFactory;
import org.apache.hudi.common.bloom.BloomFilterTypeCode;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.io.storage.row.HoodieInternalRowParquetWriter;
import org.apache.hudi.io.storage.row.HoodieRowParquetWriteSupport;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.testutils.HoodieSparkClientTestHarness;
import org.apache.hudi.testutils.SparkDatasetTestUtils;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.encoders.ExpressionEncoder;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

public class TestHoodieInternalRowParquetWriter
extends HoodieSparkClientTestHarness {
    @BeforeEach
    public void setUp() throws Exception {
        this.initSparkContexts("TestHoodieInternalRowParquetWriter");
        this.initPath();
        this.initHoodieStorage();
        this.initTestDataGenerator();
        this.initMetaClient();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanupResources();
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    public void testProperWriting(boolean parquetWriteLegacyFormatEnabled) throws Exception {
        Dataset inputRows = SparkDatasetTestUtils.getRandomRows((SQLContext)this.sqlContext, (int)100, (String)"2016/03/15", (boolean)false);
        StructType schema = inputRows.schema();
        List rows = SparkDatasetTestUtils.toInternalRows((Dataset)inputRows, (ExpressionEncoder)SparkDatasetTestUtils.ENCODER);
        HoodieWriteConfig.Builder writeConfigBuilder = SparkDatasetTestUtils.getConfigBuilder((String)this.basePath, (int)timelineServicePort);
        HoodieRowParquetWriteSupport writeSupport = this.getWriteSupport(writeConfigBuilder, (Configuration)this.storageConf.unwrap(), parquetWriteLegacyFormatEnabled);
        HoodieWriteConfig cfg = writeConfigBuilder.build();
        HoodieParquetConfig parquetConfig = new HoodieParquetConfig((Object)writeSupport, CompressionCodecName.SNAPPY, cfg.getParquetBlockSize(), cfg.getParquetPageSize(), cfg.getParquetMaxFileSize(), (StorageConfiguration)new HadoopStorageConfiguration(writeSupport.getHadoopConf()), cfg.getParquetCompressionRatio(), cfg.parquetDictionaryEnabled());
        StoragePath filePath = new StoragePath(this.basePath + "/internal_row_writer.parquet");
        try (HoodieInternalRowParquetWriter writer = new HoodieInternalRowParquetWriter(filePath, parquetConfig);){
            for (InternalRow row : rows) {
                writer.writeRow(row.getUTF8String(schema.fieldIndex("record_key")), row);
            }
        }
        Dataset result = this.sqlContext.read().parquet(this.basePath);
        Assertions.assertEquals((long)0L, (long)inputRows.except(result).count());
        List<String> recordKeys = rows.stream().map(r -> r.getString(schema.fieldIndex("record_key"))).collect(Collectors.toList());
        String minKey = (String)recordKeys.stream().min(Comparator.naturalOrder()).get();
        String maxKey = (String)recordKeys.stream().max(Comparator.naturalOrder()).get();
        FileMetaData parquetMetadata = ParquetUtils.readMetadata((HoodieStorage)this.storage, (StoragePath)filePath).getFileMetaData();
        Map extraMetadata = parquetMetadata.getKeyValueMetaData();
        Assertions.assertEquals(extraMetadata.get("hoodie_min_record_key"), (Object)minKey);
        Assertions.assertEquals(extraMetadata.get("hoodie_max_record_key"), (Object)maxKey);
        Assertions.assertEquals(extraMetadata.get("hoodie_bloom_filter_type_code"), (Object)BloomFilterTypeCode.DYNAMIC_V0.name());
        BloomFilter bloomFilter = new ParquetUtils().readBloomFilterFromMetadata(this.storage, filePath);
        recordKeys.forEach(recordKey -> Assertions.assertTrue((boolean)bloomFilter.mightContain(recordKey)));
    }

    private HoodieRowParquetWriteSupport getWriteSupport(HoodieWriteConfig.Builder writeConfigBuilder, Configuration hadoopConf, boolean parquetWriteLegacyFormatEnabled) {
        writeConfigBuilder.withStorageConfig(HoodieStorageConfig.newBuilder().parquetWriteLegacyFormat(String.valueOf(parquetWriteLegacyFormatEnabled)).build());
        HoodieWriteConfig writeConfig = writeConfigBuilder.build();
        BloomFilter filter = BloomFilterFactory.createBloomFilter((int)writeConfig.getBloomFilterNumEntries(), (double)writeConfig.getBloomFilterFPP(), (int)writeConfig.getDynamicBloomFilterMaxNumEntries(), (String)writeConfig.getBloomFilterType());
        return HoodieRowParquetWriteSupport.getHoodieRowParquetWriteSupport((Configuration)hadoopConf, (StructType)SparkDatasetTestUtils.STRUCT_TYPE, (Option)Option.of((Object)filter), (HoodieConfig)writeConfig);
    }
}

