/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Properties;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.AvroConversionUtils;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.common.config.TimestampKeyGeneratorConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.exception.HoodieKeyGeneratorException;
import org.apache.hudi.keygen.BuiltinKeyGenerator;
import org.apache.hudi.keygen.TimestampBasedKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.testutils.KeyGeneratorTestUtilities;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.Function1;

public class TestTimestampBasedKeyGenerator {
    private GenericRecord baseRecord;
    private TypedProperties properties = new TypedProperties();
    private Schema schema;
    private StructType structType;
    private Row baseRow;
    private InternalRow internalRow;

    @BeforeEach
    public void initialize() throws IOException {
        this.schema = SchemaTestUtil.getTimestampEvolvedSchema();
        this.structType = AvroConversionUtils.convertAvroSchemaToStructType((Schema)this.schema);
        this.baseRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema, (int)1, (String)"001", (String)"f1");
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        this.internalRow = KeyGeneratorTestUtilities.getInternalRow(this.baseRow);
        this.properties.setProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), "field1");
        this.properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), "createTime");
        this.properties.setProperty(KeyGeneratorOptions.HIVE_STYLE_PARTITIONING_ENABLE.key(), "false");
    }

    private Row genericRecordToRow(GenericRecord baseRecord) {
        Function1 convertor = AvroConversionUtils.createConverterToRow((Schema)baseRecord.getSchema(), (StructType)this.structType);
        Row row = (Row)convertor.apply((Object)baseRecord);
        int fieldCount = this.structType.fieldNames().length;
        Object[] values = new Object[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            values[i] = row.get(i);
        }
        return new GenericRowWithSchema(values, this.structType);
    }

    private TypedProperties getBaseKeyConfig(String partitionPathField, String timestampType, String dateFormat, String timezone, String scalarType) {
        TypedProperties properties = TypedProperties.copy((Properties)this.properties);
        properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), partitionPathField);
        properties.setProperty(TimestampKeyGeneratorConfig.TIMESTAMP_TYPE_FIELD.key(), timestampType);
        properties.setProperty(TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_DATE_FORMAT.key(), dateFormat);
        properties.setProperty(TimestampKeyGeneratorConfig.TIMESTAMP_TIMEZONE_FORMAT.key(), timezone);
        if (scalarType != null) {
            properties.setProperty("hoodie.deltastreamer.keygen.timebased.timestamp.scalar.time.unit", scalarType);
        }
        return properties;
    }

    private TypedProperties getBaseKeyConfig(String partitionPathField, String timestampType, String inputFormatList, String inputFormatDelimiterRegex, String inputTimezone, String outputFormat, String outputTimezone) {
        TypedProperties properties = TypedProperties.copy((Properties)this.properties);
        properties.setProperty(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), partitionPathField);
        if (timestampType != null) {
            properties.setProperty(TimestampKeyGeneratorConfig.TIMESTAMP_TYPE_FIELD.key(), timestampType);
        }
        if (inputFormatList != null) {
            properties.setProperty(TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT.key(), inputFormatList);
        }
        if (inputFormatDelimiterRegex != null) {
            properties.setProperty(TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_DATE_FORMAT_LIST_DELIMITER_REGEX.key(), inputFormatDelimiterRegex);
        }
        if (inputTimezone != null) {
            properties.setProperty(TimestampKeyGeneratorConfig.TIMESTAMP_INPUT_TIMEZONE_FORMAT.key(), inputTimezone);
        }
        if (outputFormat != null) {
            properties.setProperty(TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_DATE_FORMAT.key(), outputFormat);
        }
        if (outputTimezone != null) {
            properties.setProperty(TimestampKeyGeneratorConfig.TIMESTAMP_OUTPUT_TIMEZONE_FORMAT.key(), outputTimezone);
        }
        return properties;
    }

    @Test
    public void testTimestampBasedKeyGenerator() throws IOException {
        this.baseRecord.put("createTime", (Object)1578283932000L);
        this.properties = this.getBaseKeyConfig("createTime", "EPOCHMILLISECONDS", "yyyy-MM-dd hh", "GMT+8:00", null);
        TimestampBasedKeyGenerator keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk1 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020-01-06 12", (Object)hk1.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2020-01-06 12", (Object)keyGen.getPartitionPath(this.baseRow));
        this.internalRow = KeyGeneratorTestUtilities.getInternalRow(this.baseRow);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"2020-01-06 12"), (Object)keyGen.getPartitionPath(this.internalRow, this.baseRow.schema()));
        BigDecimal decimal = new BigDecimal("1578283932000.0001");
        Conversions.DecimalConversion conversion = new Conversions.DecimalConversion();
        Schema resolvedNullableSchema = AvroSchemaUtils.resolveNullableSchema((Schema)this.schema.getField("createTimeDecimal").schema());
        GenericFixed avroDecimal = conversion.toFixed(decimal, resolvedNullableSchema, (LogicalType)LogicalTypes.decimal((int)20, (int)4));
        this.baseRecord.put("createTimeDecimal", (Object)avroDecimal);
        this.properties = this.getBaseKeyConfig("createTimeDecimal", "EPOCHMILLISECONDS", "yyyy-MM-dd hh", "GMT+8:00", null);
        keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey bigDecimalKey = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020-01-06 12", (Object)bigDecimalKey.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2020-01-06 12", (Object)keyGen.getPartitionPath(this.baseRow));
        this.properties = this.getBaseKeyConfig("createTime", "EPOCHMILLISECONDS", "yyyy-MM-dd hh", "GMT", null);
        keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk2 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020-01-06 04", (Object)hk2.getPartitionPath());
        Assertions.assertEquals((Object)"2020-01-06 04", (Object)keyGen.getPartitionPath(this.baseRow));
        this.baseRecord.put("createTimeString", (Object)"2020-01-06 12:12:12");
        this.properties = this.getBaseKeyConfig("createTimeString", "DATE_STRING", "yyyy-MM-dd hh", "GMT+8:00", null);
        this.properties.setProperty("hoodie.deltastreamer.keygen.timebased.input.dateformat", "yyyy-MM-dd hh:mm:ss");
        keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk3 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020-01-06 12", (Object)hk3.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2020-01-06 12", (Object)keyGen.getPartitionPath(this.baseRow));
        this.properties = this.getBaseKeyConfig("createTimeString", "DATE_STRING", "yyyy-MM-dd hh", "GMT", null);
        keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk4 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020-01-06 12", (Object)hk4.getPartitionPath());
        Assertions.assertEquals((Object)"2020-01-06 12", (Object)keyGen.getPartitionPath(this.baseRow));
        this.baseRecord.put("createTime", null);
        this.properties = this.getBaseKeyConfig("createTime", "EPOCHMILLISECONDS", "yyyy-MM-dd hh", "GMT+8:00", null);
        keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk5 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"1970-01-01 08", (Object)hk5.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"1970-01-01 08", (Object)keyGen.getPartitionPath(this.baseRow));
        this.internalRow = KeyGeneratorTestUtilities.getInternalRow(this.baseRow);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"1970-01-01 08"), (Object)keyGen.getPartitionPath(this.internalRow, this.baseRow.schema()));
        this.baseRecord.put("createTimeString", null);
        this.properties = this.getBaseKeyConfig("createTime", "DATE_STRING", "yyyy-MM-dd hh:mm:ss", "GMT", null);
        this.properties.setProperty("hoodie.deltastreamer.keygen.timebased.input.dateformat", "yyyy-MM-dd hh:mm:ss");
        keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk6 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"1970-01-01 12:00:00", (Object)hk6.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"1970-01-01 12:00:00", (Object)keyGen.getPartitionPath(this.baseRow));
        this.internalRow = KeyGeneratorTestUtilities.getInternalRow(this.baseRow);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"1970-01-01 12:00:00"), (Object)keyGen.getPartitionPath(this.internalRow, this.baseRow.schema()));
        this.baseRecord.put("createTime", (Object)1578283932123456L);
        this.properties = this.getBaseKeyConfig("createTime", "EPOCHMICROSECONDS", "yyyy-MM-dd hh", "GMT+8:00", null);
        keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey key = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020-01-06 12", (Object)key.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2020-01-06 12", (Object)keyGen.getPartitionPath(this.baseRow));
        this.internalRow = KeyGeneratorTestUtilities.getInternalRow(this.baseRow);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"2020-01-06 12"), (Object)keyGen.getPartitionPath(this.internalRow, this.baseRow.schema()));
        decimal = new BigDecimal("1578283932123456.0001");
        resolvedNullableSchema = AvroSchemaUtils.resolveNullableSchema((Schema)this.schema.getField("createTimeDecimal").schema());
        avroDecimal = conversion.toFixed(decimal, resolvedNullableSchema, (LogicalType)LogicalTypes.decimal((int)20, (int)4));
        this.baseRecord.put("createTimeDecimal", (Object)avroDecimal);
        this.properties = this.getBaseKeyConfig("createTimeDecimal", "EPOCHMICROSECONDS", "yyyy-MM-dd hh", "GMT+8:00", null);
        keyGen = new TimestampBasedKeyGenerator(this.properties);
        bigDecimalKey = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020-01-06 12", (Object)bigDecimalKey.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2020-01-06 12", (Object)keyGen.getPartitionPath(this.baseRow));
    }

    @Test
    public void testScalar() throws IOException {
        this.baseRecord.put("createTime", (Object)20000L);
        this.properties = this.getBaseKeyConfig("createTime", "SCALAR", "yyyy-MM-dd hh", "GMT", "days");
        TimestampBasedKeyGenerator keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk1 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)hk1.getPartitionPath(), (Object)"2024-10-04 12");
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2024-10-04 12", (Object)keyGen.getPartitionPath(this.baseRow));
        this.internalRow = KeyGeneratorTestUtilities.getInternalRow(this.baseRow);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"2024-10-04 12"), (Object)keyGen.getPartitionPath(this.internalRow, this.baseRow.schema()));
        this.baseRecord.put("createTime", null);
        this.properties = this.getBaseKeyConfig("createTime", "SCALAR", "yyyy-MM-dd hh", "GMT", "days");
        keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk2 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"1970-01-02 12", (Object)hk2.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"1970-01-02 12", (Object)keyGen.getPartitionPath(this.baseRow));
        this.internalRow = KeyGeneratorTestUtilities.getInternalRow(this.baseRow);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"1970-01-02 12"), (Object)keyGen.getPartitionPath(this.internalRow, this.baseRow.schema()));
        this.baseRecord.put("createTime", (Object)18736L);
        this.properties = this.getBaseKeyConfig("createTime", "SCALAR", "yyyy-MM-dd", "GMT", "DAYS");
        keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey scalarSecondsKey = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2021-04-19", (Object)scalarSecondsKey.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2021-04-19", (Object)keyGen.getPartitionPath(this.baseRow));
    }

    @Test
    public void testScalarWithLogicalType() throws IOException {
        this.schema = SchemaTestUtil.getTimestampWithLogicalTypeSchema();
        this.structType = AvroConversionUtils.convertAvroSchemaToStructType((Schema)this.schema);
        this.baseRecord = SchemaTestUtil.generateAvroRecordFromJson((Schema)this.schema, (int)1, (String)"001", (String)"f1");
        this.baseRecord.put("createTime", (Object)1638513806000000L);
        this.properties = this.getBaseKeyConfig("createTime", "SCALAR", "yyyy/MM/dd", "GMT", "MICROSECONDS");
        this.properties.setProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), "true");
        TimestampBasedKeyGenerator keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk1 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2021/12/03", (Object)hk1.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2021/12/03", (Object)keyGen.getPartitionPath(this.baseRow));
        this.internalRow = KeyGeneratorTestUtilities.getInternalRow(this.baseRow);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"2021/12/03"), (Object)keyGen.getPartitionPath(this.internalRow, this.baseRow.schema()));
        this.baseRecord.put("createTime", null);
        this.properties = this.getBaseKeyConfig("createTime", "SCALAR", "yyyy/MM/dd", "GMT", "MICROSECONDS");
        this.properties.setProperty(KeyGeneratorOptions.KEYGENERATOR_CONSISTENT_LOGICAL_TIMESTAMP_ENABLED.key(), "true");
        keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk2 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"1970/01/01", (Object)hk2.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"1970/01/01", (Object)keyGen.getPartitionPath(this.baseRow));
        this.internalRow = KeyGeneratorTestUtilities.getInternalRow(this.baseRow);
        Assertions.assertEquals((Object)UTF8String.fromString((String)"1970/01/01"), (Object)keyGen.getPartitionPath(this.internalRow, this.baseRow.schema()));
    }

    @Test
    public void test_ExpectsMatch_SingleInputFormat_ISO8601WithMsZ_OutputTimezoneAsUTC() throws IOException {
        this.baseRecord.put("createTimeString", (Object)"2020-04-01T13:01:33.428Z");
        this.properties = this.getBaseKeyConfig("createTimeString", "DATE_STRING", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "", "", "yyyyMMddHH", "GMT");
        TimestampBasedKeyGenerator keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk1 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020040113", (Object)hk1.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2020040113", (Object)keyGen.getPartitionPath(this.baseRow));
    }

    @Test
    public void test_ExpectsMatch_SingleInputFormats_ISO8601WithMsZ_OutputTimezoneAsInputDateTimeZone() throws IOException {
        this.baseRecord.put("createTimeString", (Object)"2020-04-01T13:01:33.428Z");
        this.properties = this.getBaseKeyConfig("createTimeString", "DATE_STRING", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "", "", "yyyyMMddHH", "");
        TimestampBasedKeyGenerator keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk1 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020040113", (Object)hk1.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2020040113", (Object)keyGen.getPartitionPath(this.baseRow));
    }

    @Test
    public void test_ExpectsMatch_MultipleInputFormats_ISO8601WithMsZ_OutputTimezoneAsUTC() throws IOException {
        this.baseRecord.put("createTimeString", (Object)"2020-04-01T13:01:33.428Z");
        this.properties = this.getBaseKeyConfig("createTimeString", "DATE_STRING", "yyyy-MM-dd'T'HH:mm:ssZ,yyyy-MM-dd'T'HH:mm:ss.SSSZ", "", "", "yyyyMMddHH", "UTC");
        TimestampBasedKeyGenerator keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk1 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020040113", (Object)hk1.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2020040113", (Object)keyGen.getPartitionPath(this.baseRow));
    }

    @Test
    public void test_ExpectsMatch_MultipleInputFormats_ISO8601NoMsZ_OutputTimezoneAsUTC() throws IOException {
        this.baseRecord.put("createTimeString", (Object)"2020-04-01T13:01:33Z");
        this.properties = this.getBaseKeyConfig("createTimeString", "DATE_STRING", "yyyy-MM-dd'T'HH:mm:ssZ,yyyy-MM-dd'T'HH:mm:ss.SSSZ", "", "", "yyyyMMddHH", "UTC");
        TimestampBasedKeyGenerator keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk1 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020040113", (Object)hk1.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2020040113", (Object)keyGen.getPartitionPath(this.baseRow));
    }

    @Test
    public void test_ExpectsMatch_MultipleInputFormats_ISO8601NoMsWithOffset_OutputTimezoneAsUTC() throws IOException {
        this.baseRecord.put("createTimeString", (Object)"2020-04-01T13:01:33-05:00");
        this.properties = this.getBaseKeyConfig("createTimeString", "DATE_STRING", "yyyy-MM-dd'T'HH:mm:ssZ,yyyy-MM-dd'T'HH:mm:ss.SSSZ", "", "", "yyyyMMddHH", "UTC");
        TimestampBasedKeyGenerator keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk1 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020040118", (Object)hk1.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2020040118", (Object)keyGen.getPartitionPath(this.baseRow));
    }

    @Test
    public void test_ExpectsMatch_MultipleInputFormats_ISO8601WithMsWithOffset_OutputTimezoneAsUTC() throws IOException {
        this.baseRecord.put("createTimeString", (Object)"2020-04-01T13:01:33.123-05:00");
        this.properties = this.getBaseKeyConfig("createTimeString", "DATE_STRING", "yyyy-MM-dd'T'HH:mm:ssZ,yyyy-MM-dd'T'HH:mm:ss.SSSZ", "", "", "yyyyMMddHH", "UTC");
        TimestampBasedKeyGenerator keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk1 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020040118", (Object)hk1.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2020040118", (Object)keyGen.getPartitionPath(this.baseRow));
    }

    @Test
    public void test_ExpectsMatch_MultipleInputFormats_ISO8601WithMsZ_OutputTimezoneAsEST() throws IOException {
        this.baseRecord.put("createTimeString", (Object)"2020-04-01T13:01:33.123Z");
        this.properties = this.getBaseKeyConfig("createTimeString", "DATE_STRING", "yyyy-MM-dd'T'HH:mm:ssZ,yyyy-MM-dd'T'HH:mm:ss.SSSZ", "", "", "yyyyMMddHH", "EST");
        TimestampBasedKeyGenerator keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk1 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"2020040109", (Object)hk1.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"2020040109", (Object)keyGen.getPartitionPath(this.baseRow));
    }

    @Test
    public void test_Throws_MultipleInputFormats_InputDateNotMatchingFormats() throws IOException {
        this.baseRecord.put("createTimeString", (Object)"2020-04-01 13:01:33.123-05:00");
        this.properties = this.getBaseKeyConfig("createTimeString", "DATE_STRING", "yyyy-MM-dd'T'HH:mm:ssZ,yyyy-MM-dd'T'HH:mm:ss.SSSZ", "", "", "yyyyMMddHH", "UTC");
        TimestampBasedKeyGenerator keyGen = new TimestampBasedKeyGenerator(this.properties);
        Assertions.assertThrows(HoodieKeyGeneratorException.class, () -> this.lambda$test_Throws_MultipleInputFormats_InputDateNotMatchingFormats$0((BuiltinKeyGenerator)keyGen));
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertThrows(HoodieKeyGeneratorException.class, () -> this.lambda$test_Throws_MultipleInputFormats_InputDateNotMatchingFormats$1((BuiltinKeyGenerator)keyGen));
    }

    @Test
    public void test_ExpectsMatch_MultipleInputFormats_ShortDate_OutputCustomDate() throws IOException {
        this.baseRecord.put("createTimeString", (Object)"20200401");
        this.properties = this.getBaseKeyConfig("createTimeString", "DATE_STRING", "yyyy-MM-dd'T'HH:mm:ssZ,yyyy-MM-dd'T'HH:mm:ss.SSSZ,yyyyMMdd", "", "UTC", "MM/dd/yyyy", "UTC");
        TimestampBasedKeyGenerator keyGen = new TimestampBasedKeyGenerator(this.properties);
        HoodieKey hk1 = keyGen.getKey(this.baseRecord);
        Assertions.assertEquals((Object)"04/01/2020", (Object)hk1.getPartitionPath());
        this.baseRow = this.genericRecordToRow(this.baseRecord);
        Assertions.assertEquals((Object)"04/01/2020", (Object)keyGen.getPartitionPath(this.baseRow));
    }

    private /* synthetic */ void lambda$test_Throws_MultipleInputFormats_InputDateNotMatchingFormats$1(BuiltinKeyGenerator keyGen) throws Throwable {
        keyGen.getPartitionPath(this.baseRow);
    }

    private /* synthetic */ void lambda$test_Throws_MultipleInputFormats_InputDateNotMatchingFormats$0(BuiltinKeyGenerator keyGen) throws Throwable {
        keyGen.getKey(this.baseRecord);
    }
}

