/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.strategy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.action.compact.strategy.BoundedIOCompactionStrategy;

public class SmallBoundedIOCompactionStrategy
extends BoundedIOCompactionStrategy {
    private final double targetIO = 0.1;
    private final long opIo = 1L;

    public Pair<List<HoodieCompactionOperation>, List<String>> orderAndFilter(HoodieWriteConfig writeConfig, List<HoodieCompactionOperation> operations, List<HoodieCompactionPlan> pendingCompactionPlans) {
        ArrayList<String> missingPartitions = new ArrayList<String>();
        ArrayList<HoodieCompactionOperation> finalOperations = new ArrayList<HoodieCompactionOperation>();
        double targetIORemaining = 0.1;
        for (HoodieCompactionOperation op : operations) {
            if (targetIORemaining > 0.0) {
                targetIORemaining -= 1.0;
                finalOperations.add(op);
                continue;
            }
            if (writeConfig.isIncrementalTableServiceEnabled()) {
                missingPartitions.add(op.getPartitionPath());
                continue;
            }
            return Pair.of(finalOperations, Collections.emptyList());
        }
        return Pair.of(finalOperations, missingPartitions);
    }
}

