/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hudi.HoodieDataSourceHelpers;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;

public class DataSourceTestUtils {
    private static final Random RANDOM = new Random(-626139411L);

    public static Schema getStructTypeExampleSchema() throws IOException {
        return new Schema.Parser().parse(FileIOUtils.readAsUTFString((InputStream)DataSourceTestUtils.class.getResourceAsStream("/exampleSchema.txt")));
    }

    public static Schema getStructTypeExampleEvolvedSchema() throws IOException {
        return new Schema.Parser().parse(FileIOUtils.readAsUTFString((InputStream)DataSourceTestUtils.class.getResourceAsStream("/exampleEvolvedSchema.txt")));
    }

    public static List<Row> generateRandomRows(int count) {
        ArrayList<Row> toReturn = new ArrayList<Row>();
        List<String> partitions = Arrays.asList("2016/03/15", "2015/03/16", "2015/03/17");
        for (int i = 0; i < count; ++i) {
            Object[] values = new Object[]{HoodieTestDataGenerator.genPseudoRandomUUID((Random)RANDOM).toString(), partitions.get(i % 3), new Date().getTime(), false};
            toReturn.add(RowFactory.create((Object[])values));
        }
        return toReturn;
    }

    public static List<Row> generateRandomRowsByPartition(int count, String partition) {
        ArrayList<Row> toReturn = new ArrayList<Row>();
        for (int i = 0; i < count; ++i) {
            Object[] values = new Object[]{HoodieTestDataGenerator.genPseudoRandomUUID((Random)RANDOM).toString(), partition, new Date().getTime(), false};
            toReturn.add(RowFactory.create((Object[])values));
        }
        return toReturn;
    }

    public static List<Row> generateUpdates(List<Row> records, int count) {
        ArrayList<Row> toReturn = new ArrayList<Row>();
        for (int i = 0; i < count; ++i) {
            Object[] values = new Object[]{records.get(i).getString(0), records.get(i).getAs(1), new Date().getTime(), false};
            toReturn.add(RowFactory.create((Object[])values));
        }
        return toReturn;
    }

    public static List<Row> getUniqueRows(List<Row> inserts, int count) {
        ArrayList<Row> toReturn = new ArrayList<Row>();
        int soFar = 0;
        int curIndex = 0;
        while (soFar < count) {
            if (!toReturn.contains(inserts.get(curIndex))) {
                toReturn.add(inserts.get(curIndex));
                ++soFar;
            }
            ++curIndex;
        }
        return toReturn;
    }

    public static List<Row> generateRandomRowsEvolvedSchema(int count) {
        ArrayList<Row> toReturn = new ArrayList<Row>();
        List<String> partitions = Arrays.asList("2016/03/15", "2015/03/16", "2015/03/17");
        for (int i = 0; i < count; ++i) {
            Object[] values = new Object[]{UUID.randomUUID().toString(), partitions.get(RANDOM.nextInt(3)), new Date().getTime(), false, UUID.randomUUID().toString()};
            toReturn.add(RowFactory.create((Object[])values));
        }
        return toReturn;
    }

    public static List<Row> updateRowsWithUpdatedTs(Dataset<Row> inputDf) {
        return DataSourceTestUtils.updateRowsWithUpdatedTs(inputDf, false, false);
    }

    public static List<Row> updateRowsWithUpdatedTs(Dataset<Row> inputDf, Boolean lowerTs, Boolean updatePartitionPath) {
        List input = inputDf.collectAsList();
        ArrayList<Row> rows = new ArrayList<Row>();
        for (Row row : input) {
            Object[] values = new Object[4];
            values[0] = row.getAs("_row_key");
            String partition = (String)row.getAs("partition");
            values[1] = updatePartitionPath != false ? (partition.equals("2016/03/15") ? "2015/03/16" : (partition.equals("2015/03/16") ? "2015/03/17" : "2016/03/15")) : partition;
            values[2] = (Long)row.getAs("ts") + (long)(lowerTs != false ? -1 - RANDOM.nextInt(1000) : RANDOM.nextInt(1000));
            values[3] = false;
            rows.add(RowFactory.create((Object[])values));
        }
        return rows;
    }

    public static boolean isLogFileOnly(String basePath) throws IOException {
        Configuration conf = new Configuration();
        Path path = new Path(basePath);
        FileSystem fs = path.getFileSystem(conf);
        RemoteIterator files = fs.listFiles(path, true);
        while (files.hasNext()) {
            LocatedFileStatus file = (LocatedFileStatus)files.next();
            if (!file.isFile() || file.getPath().toString().contains(".hoodie/") || !HadoopFSUtils.isBaseFile((Path)file.getPath())) continue;
            return false;
        }
        return true;
    }

    public static String latestCommitCompletionTime(FileSystem fs, String basePath) {
        return (String)HoodieDataSourceHelpers.allCompletedCommitsCompactions((FileSystem)fs, (String)basePath).getLatestCompletionTime().orElse(null);
    }

    public static String latestCommitCompletionTime(HoodieStorage storage, String basePath) {
        return (String)HoodieDataSourceHelpers.allCompletedCommitsCompactions((HoodieStorage)storage, (String)basePath).getLatestCompletionTime().orElse(null);
    }

    public static String latestCommitRequestTime(HoodieStorage storage, String basePath) {
        return (String)HoodieDataSourceHelpers.allCompletedCommitsCompactions((HoodieStorage)storage, (String)basePath).lastInstant().map(instant -> instant.requestedTime()).orElse(null);
    }

    public static String latestDeltaCommitCompletionTime(HoodieStorage storage, String basePath) {
        return (String)HoodieDataSourceHelpers.allCompletedCommitsCompactions((HoodieStorage)storage, (String)basePath).filter(instant -> "deltacommit".equals(instant.getAction())).getLatestCompletionTime().orElse(null);
    }

    public static String latestDeltaCommitRequest(HoodieStorage storage, String basePath) {
        return (String)HoodieDataSourceHelpers.allCompletedCommitsCompactions((HoodieStorage)storage, (String)basePath).filter(instant -> "deltacommit".equals(instant.getAction())).lastInstant().map(instant -> instant.requestedTime()).orElse(null);
    }
}

