/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkConf;
import org.apache.spark.hudi.benchmark.HoodieBenchmark;
import org.apache.spark.hudi.benchmark.HoodieBenchmark$;
import org.apache.spark.hudi.benchmark.HoodieBenchmarkBase;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.RowFactory;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.hudi.HoodieSparkSessionExtension;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Random$;

public final class CowTableReadBenchmark$
extends HoodieBenchmarkBase {
    public static CowTableReadBenchmark$ MODULE$;
    private final SparkSession spark;

    static {
        new CowTableReadBenchmark$();
    }

    public SparkSession spark() {
        return this.spark;
    }

    public SparkSession getSparkSession() {
        return SparkSession$.MODULE$.builder().master("local[4]").appName(this.getClass().getCanonicalName()).withExtensions((Function1)new HoodieSparkSessionExtension()).config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.kryo.registrator", "org.apache.spark.HoodieSparkKryoRegistrar").config("spark.sql.catalog.spark_catalog", "org.apache.spark.sql.hudi.catalog.HoodieCatalog").config("hoodie.insert.shuffle.parallelism", "2").config("hoodie.upsert.shuffle.parallelism", "2").config("hoodie.delete.shuffle.parallelism", "2").config("spark.sql.session.timeZone", "CTT").config(this.sparkConf()).getOrCreate();
    }

    public SparkConf sparkConf() {
        SparkConf sparkConf = new SparkConf();
        return sparkConf;
    }

    public Dataset<Row> prepareHoodieCowTable(String tableName, String tablePath) {
        this.createDataFrame(10000000).registerTempTable("ds");
        return this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(148).append("\n         |create table ").append(tableName).append(" using hudi\n         |tblproperties(primaryKey = 'c1')\n         |location '").append(tablePath).append("'\n         |As\n         |select * from ds\n       ").toString())).stripMargin());
    }

    private Dataset<Row> createDataFrame(int number) {
        StructType schema = new StructType().add("c1", (DataType)IntegerType$.MODULE$).add("c11", (DataType)IntegerType$.MODULE$).add("c12", (DataType)IntegerType$.MODULE$).add("c2", (DataType)StringType$.MODULE$).add("c3", (DataType)new DecimalType(38, 10)).add("c4", (DataType)TimestampType$.MODULE$).add("c5", (DataType)ShortType$.MODULE$).add("c6", (DataType)DateType$.MODULE$).add("c7", (DataType)BinaryType$.MODULE$).add("c9", (DataType)ByteType$.MODULE$);
        RDD rdd = this.spark().sparkContext().parallelize((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), number), 2, ClassTag$.MODULE$.Int()).map((Function1 & Serializable & scala.Serializable)item -> CowTableReadBenchmark$.$anonfun$createDataFrame$1(BoxesRunTime.unboxToInt((Object)item)), ClassTag$.MODULE$.apply(Row.class));
        return this.spark().createDataFrame(rdd, schema);
    }

    public void withTempTable(Seq<String> tableNames, Function0<BoxedUnit> f) {
        try {
            f.apply$mcV$sp();
        }
        finally {
            tableNames.foreach((Function1 & Serializable & scala.Serializable)viewName -> BoxesRunTime.boxToBoolean((boolean)CowTableReadBenchmark$.$anonfun$withTempTable$1(viewName)));
        }
    }

    private void cowTableReadBenchmark(String tableName) {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)f -> {
            CowTableReadBenchmark$.MODULE$.withTempTable((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{tableName}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                CowTableReadBenchmark$.MODULE$.prepareHoodieCowTable(tableName$1, new Path(f.getCanonicalPath(), tableName$1).toUri().toString());
                HoodieBenchmark benchmark = new HoodieBenchmark("perf cow snapshot read", 10000000L, HoodieBenchmark$.MODULE$.$lessinit$greater$default$3(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$4(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$5(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$6(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$7());
                benchmark.addCase("vectorized disable", benchmark.addCase$default$2(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> {
                    CowTableReadBenchmark$.MODULE$.spark().sessionState().conf().setConfString("spark.sql.parquet.enableVectorizedReader", "false");
                    CowTableReadBenchmark$.MODULE$.spark().sql(new StringBuilder(27).append("select c1, c3, c4, c5 from ").append(tableName$1).toString()).count();
                });
                benchmark.addCase("vectorized enable", benchmark.addCase$default$2(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> {
                    CowTableReadBenchmark$.MODULE$.spark().sessionState().conf().setConfString("spark.sql.parquet.enableVectorizedReader", "true");
                    CowTableReadBenchmark$.MODULE$.spark().sql(new StringBuilder(27).append("select c1, c3, c4, c5 from ").append(tableName$1).toString()).count();
                });
                benchmark.run();
            });
            return BoxedUnit.UNIT;
        });
    }

    private String cowTableReadBenchmark$default$1() {
        return "cowBenchmark";
    }

    @Override
    public void afterAll() {
        this.spark().stop();
    }

    @Override
    public void runBenchmarkSuite(String[] mainArgs) {
        this.cowTableReadBenchmark(this.cowTableReadBenchmark$default$1());
    }

    public static final /* synthetic */ byte $anonfun$createDataFrame$2(int x$1) {
        return (byte)x$1;
    }

    public static final /* synthetic */ Row $anonfun$createDataFrame$1(int item) {
        Integer c1 = item;
        Integer c11 = Random$.MODULE$.nextInt(10000);
        Integer c12 = Random$.MODULE$.nextInt(10000);
        String c2 = new StringBuilder(4).append(" ").append(item).append("abc").toString();
        BigDecimal c3 = new BigDecimal(new StringBuilder(1).append(Random$.MODULE$.nextInt(1000)).append(".").append(Random$.MODULE$.nextInt(100)).toString());
        Timestamp c4 = new Timestamp(System.currentTimeMillis());
        Short c5 = Short.valueOf(String.valueOf(BoxesRunTime.boxToInteger((int)16)));
        Date c6 = Date.valueOf(new StringBuilder(2).append(2020).append("-").append(item % 11 + 1).append("-").append(item % 28 + 1).toString());
        byte[] c7 = (byte[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(new int[]{item})).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToByte((byte)CowTableReadBenchmark$.$anonfun$createDataFrame$2(BoxesRunTime.unboxToInt((Object)x$1))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
        Byte c8 = Byte.valueOf("9");
        return RowFactory.create((Object[])new Object[]{c1, c11, c12, c2, c3, c4, c5, c6, c7, c8});
    }

    public static final /* synthetic */ boolean $anonfun$withTempTable$1(String viewName) {
        return MODULE$.spark().catalog().dropTempView(viewName);
    }

    private CowTableReadBenchmark$() {
        MODULE$ = this;
        this.spark = this.getSparkSession();
    }
}

