/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.benchmark;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DefaultSparkRecordMerger;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.spark.SparkConf;
import org.apache.spark.hudi.benchmark.HoodieBenchmark;
import org.apache.spark.hudi.benchmark.HoodieBenchmark$;
import org.apache.spark.hudi.benchmark.HoodieBenchmarkBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.HoodieSparkSessionExtension;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class ReadAndWriteWithoutAvroBenchmark$
extends HoodieBenchmarkBase {
    public static ReadAndWriteWithoutAvroBenchmark$ MODULE$;
    private final SparkSession spark;
    private final String avroTable;
    private final String sparkTable;

    static {
        new ReadAndWriteWithoutAvroBenchmark$();
    }

    public SparkSession spark() {
        return this.spark;
    }

    private String avroTable() {
        return this.avroTable;
    }

    private String sparkTable() {
        return this.sparkTable;
    }

    public SparkSession getSparkSession() {
        return SparkSession$.MODULE$.builder().master("local[4]").appName(this.getClass().getCanonicalName()).withExtensions((Function1)new HoodieSparkSessionExtension()).config("spark.driver.memory", "4G").config("spark.executor.memory", "4G").config("spark.serializer", "org.apache.spark.serializer.KryoSerializer").config("spark.kryo.registrator", "org.apache.spark.HoodieSparkKryoRegistrar").config("spark.sql.catalog.spark_catalog", "org.apache.spark.sql.hudi.catalog.HoodieCatalog").config("hoodie.insert.shuffle.parallelism", "2").config("hoodie.upsert.shuffle.parallelism", "2").config("hoodie.delete.shuffle.parallelism", "2").config("spark.sql.session.timeZone", "CTT").config(this.sparkConf()).getOrCreate();
    }

    public SparkConf sparkConf() {
        SparkConf sparkConf = new SparkConf();
        return sparkConf;
    }

    private Dataset<Row> createComplexDataFrame(long rowNum) {
        ObjectRef df = ObjectRef.create((Object)this.spark().range(0L, rowNum).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id"})).withColumn("t1", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))).withColumn("d1", functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)12.99))).withColumn("s1", functions$.MODULE$.lit((Object)"s1")).withColumn("s2", functions$.MODULE$.lit((Object)"s2")).withColumn("s3", functions$.MODULE$.lit((Object)"s3")));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            df$1.elem = ((Dataset)df$1.elem).withColumn(new StringBuilder(6).append("struct").append(i).toString(), functions$.MODULE$.struct((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("s1").as("st1"), functions$.MODULE$.col("s2").as("st2"), functions$.MODULE$.col("s3").as("st3")}))).withColumn(new StringBuilder(3).append("map").append(i).toString(), functions$.MODULE$.map((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("s1"), functions$.MODULE$.col("s2")}))).withColumn(new StringBuilder(5).append("array").append(i).toString(), functions$.MODULE$.array((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("s1")})));
        });
        return (Dataset)df.elem;
    }

    private void prepareHoodieTable(String tableName, String path, String tableType, String mergerImpl, Dataset<Row> df) {
        df.collect();
        df.createOrReplaceTempView("input_df");
        Object object = this.spark().catalog().tableExists(tableName) ? this.spark().sql(new StringBuilder(21).append("drop table if exists ").append(tableName).toString()) : BoxedUnit.UNIT;
        this.spark().sql(new StringBuilder(7).append("set ").append(HoodieWriteConfig.RECORD_MERGE_IMPL_CLASSES.key()).append(" = ").append(mergerImpl).toString());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(616).append("\n         |create table ").append(tableName).append("(\n         |id long,\n         |t1 int,\n         |d1 double,\n         |s1 string,\n         |s2 string,\n         |s3 string,\n         |struct0 struct<st1:string, st2:string, st3:string>,\n         |map0 map<string, string>,\n         |array0 array<string>,\n         |struct1 struct<st1:string, st2:string, st3:string>,\n         |map1 map<string, string>,\n         |array1 array<string>\n         |) using hudi\n         |tblproperties(\n         |  primaryKey = 'id',\n         |  preCombineField = 's1',\n         |  type = '").append(tableType).append("',\n         |  ").append(HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key()).append(" = 'parquet',\n         |  ").append(HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT.key()).append(" = '10')\n         |location '").append(path).append("'\n   ").toString())).stripMargin());
        this.spark().sql(new StringBuilder(46).append("insert overwrite table ").append(tableName).append(" select * from input_df").toString());
    }

    private void overwriteBenchmark() {
        Dataset<Row> df = this.createComplexDataFrame(1000000L);
        HoodieBenchmark benchmark = new HoodieBenchmark("pref insert overwrite", 1000000L, 3, HoodieBenchmark$.MODULE$.$lessinit$greater$default$4(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$5(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$6(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$7());
        ((IterableLike)((IterableLike)new .colon.colon((Object)HoodieAvroRecordMerger.class.getName(), (List)new .colon.colon((Object)DefaultSparkRecordMerger.class.getName(), (List)Nil$.MODULE$))).zip((GenIterable)new .colon.colon((Object)this.avroTable(), (List)new .colon.colon((Object)this.sparkTable(), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ReadAndWriteWithoutAvroBenchmark$.$anonfun$overwriteBenchmark$1(benchmark, df, x0$1);
            return BoxedUnit.UNIT;
        });
        benchmark.run();
    }

    private void upsertThenReadBenchmark() {
        String avroMergerImpl = HoodieAvroRecordMerger.class.getName();
        String sparkMergerImpl = DefaultSparkRecordMerger.class.getName();
        Dataset<Row> df = this.createComplexDataFrame(10000L);
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)avroPath -> {
            ReadAndWriteWithoutAvroBenchmark$.MODULE$.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sparkPath -> {
                ReadAndWriteWithoutAvroBenchmark$.$anonfun$upsertThenReadBenchmark$2(avroPath, avroMergerImpl$1, df$3, sparkMergerImpl$1, sparkPath);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void runBenchmarkSuite(String[] mainArgs) {
        this.overwriteBenchmark();
        this.upsertThenReadBenchmark();
    }

    public static final /* synthetic */ void $anonfun$overwriteBenchmark$1(HoodieBenchmark benchmark$1, Dataset df$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String merger = (String)tuple2._1();
            String tableName = (String)tuple2._2();
            benchmark$1.addCase(merger, benchmark$1.addCase$default$2(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> MODULE$.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)f -> {
                ReadAndWriteWithoutAvroBenchmark$.MODULE$.prepareHoodieTable(tableName, new Path(f.getCanonicalPath(), tableName).toUri().toString(), "mor", merger, (Dataset<Row>)df$2);
                return BoxedUnit.UNIT;
            }));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$upsertThenReadBenchmark$3(HoodieBenchmark upsertBenchmark$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String mergerImpl = (String)tuple2._1();
            String tableName = (String)tuple2._2();
            upsertBenchmark$1.addCase(mergerImpl, upsertBenchmark$1.addCase$default$2(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$2 -> {
                MODULE$.spark().sql(new StringBuilder(7).append("set ").append(HoodieWriteConfig.RECORD_MERGE_IMPL_CLASSES.key()).append(" = ").append(mergerImpl).toString());
                MODULE$.spark().sql(new StringBuilder(40).append("update ").append(tableName).append(" set s1 = 's1_new_1' where id > 0").toString());
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$upsertThenReadBenchmark$5(HoodieBenchmark readBenchmark$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String mergerImpl = (String)tuple2._1();
            String tableName = (String)tuple2._2();
            readBenchmark$1.addCase(mergerImpl, readBenchmark$1.addCase$default$2(), (Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$3 -> {
                MODULE$.spark().sql(new StringBuilder(7).append("set ").append(HoodieWriteConfig.RECORD_MERGE_IMPL_CLASSES.key()).append(" = ").append(mergerImpl).toString());
                MODULE$.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString()).collect();
            });
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$upsertThenReadBenchmark$2(File avroPath$1, String avroMergerImpl$1, Dataset df$3, String sparkMergerImpl$1, File sparkPath) {
        HoodieBenchmark upsertBenchmark = new HoodieBenchmark("pref upsert", 10000L, 3, HoodieBenchmark$.MODULE$.$lessinit$greater$default$4(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$5(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$6(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$7());
        MODULE$.prepareHoodieTable(MODULE$.avroTable(), new Path(avroPath$1.getCanonicalPath(), MODULE$.avroTable()).toUri().toString(), "mor", avroMergerImpl$1, (Dataset<Row>)df$3);
        MODULE$.prepareHoodieTable(MODULE$.sparkTable(), new Path(sparkPath.getCanonicalPath(), MODULE$.sparkTable()).toUri().toString(), "mor", sparkMergerImpl$1, (Dataset<Row>)df$3);
        ((IterableLike)((IterableLike)new .colon.colon((Object)avroMergerImpl$1, (List)new .colon.colon((Object)sparkMergerImpl$1, (List)Nil$.MODULE$))).zip((GenIterable)new .colon.colon((Object)MODULE$.avroTable(), (List)new .colon.colon((Object)MODULE$.sparkTable(), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ReadAndWriteWithoutAvroBenchmark$.$anonfun$upsertThenReadBenchmark$3(upsertBenchmark, x0$1);
            return BoxedUnit.UNIT;
        });
        upsertBenchmark.run();
        HoodieBenchmark readBenchmark = new HoodieBenchmark("pref read", 10000L, 3, HoodieBenchmark$.MODULE$.$lessinit$greater$default$4(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$5(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$6(), HoodieBenchmark$.MODULE$.$lessinit$greater$default$7());
        ((IterableLike)((IterableLike)new .colon.colon((Object)avroMergerImpl$1, (List)new .colon.colon((Object)sparkMergerImpl$1, (List)Nil$.MODULE$))).zip((GenIterable)new .colon.colon((Object)MODULE$.avroTable(), (List)new .colon.colon((Object)MODULE$.sparkTable(), (List)Nil$.MODULE$)), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            ReadAndWriteWithoutAvroBenchmark$.$anonfun$upsertThenReadBenchmark$5(readBenchmark, x0$2);
            return BoxedUnit.UNIT;
        });
        readBenchmark.run();
    }

    private ReadAndWriteWithoutAvroBenchmark$() {
        MODULE$ = this;
        this.spark = this.getSparkSession();
        this.avroTable = "avro_merger_table";
        this.sparkTable = "spark_merger_table";
    }
}

