/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.analysis;

import java.io.Serializable;
import java.util.function.Consumer;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.ScalaAssertionSupport;
import org.apache.hudi.testutils.HoodieClientTestBase;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.plans.logical.Filter;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.hudi.HoodieSparkSessionExtension;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001\u0002\u0006\f\u0001aAQ\u0001\n\u0001\u0005\u0002\u0015B\u0011B\u0005\u0001A\u0002\u0003\u0007I\u0011\u0002\u0015\t\u00135\u0002\u0001\u0019!a\u0001\n\u0013q\u0003\"C\u001c\u0001\u0001\u0004\u0005\t\u0015)\u0003*\u0011\u0015A\u0004\u0001\"\u0011:\u0011\u0015)\u0005\u0001\"\u0011G\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u001d\ty\u0001\u0001C\u0001\u0003#AA\"a\t\u0001!\u0003\u0005\t\u0011!C\u0001\u0003K\u00111\u0005V3ti\"{w\u000eZ5f!J,h.\u001a$jY\u0016\u001cv.\u001e:dKB\u000b'\u000f^5uS>t7O\u0003\u0002\r\u001b\u0005A\u0011M\\1msNL7O\u0003\u0002\u000f\u001f\u0005!\u0001.\u001e3j\u0015\t\u0001\u0012#A\u0002tc2T!AE\n\u0002\u000bM\u0004\u0018M]6\u000b\u0005Q)\u0012AB1qC\u000eDWMC\u0001\u0017\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011\u0004\t\t\u00035yi\u0011a\u0007\u0006\u00039u\t\u0011\u0002^3tiV$\u0018\u000e\\:\u000b\u00059\u0019\u0012BA\u0010\u001c\u0005QAun\u001c3jK\u000ec\u0017.\u001a8u)\u0016\u001cHOQ1tKB\u0011\u0011EI\u0007\u0002;%\u00111%\b\u0002\u0016'\u000e\fG.Y!tg\u0016\u0014H/[8o'V\u0004\bo\u001c:u\u0003\u0019a\u0014N\\5u}Q\ta\u0005\u0005\u0002(\u00015\t1\"F\u0001*!\tQ3&D\u0001\u0010\u0013\tasB\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0005ta\u0006\u00148n\u0018\u0013fcR\u0011q&\u000e\t\u0003aMj\u0011!\r\u0006\u0002e\u0005)1oY1mC&\u0011A'\r\u0002\u0005+:LG\u000fC\u00047\u0007\u0005\u0005\t\u0019A\u0015\u0002\u0007a$\u0013'\u0001\u0004ta\u0006\u00148\u000eI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002_!\u0012Qa\u000f\t\u0003y\rk\u0011!\u0010\u0006\u0003}}\n1!\u00199j\u0015\t\u0001\u0015)A\u0004kkBLG/\u001a:\u000b\u0005\t+\u0012!\u00026v]&$\u0018B\u0001#>\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\"O\u0016$8\u000b]1sWN+7o]5p]\u0016CH/\u001a8tS>t7/\u00138kK\u000e$xN\u001d\u000b\u0002\u000fB\u0019\u0001*T(\u000e\u0003%S!AS&\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0019v\taaY8n[>t\u0017B\u0001(J\u0005\u0019y\u0005\u000f^5p]B\u0019\u0001K\u0016-\u000e\u0003ES!AU*\u0002\u0011\u0019,hn\u0019;j_:T!A\u0013+\u000b\u0003U\u000bAA[1wC&\u0011q+\u0015\u0002\t\u0007>t7/^7feB\u0011!&W\u0005\u00035>\u0011ac\u00159be.\u001cVm]:j_:,\u0005\u0010^3og&|gn]\u0001\u001di\u0016\u001cH\u000fU1si&$\u0018n\u001c8GS2$XM]:QkNDGi\\<o)\rySL\u001b\u0005\u0006=\u001e\u0001\raX\u0001\ni\u0006\u0014G.\u001a+za\u0016\u0004\"\u0001Y4\u000f\u0005\u0005,\u0007C\u000122\u001b\u0005\u0019'B\u00013\u0018\u0003\u0019a$o\\8u}%\u0011a-M\u0001\u0007!J,G-\u001a4\n\u0005!L'AB*ue&twM\u0003\u0002gc!)1n\u0002a\u0001Y\u0006Y\u0001/\u0019:uSRLwN\\3e!\t\u0001T.\u0003\u0002oc\t9!i\\8mK\u0006t\u0007\u0006B\u0004qqf\u0004\"!\u001d<\u000e\u0003IT!a\u001d;\u0002\u0011A\u0014xN^5eKJT!!^ \u0002\rA\f'/Y7t\u0013\t9(OA\u0005DgZ\u001cv.\u001e:dK\u0006)a/\u00197vK2*!\u0010 @\u0002\u0002\u0005\n10\u0001\u0005d_^dCO];fC\u0005i\u0018!C2po22\u0017\r\\:fC\u0005y\u0018\u0001C7pe2\"(/^3\"\u0005\u0005\r\u0011!C7pe22\u0017\r\\:fQ\r9\u0011q\u0001\t\u0005\u0003\u0013\tY!D\u0001u\u0013\r\ti\u0001\u001e\u0002\u0012!\u0006\u0014\u0018-\\3uKJL'0\u001a3UKN$\u0018!\t;fgR,U\u000e\u001d;z!\u0006\u0014H/\u001b;j_:4\u0015\u000e\u001c;feN\u0004Vo\u001d5E_^tGcA\u0018\u0002\u0014!)a\f\u0003a\u0001?\"*\u0001\u0002\u001d=\u0002\u00181\"\u0011\u0011DA\u000fC\t\tY\"A\u0002d_^\f#!a\b\u0002\u00075|'\u000fK\u0002\t\u0003\u000f\t1\u0003\u001d:pi\u0016\u001cG/\u001a3%i\u0006\u0014G.\u001a(b[\u0016$B!a\n\u00022A!\u0011\u0011FA\u0018\u001b\t\tYCC\u0002\u0002.Q\u000bA\u0001\\1oO&\u0019\u0001.a\u000b\t\u000fYJ\u0011\u0011!a\u0001M\u0001")
public class TestHoodiePruneFileSourcePartitions
extends HoodieClientTestBase
implements ScalaAssertionSupport {
    private SparkSession spark;

    @Override
    public <T extends Throwable, R> T assertThrows(Class<T> expectedExceptionClass, Function0<R> f) {
        return (T)ScalaAssertionSupport.assertThrows$(this, expectedExceptionClass, f);
    }

    public /* synthetic */ String protected$tableName(TestHoodiePruneFileSourcePartitions x$1) {
        return x$1.tableName;
    }

    private SparkSession spark() {
        return this.spark;
    }

    private void spark_$eq(SparkSession x$1) {
        this.spark = x$1;
    }

    @BeforeEach
    public void setUp() {
        this.setTableName("hoodie_test");
        this.initPath();
        this.initSparkContexts();
        this.spark_$eq(this.sqlContext.sparkSession());
    }

    public org.apache.hudi.common.util.Option<Consumer<SparkSessionExtensions>> getSparkSessionExtensionsInjector() {
        return HoodieConversionUtils$.MODULE$.toJavaOption((Option)new Some((Object)JFunction$.MODULE$.toJavaConsumer((Function1 & Serializable & scala.Serializable)receiver -> {
            TestHoodiePruneFileSourcePartitions.$anonfun$getSparkSessionExtensionsInjector$1(receiver);
            return BoxedUnit.UNIT;
        })));
    }

    @ParameterizedTest
    @CsvSource(value={"cow,true", "cow,false", "mor,true", "mor,false"})
    public void testPartitionFiltersPushDown(String tableType, boolean partitioned) {
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(341).append("\n         |CREATE TABLE ").append(this.tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long,\n         |  partition string\n         |) USING hudi\n         |").append((Object)(partitioned ? "PARTITIONED BY (partition)" : "")).append("\n         |TBLPROPERTIES (\n         |  type = '").append(tableType).append("',\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts'\n         |)\n         |LOCATION '").append(this.basePath).append("/").append(this.tableName).append("'\n         ").toString())).stripMargin());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(180).append("\n         |INSERT INTO ").append(this.tableName).append(" VALUES\n         |  (1, 'a1', 10, 1000, \"2021-01-05\"),\n         |  (2, 'a2', 20, 2000, \"2021-01-06\"),\n         |  (3, 'a3', 30, 3000, \"2021-01-07\")\n         ").toString())).stripMargin());
        ((IterableLike)new .colon.colon((Object)"eager", (List)new .colon.colon((Object)"lazy", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)listingModeOverride -> {
            TestHoodiePruneFileSourcePartitions.$anonfun$testPartitionFiltersPushDown$1(this, partitioned, listingModeOverride);
            return BoxedUnit.UNIT;
        });
    }

    @ParameterizedTest
    @CsvSource(value={"cow", "mor"})
    public void testEmptyPartitionFiltersPushDown(String tableType) {
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(367).append("\n         |CREATE TABLE ").append(this.tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long,\n         |  partition string\n         |) USING hudi\n         |PARTITIONED BY (partition)\n         |TBLPROPERTIES (\n         |  type = '").append(tableType).append("',\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts'\n         |)\n         |LOCATION '").append(this.basePath).append("/").append(this.tableName).append("'\n         ").toString())).stripMargin());
        this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(180).append("\n         |INSERT INTO ").append(this.tableName).append(" VALUES\n         |  (1, 'a1', 10, 1000, \"2021-01-05\"),\n         |  (2, 'a2', 20, 2000, \"2021-01-06\"),\n         |  (3, 'a3', 30, 3000, \"2021-01-07\")\n         ").toString())).stripMargin());
        ((IterableLike)new .colon.colon((Object)"eager", (List)new .colon.colon((Object)"lazy", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)listingModeOverride -> {
            TestHoodiePruneFileSourcePartitions.$anonfun$testEmptyPartitionFiltersPushDown$1(this, tableType, listingModeOverride);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$getSparkSessionExtensionsInjector$1(SparkSessionExtensions receiver) {
        new HoodieSparkSessionExtension().apply(receiver);
    }

    public static final /* synthetic */ void $anonfun$testPartitionFiltersPushDown$1(TestHoodiePruneFileSourcePartitions $this, boolean partitioned$1, String listingModeOverride) {
        LogicalPlan optimizedPlan;
        $this.spark().sessionState().catalog().invalidateAllCachedTables();
        $this.spark().sql(new StringBuilder(51).append("SET hoodie.datasource.read.file.index.listing.mode=").append(listingModeOverride).toString());
        Dataset df = $this.spark().sql(new StringBuilder(45).append("SELECT * FROM ").append($this.protected$tableName($this)).append(" WHERE partition = '2021-01-05'").toString());
        LogicalPlan logicalPlan = optimizedPlan = df.queryExecution().optimizedPlan();
        if (logicalPlan instanceof Filter) {
            Filter filter = (Filter)logicalPlan;
            Expression expression = filter.condition();
            LogicalPlan lr = filter.child();
            if (expression instanceof And) {
                And and = (And)expression;
                Expression expression2 = and.left();
                Expression expression3 = and.right();
                if (expression2 instanceof IsNotNull && expression3 instanceof EqualTo) {
                    EqualTo equalTo = (EqualTo)expression3;
                    Expression attr = equalTo.left();
                    Expression expression4 = equalTo.right();
                    if (attr instanceof AttributeReference) {
                        AttributeReference attributeReference = (AttributeReference)attr;
                        if (expression4 instanceof Literal) {
                            Literal literal = (Literal)expression4;
                            Object value = literal.value();
                            DataType dataType = literal.dataType();
                            if (StringType$.MODULE$.equals(dataType) && lr instanceof LogicalRelation) {
                                LogicalRelation logicalRelation = (LogicalRelation)lr;
                                String string = attributeReference.name();
                                String string2 = "partition";
                                if (!(string != null ? !string.equals(string2) : string2 != null) && value.toString().equals("2021-01-05")) {
                                    String string3 = listingModeOverride;
                                    if ("eager".equals(string3)) {
                                        if (partitioned$1) {
                                            Assertions.assertEquals((long)1275L, (long)(filter.stats().sizeInBytes().longValue() / 1024L));
                                            Assertions.assertEquals((long)1275L, (long)(logicalRelation.stats().sizeInBytes().longValue() / 1024L));
                                        } else {
                                            Assertions.assertEquals((long)425L, (long)((filter.stats().sizeInBytes().longValue() + 512L) / 1024L));
                                            Assertions.assertEquals((long)425L, (long)((logicalRelation.stats().sizeInBytes().longValue() + 512L) / 1024L));
                                        }
                                    } else if ("lazy".equals(string3)) {
                                        Assertions.assertEquals((long)425L, (long)((filter.stats().sizeInBytes().longValue() + 512L) / 1024L));
                                        Assertions.assertEquals((long)425L, (long)((logicalRelation.stats().sizeInBytes().longValue() + 512L) / 1024L));
                                    } else {
                                        throw new UnsupportedOperationException();
                                    }
                                    if (partitioned$1) {
                                        SparkPlan executionPlan = df.queryExecution().executedPlan();
                                        String expectedPhysicalPlanPartitionFiltersClause = new StringBuilder(48).append("PartitionFilters: [isnotnull(").append(attributeReference).append("), (").append(attributeReference).append(" = 2021-01-05)]").toString();
                                        Assertions.assertTrue((boolean)executionPlan.toString().contains(expectedPhysicalPlanPartitionFiltersClause));
                                        return;
                                    }
                                    return;
                                }
                            }
                        }
                    }
                }
            }
        }
        String failureHint = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(591).append("Expected to see plan like below:\n               |```\n               |== Optimized Logical Plan ==\n               |Filter (isnotnull(partition#74) AND (partition#74 = 2021-01-05)), Statistics(sizeInBytes=...)\n               |+- Relation default.hoodie_test[_hoodie_commit_time#65,_hoodie_commit_seqno#66,_hoodie_record_key#67,_hoodie_partition_path#68,_hoodie_file_name#69,id#70,name#71,price#72,ts#73L,partition#74] parquet, Statistics(sizeInBytes=...)\n               |```\n               |\n               |Instead got\n               |```\n               |").append(optimizedPlan).append("\n               |```\n               |").toString())).stripMargin().trim();
        BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)failureHint);
    }

    public static final /* synthetic */ void $anonfun$testEmptyPartitionFiltersPushDown$1(TestHoodiePruneFileSourcePartitions $this, String tableType$1, String listingModeOverride) {
        LogicalPlan optimizedPlan;
        $this.spark().sessionState().catalog().invalidateAllCachedTables();
        $this.spark().sql(new StringBuilder(51).append("SET hoodie.datasource.read.file.index.listing.mode=").append(listingModeOverride).toString());
        Dataset df = $this.spark().sql(new StringBuilder(14).append("SELECT * FROM ").append($this.protected$tableName($this)).toString());
        LogicalPlan logicalPlan = optimizedPlan = df.queryExecution().optimizedPlan();
        if (logicalPlan instanceof LogicalRelation) {
            String string;
            LogicalRelation logicalRelation = (LogicalRelation)logicalPlan;
            String string2 = listingModeOverride;
            if (!("eager".equals(string2) ? true : "lazy".equals(string2))) {
                throw new UnsupportedOperationException();
            }
            Assertions.assertEquals((long)1275L, (long)(logicalRelation.stats().sizeInBytes().longValue() / 1024L));
            SparkPlan executionPlan = df.queryExecution().executedPlan();
            String string3 = tableType$1;
            if ("cow".equals(string3)) {
                string = "PartitionFilters: []";
            } else if ("mor".equals(string3)) {
                string = "PushedFilters: []";
            } else {
                throw new MatchError((Object)string3);
            }
            String expectedPhysicalPlanPartitionFiltersClause = string;
            Assertions.assertTrue((boolean)executionPlan.toString().contains(expectedPhysicalPlanPartitionFiltersClause));
            return;
        }
        String failureHint = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(591).append("Expected to see plan like below:\n               |```\n               |== Optimized Logical Plan ==\n               |Filter (isnotnull(partition#74) AND (partition#74 = 2021-01-05)), Statistics(sizeInBytes=...)\n               |+- Relation default.hoodie_test[_hoodie_commit_time#65,_hoodie_commit_seqno#66,_hoodie_record_key#67,_hoodie_partition_path#68,_hoodie_file_name#69,id#70,name#71,price#72,ts#73L,partition#74] parquet, Statistics(sizeInBytes=...)\n               |```\n               |\n               |Instead got\n               |```\n               |").append(optimizedPlan).append("\n               |```\n               |").toString())).stripMargin().trim();
        BoxedUnit cfr_ignored_0 = (BoxedUnit)Assertions.fail((String)failureHint);
    }

    public TestHoodiePruneFileSourcePartitions() {
        ScalaAssertionSupport.$init$(this);
    }
}

