/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.index;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.ExpressionIndexSupport;
import org.apache.hudi.ExpressionIndexSupport$;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.HoodieFileIndex$;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.avro.model.HoodieMetadataBloomFilter;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.client.utils.SparkMetadataWriterUtils;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.hive.HoodieHiveSyncClient;
import org.apache.hudi.hive.testutils.HiveTestUtil;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.hudi.util.JFunction$;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute$;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.AttributeReference$;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FromUnixTime;
import org.apache.spark.sql.catalyst.expressions.FromUnixTime$;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Upper;
import org.apache.spark.sql.catalyst.parser.ParserInterface;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasources.FileStatusCache;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.command.CreateIndexCommand;
import org.apache.spark.sql.hudi.command.ShowIndexesCommand;
import org.apache.spark.sql.hudi.command.index.TestExpressionIndex$;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005uf\u0001\u0002\f\u0018\u0001\u0019BQ!\f\u0001\u0005\u00029BQ!\r\u0001\u0005RIBQ!\u000f\u0001\u0005\u0002IBQ!\u0012\u0001\u0005\u0002IBQa\u0012\u0001\u0005\u0002IBQ!\u0013\u0001\u0005\u0002IBQa\u0013\u0001\u0005\u0002IBQ!\u0014\u0001\u0005\u0002IBQa\u0014\u0001\u0005\nACQA\u001b\u0001\u0005\n-DQA\u001c\u0001\u0005\n=Daa \u0001\u0005\n\u0005\u0005\u0001\"CA\u001d\u0001E\u0005I\u0011BA\u001e\u0011%\t\t\u0006AI\u0001\n\u0013\tY\u0004C\u0004\u0002T\u0001!I!!\u0016\t\u0013\u0005]\u0004!%A\u0005\n\u0005m\u0002\"CA=\u0001E\u0005I\u0011BA\u001e\u0011\u001d\tY\b\u0001C\u0005\u0003{B\u0011\"a#\u0001#\u0003%I!a\u000f\t\u000f\u00055\u0005\u0001\"\u0003\u0002\u0010\"9\u0011q\u0014\u0001\u0005\n\u0005\u0005&a\u0005+fgR,\u0005\u0010\u001d:fgNLwN\\%oI\u0016D(B\u0001\r\u001a\u0003\u0015Ig\u000eZ3y\u0015\tQ2$A\u0004d_6l\u0017M\u001c3\u000b\u0005qi\u0012\u0001\u00025vI&T!AH\u0010\u0002\u0007M\fHN\u0003\u0002!C\u0005)1\u000f]1sW*\u0011!eI\u0001\u0007CB\f7\r[3\u000b\u0003\u0011\n1a\u001c:h\u0007\u0001\u0019\"\u0001A\u0014\u0011\u0005!ZS\"A\u0015\u000b\u0005)Z\u0012AB2p[6|g.\u0003\u0002-S\t1\u0002j\\8eS\u0016\u001c\u0006/\u0019:l'FdG+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002_A\u0011\u0001\u0007A\u0007\u0002/\u0005I!-\u001a4pe\u0016\fE\u000e\u001c\u000b\u0002gA\u0011AgN\u0007\u0002k)\ta'A\u0003tG\u0006d\u0017-\u0003\u00029k\t!QK\\5u\u0003M!Xm\u001d;QeVtW\rU1si&$\u0018n\u001c8tQ\t\u00191\b\u0005\u0002=\u00076\tQH\u0003\u0002?\u007f\u0005\u0019\u0011\r]5\u000b\u0005\u0001\u000b\u0015a\u00026va&$XM\u001d\u0006\u0003\u0005\u000e\nQA[;oSRL!\u0001R\u001f\u0003\tQ+7\u000f^\u00018i\u0016\u001cH/\u0012=qe\u0016\u001c8/[8o\u0013:$W\r\u001f)beRLG/[8o'R\fGo],ji\",f\u000e]1si&$\u0018n\u001c8fIR\u000b'\r\\3)\u0005\u0011Y\u0014A\n;fgR\u0004\u0016M\u001d;ji&|g\u000e\u0015:v]&twmV5uQB\u000b'\u000f^5uS>t7\u000b^1ug\"\u0012QaO\u00012i\u0016\u001cH\u000fU1si&$\u0018n\u001c8QeVt\u0017N\\4BMR,'/\u00169eCR,w+\u001b;i!\u0006\u0014H/\u001b;j_:\u001cF/\u0019;tQ\t11(A\u0019uKN$\b+\u0019:uSRLwN\u001c)sk:LgnZ!gi\u0016\u0014H)\u001a7fi\u0016<\u0016\u000e\u001e5QCJ$\u0018\u000e^5p]N#\u0018\r^:)\u0005\u001dY\u0014\u0001\b;fgR\u0014En\\8n\r&dG/\u001a:t\u0013:$W\r\u001f)sk:Lgn\u001a\u0015\u0003\u0011m\nQ#Y:tKJ$H+\u00192mK&#WM\u001c;jM&,'\u000f\u0006\u00034#nC\u0007\"\u0002*\n\u0001\u0004\u0019\u0016\u0001D2bi\u0006dwn\u001a+bE2,\u0007C\u0001+Z\u001b\u0005)&B\u0001,X\u0003\u001d\u0019\u0017\r^1m_\u001eT!\u0001W\u000f\u0002\u0011\r\fG/\u00197zgRL!AW+\u0003\u0019\r\u000bG/\u00197pOR\u000b'\r\\3\t\u000bqK\u0001\u0019A/\u0002)\u0015D\b/Z2uK\u0012$\u0015\r^1cCN,g*Y7f!\tqVM\u0004\u0002`GB\u0011\u0001-N\u0007\u0002C*\u0011!-J\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011,\u0014A\u0002)sK\u0012,g-\u0003\u0002gO\n11\u000b\u001e:j]\u001eT!\u0001Z\u001b\t\u000b%L\u0001\u0019A/\u0002#\u0015D\b/Z2uK\u0012$\u0016M\u00197f\u001d\u0006lW-\u0001\u000btKR\u001cu.\u001c9bGRLwN\\\"p]\u001aLwm\u001d\u000b\u0003g1DQ!\u001c\u0006A\u0002u\u000b\u0011\u0002^1cY\u0016$\u0016\u0010]3\u0002M]\u0014\u0018\u000e^3SK\u000e|'\u000fZ:B]\u00124\u0016\r\\5eCR,W\t\u001f9sKN\u001c\u0018n\u001c8J]\u0012,\u0007\u0010F\u00044aJ$\u0018p_?\t\u000bE\\\u0001\u0019A/\u0002\u0013Q\f'\r\\3OC6,\u0007\"B:\f\u0001\u0004i\u0016\u0001\u00032bg\u0016\u0004\u0016\r\u001e5\t\u000bU\\\u0001\u0019\u0001<\u0002\u0011%\u001cH)\u001a7fi\u0016\u0004\"\u0001N<\n\u0005a,$a\u0002\"p_2,\u0017M\u001c\u0005\u0006u.\u0001\rA^\u0001\u000eg\"|W\u000f\u001c3D_6\u0004\u0018m\u0019;\t\u000bq\\\u0001\u0019\u0001<\u0002\u001bMDw.\u001e7e\u00072,8\u000f^3s\u0011\u0015q8\u00021\u0001w\u00039\u0019\bn\\;mIJ{G\u000e\u001c2bG.\f\u0011C^3sS\u001aLh)\u001b7f!J,h.\u001b8h)-\u0019\u00141AA\u0007\u0003;\t\t$!\u000e\t\u000f\u0005\u0015A\u00021\u0001\u0002\b\u0005!q\u000e\u001d;t!\u0015q\u0016\u0011B/^\u0013\r\tYa\u001a\u0002\u0004\u001b\u0006\u0004\bbBA\b\u0019\u0001\u0007\u0011\u0011C\u0001\u000bI\u0006$\u0018MR5mi\u0016\u0014\b\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]q+A\u0006fqB\u0014Xm]:j_:\u001c\u0018\u0002BA\u000e\u0003+\u0011!\"\u0012=qe\u0016\u001c8/[8o\u0011\u001d\ty\u0002\u0004a\u0001\u0003C\t!\"\\3uC\u000ec\u0017.\u001a8u!\u0011\t\u0019#!\f\u000e\u0005\u0005\u0015\"\u0002BA\u0014\u0003S\tQ\u0001^1cY\u0016T1AKA\u0016\u0015\ta\u0012%\u0003\u0003\u00020\u0005\u0015\"!\u0006%p_\u0012LW\rV1cY\u0016lU\r^1DY&,g\u000e\u001e\u0005\t\u0003ga\u0001\u0013!a\u0001m\u00061\u0012n\u001d#bi\u0006\u001c6.\u001b9qS:<W\t\u001f9fGR,G\r\u0003\u0005\u000281\u0001\n\u00111\u0001w\u0003AI7OT8TG\u0006tW\t\u001f9fGR,G-A\u000ewKJLg-\u001f$jY\u0016\u0004&/\u001e8j]\u001e$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003{Q3A^A W\t\t\t\u0005\u0005\u0003\u0002D\u00055SBAA#\u0015\u0011\t9%!\u0013\u0002\u0013Ut7\r[3dW\u0016$'bAA&k\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005=\u0013Q\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017a\u0007<fe&4\u0017PR5mKB\u0013XO\\5oO\u0012\"WMZ1vYR$S'\u0001\fwKJLg-\u001f)beRLG/[8o!J,h.\u001b8h)5\u0019\u0014qKA-\u0003_\n\t(a\u001d\u0002v!9\u0011QA\bA\u0002\u0005\u001d\u0001bBA.\u001f\u0001\u0007\u0011QL\u0001\u0010a\u0006\u0014H/\u001b;j_:4\u0015\u000e\u001c;feB1\u0011qLA5\u0003#qA!!\u0019\u0002f9\u0019\u0001-a\u0019\n\u0003YJ1!a\u001a6\u0003\u001d\u0001\u0018mY6bO\u0016LA!a\u001b\u0002n\t\u00191+Z9\u000b\u0007\u0005\u001dT\u0007C\u0004\u0002\u0010=\u0001\r!!\u0018\t\u000f\u0005}q\u00021\u0001\u0002\"!A\u00111G\b\u0011\u0002\u0003\u0007a\u000f\u0003\u0005\u00028=\u0001\n\u00111\u0001w\u0003\u00012XM]5gsB\u000b'\u000f^5uS>t\u0007K];oS:<G\u0005Z3gCVdG\u000fJ\u001b\u0002AY,'/\u001b4z!\u0006\u0014H/\u001b;j_:\u0004&/\u001e8j]\u001e$C-\u001a4bk2$HEN\u0001\u0018O\u0016$H*\u0019;fgR$\u0015\r^1GS2,7oQ8v]R$b!a \u0002\u0006\u0006%\u0005c\u0001\u001b\u0002\u0002&\u0019\u00111Q\u001b\u0003\t1{gn\u001a\u0005\t\u0003\u000f\u0013\u0002\u0013!a\u0001m\u0006y\u0011N\\2mk\u0012,Gj\\4GS2,7\u000fC\u0004\u0002 I\u0001\r!!\t\u0002C\u001d,G\u000fT1uKN$H)\u0019;b\r&dWm]\"pk:$H\u0005Z3gCVdG\u000fJ\u0019\u0002-\u001d,G\u000fV1cY\u00164\u0015\u000e\\3TsN$X-\u001c,jK^$B!!%\u0002\u001eB!\u00111SAM\u001b\t\t)J\u0003\u0003\u0002\u0018\u0006\u0015\u0012\u0001\u0002<jK^LA!a'\u0002\u0016\nI\u0002j\\8eS\u0016$\u0016M\u00197f\r&dWmU=ti\u0016lg+[3x\u0011\u001d\ty\u0002\u0006a\u0001\u0003C\tQcZ3u/JLG/Z\"p]\u001aLwMQ;jY\u0012,'\u000f\u0006\u0004\u0002$\u0006]\u00161\u0018\t\u0005\u0003K\u000b\tL\u0004\u0003\u0002(\u00065VBAAU\u0015\u0011\tY+a\u000b\u0002\r\r|gNZ5h\u0013\u0011\ty+!+\u0002#!{w\u000eZ5f/JLG/Z\"p]\u001aLw-\u0003\u0003\u00024\u0006U&a\u0002\"vS2$WM\u001d\u0006\u0005\u0003_\u000bI\u000bC\u0004\u0002:V\u0001\r!a\u0002\u0002\u0011!,H-[(qiNDQa]\u000bA\u0002u\u0003")
public class TestExpressionIndex
extends HoodieSparkSqlTestBase {
    @Override
    public void beforeAll() {
        this.spark().sql("set hoodie.metadata.index.column.stats.enable=false");
        this.initQueryIndexConf();
    }

    @Test
    public void testPrunePartitions() {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$testPrunePartitions$1(this, tmp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testExpressionIndexPartitionStatsWithUnpartitionedTable() {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$testExpressionIndexPartitionStatsWithUnpartitionedTable$1(this, tmp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPartitionPruningWithPartitionStats() {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$testPartitionPruningWithPartitionStats$1(this, tmp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPartitionPruningAfterUpdateWithPartitionStats() {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$testPartitionPruningAfterUpdateWithPartitionStats$1(this, tmp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testPartitionPruningAfterDeleteWithPartitionStats() {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$testPartitionPruningAfterDeleteWithPartitionStats$1(this, tmp);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testBloomFiltersIndexPruning() {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$testBloomFiltersIndexPruning$1(this, tmp);
            return BoxedUnit.UNIT;
        });
    }

    private void assertTableIdentifier(CatalogTable catalogTable, String expectedDatabaseName, String expectedTableName) {
        this.assertResult(new Some((Object)expectedDatabaseName), catalogTable.identifier().database(), Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1840));
        this.assertResult(expectedTableName, catalogTable.identifier().table(), Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1841));
    }

    private void setCompactionConfigs(String tableType) {
        String string = tableType;
        String string2 = "mor";
        this.spark().sql(new StringBuilder(27).append("set hoodie.compact.inline= ").append((Object)(!(string != null ? !string.equals(string2) : string2 != null) ? "true" : "false")).toString());
        String string3 = tableType;
        String string4 = "mor";
        if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
            this.spark().sql("set hoodie.compact.inline.max.delta.commits=2");
            return;
        }
    }

    private void writeRecordsAndValidateExpressionIndex(String tableName, String basePath, boolean isDelete, boolean shouldCompact, boolean shouldCluster, boolean shouldRollback) {
        this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(1, 'a1', 1601098924, 10)").toString());
        this.spark().sql(new StringBuilder(45).append("insert into ").append(tableName).append(" values(2, 'a2', 1632634924, 100)").toString());
        this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName).append(" values(3, 'a3', 1664170924, 1000)").toString());
        this.spark().sql(new StringBuilder(102).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)basePath);
        scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}));
        UnresolvedAttribute tsColumn = UnresolvedAttribute$.MODULE$.apply("ts");
        Literal format = Literal$.MODULE$.apply((Object)"yyyy-MM-dd");
        FromUnixTime fromUnixTimeExpr = new FromUnixTime((Expression)tsColumn, (Expression)format, FromUnixTime$.MODULE$.apply$default$3());
        Literal targetDate = Literal$.MODULE$.apply((Object)"2024-03-26");
        EqualTo dataFilter = new EqualTo((Expression)fromUnixTimeExpr, (Expression)targetDate);
        this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, this.verifyFilePruning$default$4(), this.verifyFilePruning$default$5());
        Dataset dataset = isDelete ? this.spark().sql(new StringBuilder(23).append("delete from ").append(tableName).append(" where id=1").toString()) : this.spark().sql(new StringBuilder(47).append("insert into ").append(tableName).append(" values(4, 'a4', 1727329324, 10000)").toString());
        String metadataSql = new StringBuilder(160).append("select ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value, ColumnStatsMetadata.isDeleted from hudi_metadata('").append(tableName).append("') where type=3").toString();
        this.checkAnswer(metadataSql, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2020-09-26", "2020-09-26", BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2021-09-26", "2021-09-26", BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2022-09-26", "2022-09-26", BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2024-09-26", "2024-09-26", BoxesRunTime.boxToBoolean((boolean)false)}))}));
        if (shouldRollback) {
            Option lastCompletedInstant = metaClient.reloadActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant();
            HoodieWriteConfig.Builder configBuilder = this.getWriteConfigBuilder((scala.collection.immutable.Map<String, String>)Predef$.MODULE$.Map().empty(), metaClient.getBasePath().toString());
            configBuilder.withMetadataConfig(HoodieMetadataConfig.newBuilder().withMetadataIndexColumnStats(false).withMetadataIndexPartitionStats(false).build());
            SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(new JavaSparkContext(this.spark().sparkContext())), configBuilder.build());
            writeClient.rollback(((HoodieInstant)lastCompletedInstant.get()).requestedTime());
            this.checkAnswer(metadataSql, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2020-09-26", "2020-09-26", BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2021-09-26", "2021-09-26", BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2022-09-26", "2022-09-26", BoxesRunTime.boxToBoolean((boolean)false)}))}));
            return;
        }
    }

    private void verifyFilePruning(scala.collection.immutable.Map<String, String> opts, Expression dataFilter, HoodieTableMetaClient metaClient, boolean isDataSkippingExpected, boolean isNoScanExpected) {
        scala.collection.immutable.Map commonOpts = opts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)metaClient.getBasePath().toString()));
        SparkSession x$1 = this.spark();
        HoodieTableMetaClient x$2 = metaClient;
        None$ x$3 = None$.MODULE$;
        scala.collection.immutable.Map x$4 = commonOpts;
        boolean x$5 = true;
        FileStatusCache x$6 = HoodieFileIndex$.MODULE$.apply$default$5();
        boolean x$7 = HoodieFileIndex$.MODULE$.apply$default$7();
        try (HoodieFileIndex fileIndex = new HoodieFileIndex(x$1, x$2, (scala.Option)x$3, x$4, x$6, x$5, x$7);){
            Seq filteredPartitionDirectories = fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$));
            int filteredFilesCount = ((SeqLike)filteredPartitionDirectories.flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size();
            HoodieTableMetaClient x$8 = metaClient;
            boolean x$9 = this.getLatestDataFilesCount$default$1();
            long latestDataFilesCount = this.getLatestDataFilesCount(x$9, x$8);
            if (isDataSkippingExpected) {
                Assertions.assertTrue(((long)filteredFilesCount < latestDataFilesCount ? 1 : 0) != 0);
                if (isNoScanExpected) {
                    Assertions.assertTrue((filteredFilesCount == 0 ? 1 : 0) != 0);
                } else {
                    Assertions.assertTrue((filteredFilesCount > 0 ? 1 : 0) != 0);
                }
            } else {
                Assertions.assertTrue(((long)filteredFilesCount == latestDataFilesCount ? 1 : 0) != 0);
            }
            SparkSession x$10 = this.spark();
            HoodieTableMetaClient x$11 = metaClient;
            None$ x$12 = None$.MODULE$;
            scala.collection.immutable.Map x$13 = commonOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"false"));
            boolean x$14 = true;
            FileStatusCache x$15 = HoodieFileIndex$.MODULE$.apply$default$5();
            boolean x$16 = HoodieFileIndex$.MODULE$.apply$default$7();
            fileIndex = new HoodieFileIndex(x$10, x$11, (scala.Option)x$12, x$13, x$15, x$14, x$16);
            int filesCountWithNoSkipping = ((SeqLike)fileIndex.listFiles((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)).flatMap((Function1 & Serializable & scala.Serializable)s -> s.files(), Seq$.MODULE$.canBuildFrom())).size();
            Assertions.assertTrue(((long)filesCountWithNoSkipping == latestDataFilesCount ? 1 : 0) != 0);
        }
    }

    private boolean verifyFilePruning$default$4() {
        return false;
    }

    private boolean verifyFilePruning$default$5() {
        return false;
    }

    private void verifyPartitionPruning(scala.collection.immutable.Map<String, String> opts, Seq<Expression> partitionFilter, Seq<Expression> dataFilter, HoodieTableMetaClient metaClient, boolean isDataSkippingExpected, boolean isNoScanExpected) {
        scala.collection.immutable.Map commonOpts = opts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)metaClient.getBasePath().toString()));
        SparkSession x$1 = this.spark();
        HoodieTableMetaClient x$2 = metaClient;
        None$ x$3 = None$.MODULE$;
        scala.collection.immutable.Map x$4 = commonOpts;
        boolean x$5 = true;
        FileStatusCache x$6 = HoodieFileIndex$.MODULE$.apply$default$5();
        boolean x$7 = HoodieFileIndex$.MODULE$.apply$default$7();
        try (HoodieFileIndex fileIndex = new HoodieFileIndex(x$1, x$2, (scala.Option)x$3, x$4, x$6, x$5, x$7);){
            Tuple2 tuple2 = fileIndex.prunePartitionsAndGetFileSlices(dataFilter, partitionFilter);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            boolean isPruned = tuple2._1$mcZ$sp();
            Seq filteredPartitionDirectoriesAndFileSlices = (Seq)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isPruned), (Object)filteredPartitionDirectoriesAndFileSlices);
            boolean isPruned2 = tuple22._1$mcZ$sp();
            Seq filteredPartitionDirectoriesAndFileSlices2 = (Seq)tuple22._2();
            if (isDataSkippingExpected) {
                Assertions.assertTrue((boolean)isPruned2);
            }
            long filteredFilesCount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)filteredPartitionDirectoriesAndFileSlices2.map((Function1 & Serializable & scala.Serializable)o -> (Seq)o._2(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)s -> s.iterator(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)f1 -> BoxesRunTime.boxToLong((long)TestExpressionIndex.$anonfun$verifyPartitionPruning$3(f1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            HoodieTableMetaClient x$8 = metaClient;
            boolean x$9 = this.getLatestDataFilesCount$default$1();
            long latestDataFilesCount = this.getLatestDataFilesCount(x$9, x$8);
            if (isDataSkippingExpected) {
                Assertions.assertTrue((filteredFilesCount < latestDataFilesCount ? 1 : 0) != 0);
                if (isNoScanExpected) {
                    Assertions.assertTrue((filteredFilesCount == 0L ? 1 : 0) != 0);
                } else {
                    Assertions.assertTrue((filteredFilesCount > 0L ? 1 : 0) != 0);
                }
            } else {
                Assertions.assertTrue((filteredFilesCount == latestDataFilesCount ? 1 : 0) != 0);
            }
            SparkSession x$10 = this.spark();
            HoodieTableMetaClient x$11 = metaClient;
            None$ x$12 = None$.MODULE$;
            scala.collection.immutable.Map x$13 = commonOpts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"false"));
            boolean x$14 = true;
            FileStatusCache x$15 = HoodieFileIndex$.MODULE$.apply$default$5();
            boolean x$16 = HoodieFileIndex$.MODULE$.apply$default$7();
            fileIndex = new HoodieFileIndex(x$10, x$11, (scala.Option)x$12, x$13, x$15, x$14, x$16);
            long filesCountWithNoSkipping = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)fileIndex.prunePartitionsAndGetFileSlices(partitionFilter, dataFilter)._2()).map((Function1 & Serializable & scala.Serializable)o -> (Seq)o._2(), Seq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)s -> s.iterator(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)f1 -> BoxesRunTime.boxToLong((long)TestExpressionIndex.$anonfun$verifyPartitionPruning$6(f1)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            Assertions.assertTrue((filesCountWithNoSkipping == latestDataFilesCount ? 1 : 0) != 0);
        }
    }

    private boolean verifyPartitionPruning$default$5() {
        return false;
    }

    private boolean verifyPartitionPruning$default$6() {
        return false;
    }

    private long getLatestDataFilesCount(boolean includeLogFiles, HoodieTableMetaClient metaClient) {
        LongRef totalLatestDataFiles = LongRef.create((long)0L);
        try (HoodieTableFileSystemView fsView = this.getTableFileSystemView(metaClient);){
            fsView.getAllLatestFileSlicesBeforeOrOn(((HoodieInstant)metaClient.getActiveTimeline().lastInstant().get()).requestedTime()).values().forEach(JFunction$.MODULE$.toJavaConsumer((Function1 & Serializable & scala.Serializable)slices -> {
                slices.forEach(JFunction$.MODULE$.toJavaConsumer((Function1 & Serializable & scala.Serializable)slice -> {
                    totalLatestDataFiles$1.elem = totalLatestDataFiles$1.elem + ((includeLogFiles$1 ? slice.getLogFiles().count() : 0L) + (long)(slice.getBaseFile().isPresent() ? 1 : 0));
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            }));
        }
        return totalLatestDataFiles.elem;
    }

    private boolean getLatestDataFilesCount$default$1() {
        return true;
    }

    private HoodieTableFileSystemView getTableFileSystemView(HoodieTableMetaClient metaClient) {
        HoodieSparkEngineContext engineContext = new HoodieSparkEngineContext(new JavaSparkContext(this.spark().sparkContext()));
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).withMetadataIndexPartitionStats(true).build();
        HoodieBackedTableMetadata metadataTable = new HoodieBackedTableMetadata((HoodieEngineContext)engineContext, metaClient.getStorage(), metadataConfig, metaClient.getBasePath().toString());
        return new HoodieTableFileSystemView((HoodieTableMetadata)metadataTable, metaClient, (HoodieTimeline)metaClient.getActiveTimeline());
    }

    private HoodieWriteConfig.Builder getWriteConfigBuilder(scala.collection.immutable.Map<String, String> hudiOpts, String basePath) {
        TypedProperties props = TypedProperties.fromMap((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(hudiOpts).asJava()));
        return HoodieWriteConfig.newBuilder().withProps((java.util.Map)props).withPath(basePath);
    }

    public static final /* synthetic */ void $anonfun$new$2(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"mor", (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String databaseName = "testdb";
            String tableName = $this.generateTableName();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(401).append("\n               |create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long\n               |) using hudi\n               | options (\n               |  primaryKey ='id',\n               |  type = '").append((String)tableType).append("',\n               |  preCombineField = 'ts'\n               | )\n               | partitioned by(ts)\n               | location '").append(basePath).append("'\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
            $this.spark().sql(new StringBuilder(21).append("DROP TABLE if exists ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(36).append("CREATE TABLE ").append(tableName).append(" USING hudi LOCATION '").append(basePath).append("'").toString());
            $this.spark().sql(new StringBuilder(108).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd HH:mm')").toString());
            $this.spark().sql(new StringBuilder(40).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 100000)").toString());
            $this.spark().sql(new StringBuilder(42).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 10000000)").toString());
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
            HoodieIndexMetadata expressionIndexMetadata = (HoodieIndexMetadata)metaClient.getIndexMetadata().get();
            Assertions.assertEquals((int)1, (int)expressionIndexMetadata.getIndexDefinitions().size());
            Assertions.assertEquals((Object)"expr_index_idx_datestr", (Object)((HoodieIndexDefinition)expressionIndexMetadata.getIndexDefinitions().get("expr_index_idx_datestr")).getIndexName());
            TypedProperties hiveSyncProps = new TypedProperties();
            hiveSyncProps.setProperty(DataSourceWriteOptions$.MODULE$.HIVE_USER().key(), "");
            hiveSyncProps.setProperty(DataSourceWriteOptions$.MODULE$.HIVE_PASS().key(), "");
            hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_DATABASE_NAME.key(), databaseName);
            hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_TABLE_NAME.key(), tableName);
            hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_BASE_PATH.key(), basePath);
            hiveSyncProps.setProperty(DataSourceWriteOptions$.MODULE$.HIVE_USE_PRE_APACHE_INPUT_FORMAT().key(), "false");
            hiveSyncProps.setProperty(HoodieSyncConfig.META_SYNC_NO_PARTITION_METADATA.key(), "true");
            HiveTestUtil.setUp((Option)Option.of((Object)hiveSyncProps), (boolean)false);
            HiveSyncTool tool = new HiveSyncTool((Properties)hiveSyncProps, (Configuration)HiveTestUtil.getHiveConf());
            tool.syncHoodieTable();
            HoodieHiveSyncClient hiveClient = new HoodieHiveSyncClient(HiveTestUtil.getHiveSyncConfig(), HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient));
            String roTable = new StringBuilder(3).append(tableName).append("_ro").toString();
            String rtTable = new StringBuilder(3).append(tableName).append("_rt").toString();
            Assertions.assertTrue((boolean)hiveClient.tableExists(roTable));
            Assertions.assertTrue((boolean)hiveClient.tableExists(rtTable));
            Assertions.assertEquals((int)0, (int)hiveClient.getAllPartitions(roTable).size());
            Assertions.assertEquals((int)0, (int)hiveClient.getAllPartitions(rtTable).size());
            $this.checkAnswer(new StringBuilder(74).append("select id, name from ").append(tableName).append(" where from_unixtime(ts, 'yyyy-MM-dd') = '1970-01-01'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1"}))}));
            hiveClient.close();
            tool.close();
            HiveTestUtil.shutdown();
            return $this.spark().sql(new StringBuilder(21).append("DROP TABLE if exists ").append(tableName).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$new$5(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String databaseName = "default";
            String tableName = $this.generateTableName();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append((String)tableType).append("',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by(ts)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
            ParserInterface sqlParser = $this.spark().sessionState().sqlParser();
            Analyzer analyzer = $this.spark().sessionState().analyzer();
            LogicalPlan logicalPlan = sqlParser.parsePlan(new StringBuilder(26).append("show indexes from default.").append(tableName).toString());
            LogicalPlan resolvedLogicalPlan = analyzer.execute(logicalPlan);
            $this.assertTableIdentifier(((ShowIndexesCommand)resolvedLogicalPlan).table(), databaseName, tableName);
            logicalPlan = sqlParser.parsePlan(new StringBuilder(102).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString());
            resolvedLogicalPlan = analyzer.execute(logicalPlan);
            $this.assertTableIdentifier(((CreateIndexCommand)resolvedLogicalPlan).table(), databaseName, tableName);
            $this.assertResult("idx_datestr", ((CreateIndexCommand)resolvedLogicalPlan).indexName(), Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            $this.assertResult("column_stats", ((CreateIndexCommand)resolvedLogicalPlan).indexType(), Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 193));
            $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)((CreateIndexCommand)resolvedLogicalPlan).ignoreIfExists()), Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 194));
            $this.assertResult(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)"from_unixtime"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"format"), (Object)"yyyy-MM-dd")})), ((CreateIndexCommand)resolvedLogicalPlan).options(), Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
            logicalPlan = sqlParser.parsePlan(new StringBuilder(73).append("create index idx_name on ").append(tableName).append(" using bloom_filters(name) options(expr='lower')").toString());
            resolvedLogicalPlan = analyzer.execute(logicalPlan);
            $this.assertTableIdentifier(((CreateIndexCommand)resolvedLogicalPlan).table(), databaseName, tableName);
            $this.assertResult("idx_name", ((CreateIndexCommand)resolvedLogicalPlan).indexName(), Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 200));
            $this.assertResult("bloom_filters", ((CreateIndexCommand)resolvedLogicalPlan).indexType(), Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
            $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)((CreateIndexCommand)resolvedLogicalPlan).ignoreIfExists()), Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 202));
            return $this.assertResult(Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"expr"), (Object)"lower")})), ((CreateIndexCommand)resolvedLogicalPlan).options(), Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203));
        });
    }

    public static final /* synthetic */ void $anonfun$new$8(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            Bool bool;
            Set mdtPartitions;
            String databaseName = "default";
            String tableName = $this.generateTableName();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(501).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append((String)tableType).append("',\n             |  preCombineField = 'ts',\n             |  hoodie.metadata.record.index.enable = 'true',\n             |  hoodie.datasource.write.recordkey.field = 'id'\n             | )\n             | partitioned by(ts)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
            $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.RECORD_INDEX), "metaClient.getTableConfig().isMetadataPartitionAvailable(RECORD_INDEX)", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            ParserInterface sqlParser = $this.spark().sessionState().sqlParser();
            Analyzer analyzer = $this.spark().sessionState().analyzer();
            LogicalPlan logicalPlan = sqlParser.parsePlan(new StringBuilder(26).append("show indexes from default.").append(tableName).toString());
            LogicalPlan resolvedLogicalPlan = analyzer.execute(logicalPlan);
            $this.assertTableIdentifier(((ShowIndexesCommand)resolvedLogicalPlan).table(), databaseName, tableName);
            String createIndexSql = new StringBuilder(102).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString();
            logicalPlan = sqlParser.parsePlan(createIndexSql);
            resolvedLogicalPlan = analyzer.execute(logicalPlan);
            $this.assertTableIdentifier(((CreateIndexCommand)resolvedLogicalPlan).table(), databaseName, tableName);
            $this.assertResult("idx_datestr", ((CreateIndexCommand)resolvedLogicalPlan).indexName(), Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            $this.assertResult("column_stats", ((CreateIndexCommand)resolvedLogicalPlan).indexType(), Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 253));
            $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)((CreateIndexCommand)resolvedLogicalPlan).ignoreIfExists()), Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
            $this.spark().sql(createIndexSql);
            metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
            HoodieIndexMetadata expressionIndexMetadata = (HoodieIndexMetadata)metaClient.getIndexMetadata().get();
            Assertions.assertEquals((int)1, (int)expressionIndexMetadata.getIndexDefinitions().size());
            Assertions.assertEquals((Object)"expr_index_idx_datestr", (Object)((HoodieIndexDefinition)expressionIndexMetadata.getIndexDefinitions().get("expr_index_idx_datestr")).getIndexName());
            createIndexSql = new StringBuilder(49).append("create index name_lower on ").append(tableName).append(" using column_stat(ts)").toString();
            $this.checkException(createIndexSql, "column_stat is not supported");
            createIndexSql = new StringBuilder(73).append("create index name_lower on ").append(tableName).append(" using column_stats(ts) options(expr='random')").toString();
            $this.checkNestedException(createIndexSql, "Unsupported Spark function: random");
            createIndexSql = new StringBuilder(50).append("create index name_lower on ").append(tableName).append(" using column_stats(ts)").toString();
            $this.checkException(createIndexSql, "Column stats index without expression on any column can be created using datasource configs. Please refer https://hudi.apache.org/docs/metadata for more info");
            createIndexSql = new StringBuilder(101).append("create index name_lower on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString();
            $this.spark().sql(createIndexSql);
            metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            expressionIndexMetadata = (HoodieIndexMetadata)metaClient.getIndexMetadata().get();
            Assertions.assertEquals((int)2, (int)expressionIndexMetadata.getIndexDefinitions().size());
            Assertions.assertEquals((Object)"expr_index_name_lower", (Object)((HoodieIndexDefinition)expressionIndexMetadata.getIndexDefinitions().get("expr_index_name_lower")).getIndexName());
            Set $org_scalatest_assert_macro_left = mdtPartitions = metaClient.getTableConfig().getMetadataPartitions();
            String $org_scalatest_assert_macro_right = "expr_index_name_lower";
            Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
            if ($org_scalatest_assert_macro_left2.value()) {
                Set $org_scalatest_assert_macro_left3 = mdtPartitions;
                String $org_scalatest_assert_macro_right2 = "expr_index_idx_datestr";
                bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
            } else {
                bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
            }
            Bool $org_scalatest_assert_macro_right3 = bool;
            Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 281));
            Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.simpleMacroBool(metaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.RECORD_INDEX), "metaClient.getTableConfig().isMetadataPartitionAvailable(RECORD_INDEX)", Prettifier$.MODULE$.default());
            return Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 284));
        });
    }

    public static final /* synthetic */ void $anonfun$new$12(TestExpressionIndex $this, File tmp) {
        Bool bool;
        Set mdtPartitions;
        String databaseName = "default";
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(474).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | options (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts',\n           |  hoodie.metadata.record.index.enable = 'true',\n           |  hoodie.datasource.write.recordkey.field = 'id'\n           | )\n           | partitioned by(ts)\n           | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(metaClient.getTableConfig().isMetadataPartitionAvailable(MetadataPartitionType.RECORD_INDEX), "metaClient.getTableConfig().isMetadataPartitionAvailable(RECORD_INDEX)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 318));
        ParserInterface sqlParser = $this.spark().sessionState().sqlParser();
        Analyzer analyzer = $this.spark().sessionState().analyzer();
        LogicalPlan logicalPlan = sqlParser.parsePlan(new StringBuilder(26).append("show indexes from default.").append(tableName).toString());
        LogicalPlan resolvedLogicalPlan = analyzer.execute(logicalPlan);
        $this.assertTableIdentifier(((ShowIndexesCommand)resolvedLogicalPlan).table(), databaseName, tableName);
        $this.spark().sql(new StringBuilder(102).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString());
        metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
        HoodieIndexMetadata expressionIndexMetadata = (HoodieIndexMetadata)metaClient.getIndexMetadata().get();
        Assertions.assertEquals((int)1, (int)expressionIndexMetadata.getIndexDefinitions().size());
        Assertions.assertEquals((Object)"expr_index_idx_datestr", (Object)((HoodieIndexDefinition)expressionIndexMetadata.getIndexDefinitions().get("expr_index_idx_datestr")).getIndexName());
        $this.spark().sql(new StringBuilder(95).append("create index name_lower on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy')").toString());
        metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        expressionIndexMetadata = (HoodieIndexMetadata)metaClient.getIndexMetadata().get();
        Assertions.assertEquals((int)2, (int)expressionIndexMetadata.getIndexDefinitions().size());
        Assertions.assertEquals((Object)"expr_index_name_lower", (Object)((HoodieIndexDefinition)expressionIndexMetadata.getIndexDefinitions().get("expr_index_name_lower")).getIndexName());
        Set $org_scalatest_assert_macro_left = mdtPartitions = metaClient.getTableConfig().getMetadataPartitions();
        String $org_scalatest_assert_macro_right = "expr_index_name_lower";
        Bool $org_scalatest_assert_macro_left2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left, "contains", (Object)$org_scalatest_assert_macro_right, $org_scalatest_assert_macro_left.contains($org_scalatest_assert_macro_right), Prettifier$.MODULE$.default());
        if ($org_scalatest_assert_macro_left2.value()) {
            Set $org_scalatest_assert_macro_left3 = mdtPartitions;
            String $org_scalatest_assert_macro_right2 = "expr_index_idx_datestr";
            bool = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left3, "contains", (Object)$org_scalatest_assert_macro_right2, $org_scalatest_assert_macro_left3.contains($org_scalatest_assert_macro_right2), Prettifier$.MODULE$.default());
        } else {
            bool = Bool$.MODULE$.simpleMacroBool(false, "", Prettifier$.MODULE$.default());
        }
        Bool $org_scalatest_assert_macro_right3 = bool;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left2, "&&", (Object)$org_scalatest_assert_macro_right3, $org_scalatest_assert_macro_left2.$amp$amp((Function0 & Serializable & scala.Serializable)() -> $org_scalatest_assert_macro_right3), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 344));
        $this.spark().sql(new StringBuilder(26).append("drop index idx_datestr on ").append(tableName).toString());
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        Set $org_scalatest_assert_macro_left4 = metaClient.getTableConfig().getMetadataPartitions();
        String $org_scalatest_assert_macro_right4 = "expr_index_idx_datestr";
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left4, "contains", (Object)$org_scalatest_assert_macro_right4, $org_scalatest_assert_macro_left4.contains($org_scalatest_assert_macro_right4), Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 350));
        Set $org_scalatest_assert_macro_left5 = metaClient.getTableConfig().getMetadataPartitions();
        String $org_scalatest_assert_macro_right5 = "expr_index_name_lower";
        Bool $org_scalatest_assert_macro_expr4 = Bool$.MODULE$.binaryMacroBool((Object)$org_scalatest_assert_macro_left5, "contains", (Object)$org_scalatest_assert_macro_right5, $org_scalatest_assert_macro_left5.contains($org_scalatest_assert_macro_right5), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr4, (Object)"", Prettifier$.MODULE$.default(), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 352));
    }

    public static final /* synthetic */ void $anonfun$new$15(TestExpressionIndex $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(431).append("create table ").append(tableName).append(" (\n            id int,\n            name string,\n            price double,\n            ts long\n            ) using hudi\n            options (\n            primaryKey ='id',\n            type = 'mor',\n            preCombineField = 'ts',\n            hoodie.metadata.record.index.enable = 'true',\n            hoodie.datasource.write.recordkey.field = 'id'\n            )\n            partitioned by(ts)\n            location '").append(basePath).append("'").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
        $this.checkAnswer(new StringBuilder(74).append("select id, name from ").append(tableName).append(" where from_unixtime(ts, 'yyyy-MM-dd') = '1970-01-01'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3"}))}));
        String createIndexSql = new StringBuilder(102).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString();
        $this.spark().sql(createIndexSql);
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        HoodieIndexMetadata expressionIndexMetadata = (HoodieIndexMetadata)metaClient.getIndexMetadata().get();
        Assertions.assertEquals((int)1, (int)expressionIndexMetadata.getIndexDefinitions().size());
        Assertions.assertEquals((Object)"expr_index_idx_datestr", (Object)((HoodieIndexDefinition)expressionIndexMetadata.getIndexDefinitions().get("expr_index_idx_datestr")).getIndexName());
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains("expr_index_idx_datestr"));
        Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
        $this.spark().sql(new StringBuilder(42).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 10000000)").toString());
        $this.checkAnswer(new StringBuilder(74).append("select id, name from ").append(tableName).append(" where from_unixtime(ts, 'yyyy-MM-dd') = '1970-04-26'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4"}))}));
        createIndexSql = new StringBuilder(95).append("create index name_lower on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy')").toString();
        $this.spark().sql(createIndexSql);
        metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        expressionIndexMetadata = (HoodieIndexMetadata)metaClient.getIndexMetadata().get();
        Assertions.assertEquals((int)2, (int)expressionIndexMetadata.getIndexDefinitions().size());
        Assertions.assertEquals((Object)"expr_index_name_lower", (Object)((HoodieIndexDefinition)expressionIndexMetadata.getIndexDefinitions().get("expr_index_name_lower")).getIndexName());
        Set mdtPartitions = metaClient.getTableConfig().getMetadataPartitions();
        Assertions.assertTrue((mdtPartitions.contains("expr_index_name_lower") && mdtPartitions.contains("expr_index_idx_datestr") ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$new$18(TestExpressionIndex $this, File tmp$4, String tableType) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp$4.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql("set hoodie.metadata.enable=true");
        $this.spark().sql("set hoodie.enable.data.skipping=true");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(375).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  ts long,\n             |  price int\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append(tableType).append("',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by(price)\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? $this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
        $this.spark().sql(new StringBuilder(60).append("insert into ").append(tableName).append(" (id, name, ts, price) values(1, 'a1', 1000, 10)").toString());
        $this.spark().sql(new StringBuilder(63).append("insert into ").append(tableName).append(" (id, name, ts, price) values(2, 'a2', 200000, 100)").toString());
        $this.spark().sql(new StringBuilder(68).append("insert into ").append(tableName).append(" (id, name, ts, price) values(3, 'a3', 2000000000, 1000)").toString());
        $this.spark().sql(new StringBuilder(102).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
        HoodieIndexMetadata expressionIndexMetadata = (HoodieIndexMetadata)metaClient.getIndexMetadata().get();
        Assertions.assertEquals((int)1, (int)expressionIndexMetadata.getIndexDefinitions().size());
        Assertions.assertEquals((Object)"expr_index_idx_datestr", (Object)((HoodieIndexDefinition)expressionIndexMetadata.getIndexDefinitions().get("expr_index_idx_datestr")).getIndexName());
        $this.checkAnswer(new StringBuilder(118).append("select id, name, price, ts, from_unixtime(ts, 'yyyy-MM-dd') from ").append(tableName).append(" where from_unixtime(ts, 'yyyy-MM-dd') < '1970-01-03'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), "1970-01-01"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$17(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestExpressionIndex.$anonfun$new$18($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$20(TestExpressionIndex $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(354).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  price double,\n           |  ts long,\n           |  name string\n           |) using hudi\n           | options (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(name)\n           | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(1, 10, 1601098924, 'a1')").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(2, 10, 1632634924, 'a1')").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(3, 10, 1664170924, 'a2')").toString());
        $this.spark().sql(new StringBuilder(102).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains("expr_index_idx_datestr"));
        Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
        Assertions.assertEquals((int)1, (int)((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().size());
        String metadataSql = new StringBuilder(129).append("select ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value from hudi_metadata('").append(tableName).append("') where type=3").toString();
        $this.checkAnswer(metadataSql, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2020-09-26", (List)new .colon.colon((Object)"2021-09-26", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)"2022-09-26", (List)new .colon.colon((Object)"2022-09-26", (List)Nil$.MODULE$))}));
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(5, 10, 1727329324, 'a3')").toString());
        $this.checkAnswer(new StringBuilder(91).append("select id, name from ").append(tableName).append(" where from_unixtime(ts, 'yyyy-MM-dd') IN ('2024-09-26', '2022-09-26')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a3"}))}));
        $this.checkAnswer(metadataSql, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2020-09-26", (List)new .colon.colon((Object)"2021-09-26", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)"2022-09-26", (List)new .colon.colon((Object)"2022-09-26", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)"2024-09-26", (List)new .colon.colon((Object)"2024-09-26", (List)Nil$.MODULE$))}));
    }

    public static final /* synthetic */ void $anonfun$new$22(TestExpressionIndex $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(355).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  ts long,\n           |  price string\n           |) using hudi\n           | options (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(price)\n           | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName).append(" values(1, 'a1', 1601098924, '10')").toString());
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName).append(" values(2, 'a1', 1632634924, '10')").toString());
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName).append(" values(3, 'a2', 1664170924, '20')").toString());
        $this.spark().sql(new StringBuilder(102).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains("expr_index_idx_datestr"));
        Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
        Assertions.assertEquals((int)1, (int)((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().size());
        $this.spark().sql(new StringBuilder(72).append("create index idx_name on ").append(tableName).append(" using column_stats(name) options(expr='upper')").toString());
        metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains("expr_index_idx_name"));
        Assertions.assertEquals((int)2, (int)((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().size());
        String metadataSql = new StringBuilder(192).append("select ColumnStatsMetadata.columnName, ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value, ").append("ColumnStatsMetadata.isDeleted from hudi_metadata('").append(tableName).append("') where type=3").toString();
        $this.checkAnswer(metadataSql, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ts", "2020-09-26", "2021-09-26", BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ts", "2022-09-26", "2022-09-26", BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name", "A1", "A1", BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name", "A2", "A2", BoxesRunTime.boxToBoolean((boolean)false)}))}));
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set name = 'a3' where id = 1").toString());
        $this.checkAnswer(new StringBuilder(46).append("select id, name from ").append(tableName).append(" where upper(name) = 'A3'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a3"}))}));
        $this.checkAnswer(new StringBuilder(46).append("select id, name from ").append(tableName).append(" where upper(name) < 'A3'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a2"}))}));
        $this.checkAnswer(new StringBuilder(75).append("select id, name from ").append(tableName).append(" where from_unixtime(ts, 'yyyy-MM-dd') >= '2022-09-26'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a2"}))}));
        $this.checkAnswer(metadataSql, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ts", "2020-09-26", "2021-09-26", BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ts", "2020-09-26", "2020-09-26", BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ts", "2022-09-26", "2022-09-26", BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name", "A1", "A1", BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name", "A3", "A3", BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"name", "A2", "A2", BoxesRunTime.boxToBoolean((boolean)false)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$24(TestExpressionIndex $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(354).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  price double,\n           |  ts long,\n           |  name string\n           |) using hudi\n           | options (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(name)\n           | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(1, 10, 1601098924, 'a1')").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(2, 10, 1632634924, 'a1')").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(3, 10, 1664170924, 'a2')").toString());
        $this.spark().sql(new StringBuilder(102).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains("expr_index_idx_datestr"));
        Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
        Assertions.assertEquals((int)1, (int)((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().size());
        String metadataSql = new StringBuilder(129).append("select ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value from hudi_metadata('").append(tableName).append("') where type=3").toString();
        $this.checkAnswer(metadataSql, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2020-09-26", (List)new .colon.colon((Object)"2021-09-26", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)"2022-09-26", (List)new .colon.colon((Object)"2022-09-26", (List)Nil$.MODULE$))}));
        $this.spark().sql(new StringBuilder(10).append("set ").append(HoodieMetadataConfig.EXPRESSION_INDEX_ENABLE_PROP.key()).append("=false").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(4, 10, 1664170924, 'a2')").toString());
        $this.checkAnswer(new StringBuilder(74).append("select id, name from ").append(tableName).append(" where from_unixtime(ts, 'yyyy-MM-dd') = '2022-09-26'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a2"}))}));
        $this.spark().sql(new StringBuilder(9).append("set ").append(HoodieMetadataConfig.EXPRESSION_INDEX_ENABLE_PROP.key()).append("=true").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(5, 10, 1727329324, 'a3')").toString());
        $this.checkAnswer(new StringBuilder(91).append("select id, name from ").append(tableName).append(" where from_unixtime(ts, 'yyyy-MM-dd') IN ('2024-09-26', '2022-09-26')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)5), "a3"}))}));
        $this.checkAnswer(metadataSql, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2020-09-26", (List)new .colon.colon((Object)"2021-09-26", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)"2022-09-26", (List)new .colon.colon((Object)"2022-09-26", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)"2022-09-26", (List)new .colon.colon((Object)"2022-09-26", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)"2024-09-26", (List)new .colon.colon((Object)"2024-09-26", (List)Nil$.MODULE$))}));
    }

    public static final /* synthetic */ void $anonfun$new$28(TestExpressionIndex $this, String tableType$1, File tmp$5, boolean isPartitioned) {
        String tableName = new StringBuilder(7).append($this.generateTableName()).append("_clean_").append(tableType$1).append(isPartitioned).toString();
        String partitionByClause = isPartitioned ? "partitioned by(price)" : "";
        String basePath = new StringBuilder(1).append(tmp$5.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(469).append("\n               |create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  ts long,\n               |  price int\n               |) using hudi\n               | options (\n               |  primaryKey ='id',\n               |  type = '").append(tableType$1).append("',\n               |  preCombineField = 'ts',\n               |  hoodie.clean.policy = 'KEEP_LATEST_COMMITS',\n               |  ").append(HoodieCleanConfig.CLEANER_COMMITS_RETAINED.key()).append(" = '1'\n               | )\n               | ").append(partitionByClause).append("\n               | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.setCompactionConfigs(tableType$1);
        Object object = !isPartitioned ? $this.spark().sql(new StringBuilder(6).append("set ").append(HoodieCompactionConfig.PARQUET_SMALL_FILE_LIMIT.key()).append("=0").toString()) : BoxedUnit.UNIT;
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(1, 'a1', 1601098924, 10)").toString());
        $this.spark().sql(new StringBuilder(45).append("insert into ").append(tableName).append(" values(2, 'a2', 1632634924, 100)").toString());
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName).append(" values(3, 'a3', 1664170924, 1000)").toString());
        $this.spark().sql(new StringBuilder(102).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains("expr_index_idx_datestr"));
        Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
        Assertions.assertEquals((int)1, (int)((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().size());
        String metadataSql = new StringBuilder(129).append("select ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value from hudi_metadata('").append(tableName).append("') where type=3").toString();
        $this.checkAnswer(metadataSql, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2020-09-26", (List)new .colon.colon((Object)"2020-09-26", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)"2021-09-26", (List)new .colon.colon((Object)"2021-09-26", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)"2022-09-26", (List)new .colon.colon((Object)"2022-09-26", (List)Nil$.MODULE$))}));
        Row[] fileNames = (Row[])$this.spark().sql(new StringBuilder(131).append("select ColumnStatsMetadata.fileName from hudi_metadata('").append(tableName).append("') where type=3 and ColumnStatsMetadata.minValue.member6.value='2022-09-26'").toString()).collect();
        Assertions.assertEquals((int)1, (int)fileNames.length);
        String fileName = fileNames[0].getString(0);
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set ts=1695706924 where id=3").toString());
        $this.spark().sql(new StringBuilder(36).append("update ").append(tableName).append(" set ts=1727329324 where id=3").toString());
        Option lastCleanInstant = metaClient.reloadActiveTimeline().getCleanerTimeline().lastInstant();
        Assertions.assertTrue((boolean)lastCleanInstant.isPresent());
        Assertions.assertTrue((boolean)((String)((Pair)HoodieTestUtils.getCleanedFiles((HoodieTableMetaClient)metaClient, (HoodieInstant)((HoodieInstant)lastCleanInstant.get())).get(0)).getValue()).equals(fileName));
        $this.checkAnswer(new StringBuilder(196).append("select ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value, ColumnStatsMetadata.isDeleted from hudi_metadata('").append(tableName).append("') where type=3 and ColumnStatsMetadata.fileName='").append(fileName).append("'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"2022-09-26", "2022-09-26", BoxesRunTime.boxToBoolean((boolean)false)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$27(TestExpressionIndex $this, File tmp$5, String tableType) {
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)isPartitioned -> {
            TestExpressionIndex.$anonfun$new$28($this, tableType, tmp$5, BoxesRunTime.unboxToBoolean((Object)isPartitioned));
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$26(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestExpressionIndex.$anonfun$new$27($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$30(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = new StringBuilder(22).append($this.generateTableName()).append("_stats_pruning_binary_").append((String)tableType).toString();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(589).append("\n           CREATE TABLE ").append(tableName).append(" (\n             |    ts LONG,\n             |    id STRING,\n             |    rider STRING,\n             |    driver STRING,\n             |    fare DOUBLE,\n             |    dateDefault STRING,\n             |    date STRING,\n             |    city STRING,\n             |    state STRING\n             |) USING HUDI\n             |options(\n             |    type = '").append((String)tableType).append("',\n             |    hoodie.metadata.enable = 'true',\n             |    hoodie.enable.data.skipping = 'true'\n             |)\n             |PARTITIONED BY (state)\n             |location '").append(basePath).append("'\n             |").toString())).stripMargin());
            $this.setCompactionConfigs((String)tableType);
            $this.spark().sql("set hoodie.parquet.small.file.limit=0");
            Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? $this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414520,'trip2','rider-C','driver-M',27.70,'2024-11-30 01:30:40', '2024-11-30', 'sunnyvale','california'),\n             |  (1699349649,'trip5','rider-A','driver-Q',3.32, '2019-11-30 01:30:40', '2019-11-30', 'san_diego','texas')\n             |").toString())).stripMargin());
            StructType tableSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("id", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("rider", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("driver", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("fare", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dateDefault", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("date", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("city", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("state", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            $this.spark().sql(new StringBuilder(81).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime')").toString());
            $this.checkAnswer(new StringBuilder(80).append("select id, rider, from_unixtime(ts) from ").append(tableName).append(" where from_unixtime(ts) > '1970-01-03'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"trip2", (List)new .colon.colon((Object)"rider-C", (List)new .colon.colon((Object)"2023-09-22 20:28:40", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)"trip5", (List)new .colon.colon((Object)"rider-A", (List)new .colon.colon((Object)"2023-11-07 09:34:09", (List)Nil$.MODULE$)))}));
            scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}));
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            Expression fromUnixTime = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.from_unixtime(functions$.MODULE$.col("ts"))).get(), tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$1(TestExpressionIndex $outer) {
                }
            }
            Literal literal = Literal$.MODULE$.create((Object)"2023-09-22 20:28:40", ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$1(null)));
            EqualTo dataFilter = new EqualTo(fromUnixTime, (Expression)literal);
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            return $this.spark().sql(new StringBuilder(26).append("drop index idx_datestr on ").append(tableName).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$new$34(TestExpressionIndex $this, File tmp$7, String tableType) {
        String tableName = new StringBuilder(22).append($this.generateTableName()).append("_stats_pruning_binary_").append(tableType).toString();
        String basePath = new StringBuilder(1).append(tmp$7.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(691).append("\n           CREATE TABLE ").append(tableName).append(" (\n             |    ts LONG,\n             |    id STRING,\n             |    rider STRING,\n             |    driver STRING,\n             |    fare DOUBLE,\n             |    dateDefault STRING,\n             |    date STRING,\n             |    city STRING,\n             |    state STRING\n             |) USING HUDI\n             |options(\n             |    primaryKey ='id',\n             |    type = '").append(tableType).append("',\n             |    hoodie.metadata.enable = 'true',\n             |    hoodie.datasource.write.recordkey.field = 'id',\n             |    hoodie.enable.data.skipping = 'true'\n             |)\n             |PARTITIONED BY (state)\n             |location '").append(basePath).append("'\n             |").toString())).stripMargin());
        $this.setCompactionConfigs(tableType);
        $this.spark().sql("set hoodie.parquet.small.file.limit=0");
        Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? $this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414520,'trip2','rider-C','driver-M',27.70,'2024-11-30 01:30:40', '2024-11-30', 'sunnyvale','california'),\n             |  (1699349649,'trip5','rider-A','driver-Q',3.32, '2019-11-30 01:30:40', '2019-11-30', 'san_diego','texas')\n             |").toString())).stripMargin());
        $this.checkNestedExceptionContains(new StringBuilder(101).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', invalidOp='random')").toString(), "Input options [invalidOp] are not valid for spark function");
    }

    public static final /* synthetic */ void $anonfun$new$33(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestExpressionIndex.$anonfun$new$34($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testPrunePartitions$1(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = new StringBuilder(18).append($this.generateTableName()).append("_prune_partitions_").append((String)tableType).toString();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(691).append("\n           CREATE TABLE ").append(tableName).append(" (\n             |    ts LONG,\n             |    id STRING,\n             |    rider STRING,\n             |    driver STRING,\n             |    fare DOUBLE,\n             |    dateDefault STRING,\n             |    date STRING,\n             |    city STRING,\n             |    state STRING\n             |) USING HUDI\n             |options(\n             |    primaryKey ='id',\n             |    type = '").append((String)tableType).append("',\n             |    hoodie.metadata.enable = 'true',\n             |    hoodie.datasource.write.recordkey.field = 'id',\n             |    hoodie.enable.data.skipping = 'true'\n             |)\n             |PARTITIONED BY (state)\n             |location '").append(basePath).append("'\n             |").toString())).stripMargin());
            $this.spark().sql("set hoodie.parquet.small.file.limit=0");
            Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? $this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(610).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414527,'trip1','rider-A','driver-K',19.10, '2020-11-30 01:30:40', '2020-11-30', 'san_francisco','california'),\n             |  (1695414531,'trip6','rider-C','driver-K',17.14, '2021-11-30 01:30:40', '2021-11-30', 'san_diego','california'),\n             |  (1695332066,'trip3','rider-E','driver-O',93.50, '2022-11-30 01:30:40', '2022-11-30', 'austin','texas'),\n             |  (1695516137,'trip4','rider-F','driver-P',34.15, '2023-11-30 01:30:40', '2023-11-30', 'houston','texas')\n             |").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414520,'trip2','rider-C','driver-M',27.70,'2024-11-30 01:30:40', '2024-11-30', 'sunnyvale','california'),\n             |  (1699349649,'trip5','rider-A','driver-Q',3.32, '2019-11-30 01:30:40', '2019-11-30', 'san_diego','texas')\n             |").toString())).stripMargin());
            StructType tableSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("id", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("rider", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("driver", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("fare", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dateDefault", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("date", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("city", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("state", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}));
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            Expression fromUnixTimeExpr = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.from_unixtime(functions$.MODULE$.col("ts"), "yyyy-MM-dd")).get(), tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$2(TestExpressionIndex $outer) {
                }
            }
            Literal literal = Literal$.MODULE$.create((Object)"2023-11-07", ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$2(null)));
            EqualTo dataFilter = new EqualTo(fromUnixTimeExpr, (Expression)literal);
            scala.collection.immutable.Map commonOpts = opts.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)metaClient.getBasePath().toString()));
            SparkSession x$1 = $this.spark();
            HoodieTableMetaClient x$2 = metaClient;
            None$ x$3 = None$.MODULE$;
            scala.collection.immutable.Map x$4 = commonOpts;
            boolean x$5 = true;
            FileStatusCache x$6 = HoodieFileIndex$.MODULE$.apply$default$5();
            boolean x$7 = HoodieFileIndex$.MODULE$.apply$default$7();
            HoodieFileIndex fileIndex = new HoodieFileIndex(x$1, x$2, (scala.Option)x$3, x$4, x$6, x$5, x$7);
            Seq filterReferencedColumns = HoodieFileIndex$.MODULE$.collectReferencedColumns($this.spark(), (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$), tableSchema);
            HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().enable(true).build();
            ExpressionIndexSupport exprIndexSupport = new ExpressionIndexSupport($this.spark(), tableSchema, metadataConfig, metaClient, ExpressionIndexSupport$.MODULE$.$lessinit$greater$default$5());
            Assertions.assertTrue((boolean)exprIndexSupport.prunePartitions(fileIndex, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$), filterReferencedColumns).isEmpty());
            $this.spark().sql(new StringBuilder(97).append("create index idx_ts on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString());
            metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            SparkSession x$8 = $this.spark();
            HoodieTableMetaClient x$9 = metaClient;
            None$ x$10 = None$.MODULE$;
            scala.collection.immutable.Map x$11 = commonOpts;
            boolean x$12 = true;
            FileStatusCache x$13 = HoodieFileIndex$.MODULE$.apply$default$5();
            boolean x$14 = HoodieFileIndex$.MODULE$.apply$default$7();
            fileIndex = new HoodieFileIndex(x$8, x$9, (scala.Option)x$10, x$11, x$13, x$12, x$14);
            exprIndexSupport = new ExpressionIndexSupport($this.spark(), tableSchema, metadataConfig, metaClient, ExpressionIndexSupport$.MODULE$.$lessinit$greater$default$5());
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"state=texas"})), (Object)exprIndexSupport.prunePartitions(fileIndex, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$), filterReferencedColumns).get());
            $this.spark().sql(new StringBuilder(21).append("drop index idx_ts on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(47).append("create index idx_ts on ").append(tableName).append(" using bloom_filters(ts)").toString());
            metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            SparkSession x$15 = $this.spark();
            HoodieTableMetaClient x$16 = metaClient;
            None$ x$17 = None$.MODULE$;
            scala.collection.immutable.Map x$18 = commonOpts;
            boolean x$19 = true;
            FileStatusCache x$20 = HoodieFileIndex$.MODULE$.apply$default$5();
            boolean x$21 = HoodieFileIndex$.MODULE$.apply$default$7();
            fileIndex = new HoodieFileIndex(x$15, x$16, (scala.Option)x$17, x$18, x$20, x$19, x$21);
            exprIndexSupport = new ExpressionIndexSupport($this.spark(), tableSchema, metadataConfig, metaClient, ExpressionIndexSupport$.MODULE$.$lessinit$greater$default$5());
            Assertions.assertTrue((boolean)exprIndexSupport.prunePartitions(fileIndex, (Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$), filterReferencedColumns).isEmpty());
            return $this.spark().sql(new StringBuilder(21).append("drop index idx_ts on ").append(tableName).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$testExpressionIndexPartitionStatsWithUnpartitionedTable$1(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = new StringBuilder(38).append($this.generateTableName()).append("_partition_pruning_with_unpartitioned_").append((String)tableType).toString();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(654).append("\n           CREATE TABLE ").append(tableName).append(" (\n             |    ts LONG,\n             |    id STRING,\n             |    rider STRING,\n             |    driver STRING,\n             |    fare DOUBLE,\n             |    dateDefault STRING,\n             |    date STRING,\n             |    city STRING,\n             |    state STRING\n             |) USING HUDI\n             |options(\n             |    primaryKey ='id',\n             |    type = '").append((String)tableType).append("',\n             |    hoodie.metadata.enable = 'true',\n             |    hoodie.datasource.write.recordkey.field = 'id',\n             |    hoodie.enable.data.skipping = 'true'\n             |)\n             |location '").append(basePath).append("'\n             |").toString())).stripMargin());
            $this.spark().sql("set hoodie.parquet.small.file.limit=0");
            Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? $this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(610).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414527,'trip1','rider-A','driver-K',19.10, '2020-11-30 01:30:40', '2020-11-30', 'san_francisco','california'),\n             |  (1695414531,'trip6','rider-C','driver-K',17.14, '2021-11-30 01:30:40', '2021-11-30', 'san_diego','california'),\n             |  (1695332066,'trip3','rider-E','driver-O',93.50, '2022-11-30 01:30:40', '2022-11-30', 'austin','texas'),\n             |  (1695516137,'trip4','rider-F','driver-P',34.15, '2023-11-30 01:30:40', '2023-11-30', 'houston','texas')\n             |").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414520,'trip2','rider-C','driver-M',27.70,'2024-11-30 01:30:40', '2024-11-30', 'sunnyvale','california'),\n             |  (1699349649,'trip5','rider-A','driver-Q',3.32, '2019-11-30 01:30:40', '2019-11-30', 'san_diego','texas')\n             |").toString())).stripMargin());
            StructType tableSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("id", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("rider", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("driver", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("fare", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dateDefault", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("date", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("city", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("state", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}));
            $this.spark().sql(new StringBuilder(74).append("create index idx_rider on ").append(tableName).append(" using column_stats(rider) options(expr='upper')").toString());
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            Expression riderExpr = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.upper(functions$.MODULE$.col("rider"))).get(), tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$3(TestExpressionIndex $outer) {
                }
            }
            Literal literal = Literal$.MODULE$.create((Object)"RIDER-D", ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$3(null)));
            EqualTo dataFilter = new EqualTo(riderExpr, (Expression)literal);
            $this.verifyPartitionPruning((scala.collection.immutable.Map<String, String>)opts, (Seq<Expression>)((Seq)Nil$.MODULE$), (Seq<Expression>)((Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)), metaClient, false, $this.verifyPartitionPruning$default$6());
            $this.checkAnswer(new StringBuilder(133).append("select key, ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value from hudi_metadata('").append(tableName).append("') ").append("where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"__partition_stat__", (String)"", (String)"rider"), (List)new .colon.colon((Object)"RIDER-A", (List)new .colon.colon((Object)"RIDER-F", (List)Nil$.MODULE$)))}));
            $this.spark().sql(new StringBuilder(48).append("update ").append(tableName).append(" set rider = 'rider-G' where id = 'trip5'").toString());
            $this.checkAnswer(new StringBuilder(133).append("select key, ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value from hudi_metadata('").append(tableName).append("') ").append("where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"__partition_stat__", (String)"", (String)"rider"), (List)new .colon.colon((Object)"RIDER-A", (List)new .colon.colon((Object)"RIDER-G", (List)Nil$.MODULE$)))}));
            return $this.spark().sql(new StringBuilder(24).append("drop index idx_rider on ").append(tableName).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$testPartitionPruningWithPartitionStats$1(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = new StringBuilder(40).append($this.generateTableName()).append("_partition_pruning_with_partition_stats_").append((String)tableType).toString();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(691).append("\n           CREATE TABLE ").append(tableName).append(" (\n             |    ts LONG,\n             |    id STRING,\n             |    rider STRING,\n             |    driver STRING,\n             |    fare DOUBLE,\n             |    dateDefault STRING,\n             |    date STRING,\n             |    city STRING,\n             |    state STRING\n             |) USING HUDI\n             |options(\n             |    primaryKey ='id',\n             |    type = '").append((String)tableType).append("',\n             |    hoodie.metadata.enable = 'true',\n             |    hoodie.datasource.write.recordkey.field = 'id',\n             |    hoodie.enable.data.skipping = 'true'\n             |)\n             |PARTITIONED BY (state)\n             |location '").append(basePath).append("'\n             |").toString())).stripMargin());
            $this.spark().sql("set hoodie.parquet.small.file.limit=0");
            Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? $this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(610).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414527,'trip1','rider-A','driver-K',19.10, '2020-11-30 01:30:40', '2020-11-30', 'san_francisco','california'),\n             |  (1695414531,'trip6','rider-C','driver-K',17.14, '2021-11-30 01:30:40', '2021-11-30', 'san_diego','california'),\n             |  (1695332066,'trip3','rider-E','driver-O',93.50, '2022-11-30 01:30:40', '2022-11-30', 'austin','texas'),\n             |  (1695516137,'trip4','rider-F','driver-P',34.15, '2023-11-30 01:30:40', '2023-11-30', 'houston','texas')\n             |").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414520,'trip2','rider-C','driver-M',27.70,'2024-11-30 01:30:40', '2024-11-30', 'sunnyvale','california'),\n             |  (1699349649,'trip5','rider-A','driver-Q',3.32, '2019-11-30 01:30:40', '2019-11-30', 'san_diego','texas')\n             |").toString())).stripMargin());
            StructType tableSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("id", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("rider", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("driver", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("fare", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dateDefault", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("date", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("city", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("state", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}));
            $this.spark().sql(new StringBuilder(97).append("create index idx_ts on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString());
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            Expression fromUnixTimeExpr = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.from_unixtime(functions$.MODULE$.col("ts"), "yyyy-MM-dd")).get(), tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$4
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$4(TestExpressionIndex $outer) {
                }
            }
            Literal literal = Literal$.MODULE$.create((Object)"2023-11-07", ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$4(null)));
            EqualTo dataFilter = new EqualTo(fromUnixTimeExpr, (Expression)literal);
            $this.verifyPartitionPruning((scala.collection.immutable.Map<String, String>)opts, (Seq<Expression>)((Seq)Nil$.MODULE$), (Seq<Expression>)((Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)), metaClient, true, $this.verifyPartitionPruning$default$6());
            $this.spark().sql(new StringBuilder(21).append("drop index idx_ts on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(102).append("create index idx_unix on ").append(tableName).append(" using column_stats(date) options(expr='unix_timestamp', format='yyyy-MM-dd')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression unixTimestamp = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.unix_timestamp(functions$.MODULE$.col("date"), "yyyy-MM-dd")).get(), tableSchema);
            literal = Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)1732924800L), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
            dataFilter = new EqualTo(unixTimestamp, (Expression)literal);
            $this.verifyPartitionPruning((scala.collection.immutable.Map<String, String>)opts, (Seq<Expression>)((Seq)Nil$.MODULE$), (Seq<Expression>)((Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)), metaClient, true, $this.verifyPartitionPruning$default$6());
            $this.spark().sql(new StringBuilder(23).append("drop index idx_unix on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(98).append("create index idx_to_date on ").append(tableName).append(" using column_stats(date) options(expr='to_date', format='yyyy-MM-dd')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression toDate = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.to_date(functions$.MODULE$.col("date"), "yyyy-MM-dd")).get(), tableSchema);
            dataFilter = new EqualTo(toDate, functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)18230)).expr());
            $this.verifyPartitionPruning((scala.collection.immutable.Map<String, String>)opts, (Seq<Expression>)((Seq)Nil$.MODULE$), (Seq<Expression>)((Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)), metaClient, true, $this.verifyPartitionPruning$default$6());
            return $this.spark().sql(new StringBuilder(26).append("drop index idx_to_date on ").append(tableName).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$testPartitionPruningAfterUpdateWithPartitionStats$1(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            BoxedUnit boxedUnit;
            boolean isTableMOR = tableType.equals("mor");
            String tableName = new StringBuilder(32).append($this.generateTableName()).append("_partition_pruning_after_update_").append((String)tableType).toString();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(691).append("\n           CREATE TABLE ").append(tableName).append(" (\n             |    ts LONG,\n             |    id STRING,\n             |    rider STRING,\n             |    driver STRING,\n             |    fare DOUBLE,\n             |    dateDefault STRING,\n             |    date STRING,\n             |    city STRING,\n             |    state STRING\n             |) USING HUDI\n             |options(\n             |    primaryKey ='id',\n             |    type = '").append((String)tableType).append("',\n             |    hoodie.metadata.enable = 'true',\n             |    hoodie.datasource.write.recordkey.field = 'id',\n             |    hoodie.enable.data.skipping = 'true'\n             |)\n             |PARTITIONED BY (state)\n             |location '").append(basePath).append("'\n             |").toString())).stripMargin());
            $this.spark().sql("set hoodie.parquet.small.file.limit=0");
            Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? $this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(610).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414527,'trip1','rider-A','driver-K',19.10, '2020-11-30 01:30:40', '2020-11-30', 'san_francisco','california'),\n             |  (1695414531,'trip6','rider-C','driver-K',17.14, '2021-11-30 01:30:40', '2021-11-30', 'san_diego','california'),\n             |  (1695332066,'trip3','rider-E','driver-O',93.50, '2022-11-30 01:30:40', '2022-11-30', 'austin','texas'),\n             |  (1695516137,'trip4','rider-F','driver-P',34.15, '2023-11-30 01:30:40', '2023-11-30', 'houston','texas')\n             |").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414520,'trip2','rider-B','driver-M',27.70,'2024-11-30 01:30:40', '2024-11-30', 'sunnyvale','california'),\n             |  (1699349649,'trip5','rider-D','driver-Q',3.32, '2019-11-30 01:30:40', '2019-11-30', 'san_diego','texas')\n             |").toString())).stripMargin());
            StructType tableSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("id", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("rider", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("driver", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("fare", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dateDefault", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("date", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("city", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("state", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}));
            $this.spark().sql(new StringBuilder(74).append("create index idx_rider on ").append(tableName).append(" using column_stats(rider) options(expr='upper')").toString());
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            Expression riderExpr = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.upper(functions$.MODULE$.col("rider"))).get(), tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$5
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$5(TestExpressionIndex $outer) {
                }
            }
            Literal literal = Literal$.MODULE$.create((Object)"RIDER-D", ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$5(null)));
            EqualTo dataFilter = new EqualTo(riderExpr, (Expression)literal);
            $this.verifyPartitionPruning((scala.collection.immutable.Map<String, String>)opts, (Seq<Expression>)((Seq)Nil$.MODULE$), (Seq<Expression>)((Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)), metaClient, true, $this.verifyPartitionPruning$default$6());
            String riderCalifornia = HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"__partition_stat__", (String)"state=california", (String)"rider");
            String riderTexas = HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"__partition_stat__", (String)"state=texas", (String)"rider");
            $this.checkAnswer(new StringBuilder(153).append("select key, ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value from hudi_metadata('").append(tableName).append("') ").append("where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" AND key IN ('").append(riderCalifornia).append("', '").append(riderTexas).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)riderCalifornia, (List)new .colon.colon((Object)"RIDER-A", (List)new .colon.colon((Object)"RIDER-C", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)riderTexas, (List)new .colon.colon((Object)"RIDER-D", (List)new .colon.colon((Object)"RIDER-F", (List)Nil$.MODULE$)))}));
            $this.spark().sql(new StringBuilder(48).append("update ").append(tableName).append(" set rider = 'rider-G' where id = 'trip5'").toString());
            metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator2$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator2$1(TestExpressionIndex $outer) {
                }
            }
            literal = Literal$.MODULE$.create((Object)"RIDER-D", ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator2$1(null)));
            dataFilter = new EqualTo(riderExpr, (Expression)literal);
            $this.verifyPartitionPruning((scala.collection.immutable.Map<String, String>)opts, (Seq<Expression>)((Seq)Nil$.MODULE$), (Seq<Expression>)((Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)), metaClient, true, !isTableMOR);
            String partitionMinRiderValue = isTableMOR ? "RIDER-D" : "RIDER-E";
            $this.checkAnswer(new StringBuilder(153).append("select key, ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value from hudi_metadata('").append(tableName).append("') ").append("where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" AND key IN ('").append(riderCalifornia).append("', '").append(riderTexas).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)riderCalifornia, (List)new .colon.colon((Object)"RIDER-A", (List)new .colon.colon((Object)"RIDER-C", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)riderTexas, (List)new .colon.colon((Object)partitionMinRiderValue, (List)new .colon.colon((Object)"RIDER-G", (List)Nil$.MODULE$)))}));
            if (isTableMOR) {
                $this.spark().sql("set hoodie.compact.inline=true");
                boxedUnit = $this.spark().sql("set hoodie.compact.inline.max.delta.commits=1");
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $this.spark().sql(new StringBuilder(48).append("update ").append(tableName).append(" set rider = 'rider-H' where id = 'trip5'").toString());
            metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            JavaUniverse $u3 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator3$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator3$1(TestExpressionIndex $outer) {
                }
            }
            literal = Literal$.MODULE$.create((Object)"RIDER-D", ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator3$1(null)));
            dataFilter = new EqualTo(riderExpr, (Expression)literal);
            $this.verifyPartitionPruning((scala.collection.immutable.Map<String, String>)opts, (Seq<Expression>)((Seq)Nil$.MODULE$), (Seq<Expression>)((Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)), metaClient, true, true);
            $this.checkAnswer(new StringBuilder(153).append("select key, ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value from hudi_metadata('").append(tableName).append("') ").append("where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" AND key IN ('").append(riderCalifornia).append("', '").append(riderTexas).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)riderCalifornia, (List)new .colon.colon((Object)"RIDER-A", (List)new .colon.colon((Object)"RIDER-C", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)riderTexas, (List)new .colon.colon((Object)"RIDER-E", (List)new .colon.colon((Object)"RIDER-H", (List)Nil$.MODULE$)))}));
            Object object2 = isTableMOR ? $this.spark().sql("set hoodie.compact.inline=false") : BoxedUnit.UNIT;
            return $this.spark().sql(new StringBuilder(24).append("drop index idx_rider on ").append(tableName).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$testPartitionPruningAfterDeleteWithPartitionStats$1(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            BoxedUnit boxedUnit;
            boolean isTableMOR = tableType.equals("mor");
            String tableName = new StringBuilder(32).append($this.generateTableName()).append("_partition_pruning_after_delete_").append((String)tableType).toString();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(691).append("\n           CREATE TABLE ").append(tableName).append(" (\n             |    ts LONG,\n             |    id STRING,\n             |    rider STRING,\n             |    driver STRING,\n             |    fare DOUBLE,\n             |    dateDefault STRING,\n             |    date STRING,\n             |    city STRING,\n             |    state STRING\n             |) USING HUDI\n             |options(\n             |    primaryKey ='id',\n             |    type = '").append((String)tableType).append("',\n             |    hoodie.metadata.enable = 'true',\n             |    hoodie.datasource.write.recordkey.field = 'id',\n             |    hoodie.enable.data.skipping = 'true'\n             |)\n             |PARTITIONED BY (state)\n             |location '").append(basePath).append("'\n             |").toString())).stripMargin());
            $this.spark().sql("set hoodie.parquet.small.file.limit=0");
            Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? $this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(610).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414527,'trip1','rider-A','driver-K',19.10, '2020-11-30 01:30:40', '2020-11-30', 'san_francisco','california'),\n             |  (1695414531,'trip6','rider-C','driver-K',17.14, '2021-11-30 01:30:40', '2021-11-30', 'san_diego','california'),\n             |  (1695332066,'trip3','rider-E','driver-O',93.50, '2022-11-30 01:30:40', '2022-11-30', 'austin','texas'),\n             |  (1695516137,'trip4','rider-F','driver-P',34.15, '2023-11-30 01:30:40', '2023-11-30', 'houston','texas')\n             |").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414520,'trip2','rider-B','driver-M',27.70,'2024-11-30 01:30:40', '2024-11-30', 'sunnyvale','california'),\n             |  (1699349649,'trip5','rider-D','driver-Q',3.32, '2019-11-30 01:30:40', '2019-11-30', 'san_diego','texas')\n             |").toString())).stripMargin());
            StructType tableSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("id", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("rider", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("driver", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("fare", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dateDefault", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("date", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("city", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("state", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}));
            $this.spark().sql(new StringBuilder(74).append("create index idx_rider on ").append(tableName).append(" using column_stats(rider) options(expr='upper')").toString());
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            Expression riderExpr = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.upper(functions$.MODULE$.col("rider"))).get(), tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$6
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$6(TestExpressionIndex $outer) {
                }
            }
            Literal literal = Literal$.MODULE$.create((Object)"RIDER-D", ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$6(null)));
            EqualTo dataFilter = new EqualTo(riderExpr, (Expression)literal);
            $this.verifyPartitionPruning((scala.collection.immutable.Map<String, String>)opts, (Seq<Expression>)((Seq)Nil$.MODULE$), (Seq<Expression>)((Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)), metaClient, true, $this.verifyPartitionPruning$default$6());
            String riderCalifornia = HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"__partition_stat__", (String)"state=california", (String)"rider");
            String riderTexas = HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"__partition_stat__", (String)"state=texas", (String)"rider");
            $this.checkAnswer(new StringBuilder(153).append("select key, ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value from hudi_metadata('").append(tableName).append("') ").append("where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" AND key IN ('").append(riderCalifornia).append("', '").append(riderTexas).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)riderCalifornia, (List)new .colon.colon((Object)"RIDER-A", (List)new .colon.colon((Object)"RIDER-C", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)riderTexas, (List)new .colon.colon((Object)"RIDER-D", (List)new .colon.colon((Object)"RIDER-F", (List)Nil$.MODULE$)))}));
            $this.spark().sql(new StringBuilder(31).append("delete from ").append(tableName).append(" where id = 'trip5'").toString());
            metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator2$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator2$2(TestExpressionIndex $outer) {
                }
            }
            literal = Literal$.MODULE$.create((Object)"RIDER-D", ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator2$2(null)));
            dataFilter = new EqualTo(riderExpr, (Expression)literal);
            $this.verifyPartitionPruning((scala.collection.immutable.Map<String, String>)opts, (Seq<Expression>)((Seq)Nil$.MODULE$), (Seq<Expression>)((Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)), metaClient, true, !isTableMOR);
            String partitionMinRiderValue = isTableMOR ? "RIDER-D" : "RIDER-E";
            $this.checkAnswer(new StringBuilder(153).append("select key, ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value from hudi_metadata('").append(tableName).append("') ").append("where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" AND key IN ('").append(riderCalifornia).append("', '").append(riderTexas).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)riderCalifornia, (List)new .colon.colon((Object)"RIDER-A", (List)new .colon.colon((Object)"RIDER-C", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)riderTexas, (List)new .colon.colon((Object)partitionMinRiderValue, (List)new .colon.colon((Object)"RIDER-F", (List)Nil$.MODULE$)))}));
            if (isTableMOR) {
                $this.spark().sql("set hoodie.compact.inline=true");
                boxedUnit = $this.spark().sql("set hoodie.compact.inline.max.delta.commits=1");
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            $this.spark().sql(new StringBuilder(31).append("delete from ").append(tableName).append(" where id = 'trip3'").toString());
            metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            JavaUniverse $u3 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator3$2
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator3$2(TestExpressionIndex $outer) {
                }
            }
            literal = Literal$.MODULE$.create((Object)"RIDER-E", ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator3$2(null)));
            dataFilter = new EqualTo(riderExpr, (Expression)literal);
            $this.verifyPartitionPruning((scala.collection.immutable.Map<String, String>)opts, (Seq<Expression>)((Seq)Nil$.MODULE$), (Seq<Expression>)((Seq)new .colon.colon((Object)dataFilter, (List)Nil$.MODULE$)), metaClient, true, true);
            $this.checkAnswer(new StringBuilder(153).append("select key, ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value from hudi_metadata('").append(tableName).append("') ").append("where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).append(" AND key IN ('").append(riderCalifornia).append("', '").append(riderTexas).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)riderCalifornia, (List)new .colon.colon((Object)"RIDER-A", (List)new .colon.colon((Object)"RIDER-C", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)riderTexas, (List)new .colon.colon((Object)"RIDER-F", (List)new .colon.colon((Object)"RIDER-F", (List)Nil$.MODULE$)))}));
            Object object2 = isTableMOR ? $this.spark().sql("set hoodie.compact.inline=false") : BoxedUnit.UNIT;
            return $this.spark().sql(new StringBuilder(24).append("drop index idx_rider on ").append(tableName).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$new$36(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = new StringBuilder(25).append($this.generateTableName()).append("_stats_pruning_date_expr_").append((String)tableType).toString();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(691).append("\n           CREATE TABLE ").append(tableName).append(" (\n             |    ts LONG,\n             |    id STRING,\n             |    rider STRING,\n             |    driver STRING,\n             |    fare DOUBLE,\n             |    dateDefault STRING,\n             |    date STRING,\n             |    city STRING,\n             |    state STRING\n             |) USING HUDI\n             |options(\n             |    primaryKey ='id',\n             |    type = '").append((String)tableType).append("',\n             |    hoodie.metadata.enable = 'true',\n             |    hoodie.datasource.write.recordkey.field = 'id',\n             |    hoodie.enable.data.skipping = 'true'\n             |)\n             |PARTITIONED BY (state)\n             |location '").append(basePath).append("'\n             |").toString())).stripMargin());
            $this.setCompactionConfigs((String)tableType);
            $this.spark().sql("set hoodie.parquet.small.file.limit=0");
            Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? $this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(610).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414527,'trip1','rider-A','driver-K',19.10, '2020-11-30 01:30:40', '2020-11-30', 'san_francisco','california'),\n             |  (1695414531,'trip6','rider-C','driver-K',17.14, '2021-11-30 01:30:40', '2021-11-30', 'san_diego','california'),\n             |  (1695332066,'trip3','rider-E','driver-O',93.50, '2022-11-30 01:30:40', '2022-11-30', 'austin','texas'),\n             |  (1695516137,'trip4','rider-F','driver-P',34.15, '2023-11-30 01:30:40', '2023-11-30', 'houston','texas')\n             |").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414520,'trip2','rider-C','driver-M',27.70,'2024-11-30 01:30:40', '2024-11-30', 'sunnyvale','california'),\n             |  (1699349649,'trip5','rider-A','driver-Q',3.32, '2019-11-30 01:30:40', '2019-11-30', 'san_diego','texas')\n             |").toString())).stripMargin());
            StructType tableSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("id", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("rider", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("driver", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("fare", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dateDefault", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("date", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("city", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("state", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}));
            $this.spark().sql(new StringBuilder(102).append("create index idx_datestr on ").append(tableName).append(" using column_stats(ts) options(expr='from_unixtime', format='yyyy-MM-dd')").toString());
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            Expression fromUnixTime = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.from_unixtime(functions$.MODULE$.col("ts"), "yyyy-MM-dd")).get(), tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator2$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator2$3(TestExpressionIndex $outer) {
                }
            }
            Literal literal = Literal$.MODULE$.create((Object)"2023-11-07", ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator2$3(null)));
            EqualTo dataFilter = new EqualTo(fromUnixTime, (Expression)literal);
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(26).append("drop index idx_datestr on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(96).append("create index idx_unix_default on ").append(tableName).append(" using column_stats(dateDefault) options(expr='unix_timestamp')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression unixTimestampDefault = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.unix_timestamp(functions$.MODULE$.col("dateDefault"))).get(), tableSchema);
            literal = Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)1606699840L), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
            dataFilter = new EqualTo(unixTimestampDefault, (Expression)literal);
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(31).append("drop index idx_unix_default on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(102).append("create index idx_unix on ").append(tableName).append(" using column_stats(date) options(expr='unix_timestamp', format='yyyy-MM-dd')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression unixTimestamp = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.unix_timestamp(functions$.MODULE$.col("date"), "yyyy-MM-dd")).get(), tableSchema);
            literal = Literal$.MODULE$.create((Object)BoxesRunTime.boxToLong((long)1606694400L), ((TypeTags)package$.MODULE$.universe()).TypeTag().Long());
            dataFilter = new EqualTo(unixTimestamp, (Expression)literal);
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(23).append("drop index idx_unix on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(98).append("create index idx_to_date on ").append(tableName).append(" using column_stats(date) options(expr='to_date', format='yyyy-MM-dd')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression toDate = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.to_date(functions$.MODULE$.col("date"), "yyyy-MM-dd")).get(), tableSchema);
            dataFilter = new EqualTo(toDate, functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)18596)).expr());
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(26).append("drop index idx_to_date on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(85).append("create index idx_to_date_default on ").append(tableName).append(" using column_stats(date) options(expr='to_date')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression toDateDefault = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.to_date(functions$.MODULE$.col("date"))).get(), tableSchema);
            dataFilter = new EqualTo(toDateDefault, functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)18596)).expr());
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(34).append("drop index idx_to_date_default on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(100).append("create index idx_date_format on ").append(tableName).append(" using column_stats(date) options(expr='date_format', format='yyyy')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression dateFormatDefault = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.date_format(functions$.MODULE$.col("date"), "yyyy")).get(), tableSchema);
            dataFilter = new EqualTo(dateFormatDefault, functions$.MODULE$.lit((Object)"2020").expr());
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(30).append("drop index idx_date_format on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(95).append("create index idx_to_timestamp_default on ").append(tableName).append(" using column_stats(date) options(expr='to_timestamp')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression toTimestampDefault = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.to_timestamp(functions$.MODULE$.col("date"))).get(), tableSchema);
            dataFilter = new EqualTo(toTimestampDefault, functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)1732924800000000L)).expr());
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(39).append("drop index idx_to_timestamp_default on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(108).append("create index idx_to_timestamp on ").append(tableName).append(" using column_stats(date) options(expr='to_timestamp', format='yyyy-MM-dd')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression toTimestamp = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.to_timestamp(functions$.MODULE$.col("date"), "yyyy-MM-dd")).get(), tableSchema);
            dataFilter = new EqualTo(toTimestamp, functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)1732924800000000L)).expr());
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(31).append("drop index idx_to_timestamp on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(90).append("create index idx_date_add on ").append(tableName).append(" using column_stats(date) options(expr='date_add', days='10')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression dateAdd = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.date_add(functions$.MODULE$.col("date"), 10)).get(), tableSchema);
            dataFilter = new EqualTo(dateAdd, functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)18606)).expr());
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(27).append("drop index idx_date_add on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(90).append("create index idx_date_sub on ").append(tableName).append(" using column_stats(date) options(expr='date_sub', days='10')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression dateSub = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.date_sub(functions$.MODULE$.col("date"), 10)).get(), tableSchema);
            dataFilter = new EqualTo(dateSub, functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)18586)).expr());
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            return $this.spark().sql(new StringBuilder(27).append("drop index idx_date_sub on ").append(tableName).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$new$39(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = new StringBuilder(27).append($this.generateTableName()).append("_stats_pruning_string_expr_").append((String)tableType).toString();
            String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(691).append("\n           CREATE TABLE ").append(tableName).append(" (\n             |    ts LONG,\n             |    id STRING,\n             |    rider STRING,\n             |    driver STRING,\n             |    fare DOUBLE,\n             |    dateDefault STRING,\n             |    date STRING,\n             |    city STRING,\n             |    state STRING\n             |) USING HUDI\n             |options(\n             |    primaryKey ='id',\n             |    type = '").append((String)tableType).append("',\n             |    hoodie.metadata.enable = 'true',\n             |    hoodie.datasource.write.recordkey.field = 'id',\n             |    hoodie.enable.data.skipping = 'true'\n             |)\n             |PARTITIONED BY (state)\n             |location '").append(basePath).append("'\n             |").toString())).stripMargin());
            $this.setCompactionConfigs((String)tableType);
            $this.spark().sql("set hoodie.parquet.small.file.limit=0");
            $this.spark().sql("set hoodie.fileIndex.dataSkippingFailureMode=strict");
            Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? $this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(610).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414527,'trip1','rider-A','driver-K',19.10, '2020-11-30 01:30:40', '2020-11-30', 'san_francisco','california'),\n             |  (1695414531,'trip6','rider-C','driver-K',17.14, '2021-11-30 01:30:40', '2021-11-30', 'san_diego','california'),\n             |  (1695332066,'trip3','rider-E','driver-O',93.50, '2022-11-30 01:30:40', '2022-11-30', 'austin','texas'),\n             |  (1695516137,'trip4','rider-F','driver-P',34.15, '2023-11-30 01:30:40', '2023-11-30', 'houston','texas')\n             |").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(358).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, dateDefault, date, city, state) VALUES\n             |  (1695414520,'trip2','rider-C','driver-M',27.70,'2024-11-30 01:30:40', '2024-11-30', 'sunnyvale','california'),\n             |  (1699349649,'trip5','rider-A','driver-Q',3.32, '2019-11-30 01:30:40', '2019-11-30', 'san_diego','texas')\n             |").toString())).stripMargin());
            StructType tableSchema = StructType$.MODULE$.apply((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("ts", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("id", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("rider", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("driver", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("fare", (DataType)DoubleType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dateDefault", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("date", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("city", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("state", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
            scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}));
            $this.spark().sql(new StringBuilder(74).append("create index idx_lower on ").append(tableName).append(" using column_stats(rider) options(expr='lower')").toString());
            HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
            Expression lowerExpr = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.lower(functions$.MODULE$.col("rider"))).get(), tableSchema);
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator3$3
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator3$3(TestExpressionIndex $outer) {
                }
            }
            Literal literal = Literal$.MODULE$.create((Object)"rider-c", ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator3$3(null)));
            EqualTo dataFilter = new EqualTo(lowerExpr, (Expression)literal);
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(24).append("drop index idx_lower on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(101).append("create index idx_substring on ").append(tableName).append(" using column_stats(driver) options(expr='substring', pos='8', len='1')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression substring = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.substring(functions$.MODULE$.col("driver"), 8, 1)).get(), tableSchema);
            dataFilter = new EqualTo(substring, functions$.MODULE$.lit((Object)"K").expr());
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(28).append("drop index idx_substring on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(90).append("create index idx_trim on ").append(tableName).append(" using column_stats(driver) options(expr='trim', trimString='-K')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression trim = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.trim(functions$.MODULE$.col("driver"), "-K")).get(), tableSchema);
            dataFilter = new EqualTo(trim, functions$.MODULE$.lit((Object)"driver").expr());
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(23).append("drop index idx_trim on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(92).append("create index idx_rtrim on ").append(tableName).append(" using column_stats(driver) options(expr='rtrim', trimString='-K')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression rtrim = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.rtrim(functions$.MODULE$.col("driver"), "-K")).get(), tableSchema);
            dataFilter = new EqualTo(rtrim, functions$.MODULE$.lit((Object)"driver").expr());
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(24).append("drop index idx_rtrim on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(97).append("create index idx_ltrim on ").append(tableName).append(" using column_stats(driver) options(expr='ltrim', trimString='driver-')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression ltrim = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.ltrim(functions$.MODULE$.col("driver"), "driver-")).get(), tableSchema);
            dataFilter = new EqualTo(ltrim, functions$.MODULE$.lit((Object)"K").expr());
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(24).append("drop index idx_ltrim on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(126).append("create index idx_regexp on ").append(tableName).append(" using column_stats(rider) options(expr='regexp_replace', pattern='rider', replacement='passenger')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression regExpReplace = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.regexp_replace(functions$.MODULE$.col("rider"), "rider", "passenger")).get(), tableSchema);
            JavaUniverse $u2 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator4$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator4$1(TestExpressionIndex $outer) {
                }
            }
            literal = Literal$.MODULE$.create((Object)"passenger-F", ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator4$1(null)));
            dataFilter = new EqualTo(regExpReplace, (Expression)literal);
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            $this.spark().sql(new StringBuilder(25).append("drop index idx_regexp on ").append(tableName).toString());
            $this.spark().sql(new StringBuilder(127).append("create index idx_regexp_extract on ").append(tableName).append(" using column_stats(driver) options(expr='regexp_extract', pattern='driver-(\\\\w+)', idx='1')").toString());
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            Expression regExpExtract = HoodieCatalystExpressionUtils$.MODULE$.resolveExpr($this.spark(), (Expression)Column$.MODULE$.unapply(functions$.MODULE$.regexp_extract(functions$.MODULE$.col("driver"), "driver-(\\w+)", 1)).get(), tableSchema);
            JavaUniverse $u3 = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
            public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator5$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("java.lang.String").asType().toTypeConstructor();
                }

                public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator5$1(TestExpressionIndex $outer) {
                }
            }
            literal = Literal$.MODULE$.create((Object)"K", ((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator5$1(null)));
            dataFilter = new EqualTo(regExpExtract, (Expression)literal);
            $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilter, metaClient, true, $this.verifyFilePruning$default$5());
            return $this.spark().sql(new StringBuilder(33).append("drop index idx_regexp_extract on ").append(tableName).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$testBloomFiltersIndexPruning$3(Row row) {
        Row bloomFilterMetadata = row.getStruct(1);
        Assertions.assertTrue((boolean)bloomFilterMetadata.getString(0).equals("SIMPLE"));
    }

    public static final /* synthetic */ void $anonfun$testBloomFiltersIndexPruning$2(TestExpressionIndex $this, File tmp$15, String tableType) {
        String tableName = new StringBuilder(15).append($this.generateTableName()).append("_bloom_pruning_").append(tableType).toString();
        String basePath = new StringBuilder(1).append(tmp$15.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(617).append("\n           CREATE TABLE ").append(tableName).append(" (\n             |    ts BIGINT,\n             |    id STRING,\n             |    rider STRING,\n             |    driver STRING,\n             |    fare DOUBLE,\n             |    city STRING,\n             |    state STRING\n             |) USING HUDI\n             |options(\n             |    primaryKey ='id',\n             |    type = '").append(tableType).append("',\n             |    hoodie.metadata.enable = 'true',\n             |    hoodie.datasource.write.recordkey.field = 'id',\n             |    hoodie.enable.data.skipping = 'true'\n             |)\n             |PARTITIONED BY (state)\n             |location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.small.file.limit=0");
        $this.spark().sql("set hoodie.enable.data.skipping=true");
        $this.spark().sql("set hoodie.metadata.enable=true");
        Object object = HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? $this.spark().sql("set spark.sql.defaultColumn.enabled=false") : BoxedUnit.UNIT;
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(439).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, city, state) VALUES\n             |  (1695159649,'trip1','rider-A','driver-K',19.10,'san_francisco','california'),\n             |  (1695414531,'trip6','rider-C','driver-K',17.14,'san_diego','california'),\n             |  (1695332066,'trip3','rider-E','driver-O',93.50,'austin','texas'),\n             |  (1695516137,'trip4','rider-F','driver-P',34.15,'houston','texas')\n             |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(264).append("\n             |insert into ").append(tableName).append("(ts, id, rider, driver, fare, city, state) VALUES\n             |  (1695091554,'trip2','rider-C','driver-M',27.70,'sunnyvale','california'),\n             |  (1699349649,'trip5','rider-A','driver-Q',3.32,'san_diego','texas')\n             |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(127).append("create index idx_bloom_").append(tableName).append(" on ").append(tableName).append(" using bloom_filters(city) options(expr='upper', ").append("fpp").append("='0.01', ").append("filtertype").append("='SIMPLE', ").append("numentries").append("='1000')").toString());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains(new StringBuilder(21).append("expr_index_idx_bloom_").append(tableName).toString()));
        Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
        Assertions.assertEquals((int)2, (int)((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().size());
        HoodieIndexDefinition indexDefinition = (HoodieIndexDefinition)((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().get(new StringBuilder(21).append("expr_index_idx_bloom_").append(tableName).toString());
        Assertions.assertEquals((Object)"0.01", indexDefinition.getIndexOptions().get("fpp"));
        Assertions.assertEquals((Object)"SIMPLE", indexDefinition.getIndexOptions().get("filtertype"));
        Assertions.assertEquals((Object)"1000", indexDefinition.getIndexOptions().get("numentries"));
        Dataset indexMetadataDf = $this.spark().sql(new StringBuilder(92).append("select key, BloomFilterMetadata from hudi_metadata('").append(tableName).append("') where BloomFilterMetadata is not null").toString());
        Assertions.assertEquals((long)4L, (long)indexMetadataDf.count());
        Row[] indexMetadata = (Row[])indexMetadataDf.collect();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexMetadata)).foreach((Function1 & Serializable & scala.Serializable)row -> {
            TestExpressionIndex.$anonfun$testBloomFiltersIndexPruning$3(row);
            return BoxedUnit.UNIT;
        });
        $this.checkAnswer(new StringBuilder(63).append("select id, rider from ").append(tableName).append(" where upper(city) in ('sunnyvale', 'sg')").toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
        $this.checkAnswer(new StringBuilder(50).append("select id, rider from ").append(tableName).append(" where lower(city) = 'sunny'").toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
        $this.checkAnswer(new StringBuilder(54).append("select id, rider from ").append(tableName).append(" where upper(city) = 'SUNNYVALE'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"trip2", (List)new .colon.colon((Object)"rider-C", (List)Nil$.MODULE$))}));
        scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true")}));
        String x$1 = "city";
        StringType$ x$2 = StringType$.MODULE$;
        boolean x$3 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$4 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$5 = AttributeReference$.MODULE$.apply$default$5(x$1, (DataType)x$2, x$3, x$4);
        Seq x$6 = AttributeReference$.MODULE$.apply$default$6(x$1, (DataType)x$2, x$3, x$4);
        AttributeReference cityColumn = new AttributeReference(x$1, (DataType)x$2, x$3, x$4, x$5, x$6);
        Upper upperCityExpr = new Upper((Expression)cityColumn);
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$7
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.String").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$7(TestExpressionIndex $outer) {
            }
        }
        Literal targetCityUpper = Literal$.MODULE$.create((Object)"SUNNYVALE", ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator1$7(null)));
        EqualTo dataFilterUpperCityEquals = new EqualTo((Expression)upperCityExpr, (Expression)targetCityUpper);
        $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilterUpperCityEquals, metaClient, true, $this.verifyFilePruning$default$5());
        $this.spark().sql(new StringBuilder(25).append("drop index idx_bloom_").append(tableName).append(" on ").append(tableName).toString());
        $this.spark().sql(new StringBuilder(53).append("create index idx_bloom_").append(tableName).append(" on ").append(tableName).append(" using bloom_filters(city)").toString());
        $this.checkAnswer(new StringBuilder(47).append("select id, rider from ").append(tableName).append(" where city = 'sunnyvale'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"trip2", (List)new .colon.colon((Object)"rider-C", (List)Nil$.MODULE$))}));
        metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(TestExpressionIndex.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator2$4
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("java.lang.String").asType().toTypeConstructor();
            }

            public Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator2$4(TestExpressionIndex $outer) {
            }
        }
        Literal targetCity = Literal$.MODULE$.create((Object)"sunnyvale", ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_hudi_command_index_TestExpressionIndex$$typecreator2$4(null)));
        EqualTo dataFilterCityEquals = new EqualTo((Expression)cityColumn, (Expression)targetCity);
        $this.verifyFilePruning((scala.collection.immutable.Map<String, String>)opts, (Expression)dataFilterCityEquals, metaClient, true, $this.verifyFilePruning$default$5());
        $this.checkAnswer(new StringBuilder(63).append("select id, rider from ").append(tableName).append(" where city in ('san_diego', 'sunnyvale')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"trip2", (List)new .colon.colon((Object)"rider-C", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)"trip5", (List)new .colon.colon((Object)"rider-A", (List)Nil$.MODULE$)), (Seq)new .colon.colon((Object)"trip6", (List)new .colon.colon((Object)"rider-C", (List)Nil$.MODULE$))}));
    }

    public static final /* synthetic */ void $anonfun$testBloomFiltersIndexPruning$1(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestExpressionIndex.$anonfun$testBloomFiltersIndexPruning$2($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$43(TestExpressionIndex $this, File tmp$16, String tableType) {
        boolean isPartitioned = true;
        String tableName = new StringBuilder(6).append($this.generateTableName()).append("_init_").append(tableType).append(isPartitioned).toString();
        String partitionByClause = isPartitioned ? "partitioned by(price)" : "";
        String basePath = new StringBuilder(1).append(tmp$16.getCanonicalPath()).append("/").append(tableName).toString();
        $this.setCompactionConfigs(tableType);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(354).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  ts long,\n             |  price int\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append(tableType).append("',\n             |  preCombineField = 'ts'\n             | )\n             | ").append(partitionByClause).append("\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.writeRecordsAndValidateExpressionIndex(tableName, basePath, false, false, false, false);
    }

    public static final /* synthetic */ void $anonfun$new$42(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestExpressionIndex.$anonfun$new$43($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$46(TestExpressionIndex $this, File tmp$17, String tableType) {
        boolean isPartitioned = true;
        String tableName = new StringBuilder(10).append($this.generateTableName()).append("_rollback_").append(tableType).append(isPartitioned).toString();
        String partitionByClause = isPartitioned ? "partitioned by(price)" : "";
        String basePath = new StringBuilder(1).append(tmp$17.getCanonicalPath()).append("/").append(tableName).toString();
        $this.setCompactionConfigs(tableType);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(424).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  ts long,\n             |  price int\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append(tableType).append("',\n             |  preCombineField = 'ts',\n             |  hoodie.metadata.index.partition.stats.enable = false\n             | )\n             | ").append(partitionByClause).append("\n             | location '").append(basePath).append("'\n       ").toString())).stripMargin());
        $this.writeRecordsAndValidateExpressionIndex(tableName, basePath, false, false, false, true);
        $this.checkAnswer(new StringBuilder(133).append("select key, ColumnStatsMetadata.minValue.member6.value, ColumnStatsMetadata.maxValue.member6.value from hudi_metadata('").append(tableName).append("') ").append("where type=").append(MetadataPartitionType.PARTITION_STATS.getRecordType()).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"__partition_stat__", (String)"price=10", (String)"ts"), (List)new .colon.colon((Object)"2020-09-26", (List)new .colon.colon((Object)"2020-09-26", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"__partition_stat__", (String)"price=100", (String)"ts"), (List)new .colon.colon((Object)"2021-09-26", (List)new .colon.colon((Object)"2021-09-26", (List)Nil$.MODULE$))), (Seq)new .colon.colon((Object)HoodieTableMetadataUtil.getPartitionStatsIndexKey((String)"__partition_stat__", (String)"price=1000", (String)"ts"), (List)new .colon.colon((Object)"2022-09-26", (List)new .colon.colon((Object)"2022-09-26", (List)Nil$.MODULE$)))}));
    }

    public static final /* synthetic */ void $anonfun$new$45(TestExpressionIndex $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestExpressionIndex.$anonfun$new$46($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$48(TestExpressionIndex $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        scala.collection.immutable.Map metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.EXPRESSION_INDEX_ENABLE_PROP.key()), (Object)"true")}));
        scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"c8"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.metadata.index.column.stats.enable"), (Object)"false")}));
        String sourceJSONTablePath = $this.getClass().getClassLoader().getResource("index/colstats/input-table-json-partition-pruning").toString();
        StructType sourceTableSchema = new StructType().add("c1", (DataType)IntegerType$.MODULE$).add("c2", (DataType)StringType$.MODULE$).add("c3", (DataType)new DecimalType(9, 3)).add("c4", (DataType)TimestampType$.MODULE$).add("c5", (DataType)ShortType$.MODULE$).add("c6", (DataType)DateType$.MODULE$).add("c7", (DataType)BinaryType$.MODULE$).add("c8", (DataType)ByteType$.MODULE$);
        Dataset inputDF = $this.spark().read().schema(sourceTableSchema).json(sourceJSONTablePath);
        inputDF.sort("c1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).repartition(4, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{new Column("c1")})).write().format("hudi").options((Map)opts).option(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), 10240L).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(basePath);
        $this.spark().sql(new StringBuilder(36).append("create table ").append(tableName).append(" using hudi location '").append(basePath).append("'").toString());
        $this.spark().sql(new StringBuilder(72).append("create index idx_datestr on ").append(tableName).append(" using column_stats(c6) options(expr='year')").toString());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains("expr_index_idx_datestr"));
        Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
        Assertions.assertEquals((int)1, (int)((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().size());
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)HoodieConversionUtils$.MODULE$.toProperties(metadataOpts)).build();
        ExpressionIndexSupport expressionIndexSupport = new ExpressionIndexSupport($this.spark(), null, metadataConfig, metaClient, ExpressionIndexSupport$.MODULE$.$lessinit$greater$default$5());
        scala.collection.immutable.Set prunedPartitions = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"9"}));
        Dataset indexDf = expressionIndexSupport.loadExpressionIndexDataFrame("expr_index_idx_datestr", prunedPartitions, true);
        Assertions.assertTrue((indexDf.count() == 1L ? 1 : 0) != 0);
        String fileName = (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])indexDf.select("fileName", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).collect())).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getString(0), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).head();
        HoodieTableFileSystemView fsv = FileSystemViewManager.createInMemoryFileSystemView((HoodieEngineContext)new HoodieSparkEngineContext(JavaSparkContext$.MODULE$.fromSparkContext($this.spark().sparkContext())), (HoodieTableMetaClient)metaClient, (HoodieMetadataConfig)HoodieMetadataConfig.newBuilder().enable(false).build());
        fsv.loadAllPartitions();
        java.util.List partitionPaths = fsv.getPartitionPaths();
        HashMap partitionToBaseFiles = new HashMap();
        partitionPaths.forEach(partitionPath -> partitionToBaseFiles.put(partitionPath.getName(), fsv.getLatestBaseFiles(partitionPath.getName()).map(baseFile -> baseFile.getStoragePath()).collect(Collectors.toList())));
        fsv.close();
        Set expectedFileNames = ((Collection)partitionToBaseFiles.get(prunedPartitions.head())).stream().map(baseFile -> baseFile.getName()).collect(Collectors.toSet());
        Assertions.assertTrue((expectedFileNames.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)expectedFileNames.contains(fileName));
        indexDf = expressionIndexSupport.loadExpressionIndexDataFrame("expr_index_idx_datestr", (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$), true);
        Assertions.assertTrue((indexDf.count() > 1L ? 1 : 0) != 0);
    }

    public static final /* synthetic */ void $anonfun$new$54(TestExpressionIndex $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        scala.collection.immutable.Map metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.EXPRESSION_INDEX_ENABLE_PROP.key()), (Object)"true")}));
        scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)tableName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)"MERGE_ON_READ"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"c8"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.INDEX_TYPE.key()), (Object)HoodieIndex.IndexType.INMEMORY.name()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.metadata.index.column.stats.enable"), (Object)"false")}));
        String sourceJSONTablePath = $this.getClass().getClassLoader().getResource("index/colstats/input-table-json-partition-pruning").toString();
        StructType sourceTableSchema = new StructType().add("c1", (DataType)IntegerType$.MODULE$).add("c2", (DataType)StringType$.MODULE$).add("c3", (DataType)new DecimalType(9, 3)).add("c4", (DataType)TimestampType$.MODULE$).add("c5", (DataType)ShortType$.MODULE$).add("c6", (DataType)DateType$.MODULE$).add("c7", (DataType)BinaryType$.MODULE$).add("c8", (DataType)ByteType$.MODULE$);
        Dataset inputDF = $this.spark().read().schema(sourceTableSchema).json(sourceJSONTablePath);
        inputDF.sort("c1", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).repartition(4, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{new Column("c1")})).write().format("hudi").options((Map)opts).option(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE.key(), 10240L).option(DataSourceWriteOptions$.MODULE$.OPERATION().key(), DataSourceWriteOptions$.MODULE$.INSERT_OPERATION_OPT_VAL()).mode(SaveMode.Overwrite).save(basePath);
        $this.spark().sql(new StringBuilder(36).append("create table ").append(tableName).append(" using hudi location '").append(basePath).append("'").toString());
        $this.spark().sql(new StringBuilder(72).append("create index idx_datestr on ").append(tableName).append(" using column_stats(c6) options(expr='year')").toString());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HoodieTestUtils.getDefaultStorageConf()).build();
        Assertions.assertTrue((boolean)metaClient.getTableConfig().getMetadataPartitions().contains("expr_index_idx_datestr"));
        Assertions.assertTrue((boolean)metaClient.getIndexMetadata().isPresent());
        Assertions.assertEquals((int)1, (int)((HoodieIndexMetadata)metaClient.getIndexMetadata().get()).getIndexDefinitions().size());
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)HoodieConversionUtils$.MODULE$.toProperties(metadataOpts)).build();
        SparkSession x$1 = $this.spark();
        HoodieTableMetaClient x$2 = metaClient;
        None$ x$3 = None$.MODULE$;
        scala.collection.immutable.Map x$4 = opts.$plus$plus((GenTraversableOnce)metadataOpts).$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"glob.paths"), (Object)new StringBuilder(2).append(basePath).append("/9").toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.ENABLE_DATA_SKIPPING().key()), (Object)"true")})));
        boolean x$5 = true;
        FileStatusCache x$6 = HoodieFileIndex$.MODULE$.$lessinit$greater$default$5();
        boolean x$7 = HoodieFileIndex$.MODULE$.$lessinit$greater$default$7();
        HoodieFileIndex fileIndex = new HoodieFileIndex(x$1, x$2, (scala.Option)x$3, x$4, x$6, x$5, x$7);
        ExpressionIndexSupport expressionIndexSupport = new ExpressionIndexSupport($this.spark(), null, metadataConfig, metaClient, ExpressionIndexSupport$.MODULE$.$lessinit$greater$default$5());
        String x$8 = "c8";
        IntegerType$ x$9 = IntegerType$.MODULE$;
        boolean x$10 = AttributeReference$.MODULE$.apply$default$3();
        Metadata x$11 = AttributeReference$.MODULE$.apply$default$4();
        ExprId x$12 = AttributeReference$.MODULE$.apply$default$5(x$8, (DataType)x$9, x$10, x$11);
        Seq x$13 = AttributeReference$.MODULE$.apply$default$6(x$8, (DataType)x$9, x$10, x$11);
        EqualTo partitionFilter = new EqualTo((Expression)new AttributeReference(x$8, (DataType)x$9, x$10, x$11, x$12, x$13), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)9)));
        Tuple2 tuple2 = fileIndex.prunePartitionsAndGetFileSlices((Seq)Nil$.MODULE$, (Seq)new .colon.colon((Object)partitionFilter, (List)Nil$.MODULE$));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        boolean isPruned = tuple2._1$mcZ$sp();
        Seq prunedPaths = (Seq)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)isPruned), (Object)prunedPaths);
        boolean isPruned2 = tuple22._1$mcZ$sp();
        Seq prunedPaths2 = (Seq)tuple22._2();
        Assertions.assertTrue((boolean)isPruned2);
        Tuple2 prunedPartitionAndFileNames = expressionIndexSupport.getPrunedPartitionsAndFileNames(fileIndex, prunedPaths2);
        Assertions.assertTrue((((TraversableOnce)prunedPartitionAndFileNames._1()).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((TraversableOnce)prunedPartitionAndFileNames._2()).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)FSUtils.isLogFile((String)((String)((IterableLike)prunedPartitionAndFileNames._2()).head())));
        scala.collection.immutable.Map prunedPartitionAndFileNamesMap = expressionIndexSupport.getPrunedPartitionsAndFileNamesMap(prunedPaths2, true);
        Assertions.assertTrue((prunedPartitionAndFileNamesMap.keySet().size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((((TraversableOnce)prunedPartitionAndFileNamesMap.values().head()).size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)FSUtils.isLogFile((String)((String)((IterableLike)prunedPartitionAndFileNamesMap.values().head()).head())));
    }

    public static final /* synthetic */ long $anonfun$verifyPartitionPruning$3(FileSlice f1) {
        long totalLatestDataFiles = 0L;
        return totalLatestDataFiles += f1.getLogFiles().count() + (long)(f1.getBaseFile().isPresent() ? 1 : 0);
    }

    public static final /* synthetic */ long $anonfun$verifyPartitionPruning$6(FileSlice f1) {
        long totalLatestDataFiles = 0L;
        return totalLatestDataFiles += f1.getLogFiles().count() + (long)(f1.getBaseFile().isPresent() ? 1 : 0);
    }

    public TestExpressionIndex() {
        this.test("Test Expression Index With Hive Sync Non Partitioned External Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            if (HoodieTestUtils.getJavaVersion() == 8) {
                this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                    TestExpressionIndex.$anonfun$new$2(this, tmp);
                    return BoxedUnit.UNIT;
                });
                return BoxedUnit.UNIT;
            }
            return BoxedUnit.UNIT;
        }, new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 74));
        this.test("Test Create Expression Index Syntax", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$5(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 156));
        this.test("Test Create Expression Index", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$8(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        this.test("Test Drop Expression Index", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$12(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 289));
        this.test("Test expression index update after initialization", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$15(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 356));
        this.test("Test Create Expression Index With Data Skipping", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$17(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 416));
        this.test("Test Expression Index File-level Stats Update", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$20(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        this.test("Test Multiple Expression Index Update", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$22(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        this.test("Test Enable and Disable Expression Index", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$24(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
        this.test("Test Expression Index With Cleaning", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$26(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 671));
        this.test("Test Expression Index With AutoGen", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$30(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 752));
        this.test("Test Expression Index Creation With Invalid Options", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$33(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 830));
        this.test("Test Expression Index Column Stat Pruning With Timestamp Expressions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$36(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1452));
        this.test("Test Expression Index Column Stat Pruning With String Expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$39(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1602));
        this.test("Test Expression Index Insert after Initialization", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$42(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1844));
        this.test("Test Expression Index Rollback", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$45(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1874));
        this.test("testExpressionIndexUsingColumnStatsWithPartitionAndFilesFilter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$48(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1991));
        this.test("testComputeCandidateFileNames", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestExpressionIndex.$anonfun$new$54(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2075));
        this.test("testGetExpressionIndexRecordsUsingBloomFilter", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            scala.collection.immutable.Map metadataOpts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.ENABLE.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieMetadataConfig.EXPRESSION_INDEX_ENABLE_PROP.key()), (Object)"true")}));
            scala.collection.immutable.Map opts = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.insert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.upsert.shuffle.parallelism"), (Object)"4"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.TBL_NAME.key()), (Object)"testGetExpressionIndexRecordsUsingBloomFilter"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key()), (Object)"MERGE_ON_READ"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key()), (Object)"c1"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key()), (Object)"c8"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.INDEX_TYPE.key()), (Object)HoodieIndex.IndexType.INMEMORY.name())}));
            String sourceJSONTablePath = this.getClass().getClassLoader().getResource("index/colstats/input-table-json-partition-pruning").toString();
            StructType sourceTableSchema = new StructType().add("c1", (DataType)IntegerType$.MODULE$).add("c2", (DataType)StringType$.MODULE$).add("c3", (DataType)new DecimalType(9, 3)).add("c4", (DataType)TimestampType$.MODULE$).add("c5", (DataType)ShortType$.MODULE$).add("c6", (DataType)DateType$.MODULE$).add("c7", (DataType)BinaryType$.MODULE$).add("c8", (DataType)ByteType$.MODULE$);
            Dataset df = this.spark().read().schema(sourceTableSchema).json(sourceJSONTablePath);
            df = df.withColumn("_hoodie_expression_index_partition", functions$.MODULE$.lit((Object)"c/d")).withColumn("_hoodie_expression_index_relative_file_path", functions$.MODULE$.lit((Object)"c/d/123141ab-701b-4ba4-b60b-e6acd9e9103e-0_329-224134-258390_2131313124.parquet")).withColumn("_hoodie_expression_index_file_size", functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)100)));
            scala.collection.immutable.Map indexOptions = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"filtertype"), (Object)"DYNAMIC_V0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"fpp"), (Object)"0.01"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"numentries"), (Object)"1000"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"maxentries"), (Object)"1000")}));
            HoodieData bloomFilterRecords = SparkMetadataWriterUtils.getExpressionIndexRecordsUsingBloomFilter((Dataset)df, (String)"c5", (HoodieWriteConfig)HoodieWriteConfig.newBuilder().withPath("a/b").build(), (String)"", (HoodieIndexDefinition)HoodieIndexDefinition.newBuilder().withIndexName("random").withIndexOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)indexOptions).asJava()).build()).getExpressionIndexRecords();
            Assertions.assertEquals((long)1L, (long)bloomFilterRecords.count());
            Assertions.assertFalse((boolean)bloomFilterRecords.isEmpty());
            HoodieMetadataBloomFilter bloomFilter = (HoodieMetadataBloomFilter)((HoodieMetadataPayload)((HoodieRecord)bloomFilterRecords.collectAsList().get(0)).getData()).getBloomFilterMetadata().get();
            Assertions.assertTrue((boolean)bloomFilter.getType().equals("DYNAMIC_V0"));
        }, new Position("TestExpressionIndex.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 2151));
    }
}

