/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.common;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFileReader;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.Assertions;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class HoodieSparkSqlTestBase$
implements scala.Serializable {
    public static HoodieSparkSqlTestBase$ MODULE$;
    private final Pattern NAME_FORMAT_0_X;

    static {
        new HoodieSparkSqlTestBase$();
    }

    public final Pattern NAME_FORMAT_0_X() {
        return this.NAME_FORMAT_0_X;
    }

    public HoodieCommitMetadata getLastCommitMetadata(SparkSession spark, String tablePath) {
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)spark, (String)tablePath);
        return (HoodieCommitMetadata)((Pair)metaClient.getActiveTimeline().getLastCommitMetadataWithValidData().get()).getRight();
    }

    public HoodieCleanMetadata getLastCleanMetadata(SparkSession spark, String tablePath) {
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)spark, (String)tablePath);
        HoodieInstant cleanInstant = (HoodieInstant)metaClient.reloadActiveTimeline().getCleanerTimeline().filterCompletedInstants().lastInstant().get();
        return metaClient.getActiveTimeline().readCleanMetadata(cleanInstant);
    }

    public Tuple2<HoodieTableMetaClient, SyncableFileSystemView> getMetaClientAndFileSystemView(String basePath) {
        StorageConfiguration storageConf = HoodieTestUtils.getDefaultStorageConf();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(storageConf).setBasePath(basePath).build();
        HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().build();
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(storageConf);
        FileSystemViewManager viewManager = FileSystemViewManager.createViewManager((HoodieEngineContext)engineContext, (HoodieMetadataConfig)metadataConfig, (FileSystemViewStorageConfig)FileSystemViewStorageConfig.newBuilder().build(), (HoodieCommonConfig)HoodieCommonConfig.newBuilder().build(), (SerializableFunctionUnchecked & Serializable)x$4 -> HoodieTableMetadata.create((HoodieEngineContext)engineContext, (HoodieStorage)metaClient.getStorage(), (HoodieMetadataConfig)metadataConfig, (String)metaClient.getBasePath().toString()));
        SyncableFileSystemView fsView = viewManager.getFileSystemView(metaClient);
        return new Tuple2((Object)metaClient, (Object)fsView);
    }

    public void replaceWithEmptyFile(HoodieStorage storage, StoragePath filePath) {
        storage.deleteFile(filePath);
        storage.createNewFile(filePath);
    }

    public void validateDeleteLogBlockPrecombineNullOrZero(String basePath) {
        Tuple2<HoodieTableMetaClient, SyncableFileSystemView> tuple2 = this.getMetaClientAndFileSystemView(basePath);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)tuple2._1();
        SyncableFileSystemView fsView = (SyncableFileSystemView)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metaClient, (Object)fsView);
        HoodieTableMetaClient metaClient2 = (HoodieTableMetaClient)tuple22._1();
        SyncableFileSystemView fsView2 = (SyncableFileSystemView)tuple22._2();
        Optional fileSlice = fsView2.getAllFileSlices("").findFirst();
        Assertions.assertTrue((boolean)fileSlice.isPresent());
        List logFilePathList = HoodieTestUtils.getLogFileListFromFileSlice((FileSlice)((FileSlice)fileSlice.get()));
        Collections.sort(logFilePathList);
        BooleanRef deleteLogBlockFound = BooleanRef.create((boolean)false);
        Schema avroSchema = new TableSchemaResolver(metaClient2).getTableAvroSchema();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), logFilePathList.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i2 -> {
            HoodieLogFileReader logReader = new HoodieLogFileReader(metaClient2.getStorage(), new HoodieLogFile((String)logFilePathList.get(i2)), avroSchema, 0x100000, false, false, "id", null);
            Assertions.assertTrue((boolean)logReader.hasNext());
            HoodieLogBlock logBlock = logReader.next();
            if (logBlock instanceof HoodieDeleteBlock) {
                HoodieDeleteBlock deleteLogBlock = (HoodieDeleteBlock)logBlock;
                Assertions.assertTrue((boolean)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])deleteLogBlock.getRecordsToDelete())).forall((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlTestBase$.$anonfun$validateDeleteLogBlockPrecombineNullOrZero$2(i))));
                deleteLogBlockFound$1.elem = true;
                return;
            }
        });
        Assertions.assertTrue((boolean)deleteLogBlockFound.elem);
    }

    public void validateTableConfig(HoodieStorage storage, String basePath, Map<String, String> expectedConfigs, Seq<String> nonExistentConfigs) {
        HoodieTableConfig tableConfig = HoodieTableConfig.loadFromHoodieProps((HoodieStorage)storage, (String)basePath);
        expectedConfigs.foreach((Function1 & Serializable & scala.Serializable)e -> {
            HoodieSparkSqlTestBase$.$anonfun$validateTableConfig$1(tableConfig, e);
            return BoxedUnit.UNIT;
        });
        nonExistentConfigs.foreach((Function1 & Serializable & scala.Serializable)e -> {
            HoodieSparkSqlTestBase$.$anonfun$validateTableConfig$2(tableConfig, e);
            return BoxedUnit.UNIT;
        });
    }

    public boolean org$apache$spark$sql$hudi$common$HoodieSparkSqlTestBase$$checkMessageContains(Throwable e, String text) {
        return e.getMessage().trim().contains(text.trim());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$validateDeleteLogBlockPrecombineNullOrZero$2(DeleteRecord i) {
        return BoxesRunTime.equals((Object)i.getOrderingValue(), (Object)BoxesRunTime.boxToInteger((int)0)) || i.getOrderingValue() == null;
    }

    public static final /* synthetic */ void $anonfun$validateTableConfig$1(HoodieTableConfig tableConfig$1, Tuple2 e) {
        Assertions.assertEquals((Object)e._2(), (Object)tableConfig$1.getString((String)e._1()), (String)new StringBuilder(32).append("Table config ").append(e._1()).append(" should be ").append(e._2()).append(" but is ").append(tableConfig$1.getString((String)e._1())).toString());
    }

    public static final /* synthetic */ void $anonfun$validateTableConfig$2(HoodieTableConfig tableConfig$1, String e) {
        Assertions.assertFalse((boolean)tableConfig$1.contains(e), (String)new StringBuilder(42).append(e).append(" should not be present in the table config").toString());
    }

    private HoodieSparkSqlTestBase$() {
        MODULE$ = this;
        this.NAME_FORMAT_0_X = Pattern.compile("^(\\d+)(\\.\\w+)(\\.\\D+)?$");
    }
}

