/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.common;

import java.io.File;
import java.io.Serializable;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DefaultSparkRecordMerger;
import org.apache.hudi.HoodieFileIndex;
import org.apache.hudi.HoodieSparkUtils$;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.ExceptionUtil;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.index.inmemory.HoodieInMemoryHashIndex;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.log4j.Level;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.util.Utils$;
import org.joda.time.DateTimeZone;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Args;
import org.scalatest.BeforeAndAfterAll;
import org.scalatest.Status;
import org.scalatest.Tag;
import org.scalatest.funsuite.AnyFunSuite;
import org.scalatest.funsuite.AnyFunSuiteLike;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0015a\u0001B\u001c9\u0001\u0015CQA\u0017\u0001\u0005\u0002mCqA\u0018\u0001C\u0002\u0013%q\f\u0003\u0004g\u0001\u0001\u0006I\u0001\u0019\u0005\tO\u0002A)\u0019!C\u0005Q\"Aq\b\u0001EC\u0002\u0013E\u0011\u000fC\u0004w\u0001\u0001\u0007I\u0011B<\t\u0013\u0005\u0015\u0001\u00011A\u0005\n\u0005\u001d\u0001bBA\r\u0001\u0001\u0006K\u0001\u001f\u0005\n\u00037\u0001\u0001\u0019!C\u0005\u0003;A\u0011\"a\u0010\u0001\u0001\u0004%I!!\u0011\t\u0011\u0005\u0015\u0003\u0001)Q\u0005\u0003?Aq!a\u0012\u0001\t\u0003\tI\u0005C\u0004\u0002T\u0001!\t\"!\u0016\t\u000f\u0005]\u0003\u0001\"\u0005\u0002Z!9\u0011Q\r\u0001\u0005\u0012\u0005\u001d\u0004bBA7\u0001\u0011E\u0013q\u000e\u0005\b\u0003[\u0003A\u0011CAX\u0011\u001d\t\t\f\u0001C)\u0003+Bq!a-\u0001\t#\t)\fC\u0004\u00024\u0002!\t\"!5\t\u000f\u0005\u001d\b\u0001\"\u0005\u0002j\"9\u00111\u001f\u0001\u0005\u0012\u0005U\bb\u0002B\u0001\u0001\u0011E!1\u0001\u0005\b\u0005\u0003\u0001A\u0011\u0003B\u0006\u0011\u001d\u0011\t\u0003\u0001C\t\u0005GAqAa\u000b\u0001\t#\u0011i\u0003C\u0004\u0003,\u0001!\tB!\u000e\t\u000f\tu\u0002\u0001\"\u0005\u0003@!9!\u0011\n\u0001\u0005\u0012\t-\u0003b\u0002B%\u0001\u0011E!Q\u000b\u0005\b\u0005K\u0002A\u0011\u0003B4\u0011\u001d\u0011\t\t\u0001C\u0001\u0005\u0007CqA!#\u0001\t#\u0011Y\tC\u0004\u0003\u0010\u0002!\tB!%\t\u000f\tu\u0005\u0001\"\u0005\u0003 \"9!Q\u0019\u0001\u0005\u0012\t\u001d\u0007b\u0002Bi\u0001\u0011E!1\u001b\u0005\b\u0005?\u0004A\u0011\u0003Bq\u0011\u001d\u0011i\u000f\u0001C\t\u0005_D\u0011ba\u000b\u0001#\u0003%\tb!\f\t\u0013\r\r\u0003!%A\u0005\u0012\r\u0015saBB%q!\u000511\n\u0004\u0007oaB\ta!\u0014\t\ri[C\u0011AB.\u0011%\u0019if\u000bb\u0001\n\u000b\u0019y\u0006\u0003\u0005\u0004n-\u0002\u000bQBB1\u0011\u001d\u0019yg\u000bC\u0001\u0007cBqa!!,\t\u0003\u0019\u0019\tC\u0004\u0004\u0018.\"\ta!'\t\u000f\re6\u0006\"\u0001\u0004<\"911[\u0016\u0005\u0002\rU\u0007bBBmW\u0011\u000511\u001c\u0005\b\u0007S\\C\u0011BBv\u0011%\u0019YpKA\u0001\n\u0013\u0019iP\u0001\fI_>$\u0017.Z*qCJ\\7+\u001d7UKN$()Y:f\u0015\tI$(\u0001\u0004d_6lwN\u001c\u0006\u0003wq\nA\u0001[;eS*\u0011QHP\u0001\u0004gFd'BA A\u0003\u0015\u0019\b/\u0019:l\u0015\t\t%)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0007\u0006\u0019qN]4\u0004\u0001M\u0019\u0001A\u0012,\u0011\u0005\u001d\u001bfB\u0001%Q\u001d\tIeJ\u0004\u0002K\u001b6\t1J\u0003\u0002M\t\u00061AH]8pizJ\u0011aQ\u0005\u0003\u001f\n\u000b\u0011b]2bY\u0006$Xm\u001d;\n\u0005E\u0013\u0016a\u00029bG.\fw-\u001a\u0006\u0003\u001f\nK!\u0001V+\u0003\u0011\u0019+hnU;ji\u0016T!!\u0015*\u0011\u0005]CV\"\u0001*\n\u0005e\u0013&!\u0005\"fM>\u0014X-\u00118e\u0003\u001a$XM]!mY\u00061A(\u001b8jiz\"\u0012\u0001\u0018\t\u0003;\u0002i\u0011\u0001O\u0001\u0004\u0019>;U#\u00011\u0011\u0005\u0005$W\"\u00012\u000b\u0005\r\u0014\u0015!B:mMRR\u0017BA3c\u0005\u0019aunZ4fe\u0006!AjT$!\u00039\u0019\b/\u0019:l/\u0006\u0014X\rS8vg\u0016,\u0012!\u001b\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\f!![8\u000b\u00039\fAA[1wC&\u0011\u0001o\u001b\u0002\u0005\r&dW-F\u0001s!\t\u0019H/D\u0001=\u0013\t)HH\u0001\u0007Ta\u0006\u00148nU3tg&|g.A\u0004uC\ndW-\u00133\u0016\u0003a\u00042!_A\u0001\u001b\u0005Q(BA>}\u0003\u0019\tGo\\7jG*\u0011QP`\u0001\u000bG>t7-\u001e:sK:$(BA@n\u0003\u0011)H/\u001b7\n\u0007\u0005\r!PA\u0007Bi>l\u0017nY%oi\u0016<WM]\u0001\fi\u0006\u0014G.Z%e?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0005U\u0001\u0003BA\u0006\u0003#i!!!\u0004\u000b\u0005\u0005=\u0011!B:dC2\f\u0017\u0002BA\n\u0003\u001b\u0011A!\u00168ji\"A\u0011qC\u0004\u0002\u0002\u0003\u0007\u00010A\u0002yIE\n\u0001\u0002^1cY\u0016LE\rI\u0001\nKb$(/Y\"p]\u001a,\"!a\b\u0011\u0011\u0005\u0005\u00121FA\u0018\u0003_i!!a\t\u000b\t\u0005\u0015\u0012qE\u0001\nS6lW\u000f^1cY\u0016TA!!\u000b\u0002\u000e\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u00055\u00121\u0005\u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0019\u0003sqA!a\r\u00026A\u0019!*!\u0004\n\t\u0005]\u0012QB\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0012Q\b\u0002\u0007'R\u0014\u0018N\\4\u000b\t\u0005]\u0012QB\u0001\u000eKb$(/Y\"p]\u001a|F%Z9\u0015\t\u0005%\u00111\t\u0005\n\u0003/Q\u0011\u0011!a\u0001\u0003?\t!\"\u001a=ue\u0006\u001cuN\u001c4!\u0003%\u0019\b/\u0019:l\u0007>tg\r\u0006\u0002\u0002LA!\u0011QJA(\u001b\u0005q\u0014bAA)}\tI1\u000b]1sW\u000e{gNZ\u0001\u0013S:LG/U;fefLe\u000eZ3y\u0007>tg\r\u0006\u0002\u0002\n\u0005Yq/\u001b;i)\u0016l\u0007\u000fR5s)\u0011\tI!a\u0017\t\u000f\u0005uc\u00021\u0001\u0002`\u0005\ta\rE\u0004\u0002\f\u0005\u0005\u0014.!\u0003\n\t\u0005\r\u0014Q\u0002\u0002\n\rVt7\r^5p]F\n1cZ3u)\u0006\u0014G.Z*u_J\fw-\u001a)bi\"$B!a\f\u0002j!9\u00111N\bA\u0002\u0005=\u0012!\u0003;bE2,g*Y7f\u0003\u0011!Xm\u001d;\u0015\r\u0005E\u0014\u0011TAO)\u0011\t\u0019(!#\u0015\t\u0005%\u0011Q\u000f\u0005\b\u0003o\u0002\u00029AA=\u0003\r\u0001xn\u001d\t\u0005\u0003w\n))\u0004\u0002\u0002~)!\u0011qPAA\u0003\u0019\u0019x.\u001e:dK*\u0019\u00111\u0011\"\u0002\u0013M\u001c\u0017\r\\1di&\u001c\u0017\u0002BAD\u0003{\u0012\u0001\u0002U8tSRLwN\u001c\u0005\t\u0003\u0017\u0003B\u00111\u0001\u0002\u000e\u00069A/Z:u\rVt\u0007CBA\u0006\u0003\u001f\u000b\u0019*\u0003\u0003\u0002\u0012\u00065!\u0001\u0003\u001fcs:\fW.\u001a \u0011\t\u0005-\u0011QS\u0005\u0005\u0003/\u000biAA\u0002B]fDq!a'\u0011\u0001\u0004\ty#\u0001\u0005uKN$h*Y7f\u0011\u001d\ty\n\u0005a\u0001\u0003C\u000b\u0001\u0002^3tiR\u000bwm\u001d\t\u0007\u0003\u0017\t\u0019+a*\n\t\u0005\u0015\u0016Q\u0002\u0002\u000byI,\u0007/Z1uK\u0012t\u0004cA,\u0002*&\u0019\u00111\u0016*\u0003\u0007Q\u000bw-A\thK:,'/\u0019;f)\u0006\u0014G.\u001a(b[\u0016,\"!a\f\u0002\u0011\u00054G/\u001a:BY2\f1b\u00195fG.\fen]<feR!\u0011qWAh)\u0011\tI!!/\t\u000f\u0005m6\u00031\u0001\u0002>\u00069Q\r\u001f9fGR\u001c\bCBA\u0006\u0003G\u000by\f\u0005\u0004\u0002B\u0006%\u00171\u0013\b\u0005\u0003\u0007\f9MD\u0002K\u0003\u000bL!!a\u0004\n\u0007E\u000bi!\u0003\u0003\u0002L\u00065'aA*fc*\u0019\u0011+!\u0004\t\ru\u001a\u0002\u0019AA\u0018)\u0011\t\u0019.a6\u0015\t\u0005%\u0011Q\u001b\u0005\b\u0003w#\u0002\u0019AA_\u0011\u001d\tI\u000e\u0006a\u0001\u00037\fQ!\u0019:sCf\u0004b!a\u0003\u0002^\u0006\u0005\u0018\u0002BAp\u0003\u001b\u0011Q!\u0011:sCf\u00042a]Ar\u0013\r\t)\u000f\u0010\u0002\u0004%><\u0018\u0001H2iK\u000e\\g*Z:uK\u0012,\u0005pY3qi&|gnQ8oi\u0006Lgn\u001d\u000b\u0005\u0003W\f\t\u0010\u0006\u0003\u0002\n\u00055\bbBAx+\u0001\u0007\u0011qF\u0001\tKJ\u0014xN]'tO\"1Q(\u0006a\u0001\u0003_\tqb\u00195fG.,\u0005pY3qi&|gn\u001d\u000b\u0005\u0003o\fy\u0010\u0006\u0003\u0002\n\u0005e\bbBA~-\u0001\u0007\u0011Q`\u0001\nKJ\u0014xN]'tON\u0004b!!1\u0002J\u0006=\u0002BB\u001f\u0017\u0001\u0004\ty#\u0001\bdQ\u0016\u001c7.\u0012=dKB$\u0018n\u001c8\u0015\t\t\u0015!\u0011\u0002\u000b\u0005\u0003\u0013\u00119\u0001C\u0004\u0002p^\u0001\r!a\f\t\ru:\u0002\u0019AA\u0018)\u0011\u0011iA!\u0005\u0015\t\u0005%!q\u0002\u0005\b\u0003_D\u0002\u0019AA\u0018\u0011\u001d\u0011\u0019\u0002\u0007a\u0001\u0005+\t\u0001B];o]\u0006\u0014G.\u001a\t\u0005\u0005/\u0011i\"\u0004\u0002\u0003\u001a)\u0019!1D7\u0002\t1\fgnZ\u0005\u0005\u0005?\u0011IB\u0001\u0005Sk:t\u0017M\u00197f\u0003Q\u0019\u0007.Z2l\u001d\u0016\u001cH/\u001a3Fq\u000e,\u0007\u000f^5p]R!!Q\u0005B\u0015)\u0011\tIAa\n\t\u000f\u0005=\u0018\u00041\u0001\u00020!1Q(\u0007a\u0001\u0003_\tQc\u00195fG.,\u0005pY3qi&|gnQ8oi\u0006Lg\u000e\u0006\u0003\u00030\tMB\u0003BA\u0005\u0005cAq!a<\u001b\u0001\u0004\ty\u0003C\u0004\u0003\u0014i\u0001\rA!\u0006\u0015\t\t]\"1\b\u000b\u0005\u0003\u0013\u0011I\u0004C\u0004\u0002pn\u0001\r!a\f\t\ruZ\u0002\u0019AA\u0018\u0003M\u0019\u0007.Z2l\u000bb\u001cW\r\u001d;j_:l\u0015\r^2i)\u0011\u0011\tEa\u0012\u0015\t\u0005%!1\t\u0005\b\u0005\u000bb\u0002\u0019AA\u0018\u00035)'O]8s\u001bN<'+Z4fq\"1Q\b\ba\u0001\u0003_\t1fZ3u\u000bb\u0004Xm\u0019;fIVs'/Z:pYZ,GmQ8mk6tW\t_2faRLwN\\'fgN\fw-\u001a\u000b\u0007\u0003_\u0011iE!\u0015\t\u000f\t=S\u00041\u0001\u00020\u0005Q1m\u001c7v[:t\u0015-\\3\t\u000f\tMS\u00041\u0001\u00020\u0005yA/\u0019:hKR$\u0016M\u00197f\u001d\u0006lW\r\u0006\u0004\u00020\t]#\u0011\f\u0005\b\u0005\u001fr\u0002\u0019AA\u0018\u0011\u001d\u0011YF\ba\u0001\u0005;\nqBZ5fY\u0012t\u0015-\\3UkBdWm\u001d\t\u0007\u0003\u0003\fIMa\u0018\u0011\u0015\u0005-!\u0011MA\u0018\u0003_\ty#\u0003\u0003\u0003d\u00055!A\u0002+va2,7'A\nwC2LG-\u0019;f)\u0006\u0014G.Z*dQ\u0016l\u0017\r\u0006\u0004\u0002\n\t%$1\u000e\u0005\b\u0003Wz\u0002\u0019AA\u0018\u0011\u001d\u0011ig\ba\u0001\u0005_\nA#\u001a=qK\u000e$X\rZ*ueV\u001cGOR5fY\u0012\u001c\bCBAa\u0005c\u0012)(\u0003\u0003\u0003t\u00055'\u0001\u0002'jgR\u0004BAa\u001e\u0003~5\u0011!\u0011\u0010\u0006\u0004\u0005wb\u0014!\u0002;za\u0016\u001c\u0018\u0002\u0002B@\u0005s\u00121b\u0015;sk\u000e$h)[3mI\u0006)BM]8q)f\u0004X\rT5uKJ\fG\u000e\u0015:fM&DH\u0003BAJ\u0005\u000bCqAa\"!\u0001\u0004\t\u0019*A\u0003wC2,X-A\bfqR\u0014\u0018m\u0019;SC^4\u0016\r\\;f)\u0011\t\u0019J!$\t\u000f\t\u001d\u0015\u00051\u0001\u0002\u0014\u0006QQ\r_5tiN\u0004\u0016\r\u001e5\u0015\t\tM%\u0011\u0014\t\u0005\u0003\u0017\u0011)*\u0003\u0003\u0003\u0018\u00065!a\u0002\"p_2,\u0017M\u001c\u0005\b\u00057\u0013\u0003\u0019AA\u0018\u0003!1\u0017\u000e\\3QCRD\u0017aC<ji\"\u001c\u0016\u000bT\"p]\u001a,BA!)\u0003*R!!1\u0015B])\u0011\u0011)K!.\u0011\t\t\u001d&\u0011\u0016\u0007\u0001\t\u001d\u0011Yk\tb\u0001\u0005[\u0013\u0011\u0001V\t\u0005\u0005_\u000b\u0019\n\u0005\u0003\u0002\f\tE\u0016\u0002\u0002BZ\u0003\u001b\u0011qAT8uQ&tw\r\u0003\u0005\u0002^\r\"\t\u0019\u0001B\\!\u0019\tY!a$\u0003&\"9!1X\u0012A\u0002\tu\u0016!\u00029bSJ\u001c\bCBA\u0006\u0003G\u0013y\f\u0005\u0005\u0002\f\t\u0005\u0017qFA\u0018\u0013\u0011\u0011\u0019-!\u0004\u0003\rQ+\b\u000f\\33\u0003%9\u0018\u000e\u001e5UC\ndW\r\u0006\u0003\u0003J\n=G\u0003BA\u0005\u0005\u0017Dq!!\u0018%\u0001\u0004\u0011i\r\u0005\u0005\u0002\f\u0005\u0005\u0014qFA\u0005\u0011\u001d\tY\u0007\na\u0001\u0003_\t\u0011d^5uQN\u0003\u0018M]6Tc2\u001cVm]:j_:\u001cuN\u001c4jOR!!Q\u001bBn)\u0011\tIAa6\t\u0011\u0005uS\u0005\"a\u0001\u00053\u0004b!a\u0003\u0002\u0010\u0006%\u0001b\u0002BoK\u0001\u0007!QX\u0001\u0011G>tg-[4OC6,g+\u00197vKN\fae^5uQN\u0003\u0018M]6Tc2\u001cVm]:j_:\u001cuN\u001c4jO^KG\u000f[\"p]\u0012LG/[8o)\u0011\u0011\u0019Oa:\u0015\t\u0005%!Q\u001d\u0005\t\u0003;2C\u00111\u0001\u0003Z\"9!Q\u001c\u0014A\u0002\t%\bCBA\u0006\u0003G\u0013Y\u000f\u0005\u0005\u0002\f\t\u0005'q\u0018BJ\u000399\u0018\u000e\u001e5SK\u000e|'\u000f\u001a+za\u0016$bA!=\u0003v\u000e\u0005B\u0003BA\u0005\u0005gD\u0001\"!\u0018(\t\u0003\u0007!\u0011\u001c\u0005\n\u0005o<\u0003\u0013!a\u0001\u0005s\f1B]3d_J$G+\u001f9fgB1\u0011\u0011YAe\u0005w\u0004BA!@\u0004\u001c9!!q`B\u000b\u001d\u0011\u0019\taa\u0004\u000f\t\r\r11\u0002\b\u0005\u0007\u000b\u0019IAD\u0002J\u0007\u000fI!!\u0011\"\n\u0005m\u0002\u0015bA\u001d\u0004\u000e)\u00111\bQ\u0005\u0005\u0007#\u0019\u0019\"A\u0003n_\u0012,GNC\u0002:\u0007\u001bIAaa\u0006\u0004\u001a\u0005a\u0001j\\8eS\u0016\u0014VmY8sI*!1\u0011CB\n\u0013\u0011\u0019iba\b\u0003!!{w\u000eZ5f%\u0016\u001cwN\u001d3UsB,'\u0002BB\f\u00073A\u0011ba\t(!\u0003\u0005\ra!\n\u0002\u0019I,7m\u001c:e\u0007>tg-[4\u0011\u0011\u0005E2q\u0005B~\u0007SIA!!\f\u0002>AA\u0011\u0011GB\u0014\u0003_\ty#\u0001\rxSRD'+Z2pe\u0012$\u0016\u0010]3%I\u00164\u0017-\u001e7uIE*\"aa\f+\t\te8\u0011G\u0016\u0003\u0007g\u0001Ba!\u000e\u0004@5\u00111q\u0007\u0006\u0005\u0007s\u0019Y$A\u0005v]\u000eDWmY6fI*!1QHA\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0007\u0003\u001a9DA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001d^5uQJ+7m\u001c:e)f\u0004X\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u00199E\u000b\u0003\u0004&\rE\u0012A\u0006%p_\u0012LWm\u00159be.\u001c\u0016\u000f\u001c+fgR\u0014\u0015m]3\u0011\u0005u[3#B\u0016\u0004P\rU\u0003\u0003BA\u0006\u0007#JAaa\u0015\u0002\u000e\t1\u0011I\\=SK\u001a\u0004B!a\u0003\u0004X%!1\u0011LA\u0007\u00051\u0019VM]5bY&T\u0018M\u00197f)\t\u0019Y%A\bO\u00036+uLR(S\u001b\u0006#v\fM0Y+\t\u0019\t\u0007\u0005\u0003\u0004d\r%TBAB3\u0015\r\u00199G`\u0001\u0006e\u0016<W\r_\u0005\u0005\u0007W\u001a)GA\u0004QCR$XM\u001d8\u0002!9\u000bU*R0G\u001fJk\u0015\tV01?b\u0003\u0013!F4fi2\u000b7\u000f^\"p[6LG/T3uC\u0012\fG/\u0019\u000b\u0007\u0007g\u001aYh! \u0011\t\rU4qO\u0007\u0003\u00073IAa!\u001f\u0004\u001a\t!\u0002j\\8eS\u0016\u001cu.\\7ji6+G/\u00193bi\u0006DQaP\u0018A\u0002IDqaa 0\u0001\u0004\ty#A\u0005uC\ndW\rU1uQ\u0006!r-\u001a;MCN$8\t\\3b]6+G/\u00193bi\u0006$ba!\"\u0004\u0014\u000eU\u0005\u0003BBD\u0007\u001fk!a!#\u000b\t\rE11\u0012\u0006\u0005\u0007\u001b\u001bi!\u0001\u0003bmJ|\u0017\u0002BBI\u0007\u0013\u00131\u0003S8pI&,7\t\\3b]6+G/\u00193bi\u0006DQa\u0010\u0019A\u0002IDqaa 1\u0001\u0004\ty#\u0001\u0010hKRlU\r^1DY&,g\u000e^!oI\u001aKG.Z*zgR,WNV5foR!11TB[!!\tYA!1\u0004\u001e\u000e%\u0006\u0003BBP\u0007Kk!a!)\u000b\t\r\r61C\u0001\u0006i\u0006\u0014G.Z\u0005\u0005\u0007O\u001b\tKA\u000bI_>$\u0017.\u001a+bE2,W*\u001a;b\u00072LWM\u001c;\u0011\t\r-6\u0011W\u0007\u0003\u0007[SAaa,\u0004\"\u0006!a/[3x\u0013\u0011\u0019\u0019l!,\u0003-MKhnY1cY\u00164\u0015\u000e\\3TsN$X-\u001c,jK^Dqaa.2\u0001\u0004\ty#\u0001\u0005cCN,\u0007+\u0019;i\u0003Q\u0011X\r\u001d7bG\u0016<\u0016\u000e\u001e5F[B$\u0018PR5mKR1\u0011\u0011BB_\u0007\u0017Dqaa03\u0001\u0004\u0019\t-A\u0004ti>\u0014\u0018mZ3\u0011\t\r\r7qY\u0007\u0003\u0007\u000bTAaa0\u0004\u000e%!1\u0011ZBc\u00055Aun\u001c3jKN#xN]1hK\"9!1\u0014\u001aA\u0002\r5\u0007\u0003BBb\u0007\u001fLAa!5\u0004F\nY1\u000b^8sC\u001e,\u0007+\u0019;i\u0003)2\u0018\r\\5eCR,G)\u001a7fi\u0016dun\u001a\"m_\u000e\\\u0007K]3d_6\u0014\u0017N\\3Ok2dwJ\u001d.fe>$B!!\u0003\u0004X\"91qW\u001aA\u0002\u0005=\u0012a\u0005<bY&$\u0017\r^3UC\ndWmQ8oM&<GCCA\u0005\u0007;\u001cyn!9\u0004f\"91q\u0018\u001bA\u0002\r\u0005\u0007bBB\\i\u0001\u0007\u0011q\u0006\u0005\b\u0007G$\u0004\u0019AB\u0015\u0003=)\u0007\u0010]3di\u0016$7i\u001c8gS\u001e\u001c\bbBBti\u0001\u0007\u0011Q`\u0001\u0013]>tW\t_5ti\u0016tGoQ8oM&<7/\u0001\u000bdQ\u0016\u001c7.T3tg\u0006<WmQ8oi\u0006Lgn\u001d\u000b\u0007\u0005'\u001bioa>\t\u000f\r=X\u00071\u0001\u0004r\u0006\tQ\r\u0005\u0003\u0002B\u000eM\u0018\u0002BB{\u0003\u001b\u0014\u0011\u0002\u00165s_^\f'\r\\3\t\u000f\reX\u00071\u0001\u00020\u0005!A/\u001a=u\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\r}\b\u0003\u0002B\f\t\u0003IA\u0001b\u0001\u0003\u001a\t1qJ\u00196fGR\u0004")
public class HoodieSparkSqlTestBase
extends AnyFunSuite
implements BeforeAndAfterAll {
    private File sparkWareHouse;
    private SparkSession spark;
    private final Logger LOG;
    private AtomicInteger tableId;
    private Map<String, String> extraConf;
    private final boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    private volatile byte bitmap$0;

    public static void validateTableConfig(HoodieStorage hoodieStorage, String string, Map<String, String> map, Seq<String> seq) {
        HoodieSparkSqlTestBase$.MODULE$.validateTableConfig(hoodieStorage, string, map, seq);
    }

    public static void validateDeleteLogBlockPrecombineNullOrZero(String string) {
        HoodieSparkSqlTestBase$.MODULE$.validateDeleteLogBlockPrecombineNullOrZero(string);
    }

    public static void replaceWithEmptyFile(HoodieStorage hoodieStorage, StoragePath storagePath) {
        HoodieSparkSqlTestBase$.MODULE$.replaceWithEmptyFile(hoodieStorage, storagePath);
    }

    public static Tuple2<HoodieTableMetaClient, SyncableFileSystemView> getMetaClientAndFileSystemView(String string) {
        return HoodieSparkSqlTestBase$.MODULE$.getMetaClientAndFileSystemView(string);
    }

    public static HoodieCleanMetadata getLastCleanMetadata(SparkSession sparkSession, String string) {
        return HoodieSparkSqlTestBase$.MODULE$.getLastCleanMetadata(sparkSession, string);
    }

    public static HoodieCommitMetadata getLastCommitMetadata(SparkSession sparkSession, String string) {
        return HoodieSparkSqlTestBase$.MODULE$.getLastCommitMetadata(sparkSession, string);
    }

    public static Pattern NAME_FORMAT_0_X() {
        return HoodieSparkSqlTestBase$.MODULE$.NAME_FORMAT_0_X();
    }

    public /* synthetic */ Status org$scalatest$BeforeAndAfterAll$$super$run(Option testName, Args args) {
        return AnyFunSuiteLike.run$((AnyFunSuiteLike)this, (Option)testName, (Args)args);
    }

    public void beforeAll() {
        BeforeAndAfterAll.beforeAll$((BeforeAndAfterAll)this);
    }

    public Status run(Option<String> testName, Args args) {
        return BeforeAndAfterAll.run$((BeforeAndAfterAll)this, testName, (Args)args);
    }

    public boolean invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected() {
        return this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected;
    }

    public void org$scalatest$BeforeAndAfterAll$_setter_$invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected_$eq(boolean x$1) {
        this.invokeBeforeAllAndAfterAllEvenIfNoTestsAreExpected = x$1;
    }

    private Logger LOG() {
        return this.LOG;
    }

    /*
     * WARNING - void declaration
     */
    private File sparkWareHouse$lzycompute() {
        HoodieSparkSqlTestBase hoodieSparkSqlTestBase = this;
        synchronized (hoodieSparkSqlTestBase) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                File dir = Utils$.MODULE$.createTempDir();
                Utils$.MODULE$.deleteRecursively(dir);
                this.sparkWareHouse = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.sparkWareHouse;
    }

    private File sparkWareHouse() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.sparkWareHouse$lzycompute();
        }
        return this.sparkWareHouse;
    }

    private SparkSession spark$lzycompute() {
        HoodieSparkSqlTestBase hoodieSparkSqlTestBase = this;
        synchronized (hoodieSparkSqlTestBase) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.spark = SparkSession$.MODULE$.builder().config("spark.sql.warehouse.dir", this.sparkWareHouse().getCanonicalPath()).config("spark.sql.session.timeZone", "UTC").config("hoodie.insert.shuffle.parallelism", "4").config("hoodie.upsert.shuffle.parallelism", "4").config("hoodie.delete.shuffle.parallelism", "4").config(this.sparkConf()).getOrCreate();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.spark;
    }

    public SparkSession spark() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.spark$lzycompute();
        }
        return this.spark;
    }

    private AtomicInteger tableId() {
        return this.tableId;
    }

    private void tableId_$eq(AtomicInteger x$1) {
        this.tableId = x$1;
    }

    private Map<String, String> extraConf() {
        return this.extraConf;
    }

    private void extraConf_$eq(Map<String, String> x$1) {
        this.extraConf = x$1;
    }

    public SparkConf sparkConf() {
        SparkConf conf = HoodieClientTestUtils.getSparkConfForTest((String)"Hoodie SQL Test");
        conf.setAll(this.extraConf());
        return conf;
    }

    public void initQueryIndexConf() {
        this.extraConf_$eq((Map<String, String>)this.extraConf().$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieFileIndex.DataSkippingFailureMode$.MODULE$.configName()), (Object)HoodieFileIndex.DataSkippingFailureMode$.MODULE$.Strict().value())}))));
    }

    public void withTempDir(Function1<File, BoxedUnit> f) {
        File tempDir = Utils$.MODULE$.createTempDir();
        try {
            f.apply((Object)tempDir);
        }
        finally {
            Utils$.MODULE$.deleteRecursively(tempDir);
        }
    }

    public String getTableStoragePath(String tableName) {
        return new File(this.sparkWareHouse(), tableName).getCanonicalPath();
    }

    public void test(String testName, Seq<Tag> testTags, Function0<Object> testFun, Position pos) {
        AnyFunSuiteLike.test$((AnyFunSuiteLike)this, (String)testName, testTags, (Function0 & Serializable & scala.Serializable)() -> {
            Object object;
            try {
                object = testFun.apply();
            }
            finally {
                SessionCatalog catalog = this.spark().sessionState().catalog();
                catalog.listDatabases().foreach((Function1 & Serializable & scala.Serializable)db -> {
                    HoodieSparkSqlTestBase.$anonfun$test$2(catalog, db);
                    return BoxedUnit.UNIT;
                });
            }
            return object;
        }, (Position)pos);
    }

    public String generateTableName() {
        return new StringBuilder(1).append("h").append(this.tableId().incrementAndGet()).toString();
    }

    public void afterAll() {
        Utils$.MODULE$.deleteRecursively(this.sparkWareHouse());
        this.spark().stop();
    }

    public void checkAnswer(String sql, Seq<Seq<Object>> expects) {
        this.assertResult(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)expects.map((Function1 & Serializable & scala.Serializable)row -> Row$.MODULE$.apply(row), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Row.class)))).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), (Ordering)Ordering.String$.MODULE$), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().sql(sql).collect())).sortBy((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toString(), (Ordering)Ordering.String$.MODULE$), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 135));
    }

    public void checkAnswer(Row[] array, Seq<Seq<Object>> expects) {
        this.assertResult(((TraversableOnce)expects.map((Function1 & Serializable & scala.Serializable)row -> Row$.MODULE$.apply(row), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Row.class)), array, Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 139));
    }

    public void checkNestedExceptionContains(String sql, String errorMsg) {
        Dataset dataset;
        boolean hasException = false;
        try {
            dataset = this.spark().sql(sql);
        }
        catch (Throwable e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (!t.getMessage().trim().contains(errorMsg.trim())) continue;
                hasException = true;
            }
            if (!hasException) {
                e.printStackTrace(System.err);
            }
            dataset = BoxedUnit.UNIT;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 159));
    }

    public void checkExceptions(String sql, Seq<String> errorMsgs) {
        Dataset dataset;
        boolean hasException = false;
        try {
            dataset = this.spark().sql(sql);
        }
        catch (Throwable e) {
            this.assertResult(BoxesRunTime.boxToBoolean((boolean)errorMsgs.contains((Object)e.getMessage().split("\n")[0])), BoxesRunTime.boxToBoolean((boolean)true), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 168));
            hasException = true;
            dataset = BoxedUnit.UNIT;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 171));
    }

    public void checkException(String sql, String errorMsg) {
        Dataset dataset;
        boolean hasException = false;
        try {
            dataset = this.spark().sql(sql);
        }
        catch (Throwable e) {
            this.assertResult(errorMsg.trim(), e.getMessage().trim(), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180));
            hasException = true;
            dataset = BoxedUnit.UNIT;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 183));
    }

    public void checkException(Runnable runnable, String errorMsg) {
        boolean hasException = false;
        try {
            runnable.run();
        }
        catch (Throwable e) {
            this.assertResult(errorMsg.trim(), e.getMessage().trim(), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 192));
            hasException = true;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 195));
    }

    public void checkNestedException(String sql, String errorMsg) {
        Dataset dataset;
        boolean hasException = false;
        try {
            dataset = this.spark().sql(sql);
        }
        catch (Throwable e) {
            for (Throwable t = e; t != null; t = t.getCause()) {
                if (!errorMsg.trim().equals(t.getMessage().trim())) continue;
                hasException = true;
            }
            dataset = BoxedUnit.UNIT;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 212));
    }

    public void checkExceptionContain(Runnable runnable, String errorMsg) {
        boolean hasException = false;
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && (HoodieSparkSqlTestBase$.MODULE$.org$apache$spark$sql$hudi$common$HoodieSparkSqlTestBase$$checkMessageContains(throwable2 = throwable3, errorMsg) || HoodieSparkSqlTestBase$.MODULE$.org$apache$spark$sql$hudi$common$HoodieSparkSqlTestBase$$checkMessageContains(ExceptionUtil.getRootCause((Throwable)throwable2), errorMsg))) {
                hasException = true;
            }
            if (throwable3 != null) {
                Throwable throwable4 = throwable3;
                throw this.fail(new StringBuilder(43).append("Exception should contain: ").append(errorMsg).append(", error message: ").append(throwable4.getMessage()).toString(), throwable4, new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
            }
            throw throwable;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
    }

    public void checkExceptionContain(String sql, String errorMsg) {
        Dataset dataset;
        boolean hasException = false;
        try {
            dataset = this.spark().sql(sql);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && (HoodieSparkSqlTestBase$.MODULE$.org$apache$spark$sql$hudi$common$HoodieSparkSqlTestBase$$checkMessageContains(throwable2 = throwable3, errorMsg) || HoodieSparkSqlTestBase$.MODULE$.org$apache$spark$sql$hudi$common$HoodieSparkSqlTestBase$$checkMessageContains(ExceptionUtil.getRootCause((Throwable)throwable2), errorMsg))) {
                hasException = true;
                dataset = BoxedUnit.UNIT;
            }
            if (throwable3 != null) {
                Throwable throwable4 = throwable3;
                throw this.fail(new StringBuilder(43).append("Exception should contain: ").append(errorMsg).append(", error message: ").append(throwable4.getMessage()).toString(), throwable4, new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 238));
            }
            throw throwable;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
    }

    public void checkExceptionMatch(String sql, String errorMsgRegex) {
        Dataset dataset;
        boolean hasException = false;
        try {
            dataset = this.spark().sql(sql);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && ExceptionUtil.getRootCause((Throwable)(throwable2 = throwable3)).getMessage().matches(errorMsgRegex)) {
                hasException = true;
                dataset = BoxedUnit.UNIT;
            }
            if (throwable3 != null) {
                Throwable throwable4 = throwable3;
                throw this.fail(new StringBuilder(49).append("Exception should match pattern: ").append(errorMsgRegex).append(", error message: ").append(ExceptionUtil.getRootCause((Throwable)throwable4).getMessage()).toString(), throwable4, new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 252));
            }
            throw throwable;
        }
        this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)hasException), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 254));
    }

    public String getExpectedUnresolvedColumnExceptionMessage(String columnName, String targetTableName) {
        Tuple3[] targetTableFields = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().sql(new StringBuilder(14).append("select * from ").append(targetTableName).toString()).schema().fields())).map((Function1 & Serializable & scala.Serializable)e -> new Tuple3((Object)e.name(), (Object)targetTableName, (Object)new StringBuilder(23).append("spark_catalog.default.").append(targetTableName).append(".").append(e.name()).toString()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        return this.getExpectedUnresolvedColumnExceptionMessage(columnName, (Seq<Tuple3<String, String, String>>)Predef$.MODULE$.wrapRefArray((Object[])targetTableFields));
    }

    public String getExpectedUnresolvedColumnExceptionMessage(String columnName, Seq<Tuple3<String, String, String>> fieldNameTuples) {
        String fieldNames = ((TraversableOnce)((TraversableLike)fieldNameTuples.sortBy((Function1 & Serializable & scala.Serializable)e -> new Tuple2(e._1(), e._2()), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.String$.MODULE$))).map((Function1 & Serializable & scala.Serializable)e -> (String)e._3(), Seq$.MODULE$.canBuildFrom())).mkString("[", ", ", "]");
        if (HoodieSparkUtils$.MODULE$.gteqSpark3_5()) {
            return new StringBuilder(134).append("[UNRESOLVED_COLUMN.WITH_SUGGESTION] A column or function parameter with name ").append(columnName).append(" cannot be resolved. Did you mean one of the following? ").append(fieldNames).append(".").toString();
        }
        return new StringBuilder(47).append("cannot resolve ").append(columnName).append(" in MERGE command given columns ").append(fieldNames).append((Object)(HoodieSparkUtils$.MODULE$.gteqSpark3_4() ? "." : "")).toString();
    }

    public void validateTableSchema(String tableName, List<StructField> expectedStructFields) {
        this.assertResult(expectedStructFields, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString()).schema().fields())).filter((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)HoodieSparkSqlTestBase.$anonfun$validateTableSchema$1(e))), Prettifier$.MODULE$.default(), new Position("HoodieSparkSqlTestBase.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 279));
    }

    public Object dropTypeLiteralPrefix(Object value) {
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString(string)).stripPrefix("DATE"))).stripPrefix("TIMESTAMP"))).stripPrefix("X");
        }
        return value;
    }

    public Object extractRawValue(Object value) {
        Object object = value;
        if (object instanceof String) {
            String string = (String)object;
            return new StringOps(Predef$.MODULE$.augmentString(new StringOps(Predef$.MODULE$.augmentString((String)this.dropTypeLiteralPrefix(string))).stripPrefix("'"))).stripSuffix("'");
        }
        return value;
    }

    public boolean existsPath(String filePath) {
        Path path = new Path(filePath);
        FileSystem fs = HadoopFSUtils.getFs((String)filePath, (Configuration)this.spark().sparkContext().hadoopConfiguration());
        return fs.exists(path);
    }

    public <T> T withSQLConf(Seq<Tuple2<String, String>> pairs, Function0<T> f) {
        Object object;
        SQLConf conf = this.spark().sessionState().conf();
        Seq currentValues = (Seq)((TraversableLike)pairs.unzip((Function1)Predef$.MODULE$.$conforms())._1()).map((Function1 & Serializable & scala.Serializable)k -> {
            if (conf.contains(k)) {
                return new Some((Object)conf.getConfString(k));
            }
            return None$.MODULE$;
        }, Seq$.MODULE$.canBuildFrom());
        pairs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            HoodieSparkSqlTestBase.$anonfun$withSQLConf$2(conf, x0$1);
            return BoxedUnit.UNIT;
        });
        try {
            object = f.apply();
        }
        finally {
            ((IterableLike)((IterableLike)pairs.unzip((Function1)Predef$.MODULE$.$conforms())._1()).zip((GenIterable)currentValues, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                HoodieSparkSqlTestBase.$anonfun$withSQLConf$3(conf, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        return (T)object;
    }

    public void withTable(String tableName, Function1<String, BoxedUnit> f) {
        try {
            f.apply((Object)tableName);
        }
        finally {
            this.spark().sql(new StringBuilder(27).append("drop table if exists ").append(tableName).append(" purge").toString());
        }
    }

    public void withSparkSqlSessionConfig(Seq<Tuple2<String, String>> configNameValues, Function0<BoxedUnit> f) {
        this.withSparkSqlSessionConfigWithCondition((Seq<Tuple2<Tuple2<String, String>, Object>>)((Seq)configNameValues.map((Function1 & Serializable & scala.Serializable)e -> new Tuple2(e, (Object)BoxesRunTime.boxToBoolean((boolean)true)), Seq$.MODULE$.canBuildFrom())), f);
    }

    public void withSparkSqlSessionConfigWithCondition(Seq<Tuple2<Tuple2<String, String>, Object>> configNameValues, Function0<BoxedUnit> f) {
        try {
            configNameValues.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    boolean condition = tuple2._2$mcZ$sp();
                    if (tuple22 != null) {
                        String configName = (String)tuple22._1();
                        String configValue = (String)tuple22._2();
                        if (condition) {
                            return this.spark().sql(new StringBuilder(5).append("set ").append(configName).append("=").append(configValue).toString());
                        }
                        return BoxedUnit.UNIT;
                    }
                }
                throw new MatchError((Object)tuple2);
            });
            f.apply$mcV$sp();
        }
        finally {
            configNameValues.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2;
                Tuple2 tuple22 = x0$2;
                if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                    String configName = (String)tuple2._1();
                    return this.spark().sql(new StringBuilder(6).append("reset ").append(configName).toString());
                }
                throw new MatchError((Object)tuple22);
            });
        }
    }

    public void withRecordType(Seq<HoodieRecord.HoodieRecordType> recordTypes, Map<HoodieRecord.HoodieRecordType, Map<String, String>> recordConfig, Function0<BoxedUnit> f) {
        recordTypes.foreach((Function1 & Serializable & scala.Serializable)recordType -> {
            HoodieSparkSqlTestBase.$anonfun$withRecordType$1(this, recordConfig, f, recordType);
            return BoxedUnit.UNIT;
        });
    }

    public Seq<HoodieRecord.HoodieRecordType> withRecordType$default$1() {
        return (Seq)new .colon.colon((Object)HoodieRecord.HoodieRecordType.AVRO, (List)new .colon.colon((Object)HoodieRecord.HoodieRecordType.SPARK, (List)Nil$.MODULE$));
    }

    public Map<HoodieRecord.HoodieRecordType, Map<String, String>> withRecordType$default$2() {
        return Predef$.MODULE$.Map().empty();
    }

    public static final /* synthetic */ void $anonfun$test$2(SessionCatalog catalog$1, String db) {
        catalog$1.listTables(db).foreach((Function1 & Serializable & scala.Serializable)table -> {
            catalog$1.dropTable(table, true, true);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$validateTableSchema$1(StructField e) {
        return !HoodieRecord.HOODIE_META_COLUMNS_WITH_OPERATION.contains(e.name());
    }

    public static final /* synthetic */ void $anonfun$withSQLConf$2(SQLConf conf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            conf$1.setConfString(k, v);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$withSQLConf$3(SQLConf conf$1, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                String value = (String)some.value();
                conf$1.setConfString(key, value);
                return;
            }
        }
        if (tuple2 != null) {
            String key = (String)tuple2._1();
            Option option = (Option)tuple2._2();
            if (None$.MODULE$.equals(option)) {
                conf$1.unsetConf(key);
                return;
            }
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$withRecordType$1(HoodieSparkSqlTestBase $this, Map recordConfig$1, Function0 f$1, HoodieRecord.HoodieRecordType recordType) {
        Tuple2 tuple2;
        HoodieRecord.HoodieRecordType hoodieRecordType = recordType;
        Tuple2 tuple22 = tuple2 = HoodieRecord.HoodieRecordType.SPARK.equals(hoodieRecordType) ? new Tuple2((Object)DefaultSparkRecordMerger.class.getName(), (Object)"parquet") : new Tuple2((Object)HoodieAvroRecordMerger.class.getName(), (Object)"avro");
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String merger = (String)tuple2._1();
        String format = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)merger, (Object)format);
        String merger2 = (String)tuple23._1();
        String format2 = (String)tuple23._2();
        Map config = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.RECORD_MERGE_IMPL_CLASSES.key()), (Object)merger2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key()), (Object)format2)}))).$plus$plus((GenTraversableOnce)recordConfig$1.getOrElse((Object)recordType, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty()));
        $this.withSQLConf((Seq<Tuple2<String, String>>)config.toList(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            f$1.apply$mcV$sp();
            HoodieInMemoryHashIndex.clear();
        });
    }

    public HoodieSparkSqlTestBase() {
        BeforeAndAfterAll.$init$((BeforeAndAfterAll)this);
        org.apache.log4j.Logger.getRootLogger().setLevel(Level.WARN);
        this.LOG = LoggerFactory.getLogger((Class)this.getClass());
        System.setProperty("spark.testing", "true");
        DateTimeZone.setDefault((DateTimeZone)DateTimeZone.UTC);
        TimeZone.setDefault(DateTimeUtils$.MODULE$.getTimeZone("UTC"));
        this.tableId = new AtomicInteger(0);
        this.extraConf = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }
}

