/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.common;

import java.io.Serializable;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.testutils.SparkClientFunctionalTestHarness;
import org.apache.spark.sql.hudi.HoodieOptionConfig$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.scalactic.source.Position;
import org.scalatest.package$;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q2Aa\u0002\u0005\u0001+!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!)A\u0007\u0001C\u0001E!)a\u0007\u0001C\u0001E!)\u0001\b\u0001C\u0001E!)!\b\u0001C\u0001E\t1B+Z:u\u0011>|G-[3PaRLwN\\\"p]\u001aLwM\u0003\u0002\n\u0015\u000511m\\7n_:T!a\u0003\u0007\u0002\t!,H-\u001b\u0006\u0003\u001b9\t1a]9m\u0015\ty\u0001#A\u0003ta\u0006\u00148N\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"aF\u000e\u000e\u0003aQ!!\u0007\u000e\u0002\u0013Q,7\u000f^;uS2\u001c(BA\u0006\u0011\u0013\ta\u0002D\u0001\u0011Ta\u0006\u00148n\u00117jK:$h)\u001e8di&|g.\u00197UKN$\b*\u0019:oKN\u001c\u0018A\u0002\u001fj]&$h\bF\u0001 !\t\u0001\u0003!D\u0001\t\u0003e!Xm\u001d;XSRDG)\u001a4bk2$8+\u001d7PaRLwN\\:\u0015\u0003\r\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012A!\u00168ji\"\u0012!A\u000b\t\u0003WIj\u0011\u0001\f\u0006\u0003[9\n1!\u00199j\u0015\ty\u0003'A\u0004kkBLG/\u001a:\u000b\u0005E\u0012\u0012!\u00026v]&$\u0018BA\u001a-\u0005\u0011!Vm\u001d;\u0002CQ,7\u000f^'baBLgnZ*rY>\u0003H/[8o)>$\u0016M\u00197f\u0007>tg-[4)\u0005\rQ\u0013a\u0006;fgR$U\r\\3uK\"{w\u000eZ5f\u001fB$\u0018n\u001c8tQ\t!!&A\u000buKN$X\t\u001f;sC\u000e$8+\u001d7PaRLwN\\:)\u0005\u0015Q\u0013!\u0005;fgR4\u0016\r\\5eCR,G+\u00192mK\"\u0012aA\u000b")
public class TestHoodieOptionConfig
extends SparkClientFunctionalTestHarness {
    @Test
    public void testWithDefaultSqlOptions() {
        Map ops1 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"primaryKey"), (Object)"id")}));
        Map with1 = HoodieOptionConfig$.MODULE$.withDefaultSqlOptions(ops1);
        Assertions.assertEquals((int)2, (int)with1.size());
        Assertions.assertEquals((Object)"id", (Object)with1.apply((Object)"primaryKey"));
        Assertions.assertEquals((Object)"cow", (Object)with1.apply((Object)"type"));
        Map ops2 = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"primaryKey"), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preCombineField"), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"mor"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"payloadClass"), (Object)OverwriteWithLatestAvroPayload.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"recordMergeStrategyId"), (Object)"eeb8d96f-b1e4-49fd-bbf8-28ac514178e5")}));
        Map with2 = HoodieOptionConfig$.MODULE$.withDefaultSqlOptions(ops2);
        Map map = ops2;
        Map map2 = with2;
        Assertions.assertTrue((!(map != null ? !map.equals(map2) : map2 != null) ? 1 : 0) != 0);
    }

    @Test
    public void testMappingSqlOptionToTableConfig() {
        Map sqlOptions = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"primaryKey"), (Object)"id,addr"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preCombineField"), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"mor"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.index.type"), (Object)"INMEMORY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline"), (Object)"true")}));
        Map tableConfigs = HoodieOptionConfig$.MODULE$.mapSqlOptionsToTableConfigs(sqlOptions);
        Assertions.assertTrue((tableConfigs.size() == 5 ? 1 : 0) != 0);
        Object object = tableConfigs.apply((Object)HoodieTableConfig.RECORDKEY_FIELDS.key());
        String string = "id,addr";
        Assertions.assertTrue((!(object != null ? !object.equals(string) : string != null) ? 1 : 0) != 0);
        Object object2 = tableConfigs.apply((Object)HoodieTableConfig.PRECOMBINE_FIELD.key());
        String string2 = "timestamp";
        Assertions.assertTrue((!(object2 != null ? !object2.equals(string2) : string2 != null) ? 1 : 0) != 0);
        Object object3 = tableConfigs.apply((Object)HoodieTableConfig.TYPE.key());
        String string3 = "MERGE_ON_READ";
        Assertions.assertTrue((!(object3 != null ? !object3.equals(string3) : string3 != null) ? 1 : 0) != 0);
        Object object4 = tableConfigs.apply((Object)"hoodie.index.type");
        String string4 = "INMEMORY";
        Assertions.assertTrue((!(object4 != null ? !object4.equals(string4) : string4 != null) ? 1 : 0) != 0);
        Object object5 = tableConfigs.apply((Object)"hoodie.compact.inline");
        String string5 = "true";
        Assertions.assertTrue((!(object5 != null ? !object5.equals(string5) : string5 != null) ? 1 : 0) != 0);
    }

    @Test
    public void testDeleteHoodieOptions() {
        Map sqlOptions = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"primaryKey"), (Object)"id,addr"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preCombineField"), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"mor"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.index.type"), (Object)"INMEMORY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key123"), (Object)"value456")}));
        Map tableConfigs = HoodieOptionConfig$.MODULE$.deleteHoodieOptions(sqlOptions);
        Assertions.assertTrue((tableConfigs.size() == 1 ? 1 : 0) != 0);
        Object object = tableConfigs.apply((Object)"key123");
        String string = "value456";
        Assertions.assertTrue((!(object != null ? !object.equals(string) : string != null) ? 1 : 0) != 0);
    }

    @Test
    public void testExtractSqlOptions() {
        Map sqlOptions = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"primaryKey"), (Object)"id,addr"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preCombineField"), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"mor"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.index.type"), (Object)"INMEMORY"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.compact.inline"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key123"), (Object)"value456")}));
        Map tableConfigs = HoodieOptionConfig$.MODULE$.extractSqlOptions(sqlOptions);
        Assertions.assertTrue((tableConfigs.size() == 3 ? 1 : 0) != 0);
        Set set = tableConfigs.keySet();
        GenTraversable genTraversable = Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"primaryKey", "preCombineField", "type"}));
        Assertions.assertTrue((!(set != null ? !set.equals(genTraversable) : genTraversable != null) ? 1 : 0) != 0);
    }

    @Test
    public void testValidateTable() {
        Map baseSqlOptions = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.hive_style_partitioning"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.partitionpath.urlencode"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.table.keygenerator.class"), (Object)"org.apache.hudi.keygen.ComplexKeyGenerator")}));
        StructType schema = StructType$.MODULE$.apply((Seq)new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("timestamp", (DataType)TimestampType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("dt", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
        Map sqlOptions2 = baseSqlOptions.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"primaryKey"), (Object)"xxx"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"mor")})));
        IllegalArgumentException e2 = (IllegalArgumentException)package$.MODULE$.Matchers().intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> HoodieOptionConfig$.MODULE$.validateTable(this.spark(), schema, sqlOptions2), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestHoodieOptionConfig.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 116));
        Assertions.assertTrue((boolean)e2.getMessage().contains("Can't find primaryKey"));
        Map sqlOptions3 = baseSqlOptions.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"primaryKey"), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preCombineField"), (Object)"ts"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"mor")})));
        IllegalArgumentException e3 = (IllegalArgumentException)package$.MODULE$.Matchers().intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> HoodieOptionConfig$.MODULE$.validateTable(this.spark(), schema, sqlOptions3), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestHoodieOptionConfig.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 127));
        Assertions.assertTrue((boolean)e3.getMessage().contains("Can't find preCombineKey"));
        Map sqlOptions4 = baseSqlOptions.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"primaryKey"), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preCombineField"), (Object)"timestamp")})));
        IllegalArgumentException e4 = (IllegalArgumentException)package$.MODULE$.Matchers().intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> HoodieOptionConfig$.MODULE$.validateTable(this.spark(), schema, sqlOptions4), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestHoodieOptionConfig.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 137));
        Assertions.assertTrue((boolean)e4.getMessage().contains("No `type` is specified."));
        Map sqlOptions5 = baseSqlOptions.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"primaryKey"), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preCombineField"), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"abc")})));
        IllegalArgumentException e5 = (IllegalArgumentException)package$.MODULE$.Matchers().intercept((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> HoodieOptionConfig$.MODULE$.validateTable(this.spark(), schema, sqlOptions5), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("TestHoodieOptionConfig.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 148));
        Assertions.assertTrue((boolean)e5.getMessage().contains("'type' must be 'cow' or 'mor'"));
        Map sqlOptions6 = baseSqlOptions.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"primaryKey"), (Object)"id"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"preCombineField"), (Object)"timestamp"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"type"), (Object)"cow")})));
        HoodieOptionConfig$.MODULE$.validateTable(this.spark(), schema, sqlOptions6);
    }
}

