/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.ddl;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.keygen.ComplexKeyGenerator;
import org.apache.hudi.keygen.SimpleKeyGenerator;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase$;
import org.apache.spark.sql.hudi.ddl.TestAlterTableDropPartition$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000193AAB\u0004\u0001)!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003BB\u001c\u0001A\u0003%\u0011\u0005C\u00039\u0001\u0011%\u0011\bC\u0004C\u0001E\u0005I\u0011B\"\u00037Q+7\u000f^!mi\u0016\u0014H+\u00192mK\u0012\u0013x\u000e\u001d)beRLG/[8o\u0015\tA\u0011\"A\u0002eI2T!AC\u0006\u0002\t!,H-\u001b\u0006\u0003\u00195\t1a]9m\u0015\tqq\"A\u0003ta\u0006\u00148N\u0003\u0002\u0011#\u00051\u0011\r]1dQ\u0016T\u0011AE\u0001\u0004_J<7\u0001A\n\u0003\u0001U\u0001\"AF\r\u000e\u0003]Q!\u0001G\u0005\u0002\r\r|W.\\8o\u0013\tQrC\u0001\fI_>$\u0017.Z*qCJ\\7+\u001d7UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u001f\u00015\tq!\u0001\u0007tG\",W.\u0019$jK2$7/F\u0001\"!\r\u0011Cf\f\b\u0003G%r!\u0001J\u0014\u000e\u0003\u0015R!AJ\n\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0013!B:dC2\f\u0017B\u0001\u0016,\u0003\u001d\u0001\u0018mY6bO\u0016T\u0011\u0001K\u0005\u0003[9\u00121aU3r\u0015\tQ3\u0006\u0005\u00021i9\u0011\u0011G\r\t\u0003I-J!aM\u0016\u0002\rA\u0013X\rZ3g\u0013\t)dG\u0001\u0004TiJLgn\u001a\u0006\u0003g-\nQb]2iK6\fg)[3mIN\u0004\u0013\u0001J3ogV\u0014X\rT1ti\u000e{W.\\5u\u0013:\u001cG.\u001e3fgB\u0013x\u000e]3s'\u000eDW-\\1\u0015\u0007ir\u0004\t\u0005\u0002<y5\t1&\u0003\u0002>W\t!QK\\5u\u0011\u0015yD\u00011\u00010\u0003\u0011\u0001\u0018\r\u001e5\t\u000f\u0005#\u0001\u0013!a\u0001C\u0005qQ\r\u001f9fGR,GmU2iK6\f\u0017AL3ogV\u0014X\rT1ti\u000e{W.\\5u\u0013:\u001cG.\u001e3fgB\u0013x\u000e]3s'\u000eDW-\\1%I\u00164\u0017-\u001e7uII*\u0012\u0001\u0012\u0016\u0003C\u0015[\u0013A\u0012\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000b\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005-[\u0013AC1o]>$\u0018\r^5p]&\u0011Q\n\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007")
public class TestAlterTableDropPartition
extends HoodieSparkSqlTestBase {
    private final Seq<String> schemaFields = (Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"ts", (List)new .colon.colon((Object)"dt", (List)Nil$.MODULE$))));

    private Seq<String> schemaFields() {
        return this.schemaFields;
    }

    private void ensureLastCommitIncludesProperSchema(String path, Seq<String> expectedSchema) {
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)this.spark(), (String)path);
        HoodieInstant lastInstant = (HoodieInstant)metaClient.getActiveTimeline().getCompletedReplaceTimeline().lastInstant().get();
        HoodieCommitMetadata commitMetadata = metaClient.getActiveTimeline().readCommitMetadata(lastInstant);
        String schemaStr = commitMetadata.getMetadata("schema");
        Schema schema = new Schema.Parser().parse(schemaStr);
        Buffer fields = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(schema.getFields()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.name(), Buffer$.MODULE$.canBuildFrom());
        Seq<String> $org_scalatest_assert_macro_left = expectedSchema;
        Buffer $org_scalatest_assert_macro_right = fields;
        Seq<String> seq = $org_scalatest_assert_macro_left;
        Buffer buffer = $org_scalatest_assert_macro_right;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool($org_scalatest_assert_macro_left, "==", (Object)$org_scalatest_assert_macro_right, !(seq != null ? !seq.equals((Object)buffer) : buffer != null), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(56).append("Commit metadata should include no meta fields, received ").append(fields).toString(), Prettifier$.MODULE$.default(), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
    }

    private Seq<String> ensureLastCommitIncludesProperSchema$default$2() {
        return this.schemaFields();
    }

    public static final /* synthetic */ void $anonfun$new$6(IntRef totalDeletedFiles$1, Object entry) {
        totalDeletedFiles$1.elem += ((HoodieCleanPartitionMetadata)entry).getSuccessDeleteFiles().size();
    }

    public static final /* synthetic */ void $anonfun$new$5(TestAlterTableDropPartition $this, boolean urlencode$1, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestAlterTableDropPartition.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_ddl_TestAlterTableDropPartition$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_sql_hudi_ddl_TestAlterTableDropPartition$$typecreator6$1(TestAlterTableDropPartition $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"z3", (Object)"v1", (Object)"2021/10/01"), (List)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)2), (Object)"l4", (Object)"v1", (Object)"2021/10/02"), (List)Nil$.MODULE$)), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_ddl_TestAlterTableDropPartition$$typecreator6$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "ts", "dt"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "dt").option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), urlencode$1).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "dt").option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), urlencode$1).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), SimpleKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Append).save(tablePath);
        $this.spark().sql(new StringBuilder(45).append("alter table ").append(tableName).append(" drop partition (dt='2021/10/01')").toString());
        $this.ensureLastCommitIncludesProperSchema(tablePath, $this.ensureLastCommitIncludesProperSchema$default$2());
        $this.spark().sql(new StringBuilder(5).append("set ").append(HoodieCleanConfig.CLEANER_POLICY.key()).append("=").append(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS.name()).toString());
        $this.spark().sql(new StringBuilder(48).append("call run_clean(table => '").append(tableName).append("', retain_commits => 1)").toString()).collect();
        $this.ensureLastCommitIncludesProperSchema(tablePath, $this.ensureLastCommitIncludesProperSchema$default$2());
        HoodieCleanMetadata cleanMetadata = HoodieSparkSqlTestBase$.MODULE$.getLastCleanMetadata($this.spark(), tablePath);
        Object[] cleanPartitionMeta = new ArrayList(cleanMetadata.getPartitionMetadata().values()).toArray();
        IntRef totalDeletedFiles = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(cleanPartitionMeta)).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            TestAlterTableDropPartition.$anonfun$new$6(totalDeletedFiles, entry);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((totalDeletedFiles.elem > 0 ? 1 : 0) != 0);
        String partitionPath = urlencode$1 ? PartitionPathEncodeUtils.escapePathName((String)"2021/10/01") : "2021/10/01";
        $this.checkAnswer(new StringBuilder(15).append("select dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2021/10/02", (List)Nil$.MODULE$)}));
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)$this.existsPath(new StringBuilder(2).append(tmp.getCanonicalPath()).append("/").append(tableName).append("/").append(partitionPath).toString())), Prettifier$.MODULE$.default(), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 177));
        if (urlencode$1) {
            $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)PartitionPathEncodeUtils.escapePathName((String)"2021/10/02"), (List)Nil$.MODULE$)}));
            return;
        }
        $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2021/10/02", (List)Nil$.MODULE$)}));
    }

    public static final /* synthetic */ void $anonfun$new$9(TestAlterTableDropPartition $this, boolean urlencode$2, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestAlterTableDropPartition.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_ddl_TestAlterTableDropPartition$$typecreator16$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple4"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))));
            }

            public Org_apache_spark_sql_hudi_ddl_TestAlterTableDropPartition$$typecreator16$1(TestAlterTableDropPartition $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple4((Object)BoxesRunTime.boxToInteger((int)1), (Object)"z3", (Object)"v1", (Object)"2021/10/01"), (List)Nil$.MODULE$), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_ddl_TestAlterTableDropPartition$$typecreator16$1(null)))).toDF((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"id", "name", "ts", "dt"}));
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "dt").option(DataSourceWriteOptions$.MODULE$.URL_ENCODE_PARTITIONING().key(), urlencode$2).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(254).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  hoodie.clean.commits.retained= '1'\n             | )\n             |").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(45).append("alter table ").append(tableName).append(" drop partition (dt='2021/10/01')").toString());
        $this.ensureLastCommitIncludesProperSchema(tablePath, $this.ensureLastCommitIncludesProperSchema$default$2());
        $this.spark().sql(new StringBuilder(49).append("insert into ").append(tableName).append(" values (2, \"l4\", \"v1\", \"2021/10/02\")").toString());
        $this.ensureLastCommitIncludesProperSchema(tablePath, $this.ensureLastCommitIncludesProperSchema$default$2());
        String partitionPath = urlencode$2 ? PartitionPathEncodeUtils.escapePathName((String)"2021/10/01") : "2021/10/01";
        $this.checkAnswer(new StringBuilder(15).append("select dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2021/10/02", (List)Nil$.MODULE$)}));
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)$this.existsPath(new StringBuilder(2).append(tmp.getCanonicalPath()).append("/").append(tableName).append("/").append(partitionPath).toString())), Prettifier$.MODULE$.default(), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 235));
        if (urlencode$2) {
            $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)PartitionPathEncodeUtils.escapePathName((String)"2021/10/02"), (List)Nil$.MODULE$)}));
            return;
        }
        $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2021/10/02", (List)Nil$.MODULE$)}));
    }

    public static final /* synthetic */ void $anonfun$new$14(IntRef totalDeletedFiles$2, Object entry) {
        totalDeletedFiles$2.elem += ((HoodieCleanPartitionMetadata)entry).getSuccessDeleteFiles().size();
    }

    public static final /* synthetic */ void $anonfun$new$13(TestAlterTableDropPartition $this, boolean hiveStyle$1, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        Seq schemaFields = (Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"ts", (List)new .colon.colon((Object)"year", (List)new .colon.colon((Object)"month", (List)new .colon.colon((Object)"day", (List)Nil$.MODULE$))))));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestAlterTableDropPartition.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_ddl_TestAlterTableDropPartition$$typecreator26$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_spark_sql_hudi_ddl_TestAlterTableDropPartition$$typecreator26$1(TestAlterTableDropPartition $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)1), (Object)"z3", (Object)"v1", (Object)"2021", (Object)"10", (Object)"01"), (List)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)2), (Object)"l4", (Object)"v1", (Object)"2021", (Object)"10", (Object)"02"), (List)Nil$.MODULE$)), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_ddl_TestAlterTableDropPartition$$typecreator26$1(null)))).toDF(schemaFields);
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "year,month,day").option(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), hiveStyle$1).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             |").toString())).stripMargin());
        $this.checkExceptionContain(new StringBuilder(53).append("alter table ").append(tableName).append(" drop partition (year='2021', month='10')").toString(), "All partition columns need to be specified for Hoodie's partition");
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "year,month,day").option(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), hiveStyle$1).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), ComplexKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Append).save(tablePath);
        $this.spark().sql(new StringBuilder(63).append("alter table ").append(tableName).append(" drop partition (year='2021', month='10', day='01')").toString());
        $this.ensureLastCommitIncludesProperSchema(tablePath, (Seq<String>)schemaFields);
        $this.spark().sql(new StringBuilder(5).append("set ").append(HoodieCleanConfig.CLEANER_POLICY.key()).append("=").append(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS.name()).toString());
        $this.spark().sql(new StringBuilder(48).append("call run_clean(table => '").append(tableName).append("', retain_commits => 1)").toString()).collect();
        $this.ensureLastCommitIncludesProperSchema(tablePath, (Seq<String>)schemaFields);
        HoodieCleanMetadata cleanMetadata = HoodieSparkSqlTestBase$.MODULE$.getLastCleanMetadata($this.spark(), tablePath);
        Object[] cleanPartitionMeta = new ArrayList(cleanMetadata.getPartitionMetadata().values()).toArray();
        IntRef totalDeletedFiles = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(cleanPartitionMeta)).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            TestAlterTableDropPartition.$anonfun$new$14(totalDeletedFiles, entry);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((totalDeletedFiles.elem > 0 ? 1 : 0) != 0);
        $this.checkAnswer(new StringBuilder(43).append("select id, name, ts, year, month, day from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "l4", "v1", "2021", "10", "02"}))}));
        if (hiveStyle$1) {
            $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"year=2021/month=10/day=02", (List)Nil$.MODULE$)}));
            return;
        }
        $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2021/10/02", (List)Nil$.MODULE$)}));
    }

    public static final /* synthetic */ void $anonfun$new$18(IntRef totalDeletedFiles$3, Object entry) {
        totalDeletedFiles$3.elem += ((HoodieCleanPartitionMetadata)entry).getSuccessDeleteFiles().size();
    }

    public static final /* synthetic */ void $anonfun$new$17(TestAlterTableDropPartition $this, boolean hiveStyle$2, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        Seq schemaFields = (Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"ts", (List)new .colon.colon((Object)"year", (List)new .colon.colon((Object)"month", (List)new .colon.colon((Object)"day", (List)Nil$.MODULE$))))));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(TestAlterTableDropPartition.class.getClassLoader());
        public final class Org_apache_spark_sql_hudi_ddl_TestAlterTableDropPartition$$typecreator36$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple6"), (List)new .colon.colon((Object)$m.staticClass("scala.Int").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)new .colon.colon((Object)$m.staticClass("java.lang.String").asType().toTypeConstructor(), (List)Nil$.MODULE$)))))));
            }

            public Org_apache_spark_sql_hudi_ddl_TestAlterTableDropPartition$$typecreator36$1(TestAlterTableDropPartition $outer) {
            }
        }
        Dataset df = $this.spark().implicits().localSeqToDatasetHolder((Seq)new .colon.colon((Object)new Tuple6((Object)BoxesRunTime.boxToInteger((int)1), (Object)"z3", (Object)"v1", (Object)"2021", (Object)"10", (Object)"01"), (List)Nil$.MODULE$), $this.spark().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_hudi_ddl_TestAlterTableDropPartition$$typecreator36$1(null)))).toDF(schemaFields);
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "year,month,day").option(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), hiveStyle$2).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Overwrite).save(tablePath);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(254).append("\n             |create table ").append(tableName).append(" using hudi\n             |location '").append(tablePath).append("'\n             | tblproperties (\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts',\n             |  hoodie.clean.commits.retained= '1'\n             | )\n             |").toString())).stripMargin());
        df.write().format("hudi").option(HoodieWriteConfig.TBL_NAME.key(), tableName).option(DataSourceWriteOptions$.MODULE$.TABLE_TYPE().key(), DataSourceWriteOptions$.MODULE$.COW_TABLE_TYPE_OPT_VAL()).option(DataSourceWriteOptions$.MODULE$.RECORDKEY_FIELD().key(), "id").option(DataSourceWriteOptions$.MODULE$.PRECOMBINE_FIELD().key(), "ts").option(DataSourceWriteOptions$.MODULE$.PARTITIONPATH_FIELD().key(), "year,month,day").option(DataSourceWriteOptions$.MODULE$.HIVE_STYLE_PARTITIONING().key(), hiveStyle$2).option(DataSourceWriteOptions$.MODULE$.KEYGENERATOR_CLASS_NAME().key(), ComplexKeyGenerator.class.getName()).option(HoodieWriteConfig.INSERT_PARALLELISM_VALUE.key(), "1").option(HoodieWriteConfig.UPSERT_PARALLELISM_VALUE.key(), "1").mode(SaveMode.Append).save(tablePath);
        $this.spark().sql(new StringBuilder(63).append("alter table ").append(tableName).append(" drop partition (year='2021', month='10', day='01')").toString());
        $this.ensureLastCommitIncludesProperSchema(tablePath, (Seq<String>)schemaFields);
        $this.spark().sql(new StringBuilder(55).append("insert into ").append(tableName).append(" values (2, \"l4\", \"v1\", \"2021\", \"10\", \"02\")").toString());
        $this.spark().sql(new StringBuilder(48).append("call run_clean(table => '").append(tableName).append("', retain_commits => 1)").toString()).collect();
        $this.ensureLastCommitIncludesProperSchema(tablePath, (Seq<String>)schemaFields);
        HoodieCleanMetadata cleanMetadata = HoodieSparkSqlTestBase$.MODULE$.getLastCleanMetadata($this.spark(), tablePath);
        Object[] cleanPartitionMeta = new ArrayList(cleanMetadata.getPartitionMetadata().values()).toArray();
        IntRef totalDeletedFiles = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(cleanPartitionMeta)).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            TestAlterTableDropPartition.$anonfun$new$18(totalDeletedFiles, entry);
            return BoxedUnit.UNIT;
        });
        Assertions.assertTrue((totalDeletedFiles.elem > 0 ? 1 : 0) != 0);
        $this.spark().sql(new StringBuilder(55).append("insert into ").append(tableName).append(" values (2, \"l4\", \"v1\", \"2021\", \"10\", \"02\")").toString());
        $this.checkAnswer(new StringBuilder(43).append("select id, name, ts, year, month, day from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "l4", "v1", "2021", "10", "02"}))}));
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)$this.existsPath(new StringBuilder(27).append(tmp.getCanonicalPath()).append("/").append(tableName).append("/year=2021/month=10/day=01").toString())), Prettifier$.MODULE$.default(), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 448));
        if (hiveStyle$2) {
            $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"year=2021/month=10/day=02", (List)Nil$.MODULE$)}));
            return;
        }
        $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2021/10/02", (List)Nil$.MODULE$)}));
    }

    public static final /* synthetic */ void $anonfun$new$21(TestAlterTableDropPartition $this, File tmp$1, String tableType) {
        String tableName = $this.generateTableName();
        Seq schemaFields = (Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"ts", (List)new .colon.colon((Object)"dt", (List)Nil$.MODULE$)))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(411).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  dt string\n             |) using hudi\n             | location '").append(tmp$1.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by (dt)\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(98).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000, '01'), ").append("(2, 'a2', 10, 1000, '02'), (3, 'a3', 10, 1000, '03')").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "02"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "03"}))}));
        $this.spark().sql(new StringBuilder(39).append("alter table ").append(tableName).append(" drop partition (dt = '01')").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "02"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "03"}))}));
        $this.ensureLastCommitIncludesProperSchema(new StringBuilder(1).append(tmp$1.getCanonicalPath()).append("/").append(tableName).toString(), (Seq<String>)schemaFields);
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)new StringBuilder(1).append(tmp$1.getCanonicalPath()).append("/").append(tableName).toString());
        Option lastInstant = metaClient.getActiveTimeline().getCommitsTimeline().lastInstant();
        HoodieCommitMetadata commitMetadata = metaClient.getActiveTimeline().readCommitMetadata((HoodieInstant)lastInstant.get());
        String schemaStr = (String)commitMetadata.getExtraMetadata().get("schema");
        Assertions.assertFalse((boolean)StringUtils.isNullOrEmpty((String)schemaStr));
        $this.spark().sql(new StringBuilder(28).append("delete from ").append(tableName).append(" where dt = '02'").toString());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), "03"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$20(TestAlterTableDropPartition $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestAlterTableDropPartition.$anonfun$new$21($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$24(TestAlterTableDropPartition $this, String tableType$1, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(2).append(tmp.getCanonicalPath()).append("t/").append(tableName).toString();
        Seq schemaFields = (Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"ts", (List)Nil$.MODULE$))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(383).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = '").append(tableType$1).append("',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by(ts)\n             | location '").append(basePath).append("'\n             | ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
        SparkRDDWriteClient client = HoodieCLIUtils$.MODULE$.createHoodieWriteClient($this.spark(), basePath, Predef$.MODULE$.Map().empty(), Option$.MODULE$.apply((Object)tableName));
        String firstScheduleInstant = client.createNewInstantTime();
        client.scheduleClusteringAtInstant(firstScheduleInstant, Option.empty());
        $this.checkAnswer(new StringBuilder(24).append("call show_clustering('").append(tableName).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)3), HoodieInstant.State.REQUESTED.name(), "*"}))}));
        String partition = "ts=1002";
        String errMsg = new StringBuilder(149).append("Failed to drop partitions. Please ensure that there are no pending table service actions (clustering/compaction) for the partitions to be deleted: [").append(partition).append("]").toString();
        $this.checkExceptionContain(new StringBuilder(29).append("ALTER TABLE ").append(tableName).append(" DROP PARTITION(").append(partition).append(")").toString(), errMsg);
    }

    public static final /* synthetic */ void $anonfun$new$26(TestAlterTableDropPartition $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(2).append(tmp.getCanonicalPath()).append("t/").append(tableName).toString();
        Seq schemaFields = (Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"ts", (List)Nil$.MODULE$))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(404).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | options (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts',\n           |  hoodie.index.type = 'INMEMORY'\n           | )\n           | partitioned by(ts)\n           | location '").append(basePath).append("'\n           | ").toString())).stripMargin());
        $this.spark().sql("set hoodie.compact.inline=false");
        $this.spark().sql("set hoodie.compact.schedule.inline=false");
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1003)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1004)").toString());
        SparkRDDWriteClient client = HoodieCLIUtils$.MODULE$.createHoodieWriteClient($this.spark(), basePath, Predef$.MODULE$.Map().empty(), Option$.MODULE$.apply((Object)tableName));
        String firstScheduleInstant = client.createNewInstantTime();
        Assertions.assertTrue((boolean)client.scheduleCompactionAtInstant(firstScheduleInstant, Option.empty()));
        $this.checkAnswer(new StringBuilder(24).append("call show_compaction('").append(tableName).append("')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{firstScheduleInstant, BoxesRunTime.boxToInteger((int)5), HoodieInstant.State.REQUESTED.name()}))}));
        String partition = "ts=1002";
        String errMsg = new StringBuilder(149).append("Failed to drop partitions. Please ensure that there are no pending table service actions (clustering/compaction) for the partitions to be deleted: [").append(partition).append("]").toString();
        $this.checkExceptionContain(new StringBuilder(29).append("ALTER TABLE ").append(tableName).append(" DROP PARTITION(").append(partition).append(")").toString(), errMsg);
    }

    public static final /* synthetic */ void $anonfun$new$28(TestAlterTableDropPartition $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(2).append(tmp.getCanonicalPath()).append("t/").append(tableName).toString();
        Seq schemaFields = (Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"ts", (List)Nil$.MODULE$))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(404).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | options (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts',\n           |  hoodie.index.type = 'INMEMORY'\n           | )\n           | partitioned by(ts)\n           | location '").append(basePath).append("'\n           | ").toString())).stripMargin());
        $this.spark().sql("set hoodie.compact.inline=false");
        $this.spark().sql("set hoodie.compact.schedule.inline=false");
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1000)").toString());
        SparkRDDWriteClient client = HoodieCLIUtils$.MODULE$.createHoodieWriteClient($this.spark(), basePath, Predef$.MODULE$.Map().empty(), Option$.MODULE$.apply((Object)tableName));
        String firstScheduleInstant = client.createNewInstantTime();
        Assertions.assertTrue((boolean)client.scheduleLogCompactionAtInstant(firstScheduleInstant, Option.empty()));
        String partition = "ts=1000";
        String errMsg = new StringBuilder(149).append("Failed to drop partitions. Please ensure that there are no pending table service actions (clustering/compaction) for the partitions to be deleted: [").append(partition).append("]").toString();
        $this.checkExceptionContain(new StringBuilder(29).append("ALTER TABLE ").append(tableName).append(" DROP PARTITION(").append(partition).append(")").toString(), errMsg);
    }

    public static final /* synthetic */ void $anonfun$new$31(TestAlterTableDropPartition $this, File tmp$2, String tableType) {
        String tableName = $this.generateTableName();
        Seq schemaFields = (Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"ts", (List)new .colon.colon((Object)"partition_date_col", (List)Nil$.MODULE$)))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(429).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  partition_date_col string\n             |) using hudi\n             | location '").append(tmp$2.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  primaryKey ='id',\n             |  type = '").append(tableType).append("',\n             |  preCombineField = 'ts'\n             | ) partitioned by (partition_date_col)\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(123).append("insert into ").append(tableName).append(" values ").append("(1, 'a1', 10, 1000, '2023-08-01'), (2, 'a2', 10, 1000, '2023-08-02'), (3, 'a3', 10, 1000, '2023-09-01')").toString());
        $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"partition_date_col=2023-08-01", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"partition_date_col=2023-08-02", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"partition_date_col=2023-09-01", (List)Nil$.MODULE$)}));
        $this.spark().sql(new StringBuilder(59).append("alter table ").append(tableName).append(" drop partition(partition_date_col='2023-08-*')").toString());
        $this.ensureLastCommitIncludesProperSchema(new StringBuilder(1).append(tmp$2.getCanonicalPath()).append("/").append(tableName).toString(), (Seq<String>)schemaFields);
        $this.checkAnswer(new StringBuilder(40).append("select distinct partition_date_col from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"2023-09-01", (List)Nil$.MODULE$)}));
    }

    public static final /* synthetic */ void $anonfun$new$30(TestAlterTableDropPartition $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestAlterTableDropPartition.$anonfun$new$31($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public TestAlterTableDropPartition() {
        this.test("Drop non-partitioned table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(272).append("\n         | create table ").append(tableName).append(" (\n         |  id bigint,\n         |  name string,\n         |  ts string,\n         |  dt string\n         | )\n         | using hudi\n         | tblproperties (\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts'\n         | )\n         |").toString())).stripMargin());
            this.spark().sql(new StringBuilder(80).append("insert into ").append(tableName).append(" values (1, \"z3\", \"v1\", \"2021-10-01\"), (2, \"l4\", \"v1\", \"2021-10-02\")").toString());
            this.checkExceptionContain(new StringBuilder(45).append("alter table ").append(tableName).append(" drop partition (dt='2021-10-01')").toString(), new StringBuilder(65).append(tableName).append(" is a non-partitioned table that is not allowed to drop partition").toString());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)((Seq)Nil$.MODULE$));
        }, new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 55));
        this.test("Lazy Clean drop non-partitioned table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(320).append("\n         | create table ").append(tableName).append(" (\n         |  id bigint,\n         |  name string,\n         |  ts string,\n         |  dt string\n         | )\n         | using hudi\n         | tblproperties (\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts',\n         |  hoodie.clean.commits.retained= '1'\n         | )\n         |").toString())).stripMargin());
            this.spark().sql(new StringBuilder(80).append("insert into ").append(tableName).append(" values (1, \"z3\", \"v1\", \"2021-10-01\"), (2, \"l4\", \"v1\", \"2021-10-02\")").toString());
            this.checkExceptionContain(new StringBuilder(45).append("alter table ").append(tableName).append(" drop partition (dt='2021-10-01')").toString(), new StringBuilder(65).append(tableName).append(" is a non-partitioned table that is not allowed to drop partition").toString());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)((Seq)Nil$.MODULE$));
        }, new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)urlencode -> {
            this.test(new StringBuilder(52).append("Drop single-partition table' partitions, urlencode: ").append(BoxesRunTime.unboxToBoolean((Object)urlencode)).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestAlterTableDropPartition.$anonfun$new$5($this, urlencode, tmp);
                return BoxedUnit.UNIT;
            }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 111));
            return BoxedUnit.UNIT;
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)urlencode -> {
            this.test(new StringBuilder(63).append("Lazy Clean drop single-partition table' partitions, urlencode: ").append(BoxesRunTime.unboxToBoolean((Object)urlencode)).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestAlterTableDropPartition.$anonfun$new$9($this, urlencode, tmp);
                return BoxedUnit.UNIT;
            }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 190));
            return BoxedUnit.UNIT;
        });
        this.test("Drop single-partition table' partitions created by sql", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(303).append("\n         | create table ").append(tableName).append(" (\n         |  id bigint,\n         |  name string,\n         |  ts string,\n         |  dt string\n         | )\n         | using hudi\n         | tblproperties (\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts'\n         | )\n         | partitioned by (dt)\n         |").toString())).stripMargin());
            this.spark().sql(new StringBuilder(80).append("insert into ").append(tableName).append(" values (1, \"z3\", \"v1\", \"2021-10-01\"), (2, \"l4\", \"v1\", \"2021-10-02\")").toString());
            this.checkExceptionContain(new StringBuilder(62).append("alter table ").append(tableName).append(" drop partition (dt='2021-10-01', dt='2021-10-02')").toString(), "Found duplicate keys `dt`");
            this.spark().sql(new StringBuilder(80).append("insert into ").append(tableName).append(" values (3, \"z5\", \"v1\", \"2021-10-01\"), (4, \"l5\", \"v1\", \"2021-10-02\")").toString());
            this.spark().sql(new StringBuilder(45).append("alter table ").append(tableName).append(" drop partition (dt='2021-10-01')").toString());
            this.ensureLastCommitIncludesProperSchema(this.getTableStoragePath(tableName), this.ensureLastCommitIncludesProperSchema$default$2());
            this.spark().sql(new StringBuilder(5).append("set ").append(HoodieCleanConfig.CLEANER_POLICY.key()).append("=").append(HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS.name()).toString());
            this.spark().sql(new StringBuilder(48).append("call run_clean(table => '").append(tableName).append("', retain_commits => 1)").toString()).collect();
            this.checkAnswer(new StringBuilder(29).append("select id, name, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "l4", "v1", "2021-10-02"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "l5", "v1", "2021-10-02"}))}));
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"dt=2021-10-02", (List)Nil$.MODULE$)}));
        }, new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 247));
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)hiveStyle -> {
            this.test(new StringBuilder(74).append("Drop multi-level partitioned table's partitions, isHiveStylePartitioning: ").append(BoxesRunTime.unboxToBoolean((Object)hiveStyle)).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestAlterTableDropPartition.$anonfun$new$13($this, hiveStyle, tmp);
                return BoxedUnit.UNIT;
            }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 294));
            return BoxedUnit.UNIT;
        });
        ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{false, true}))).foreach((Function1 & Serializable & scala.Serializable)hiveStyle -> {
            this.test(new StringBuilder(85).append("Lazy Clean drop multi-level partitioned table's partitions, isHiveStylePartitioning: ").append(BoxesRunTime.unboxToBoolean((Object)hiveStyle)).toString(), (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestAlterTableDropPartition.$anonfun$new$17($this, hiveStyle, tmp);
                return BoxedUnit.UNIT;
            }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 375));
            return BoxedUnit.UNIT;
        });
        this.test("check instance schema", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTableDropPartition.$anonfun$new$20(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 461));
        this.test("Prevent a partition from being dropped if there are pending CLUSTERING jobs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestAlterTableDropPartition.$anonfun$new$24($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 518));
        this.test("Prevent a partition from being dropped if there are pending COMPACTs jobs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTableDropPartition.$anonfun$new$26(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 560));
        this.test("Prevent a partition from being dropped if there are pending LOG_COMPACT jobs", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTableDropPartition.$anonfun$new$28(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 608));
        this.test("Test drop partition with wildcards", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestAlterTableDropPartition.$anonfun$new$30(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestAlterTableDropPartition.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 653));
    }
}

