/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.ddl;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.TableIdentifier$;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.types.StructType;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u00113Aa\u0001\u0003\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0005;\tiA+Z:u\tJ|\u0007\u000fV1cY\u0016T!!\u0002\u0004\u0002\u0007\u0011$GN\u0003\u0002\b\u0011\u0005!\u0001.\u001e3j\u0015\tI!\"A\u0002tc2T!a\u0003\u0007\u0002\u000bM\u0004\u0018M]6\u000b\u00055q\u0011AB1qC\u000eDWMC\u0001\u0010\u0003\ry'oZ\u0002\u0001'\t\u0001!\u0003\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u000511m\\7n_:L!a\u0006\u000b\u0003-!{w\u000eZ5f'B\f'o[*rYR+7\u000f\u001e\"bg\u0016\fa\u0001P5oSRtD#\u0001\u000e\u0011\u0005m\u0001Q\"\u0001\u0003\u0002)\u0005dG/\u001a:TKJ$W\r\u0015:pa\u0016\u0014H/[3t)\u0011qBE\f\u001b\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006K\t\u0001\rAJ\u0001\u000fg\u0016\u001c8/[8o\u0007\u0006$\u0018\r\\8h!\t9C&D\u0001)\u0015\tI#&A\u0004dCR\fGn\\4\u000b\u0005-B\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u00055B#AD*fgNLwN\\\"bi\u0006dwn\u001a\u0005\u0006_\t\u0001\r\u0001M\u0001\ti\u0006\u0014G.Z%eiB\u0011\u0011GM\u0007\u0002U%\u00111G\u000b\u0002\u0010)\u0006\u0014G.Z%eK:$\u0018NZ5fe\")QG\u0001a\u0001m\u0005ia.Z<Qe>\u0004XM\u001d;jKN\u0004Ba\u000e B\u0003:\u0011\u0001\b\u0010\t\u0003s\u0001j\u0011A\u000f\u0006\u0003wA\ta\u0001\u0010:p_Rt\u0014BA\u001f!\u0003\u0019\u0001&/\u001a3fM&\u0011q\b\u0011\u0002\u0004\u001b\u0006\u0004(BA\u001f!!\t9$)\u0003\u0002D\u0001\n11\u000b\u001e:j]\u001e\u0004")
public class TestDropTable
extends HoodieSparkSqlTestBase {
    private void alterSerdeProperties(SessionCatalog sessionCatalog, TableIdentifier tableIdt, Map<String, String> newProperties) {
        Map storageProperties;
        CatalogTable catalogTable = this.spark().sessionState().catalog().getTableMetadata(tableIdt);
        CatalogStorageFormat storage = catalogTable.storage();
        Map x$1 = storageProperties = storage.properties().$plus$plus(newProperties);
        Option x$2 = storage.copy$default$1();
        Option x$3 = storage.copy$default$2();
        Option x$4 = storage.copy$default$3();
        Option x$5 = storage.copy$default$4();
        boolean x$6 = storage.copy$default$5();
        CatalogStorageFormat x$7 = storage.copy(x$2, x$3, x$4, x$5, x$6, x$1);
        TableIdentifier x$8 = catalogTable.copy$default$1();
        CatalogTableType x$9 = catalogTable.copy$default$2();
        StructType x$10 = catalogTable.copy$default$4();
        Option x$11 = catalogTable.copy$default$5();
        Seq x$12 = catalogTable.copy$default$6();
        Option x$13 = catalogTable.copy$default$7();
        String x$14 = catalogTable.copy$default$8();
        long x$15 = catalogTable.copy$default$9();
        long x$16 = catalogTable.copy$default$10();
        String x$17 = catalogTable.copy$default$11();
        Map x$18 = catalogTable.copy$default$12();
        Option x$19 = catalogTable.copy$default$13();
        Option x$20 = catalogTable.copy$default$14();
        Option x$21 = catalogTable.copy$default$15();
        Seq x$22 = catalogTable.copy$default$16();
        boolean x$23 = catalogTable.copy$default$17();
        boolean x$24 = catalogTable.copy$default$18();
        Map x$25 = catalogTable.copy$default$19();
        Option x$26 = catalogTable.copy$default$20();
        CatalogTable newCatalogTable = catalogTable.copy(x$8, x$9, x$7, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19, x$20, x$21, x$22, x$23, x$24, x$25, x$26);
        sessionCatalog.alterTable(newCatalogTable);
    }

    public static final /* synthetic */ void $anonfun$new$2(TestDropTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = $this.generateTableName();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(349).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  type = '").append((String)tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(11).append("DROP TABLE ").append(tableName).toString());
            $this.checkAnswer(new StringBuilder(19).append("show tables like '").append(tableName).append("'").toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
            return $this.assertResult(BoxesRunTime.boxToBoolean((boolean)true), BoxesRunTime.boxToBoolean((boolean)$this.existsPath(new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString())), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 54));
        });
    }

    public static final /* synthetic */ void $anonfun$new$7(TestDropTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            String tableName = $this.generateTableName();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(349).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  type = '").append((String)tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(17).append("DROP TABLE ").append(tableName).append(" PURGE").toString());
            $this.checkAnswer(new StringBuilder(19).append("show tables like '").append(tableName).append("'").toString(), (Seq<Seq<Object>>)Nil$.MODULE$);
            return $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)$this.existsPath(new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString())), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
        });
    }

    public static final /* synthetic */ void $anonfun$new$10(TestDropTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(300).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_ro using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_ro").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"true")}))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_rt using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_rt").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"false")}))));
        $this.spark().sql(new StringBuilder(17).append("drop table ").append(tableName).append(" purge").toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$12(TestDropTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(300).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_ro using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_ro").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"true")}))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_rt using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_rt").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"false")}))));
        $this.spark().sql(new StringBuilder(14).append("drop table ").append(tableName).append("_ro").toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", tableName, BoxesRunTime.boxToBoolean((boolean)false)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", new StringBuilder(3).append(tableName).append("_rt").toString(), BoxesRunTime.boxToBoolean((boolean)false)}))}));
        $this.spark().sql(new StringBuilder(14).append("drop table ").append(tableName).append("_rt").toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"default", tableName, BoxesRunTime.boxToBoolean((boolean)false)}))}));
        $this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$14(TestDropTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(300).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  ts long\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_ro using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_ro").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"true")}))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_rt using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_rt").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"false")}))));
        $this.spark().sql(new StringBuilder(20).append("drop table ").append(tableName).append("_ro purge").toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$16(TestDropTable $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        FileSystem filesystem = HadoopFSUtils.getFs((String)tablePath, (Configuration)$this.spark().sparkContext().hadoopConfiguration());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(269).append("\n           |create table ").append(tableName).append(" (\n           |id int,\n           |ts int,\n           |value string\n           |)using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           |").toString())).stripMargin());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(filesystem.exists(new Path(tablePath)), "filesystem.exists(new org.apache.hadoop.fs.Path(tablePath))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(29).append("Table path doesn't exists (").append(tablePath).append(").").toString(), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 269));
        filesystem.delete(new Path(tablePath), true);
        $this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$18(TestDropTable $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        FileSystem filesystem = HadoopFSUtils.getFs((String)tablePath, (Configuration)$this.spark().sparkContext().hadoopConfiguration());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(297).append("\n           |create table ").append(tableName).append(" (\n           |id int,\n           |ts int,\n           |value string\n           |)using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts',\n           |  type = 'mor'\n           | )\n           |").toString())).stripMargin());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(filesystem.exists(new Path(tablePath)), "filesystem.exists(new org.apache.hadoop.fs.Path(tablePath))", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(28).append("Table path doesn't exist (").append(tablePath).append(").").toString(), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 296));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_ro using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_ro").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"true")}))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(216).append("\n           |create table ").append(tableName).append("_rt using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.alterSerdeProperties($this.spark().sessionState().catalog(), TableIdentifier$.MODULE$.apply(new StringBuilder(3).append(tableName).append("_rt").toString()), (Map<String, String>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.query.as.ro.table"), (Object)"false")}))));
        filesystem.delete(new Path(tablePath), true);
        $this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
        $this.spark().sql(new StringBuilder(14).append("drop table ").append(tableName).append("_ro").toString());
        $this.spark().sql(new StringBuilder(14).append("drop table ").append(tableName).append("_rt").toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$new$22(TestDropTable $this, String tableName) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(284).append("\n               |create table ").append(tableName).append(" (\n               |id int,\n               |ts int,\n               |value string\n               |)using hudi\n               | tblproperties (\n               |  primaryKey = 'id',\n               |  preCombineField = 'ts'\n               | )\n               |").toString())).stripMargin());
        Path tablePath = new Path($this.spark().sessionState().catalog().getTableMetadata(TableIdentifier$.MODULE$.apply(tableName)).location());
        FileSystem filesystem = HadoopFSUtils.getFs((Path)tablePath, (Configuration)$this.spark().sparkContext().hadoopConfiguration());
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(filesystem.exists(tablePath), "filesystem.exists(tablePath)", Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)new StringBuilder(29).append("Table path doesn't exists (").append(tablePath).append(").").toString(), Prettifier$.MODULE$.default(), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 353));
        filesystem.delete(tablePath, true);
        $this.spark().sql(new StringBuilder(11).append("drop table ").append(tableName).toString());
        $this.checkAnswer("show tables", (Seq<Seq<Object>>)Nil$.MODULE$);
    }

    public TestDropTable() {
        this.test("Test Drop Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 32));
        this.test("Test Drop Table with non existent table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            this.spark().sql("drop table if exists non_existent_table");
            return this.assertThrows((Function0 & Serializable & scala.Serializable)() -> this.spark().sql("drop table non_existent_table"), ClassTag$.MODULE$.apply(AnalysisException.class), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 64));
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 59));
        this.test("Test Drop Table with purge", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$7(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("Test Drop RO & RT table by purging base table.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$10(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 96));
        this.test("Test Drop RO & RT table by one by one.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$12(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 145));
        this.test("Test Drop RO table with purge", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$14(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 201));
        this.test("Drop an EXTERNAL table which path is lost.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$16(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 250));
        this.test("Drop an MOR table and related RT & RO when path is lost.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropTable.$anonfun$new$18(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
        this.test("Drop a MANAGED table whose path is lost when schema evolution is applied/unapplied.", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)enableSchemaEvolution -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.schema.on.read.enable"), (Object)enableSchemaEvolution)}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTable(this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tableName -> {
                TestDropTable.$anonfun$new$22($this, tableName);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 332));
        this.test("Drop local temporary view should not fail", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String viewName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(67).append("\n         |create temporary view ").append(viewName).append(" as\n         | select 1\n         |").toString())).stripMargin());
            return this.spark().sql(new StringBuilder(10).append("drop view ").append(viewName).toString());
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 363));
        this.test("Drop global temporary view should not fail", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String viewName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(74).append("\n         |create global temporary view ").append(viewName).append(" as\n         | select 1\n         |").toString())).stripMargin());
            return this.spark().sql(new StringBuilder(22).append("drop view global_temp.").append(viewName).toString());
        }, new Position("TestDropTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 374));
    }
}

