/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.ddl;

import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m1AAA\u0002\u0001!!)q\u0003\u0001C\u00011\t\u0011B+Z:u'\"|w\u000fU1si&$\u0018n\u001c8t\u0015\t!Q!A\u0002eI2T!AB\u0004\u0002\t!,H-\u001b\u0006\u0003\u0011%\t1a]9m\u0015\tQ1\"A\u0003ta\u0006\u00148N\u0003\u0002\r\u001b\u00051\u0011\r]1dQ\u0016T\u0011AD\u0001\u0004_J<7\u0001A\n\u0003\u0001E\u0001\"AE\u000b\u000e\u0003MQ!\u0001F\u0003\u0002\r\r|W.\\8o\u0013\t12C\u0001\fI_>$\u0017.Z*qCJ\\7+\u001d7UKN$()Y:f\u0003\u0019a\u0014N\\5u}Q\t\u0011\u0004\u0005\u0002\u001b\u00015\t1\u0001")
public class TestShowPartitions
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$7(TestShowPartitions $this, String tableName) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(475).append("\n               | create table ").append(tableName).append(" (\n               |   id int,\n               |   name string,\n               |   price double,\n               |   ts long,\n               |   year string,\n               |   month string,\n               |   day string\n               | ) using hudi\n               | partitioned by (year, month, day)\n               | tblproperties (\n               |   primaryKey = 'id',\n               |   preCombineField = 'ts'\n               | )\n             ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(61).append("alter table ").append(tableName).append(" add partition(year='2023', month='06', day='06')").toString());
        $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"year=2023/month=06/day=06", (List)Nil$.MODULE$)}));
        $this.spark().sql(new StringBuilder(62).append("alter table ").append(tableName).append(" drop partition(year='2023', month='06', day='06')").toString());
        $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)((Seq)Nil$.MODULE$));
        $this.spark().sql(new StringBuilder(59).append("insert into ").append(tableName).append(" values (1, 'a1', 10, 1000, '2023', '06', '06')").toString());
        $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"year=2023/month=06/day=06", (List)Nil$.MODULE$)}));
    }

    public static final /* synthetic */ void $anonfun$new$9(TestShowPartitions $this, String tableName) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(415).append("\n           | create table ").append(tableName).append(" (\n           |   id int,\n           |   name string,\n           |   price double,\n           |   ts long,\n           |   year string,\n           |   month string,\n           |   day string\n           | ) using hudi\n           | partitioned by (year, month, day)\n           | tblproperties (\n           |   primaryKey = 'id',\n           |   preCombineField = 'ts'\n           | )\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(222).append("\n           | insert into ").append(tableName).append("\n           | values\n           |   (1, 'a1', 10, 1000, '2023', '12', '01'),\n           |   (2, 'a2', 10, 1000, '2023', '12', '02'),\n           |   (3, 'a3', 10, 1000, '2023', '12', '03')\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"year=2023/month=12/day=01", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"year=2023/month=12/day=02", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"year=2023/month=12/day=03", (List)Nil$.MODULE$)}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(177).append("\n           | insert overwrite table ").append(tableName).append("\n           | values\n           |   (4, 'a4', 10, 1000, '2023', '12', '01'),\n           |   (2, 'a2', 10, 1000, '2023', '12', '04')\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"year=2023/month=12/day=01", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"year=2023/month=12/day=04", (List)Nil$.MODULE$)}));
    }

    public static final /* synthetic */ void $anonfun$new$12(TestShowPartitions $this, String tableName) {
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(367).append("\n             | create table ").append(tableName).append(" (\n             |   id int,\n             |   name string,\n             |   price double,\n             |   ts long,\n             |   dt string\n             | ) using hudi\n             | partitioned by (dt)\n             | tblproperties (\n             |   primaryKey = 'id',\n             |   preCombineField = 'ts'\n             | )\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(214).append("\n             | insert into ").append(tableName).append("\n             | values\n             |   (1, 'a1', 10, 1000, '2023-12-01'),\n             |   (2, 'a2', 10, 1000, '2023-12-02'),\n             |   (3, 'a3', 10, 1000, '2023-12-03')\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"dt=2023-12-01", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"dt=2023-12-02", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"dt=2023-12-03", (List)Nil$.MODULE$)}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(172).append("\n             | insert overwrite table ").append(tableName).append(" partition(dt='2023-12-01')\n             | values\n             |   (4, 'a4', 10, 1000),\n             |   (2, 'a2', 10, 1000)\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"dt=2023-12-01", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"dt=2023-12-02", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"dt=2023-12-03", (List)Nil$.MODULE$)}));
    }

    public TestShowPartitions() {
        this.test("Test Show Non Partitioned Table's Partitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(252).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         |  price double,\n         |  ts long\n         |) using hudi\n         |tblproperties (\n         |  primaryKey = 'id',\n         |  preCombineField = 'ts'\n         )\n       ").toString())).stripMargin());
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(98).append("\n         | insert into ").append(tableName).append("\n         | select 1 as id, 'a1' as name, 10 as price, 1000 as ts\n        ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)((Seq)Nil$.MODULE$));
        }, new Position("TestShowPartitions.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        this.test("Test Show Partitioned Table's Partitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(309).append("\n         | create table ").append(tableName).append(" (\n         |  id int,\n         |  name string,\n         | price double,\n         |  ts long,\n         |  dt string\n         ) using hudi\n         | partitioned by (dt)\n         | tblproperties (\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts'\n         | )\n       ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)((Seq)Nil$.MODULE$));
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(85).append("\n         | insert into ").append(tableName).append("\n         | values (1, 'a1', 10, 1000, '2021-01-01')\n        ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"dt=2021-01-01", (List)Nil$.MODULE$)}));
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(127).append("\n         | insert into ").append(tableName).append(" partition(dt = '2021-01-02')\n         | select 2 as id, 'a2' as name, 10 as price, 1000 as ts\n        ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(43).append("show partitions ").append(tableName).append(" partition(dt='2021-01-02')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"dt=2021-01-02", (List)Nil$.MODULE$)}));
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(110).append("\n         | insert into ").append(tableName).append("\n         | select 3 as id, 'a3' as name, 10 as price, 1000 as ts, null as dt\n        ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"dt=2021-01-01", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"dt=2021-01-02", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("dt=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__"})), (List)Nil$.MODULE$)}));
        }, new Position("TestShowPartitions.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("Test Show Table's Partitions with MultiLevel Partitions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(385).append("\n         | create table ").append(tableName).append(" (\n         |   id int,\n         |   name string,\n         |   price double,\n         |   ts long,\n         |   year string,\n         |   month string,\n         |   day string\n         | ) using hudi\n         | partitioned by (year, month, day)\n         | tblproperties (\n         |   primaryKey = 'id',\n         |   preCombineField = 'ts'\n         | )\n       ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)((Seq)Nil$.MODULE$));
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(530).append("\n         | insert into ").append(tableName).append("\n         | values\n         |   (1, 'a1', 10, 1000, '2021', '01', '01'),\n         |   (2, 'a2', 10, 1000, '2021', '01', '02'),\n         |   (3, 'a3', 10, 1000, '2021', '02', '01'),\n         |   (4, 'a4', 10, 1000, '2021', '02', null),\n         |   (5, 'a5', 10, 1000, '2021', null, '01'),\n         |   (6, 'a6', 10, 1000, null, '01', '02'),\n         |   (7, 'a6', 10, 1000, '2022', null, null),\n         |   (8, 'a6', 10, 1000, null, '01', null),\n         |   (9, 'a6', 10, 1000, null, null, '01')\n        ").toString())).stripMargin());
            this.checkAnswer(new StringBuilder(16).append("show partitions ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"year=2021/month=01/day=01", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"year=2021/month=01/day=02", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"year=2021/month=02/day=01", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("year=2021/month=02/day=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__"})), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("year=2021/month=%s/day=01")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__"})), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("year=%s/month=01/day=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__", "__HIVE_DEFAULT_PARTITION__"})), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("year=%s/month=01/day=02")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__"})), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("year=%s/month=%s/day=01")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__", "__HIVE_DEFAULT_PARTITION__"})), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("year=2022/month=%s/day=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__", "__HIVE_DEFAULT_PARTITION__"})), (List)Nil$.MODULE$)}));
            this.checkAnswer(new StringBuilder(61).append("show partitions ").append(tableName).append(" partition(year='2021', month='01', day='01')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"year=2021/month=01/day=01", (List)Nil$.MODULE$)}));
            this.checkAnswer(new StringBuilder(51).append("show partitions ").append(tableName).append(" partition(year='2021', month='02')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("year=2021/month=02/day=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__"})), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"year=2021/month=02/day=01", (List)Nil$.MODULE$)}));
            this.checkAnswer(new StringBuilder(36).append("show partitions ").append(tableName).append(" partition(day='01')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)"year=2021/month=02/day=01", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("year=2021/month=%s/day=01")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__"})), (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)"year=2021/month=01/day=01", (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)new StringOps(Predef$.MODULE$.augmentString("year=%s/month=%s/day=01")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"__HIVE_DEFAULT_PARTITION__", "__HIVE_DEFAULT_PARTITION__"})), (List)Nil$.MODULE$)}));
        }, new Position("TestShowPartitions.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 102));
        this.test("Test alter table show partitions which are dropped before", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> ((IterableLike)new .colon.colon((Object)"true", (List)new .colon.colon((Object)"false", (List)Nil$.MODULE$))).foreach((Function1 & java.io.Serializable & Serializable)enableMetadata -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.metadata.enable"), (Object)enableMetadata)}), (JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.withTable(this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)tableName -> {
                TestShowPartitions.$anonfun$new$7($this, tableName);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("TestShowPartitions.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170));
        this.test("Test show partitions after table being overwritten", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.withTable(this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)tableName -> {
            TestShowPartitions.$anonfun$new$9(this, tableName);
            return BoxedUnit.UNIT;
        }), new Position("TestShowPartitions.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
        this.test("Test show partitions in static partition overwrite", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.overwrite.mode"), (Object)"STATIC")}), (JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.withTable(this.generateTableName(), (Function1<String, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)tableName -> {
            TestShowPartitions.$anonfun$new$12(this, tableName);
            return BoxedUnit.UNIT;
        })), new Position("TestShowPartitions.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 258));
    }
}

