/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.dml;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.ScalaAssertionSupport;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.testutils.DataSourceTestUtils;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001-2A\u0001B\u0003\u0001%!)a\u0004\u0001C\u0001?!9!\u0005\u0001b\u0001\n\u0013\u0019\u0003B\u0002\u0016\u0001A\u0003%AE\u0001\nUKN$X*\u001a:hK&sGo\u001c+bE2,'B\u0001\u0004\b\u0003\r!W\u000e\u001c\u0006\u0003\u0011%\tA\u0001[;eS*\u0011!bC\u0001\u0004gFd'B\u0001\u0007\u000e\u0003\u0015\u0019\b/\u0019:l\u0015\tqq\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0005Y9\u0011AB2p[6|g.\u0003\u0002\u0019+\t1\u0002j\\8eS\u0016\u001c\u0006/\u0019:l'FdG+Z:u\u0005\u0006\u001cX\r\u0005\u0002\u001b95\t1D\u0003\u0002\t\u001b%\u0011Qd\u0007\u0002\u0016'\u000e\fG.Y!tg\u0016\u0014H/[8o'V\u0004\bo\u001c:u\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0005\u0005\u0002\"\u00015\tQ!A\u0002m_\u001e,\u0012\u0001\n\t\u0003K!j\u0011A\n\u0006\u0003O=\tQa\u001d7gi)L!!\u000b\u0014\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011")
public class TestMergeIntoTable
extends HoodieSparkSqlTestBase
implements ScalaAssertionSupport {
    private final Logger log;

    @Override
    public <T extends Throwable, R> T assertThrows(Class<T> expectedExceptionClass, Function0<R> f) {
        return (T)ScalaAssertionSupport.assertThrows$(this, expectedExceptionClass, f);
    }

    private Logger log() {
        return this.log;
    }

    public static final /* synthetic */ void $anonfun$new$7(SyncableFileSystemView fsv$1, HoodieTableMetaClient metaClient$1, String partition) {
        Assertions.assertTrue((fsv$1.getLatestFileSlices(partition).count() > 0L ? 1 : 0) != 0);
        fsv$1.getLatestFileSlices(partition).forEach(fileSlice -> {
            if (fileSlice.getBaseFile().isPresent()) {
                HoodieSparkSqlTestBase$.MODULE$.replaceWithEmptyFile(metaClient$1.getStorage(), ((BaseFile)fileSlice.getBaseFile().get()).getStoragePath());
            }
            fileSlice.getLogFiles().forEach(logFile -> HoodieSparkSqlTestBase$.MODULE$.replaceWithEmptyFile(metaClient$1.getStorage(), logFile.getPath()));
        });
    }

    public static final /* synthetic */ void $anonfun$new$11(TestMergeIntoTable $this, File tmp) {
        String targetTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(393).append("\n           |create table ").append(targetTable).append(" (\n           |  id int,\n           |  name string,\n           |  data int,\n           |  country string,\n           |  ts int\n           |) using hudi\n           |tblproperties (\n           |  type = 'cow',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           |partitioned by (country)\n           |location '").append(tmp.getCanonicalPath()).append("/").append(targetTable).append("'\n           |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(318).append("\n           |merge into ").append(targetTable).append(" as target\n           |using (\n           |select 1 as id, 'lb' as name, 6 as data, 'shu' as country, 43193 as ts\n           |) source\n           |on source.id = target.id\n           |when matched then\n           |update set *\n           |when not matched then\n           |insert *\n           |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(517).append("\n           |merge into ").append(targetTable).append(" as target\n           |using (\n           |select 1 as id, 'lb' as name, 5 as data, 'shu' as country, 43196 as ts\n           |) source\n           |on source.id = target.id\n           |when matched and source.data > target.data then\n           |update set target.data = source.data, target.ts = source.ts\n           |when matched and source.data = 5 then\n           |update set target.data = source.data, target.ts = source.ts\n           |when not matched then\n           |insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(40).append("select id, name, data, country, ts from ").append(targetTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "lb", BoxesRunTime.boxToInteger((int)5), "shu", BoxesRunTime.boxToInteger((int)43196)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$18(TestMergeIntoTable $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        String sourceTable = $this.generateTableName();
        String targetTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(192).append("\n           | create table ").append(sourceTable).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts int\n           | ) using parquet\n           | location '").append(tmp.getCanonicalPath()).append("/").append(sourceTable).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(298).append("\n           |create table ").append(targetTable).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts int\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(targetTable).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(sourceTable).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(sourceTable).append(" values(2, 'a2', 11, 1000)").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("\n           | merge into ").append(targetTable).append(" as t0\n           | using (select * from ").append(sourceTable).append(") as s0\n           | on t0.id = s0.id\n           | when matched then update set *\n           | when not matched and s0.name = 'a1' then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(targetTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(37).append("insert into ").append(targetTable).append(" select 3, 'a3', 12, 1000").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(targetTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(557).append("\n           | merge into ").append(targetTable).append(" as t0\n           | using (\n           |  select * from (\n           |    select 1 as s_id, 'a1' as name, 20 as price, 1001 as ts\n           |    union all\n           |    select 3 as s_id, 'a3' as name, 20 as price, 1003 as ts\n           |    union all\n           |    select 4 as s_id, 'a4' as name, 10 as price, 1004 as ts\n           |  )\n           | ) s0\n           | on s0.s_id = t0.id\n           | when matched and s0.ts = 1001 then update set id = s0.s_id, name = t0.name, price =\n           | s0.price, ts = s0.ts\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(targetTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$23(TestMergeIntoTable $this, File tmp$3, boolean updatePartitionPathEnabled$1, String tableType) {
        String targetTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(625).append("\n                 | create table ").append(targetTable).append(" (\n                 |  id int,\n                 |  version int,\n                 |  mergeCond string,\n                 |  partition string\n                 | ) using hudi\n                 | partitioned by (partition)\n                 | tblproperties (\n                 |    'primaryKey' = 'id',\n                 |    'type' = '").append(tableType).append("',\n                 |    'payloadClass' = 'org.apache.hudi.common.model.DefaultHoodieRecordPayload',\n                 |    'payloadType' = 'CUSTOM',\n                 |    preCombineField = 'version'\n                 | )\n                 | location '").append(tmp$3.getCanonicalPath()).append("/").append(targetTable).append("'\n             ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(49).append("insert into ").append(targetTable).append(" values(1, 1, 'insert', '2023-10-01')").toString());
        $this.spark().sql(new StringBuilder(49).append("insert into ").append(targetTable).append(" values(2, 1, 'insert', '2023-10-01')").toString());
        $this.spark().sql(new StringBuilder(49).append("insert into ").append(targetTable).append(" values(3, 1, 'insert', '2023-10-01')").toString());
        $this.spark().sql(new StringBuilder(49).append("insert into ").append(targetTable).append(" values(4, 1, 'insert', '2023-10-01')").toString());
        $this.spark().sql(new StringBuilder(49).append("insert into ").append(targetTable).append(" values(5, 1, 'insert', '2023-10-01')").toString());
        $this.spark().sql(new StringBuilder(49).append("insert into ").append(targetTable).append(" values(6, 1, 'insert', '2023-10-01')").toString());
        String sourceTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(293).append("\n                 | create table ").append(sourceTable).append(" (\n                 | id int,\n                 | version int,\n                 | mergeCond string,\n                 | partition string\n                 | ) using parquet\n                 | partitioned by (partition)\n                 | location '").append(tmp$3.getCanonicalPath()).append("/").append(sourceTable).append("'\n            ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(sourceTable).append(" values(1, 2, 'yes', '2023-10-02')").toString());
        $this.spark().sql(new StringBuilder(45).append("insert into ").append(sourceTable).append(" values(2, 2, 'no', '2023-10-02')").toString());
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(sourceTable).append(" values(3, 2, 'yes', '2023-10-01')").toString());
        $this.spark().sql(new StringBuilder(45).append("insert into ").append(sourceTable).append(" values(4, 2, 'no', '2023-10-01')").toString());
        $this.spark().sql(new StringBuilder(49).append("insert into ").append(sourceTable).append(" values(5, 2, 'delete', '2023-10-02')").toString());
        $this.spark().sql(new StringBuilder(49).append("insert into ").append(sourceTable).append(" values(6, 2, 'delete', '2023-10-01')").toString());
        $this.spark().sql(new StringBuilder(49).append("insert into ").append(sourceTable).append(" values(7, 1, 'insert', '2023-10-01')").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(321).append("\n                 | merge into ").append(targetTable).append(" t using\n                 | (select * from ").append(sourceTable).append(") as s\n                 | on t.id=s.id\n                 | when matched and s.mergeCond = 'yes' then update set *\n                 | when matched and s.mergeCond = 'delete' then delete\n                 | when not matched then insert *\n             ").toString())).stripMargin());
        String updatedPartitionPath = updatePartitionPathEnabled$1 ? "partition=2023-10-02" : "partition=2023-10-01";
        $this.checkAnswer(new StringBuilder(58).append("select id,version,_hoodie_partition_path from ").append(targetTable).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), updatedPartitionPath})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), BoxesRunTime.boxToInteger((int)1), "partition=2023-10-01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), BoxesRunTime.boxToInteger((int)2), "partition=2023-10-01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), BoxesRunTime.boxToInteger((int)1), "partition=2023-10-01"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), BoxesRunTime.boxToInteger((int)1), "partition=2023-10-01"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$25(TestMergeIntoTable $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(387).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts int,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        .colon.colon structFields = new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("price", (DataType)DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("ts", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("dt", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as id, 'a1' as name, 10 as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when not matched and s0.id % 2 = 1 then insert *\n         ").toString())).stripMargin());
        $this.validateTableSchema(tableName, (List<StructField>)structFields);
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(352).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as _id, 'a1' as name, 12 as _price, 1001 as _ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0._id\n           | when matched and s0._id % 2 = 0 then update set\n           |  id = s0._id, name = s0.name, price = s0._price, ts = s0._ts, dt = s0.dt\n         ").toString())).stripMargin());
        $this.validateTableSchema(tableName, (List<StructField>)structFields);
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(352).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 1 as _id, 'a1' as name, 12 as _price, 1001 as _ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0._id\n           | when matched and s0._id % 2 = 1 then update set\n           |  id = s0._id, name = s0.name, price = s0._price, ts = s0._ts, dt = s0.dt\n         ").toString())).stripMargin());
        $this.validateTableSchema(tableName, (List<StructField>)structFields);
        $this.checkAnswer(new StringBuilder(29).append("select id,name,price,dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 2 as id, 'a2' as name, 10 as price, 1000 as ts, '2021-03-21' as dt\n           | ) as s0\n           | on t0.id = s0.id\n           | when not matched and s0.id % 2 = 0 then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(41).append("select id,name,price,dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), "2021-03-21"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(344).append("\n           | merge into ").append(tableName).append(" t0\n           | using (\n           |  select 2 as s_id, 'a2' as s_name, 15 as s_price, 1001 as s_ts, '2021-03-21' as dt\n           | ) s0\n           | on t0.id = s0.s_id\n           | when matched and s_ts = 1001\n           | then update set id = s_id, name = s_name, price = s_price, ts = s_ts, t0.dt = s0.dt\n         ").toString())).stripMargin());
        $this.validateTableSchema(tableName, (List<StructField>)structFields);
        $this.checkAnswer(new StringBuilder(41).append("select id,name,price,dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)15), "2021-03-21"}))}));
        String errorMessage = "Only simple conditions of the form `t.id = s.id` are allowed on the primary-key and partition path column. Found `t0.id = (s0.s_id + 1)`";
        $this.checkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(263).append("\n           | merge into ").append(tableName).append(" t0\n           | using (\n           |  select 1 as s_id, 'a2' as s_name, 15 as s_price, 1001 as s_ts, '2021-03-21' as dt\n           | ) s0\n           | on t0.id = s0.s_id + 1\n           | when matched and s_ts = 1001 then delete\n         ").toString())).stripMargin(), errorMessage);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(258).append("\n           | merge into ").append(tableName).append(" t0\n           | using (\n           |  select 2 as s_id, 'a2' as s_name, 15 as s_price, 1001 as ts, '2021-03-21' as dt\n           | ) s0\n           | on t0.id = s0.s_id\n           | when matched and s0.ts = 1001 then delete\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(41).append("select id,name,price,dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$27(TestMergeIntoTable $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(327).append("\n           | create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(45).append("insert into ").append(tableName).append(" select 1, 'a1', 10, '2021-03-21'").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(327).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 2 as id, 'a2' as name, 10 as price, 1000 as ts, '2021-03-20' as dt\n           | ) s0\n           | on s0.id = t0.id\n           | when not matched and s0.id % 2 = 0 then insert (id,name,price,dt)\n           | values(s0.id,s0.name,s0.price,s0.dt)\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(41).append("select id,name,price,dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), "2021-03-20"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(327).append("\n           | merge into ").append(tableName).append(" as t0\n           | using (\n           |  select 3 as id, 'a3' as name, 10 as price, 1000 as ts, '2021-03-20' as dt\n           | ) s0\n           | on s0.id = t0.id\n           | when not matched and s0.id % 2 = 0 then insert (id,name,price,dt)\n           | values(s0.id,s0.name,s0.price,s0.dt)\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(41).append("select id,name,price,dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), "2021-03-20"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$31(TestMergeIntoTable $this, File tmp$4, String tableType) {
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(520).append("\n             | create table ").append(tableName1).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  v int,\n             |  dt string\n             | ) using hudi\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'v',\n             |  hoodie.compaction.payload.class = 'org.apache.hudi.common.model.DefaultHoodieRecordPayload'\n             | )\n             | partitioned by(dt)\n             | location '").append(tmp$4.getCanonicalPath()).append("/").append(tableName1).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(274).append("\n             | merge into ").append(tableName1).append(" as t0\n             | using (\n             |  select 1 as id, 'a1' as name, 10 as price, 1001 as v, '2021-03-21' as dt\n             | ) as s0\n             | on t0.id = s0.id\n             | when not matched and s0.id % 2 = 1 then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(31).append("select id,name,price,dt,v from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21", BoxesRunTime.boxToInteger((int)1001)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(274).append("\n             | merge into ").append(tableName1).append(" as t0\n             | using (\n             |  select 1 as id, 'a1' as name, 11 as price, 1000 as v, '2021-03-21' as dt\n             | ) as s0\n             | on t0.id = s0.id\n             | when matched and s0.id % 2 = 1 then update set *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(31).append("select id,name,price,dt,v from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), "2021-03-21", BoxesRunTime.boxToInteger((int)1001)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(274).append("\n             | merge into ").append(tableName1).append(" as t0\n             | using (\n             |  select 1 as id, 'a1' as name, 12 as price, 1002 as v, '2021-03-21' as dt\n             | ) as s0\n             | on t0.id = s0.id\n             | when matched and s0.id % 2 = 1 then update set *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(31).append("select id,name,price,dt,v from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), "2021-03-21", BoxesRunTime.boxToInteger((int)1002)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$30(TestMergeIntoTable $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestMergeIntoTable.$anonfun$new$31($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$34(TestMergeIntoTable $this, File tmp$5, String tableType) {
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(411).append("\n             | create table ").append(tableName1).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  v int,\n             |  dt string\n             | ) using hudi\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'v'\n             | )\n             | partitioned by(dt)\n             | location '").append(tmp$5.getCanonicalPath()).append("/").append(tableName1).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(tableName1).append(" values(1, 'a1', 10, 1000, '2021-03-21')").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(314).append("\n             | merge into ").append(tableName1).append(" as t0\n             | using (\n             |  select 1 as id, 'a1' as name, 11 as price, 999 as v, '2021-03-21' as dt\n             | ) as s0\n             | on t0.id = s0.id\n             | when matched then update set id=s0.id, name=s0.name, price=s0.price*2, v=s0.v+2, dt=s0.dt\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(31).append("select id,name,price,dt,v from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)22), "2021-03-21", BoxesRunTime.boxToInteger((int)1001)}))}));
        $this.checkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(333).append("\n             | merge into ").append(tableName1).append(" as t0\n             | using (\n             |  select 1 as s_id, 'a1' as s_name, 12 as s_price, 1000 as s_v, '2021-03-21' as dt\n             | ) as s0\n             | on t0.id = s0.s_id\n             | when matched then update set id=s0.s_id, name=s0.s_name, price=s0.s_price*2, v=s0.s_v+2, dt=s0.dt\n         ").toString())).stripMargin(), "MERGE INTO field resolution error: Failed to resolve precombine field `v` w/in the source-table output");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(329).append("\n             | merge into ").append(tableName1).append(" as t0\n             | using (\n             |  select 1 as s_id, 'a1' as s_name, 12 as s_price, 1000 as v, '2021-03-21' as dt\n             | ) as s0\n             | on t0.id = s0.s_id\n             | when matched then update set id=s0.s_id, name=s0.s_name, price=s0.s_price*2, v=s0.v+2, dt=s0.dt\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(31).append("select id,name,price,dt,v from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)24), "2021-03-21", BoxesRunTime.boxToInteger((int)1002)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$33(TestMergeIntoTable $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestMergeIntoTable.$anonfun$new$34($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$36(TestMergeIntoTable $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(386).append("\n           | create table ").append(tableName1).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  v int,\n           |  dt string\n           | ) using hudi\n           | tblproperties (\n           |  type = 'cow',\n           |  primaryKey = 'id',\n           |  preCombineField = 'v'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName1).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(tableName1).append(" values(3, 'a3', 30, 3000, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(tableName1).append(" values(2, 'a2', 20, 2000, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(tableName1).append(" values(1, 'a1', 10, 1000, '2021-03-21')").toString());
        $this.checkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(220).append("merge into ").append(tableName1).append(" t0\n           | using (\n           |  select 1 as id, 'a1' as name, 15 as price, 1001 as v, '2021-03-21' as dt\n           | ) s0\n           | on t0.id = s0.id + 1\n           | when matched then delete\n       ").toString())).stripMargin(), "Only simple conditions of the form `t.id = s.id` are allowed on the primary-key and partition path column. Found `t0.id = (s0.id + 1)`");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(232).append("\n           | merge into ").append(tableName1).append(" t0\n           | using (\n           |  select 2 as id, 'a2' as name, 20 as price, 2000 as v, '2021-03-21' as dt\n           | ) s0\n           | on t0.id = s0.id\n           | when matched then delete\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(43).append("select id,name,price,v,dt from ").append(tableName1).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToInteger((int)30), BoxesRunTime.boxToInteger((int)3000), "2021-03-21"}))}));
        $this.checkException(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(231).append("merge into ").append(tableName1).append(" t0\n           | using (\n           |  select 3 as s_id, 'a3' as s_name, 30 as s_price, 3000 as s_v, '2021-03-21' as dt\n           | ) s0\n           | on t0.id = s0.s_id\n           | when matched then delete\n           |").toString())).stripMargin(), "MERGE INTO field resolution error: Failed to resolve precombine field `v` w/in the source-table output");
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(240).append("\n           | merge into ").append(tableName1).append(" t0\n           | using (\n           |  select 3 as s_id, 'a3' as s_name, 30 as s_price, 3000 as v, '2021-03-21' as dt\n           | ) s0\n           | on t0.id = s0.s_id\n           | when matched then delete\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(43).append("select id,name,price,v,dt from ").append(tableName1).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$39(TestMergeIntoTable $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        String sourceTable = $this.generateTableName();
        String targetTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(218).append("\n           | create table ").append(sourceTable).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           | ) using parquet\n           | location '").append(tmp.getCanonicalPath()).append("/").append(sourceTable).append("'\n         ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(sourceTable).append(" values(8, 's8', 80, 2008, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(sourceTable).append(" values(9, 's9', 90, 2009, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(55).append("insert into ").append(sourceTable).append(" values(10, 's10', 100, 2010, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(55).append("insert into ").append(sourceTable).append(" values(11, 's11', 110, 2011, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(55).append("insert into ").append(sourceTable).append(" values(12, 's12', 120, 2012, '2021-03-21')").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(356).append("\n           |create table ").append(targetTable).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  dt string\n           |) using hudi\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(dt)\n           | location '").append(tmp.getCanonicalPath()).append("/").append(targetTable).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(targetTable).append(" values(7, 'a7', 70, 1007, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(targetTable).append(" values(8, 'a8', 80, 1008, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(52).append("insert into ").append(targetTable).append(" values(9, 'a9', 90, 1009, '2021-03-21')").toString());
        $this.spark().sql(new StringBuilder(55).append("insert into ").append(targetTable).append(" values(10, 'a10', 100, 1010, '2021-03-21')").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(331).append("\n           | merge into ").append(targetTable).append(" as t0\n           | using ").append(sourceTable).append(" as s0\n           | on t0.id = s0.id\n           | when matched and s0.id = 10 then delete\n           | when matched and s0.id < 10 then update set id=s0.id, name='sxx', price=s0.price*2, ts=s0.ts+10000, dt=s0.dt\n           | when not matched and s0.id > 10 then insert *\n         ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(44).append("select id,name,price,ts,dt from ").append(targetTable).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)7), "a7", BoxesRunTime.boxToInteger((int)70), BoxesRunTime.boxToInteger((int)1007), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)8), "sxx", BoxesRunTime.boxToInteger((int)160), BoxesRunTime.boxToInteger((int)12008), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)9), "sxx", BoxesRunTime.boxToInteger((int)180), BoxesRunTime.boxToInteger((int)12009), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)11), "s11", BoxesRunTime.boxToInteger((int)110), BoxesRunTime.boxToInteger((int)2011), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)12), "s12", BoxesRunTime.boxToInteger((int)120), BoxesRunTime.boxToInteger((int)2012), "2021-03-21"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$43(TestMergeIntoTable $this, File tmp$6, String tableType) {
        String sourceTable = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(342).append("\n             |create table ").append(sourceTable).append(" (\n             | id int,\n             | name string,\n             | price double,\n             | _ts long\n             |) using hudi\n             |tblproperties(\n             | type ='").append(tableType).append("',\n             | primaryKey = 'id',\n             | preCombineField = '_ts'\n             |)\n             |location '").append(tmp$6.getCanonicalPath()).append("/").append(sourceTable).append("'\n          ").toString())).stripMargin());
        String targetTable = $this.generateTableName();
        String targetBasePath = new StringBuilder(1).append(tmp$6.getCanonicalPath()).append("/").append(targetTable).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(341).append("\n             |create table ").append(targetTable).append(" (\n             | id int,\n             | name string,\n             | price double,\n             | _ts long\n             |) using hudi\n             |tblproperties(\n             | type ='").append(tableType).append("',\n             | primaryKey = 'id',\n             | preCombineField = '_ts'\n             |)\n             |location '").append(targetBasePath).append("'\n          ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(sourceTable).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(140).append("\n             |merge into ").append(targetTable).append(" t0\n             |using ").append(sourceTable).append(" s0\n             |on t0.id = s0.id\n             |when not matched then insert *\n          ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(33).append("select id, name, price, _ts from ").append(targetTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
        FileSystem fs = HadoopFSUtils.getFs((String)targetBasePath, (Configuration)$this.spark().sessionState().newHadoopConf());
        String firstCompletionTime = DataSourceTestUtils.latestCommitCompletionTime(fs, targetBasePath);
        $this.spark().sql(new StringBuilder(47).append("update ").append(sourceTable).append(" set price = 12, _ts = 1001 where id = 1").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(177).append("\n             |merge into ").append(targetTable).append(" t0\n             |using ").append(sourceTable).append(" s0\n             |on t0.id = s0.id\n             |when matched and cast(s0._ts as string) > '1000' then update set *\n           ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(33).append("select id, name, price, _ts from ").append(targetTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1001)}))}));
        Dataset hudiIncDF1 = $this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), firstCompletionTime).option(DataSourceReadOptions$.MODULE$.END_COMMIT().key(), firstCompletionTime).load(targetBasePath);
        hudiIncDF1.createOrReplaceTempView("inc1");
        $this.checkAnswer("select id, name, price, _ts from inc1", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(sourceTable).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(205).append("\n             |merge into ").append(targetTable).append(" t0\n             |using ").append(sourceTable).append(" s0\n             |on t0.id = s0.id\n             |when matched then update set *\n             |when not matched and s0.name = 'a2' then insert *\n           ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(45).append("select id, name, price, _ts from ").append(targetTable).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1001)}))}));
        String thirdCompletionTime = DataSourceTestUtils.latestCommitCompletionTime(fs, targetBasePath);
        Dataset hudiIncDF2 = $this.spark().read().format("org.apache.hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), thirdCompletionTime).load(targetBasePath);
        hudiIncDF2.createOrReplaceTempView("inc2");
        $this.checkAnswer("select id, name, price, _ts from inc2 order by id", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1001)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1001)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$42(TestMergeIntoTable $this, File tmp) {
        $this.spark().sessionState().conf().setConf(SQLConf$.MODULE$.WHOLESTAGE_CODEGEN_ENABLED(), (Object)BoxesRunTime.boxToBoolean((boolean)false));
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestMergeIntoTable.$anonfun$new$43($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$46(TestMergeIntoTable $this, File tmp$7, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String dataType = (String)tuple2._1();
            Object dataValue = tuple2._2();
            String tableName = $this.generateTableName();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(315).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  c ").append(dataType).append("\n             |) using hudi\n             | location '").append(tmp$7.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  primaryKey ='id',\n             |  preCombineField = 'c'\n             | )\n       ").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(318).append("\n             | merge into ").append(tableName).append("\n             | using (\n             |  select 1 as id, 'a1' as name, 10 as price, cast(").append(dataValue).append(" as ").append(dataType).append(") as c, '1' as flag\n             | ) s0\n             | on s0.id = ").append(tableName).append(".id\n             | when matched and flag = '1' then update set *\n             | when not matched and flag = '1' then insert *\n       ").toString())).stripMargin());
            $this.checkAnswer(new StringBuilder(28).append("select id, name, price from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0)}))}));
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(352).append("\n             | merge into ").append(tableName).append("\n             | using (\n             |  select 1 as id, 'a1' as name, 10 as price, cast(").append(dataValue).append(" as ").append(dataType).append(") as c\n             | ) s0\n             | on s0.id = ").append(tableName).append(".id\n             | when matched then update set\n             | id = s0.id, name = s0.name, price = s0.price + ").append(tableName).append(".price, c = s0.c\n             | when not matched then insert *\n       ").toString())).stripMargin());
            $this.checkAnswer(new StringBuilder(28).append("select id, name, price from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)20.0)}))}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$45(TestMergeIntoTable $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        Seq typeAndValue = (Seq)new .colon.colon((Object)new Tuple2((Object)"string", (Object)"'1000'"), (List)new .colon.colon((Object)new Tuple2((Object)"int", (Object)BoxesRunTime.boxToInteger((int)1000)), (List)new .colon.colon((Object)new Tuple2((Object)"bigint", (Object)BoxesRunTime.boxToInteger((int)10000)), (List)new .colon.colon((Object)new Tuple2((Object)"timestamp", (Object)"'2021-05-20 00:00:00'"), (List)new .colon.colon((Object)new Tuple2((Object)"date", (Object)"'2021-05-20'"), (List)Nil$.MODULE$)))));
        typeAndValue.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TestMergeIntoTable.$anonfun$new$46($this, tmp, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$49(TestMergeIntoTable $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(371).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts int\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  type = 'mor',\n           |  preCombineField = 'ts',\n           |  hoodie.compact.inline = 'true'\n           | )\n       ").toString())).stripMargin());
        .colon.colon structFields = new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("price", (DataType)DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("ts", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$))));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1000)").toString());
        $this.validateTableSchema(tableName, (List<StructField>)structFields);
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(294).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           | select 4 as _id, 'a4' as name, 11 as _price, 1000 as ts\n           | ) s0\n           | on h0.id = s0._id\n           | when matched then update set\n           |   id = s0._id, name = s0.name, price = s0._price, ts = s0.ts\n           |").toString())).stripMargin());
        $this.validateTableSchema(tableName, (List<StructField>)structFields);
        $this.checkAnswer(new StringBuilder(44).append("select id, name, price, ts from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$53(TestMergeIntoTable $this, File tmp$8, String dataType) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(314).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  value ").append(dataType).append(",\n             |  ts int\n             |) using hudi\n             | location '").append(tmp$8.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  primaryKey ='id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(245).append("\n             |merge into ").append(tableName).append(" h0\n             |using (\n             | select 1 as id, 'a1' as name, cast(null as ").append(dataType).append(") as value, 1000 as ts\n             | ) s0\n             | on h0.id = s0.id\n             | when not matched then insert *\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", null, BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$52(TestMergeIntoTable $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        Seq types = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"string", "int", "bigint", "double", "float", "timestamp", "date", "decimal"}));
        types.foreach((Function1 & Serializable & scala.Serializable)dataType -> {
            TestMergeIntoTable.$anonfun$new$53($this, tmp, dataType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$57(TestMergeIntoTable $this, File tmp$9, Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            String dataType = (String)tuple2._1();
            String dataValue = (String)tuple2._2();
            String tableName = $this.generateTableName();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(314).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  value ").append(dataType).append(",\n             |  ts int\n             |) using hudi\n             | location '").append(tmp$9.getCanonicalPath()).append("/").append(tableName).append("'\n             | tblproperties (\n             |  primaryKey ='id',\n             |  preCombineField = 'ts'\n             | )\n       ").toString())).stripMargin());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(241).append("\n             |merge into ").append(tableName).append(" h0\n             |using (\n             | select 1 as id, 'a1' as name, cast(").append(dataValue).append(" as ").append(dataType).append(") as value, 1000 as ts\n             | ) s0\n             | on h0.id = s0.id\n             | when not matched then insert *\n             |").toString())).stripMargin());
            $this.checkAnswer(new StringBuilder(48).append("select id, name, cast(value as string), ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", $this.extractRawValue(dataValue), BoxesRunTime.boxToInteger((int)1000)}))}));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$56(TestMergeIntoTable $this, File tmp) {
        $this.spark().sql("set hoodie.payload.combined.schema.validate = true");
        Seq dataAndTypes = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"string", (Object)"'a1'"), new Tuple2((Object)"int", (Object)"10"), new Tuple2((Object)"bigint", (Object)"10"), new Tuple2((Object)"double", (Object)"10.0"), new Tuple2((Object)"float", (Object)"10.0"), new Tuple2((Object)"decimal(5,2)", (Object)"10.11"), new Tuple2((Object)"decimal(5,0)", (Object)"10"), new Tuple2((Object)"timestamp", (Object)"'2021-05-20 00:00:00'"), new Tuple2((Object)"date", (Object)"'2021-05-20'")}));
        dataAndTypes.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            TestMergeIntoTable.$anonfun$new$57($this, tmp, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$60(TestMergeIntoTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(295).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  value int,\n           |  ts int\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(204).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           | select 1 as id, 1001 as ts\n           | ) s0\n           | on h0.id = s0.id\n           | when matched then update set h0.ts = s0.ts\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1001)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$63(TestMergeIntoTable $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        String tableType = "mor";
        String logDataBlockFormat = "parquet";
        $this.withSparkSqlSessionConfig((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.ENABLE_MERGE_INTO_PARTIAL_UPDATES().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key()), (Object)logDataBlockFormat), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING.key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.key()), (Object)"2"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieClusteringConfig.PLAN_STRATEGY_SORT_COLUMNS.key()), (Object)"id,price")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(395).append("\n             | create table ").append(tableName).append(" (\n             |   id int,\n             |   name string,\n             |   price long,\n             |   ts long,\n             |   description string\n             | ) using hudi\n             | tblproperties(\n             |   type ='").append(tableType).append("',\n             |   primaryKey = 'id',\n             |   preCombineField = 'ts'\n             | )\n             | location '").append(basePath).append("'\n            ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(121).append("insert into ").append(tableName).append(" values ").append("(1, 'a1', 10, 1000, 'a1: desc1'),").append("(2, 'a2', 20, 1200, 'a2: desc2'), ").append("(3, 'a3', 30.0, 1250, 'a3: desc3')").toString());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(359).append("\n             | merge into ").append(tableName).append(" t0\n             | using (\n             |   select 1 as id, 'a1' as name1, 12 as price, 1001 as _ts\n             | union\n             |   select 3 as id, 'a3' as name1, 25 as price, 1260 as _ts\n             |   ) s0\n             | on t0.id = s0.id\n             | when matched then update set price = s0.price, ts = s0._ts\n          ").toString())).stripMargin());
            $this.checkAnswer(new StringBuilder(57).append("select id, name, price, ts, description from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)12), BoxesRunTime.boxToInteger((int)1001), "a1: desc1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)20), BoxesRunTime.boxToInteger((int)1200), "a2: desc2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToInteger((int)25), BoxesRunTime.boxToInteger((int)1260), "a3: desc3"}))}));
            Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.simpleMacroBool(((HoodieInstant)HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath).getActiveTimeline().lastInstant().get()).getAction().equals("replacecommit"), "org.apache.hudi.testutils.HoodieClientTestUtils.createMetaClient(TestMergeIntoTable.this.spark, basePath).getActiveTimeline().lastInstant().get().getAction().equals(\"replacecommit\")", Prettifier$.MODULE$.default());
            Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1384));
        });
    }

    public static final /* synthetic */ void $anonfun$new$67(TestMergeIntoTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(295).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  value int,\n           |  ts int\n           |) using hudi\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n           | tblproperties (\n           |  primaryKey ='id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(250).append("\n           |merge into ").append(tableName).append(" h0\n           |using (\n           |  select cast(1 as int) as id, 1004 as ts\n           | ) s0\n           | on cast(h0.id as string) = cast(s0.id as string)\n           | when matched then update set h0.ts = s0.ts\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, value, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)10), BoxesRunTime.boxToInteger((int)1004)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$72(TestMergeIntoTable $this, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(447).append("\n               | create table ").append(tableName).append(" (\n               |  id long,\n               |  name string,\n               |  price double,\n               |  ts long,\n               |  dt string\n               | ) using hudi\n               | tblproperties (\n               |  type = 'mor',\n               |  primaryKey = 'id',\n               |  precombineField = 'ts'\n               | )\n               | partitioned by(dt)\n               | location '").append(tmp.getCanonicalPath()).append("'\n           ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(50).append("insert into ").append(tableName).append(" select 1L, 'a1', 10, 1L, '2021-03-21'").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(599).append("\n               |MERGE INTO ").append(tableName).append(" AS t0\n               |USING (\n               |  SELECT 2L as id, 'a2' as name, 10 as price, 1L as ts, '2021-03-20' as dt\n               |  UNION\n               |  SELECT 1L as id, 'a3' as name, 11 as price, 1L as ts, '2021-03-21' as dt\n               |) s0\n               |ON s0.id = t0.id\n               |WHEN MATCHED THEN\n               |  UPDATE SET price = s0.price, name = s0.name, ts = s0.ts\n               |WHEN NOT MATCHED AND s0.id % 2 = 0 THEN\n               |  INSERT (id, name, dt, ts)\n               |  VALUES (s0.id, s0.name, s0.dt, s0.ts)\n               |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(48).append("select id, name, price, ts, dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)1L), "a3", BoxesRunTime.boxToInteger((int)11), BoxesRunTime.boxToLong((long)1L), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)2L), "a2", null, BoxesRunTime.boxToLong((long)1L), "2021-03-20"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$74(TestMergeIntoTable $this, Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            String tableType = (String)tuple2._1();
            boolean sparkSqlOptimizedWrites = tuple2._2$mcZ$sp();
            $this.log().info(new StringBuilder(83).append("=== Testing MergeInto with partial insert: tableType=").append(tableType).append(", sparkSqlOptimizedWrites=").append(sparkSqlOptimizedWrites).append(" ===").toString());
            $this.withRecordType($this.withRecordType$default$1(), $this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                $this.withSparkSqlSessionConfig((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.payload.combined.schema.validate"), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.SPARK_SQL_OPTIMIZED_WRITES().key()), (Object)Boolean.toString(sparkSqlOptimizedWrites))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String tableName = $this.generateTableName();
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(403).append("\n               | create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts bigint,\n               |  dt string\n               | ) using hudi\n               | tblproperties (\n               |  type = '").append(tableType$2).append("',\n               |  primaryKey = 'id'\n               | )\n               | partitioned by(dt)\n               | location '").append(tmp.getCanonicalPath()).append("'\n           ").toString())).stripMargin());
                    $this.spark().sql(new StringBuilder(49).append("insert into ").append(tableName).append(" select 1, 'a1', 10, 1L, '2021-03-21'").toString());
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(545).append("\n               | merge into ").append(tableName).append(" as t0\n               | using (\n               |  select 2 as id, 'a2' as name, 10 as price, 2L as ts, '2021-03-20' as dt\n               |  union\n               |  select 1 as id, 'a1_updated' as name, 11 as price, 3L as ts, '2021-03-21' as dt\n               | ) s0\n               | on s0.id = t0.id\n               | when matched then update set t0.id = s0.id, t0.name = s0.name\n               | when not matched and s0.id % 2 = 0 then insert (id, name, dt)\n               | values(s0.id, s0.name, s0.dt)\n           ").toString())).stripMargin());
                    $this.checkAnswer(new StringBuilder(44).append("select id, name, price, dt from ").append(tableName).append(" order by id").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1_updated", BoxesRunTime.boxToInteger((int)10), "2021-03-21"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", null, "2021-03-20"}))}));
                });
                return BoxedUnit.UNIT;
            }));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$new$80(TestMergeIntoTable $this, String tableType$3, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(329).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  dt string,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (primaryKey = 'id', type = '").append(tableType$3).append("')\n             | partitioned by (dt)\n             | location '").append(tmp.getCanonicalPath()).append("'\n             | ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(232).append("\n             | insert into ").append(tableName).append(" partition(dt = '2024-01-14')\n             | select 1 as id, 'a1' as name, 10 as price, 1000 as ts\n             | union\n             | select 2 as id, 'a2' as name, 20 as price, 1002 as ts\n             | ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2024-01-14"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1002), "2024-01-14"}))}));
        Tuple3[] targetTableFields = (Tuple3[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])$this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString()).schema().fields())).map((Function1 & Serializable & scala.Serializable)e -> new Tuple3((Object)e.name(), (Object)tableName, (Object)new StringBuilder(23).append("spark_catalog.default.").append(tableName).append(".").append(e.name()).toString()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple3.class)));
        Seq sourceTableFields = (Seq)((TraversableLike)new .colon.colon((Object)"s0._id", (List)new .colon.colon((Object)"s0._price", (List)new .colon.colon((Object)"s0._ts", (List)new .colon.colon((Object)"s0.dt", (List)new .colon.colon((Object)"s0.name", (List)Nil$.MODULE$)))))).map((Function1 & Serializable & scala.Serializable)e -> {
            String[] splits = new StringOps(Predef$.MODULE$.augmentString(e)).split('.');
            return new Tuple3((Object)splits[1], (Object)splits[0], e);
        }, Seq$.MODULE$.canBuildFrom());
        String sqlStatement1 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(487).append("\n             | merge into ").append(tableName).append("\n             | using (\n             |  select 2 as _id, '2024-01-14' as dt, 'a2_new' as name, 25 as _price, 1005 as _ts\n             |  union\n             |  select 3 as _id, '2024-01-14' as dt, 'a3' as name, 30 as _price, 1003 as _ts\n             | ) s0\n             | on s0._id = ").append(tableName).append(".id\n             | when matched then update set\n             | id = s0._id, dt = s0.dt, new_col = s0.name, price = s0._price + ").append(tableName).append(".price,\n             | ts = s0._ts\n             | ").toString())).stripMargin();
        String sqlStatement2 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(487).append("\n             | merge into ").append(tableName).append("\n             | using (\n             |  select 2 as _id, '2024-01-14' as dt, 'a2_new' as name, 25 as _price, 1005 as _ts\n             |  union\n             |  select 3 as _id, '2024-01-14' as dt, 'a3' as name, 30 as _price, 1003 as _ts\n             | ) s0\n             | on s0._id = ").append(tableName).append(".id\n             | when matched then update set\n             | id = s0._id, dt = s0.dt, name = s0.new_col, price = s0._price + ").append(tableName).append(".price,\n             | ts = s0._ts\n             | ").toString())).stripMargin();
        $this.checkExceptionContain(sqlStatement1, $this.getExpectedUnresolvedColumnExceptionMessage("new_col", (Seq<Tuple3<String, String, String>>)Predef$.MODULE$.wrapRefArray((Object[])targetTableFields)));
        $this.checkExceptionContain(sqlStatement2, $this.getExpectedUnresolvedColumnExceptionMessage("s0.new_col", (Seq<Tuple3<String, String, String>>)((Seq)sourceTableFields.$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])targetTableFields)), Seq$.MODULE$.canBuildFrom()))));
    }

    public static final /* synthetic */ void $anonfun$new$85(TestMergeIntoTable $this, String tableType$4, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(329).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  dt string,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (primaryKey = 'id', type = '").append(tableType$4).append("')\n             | partitioned by (dt)\n             | location '").append(tmp.getCanonicalPath()).append("'\n             | ").toString())).stripMargin());
        .colon.colon structFields = new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("price", (DataType)DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("ts", (DataType)LongType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("dt", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(232).append("\n             | insert into ").append(tableName).append(" partition(dt = '2024-01-14')\n             | select 1 as id, 'a1' as name, 10 as price, 1000 as ts\n             | union\n             | select 2 as id, 'a2' as name, 20 as price, 1002 as ts\n             | ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2024-01-14"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1002), "2024-01-14"}))}));
        String sqlStatement1 = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(538).append("\n             | merge into ").append(tableName).append("\n             | using (\n             |  select 2 as _id, '2024-01-14' as dt, 'a2_new' as name, 25 as _price, 1005 as _ts, 'x' as new_col\n             |  union\n             |  select 3 as _id, '2024-01-14' as dt, 'a3' as name, 30 as _price, 1003 as _ts, 'y' as new_col\n             | ) s0\n             | on s0._id = ").append(tableName).append(".id\n             | when matched then update set\n             | id = s0._id, dt = s0.dt, name = s0.name, price = s0._price + ").append(tableName).append(".price,\n             | ts = s0._ts, new_col = s0.new_col\n             | ").toString())).stripMargin();
        $this.checkExceptionContain(sqlStatement1, $this.getExpectedUnresolvedColumnExceptionMessage("new_col", tableName));
        $this.validateTableSchema(tableName, (List<StructField>)structFields);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(268).append("\n             | merge into ").append(tableName).append("\n             | using (\n             |  select 3 as id, '2024-01-14' as dt, 'a3' as name, 30 as price, 1003 as ts, 'y' as new_col\n             | ) s0\n             | on s0.id = ").append(tableName).append(".id\n             | when not matched then insert *\n             | ").toString())).stripMargin());
        $this.validateTableSchema(tableName, (List<StructField>)structFields);
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2024-01-14"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1002), "2024-01-14"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1003), "2024-01-14"}))}));
    }

    public TestMergeIntoTable() {
        ScalaAssertionSupport.$init$(this);
        this.log = LoggerFactory.getLogger((Class)this.getClass());
        this.test("Test MergeInto Basic", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)sparkSqlOptimizedWrites -> {
            this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                $this.withSparkSqlSessionConfig((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.payload.combined.schema.validate"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.metadata.index.column.stats.enable"), (Object)"false"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.metadata.index.partition.stats.enable"), (Object)"false")}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String tableName = $this.generateTableName();
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(421).append("\n               |create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts int,\n               |  partition string\n               |) using hudi\n               | partitioned by (partition)\n               | location '").append(tmp.getCanonicalPath()).append("'\n               | tblproperties (\n               |  primaryKey ='id',\n               |  preCombineField = 'ts'\n               | )\n       ").toString())).stripMargin());
                    $this.spark().sql(new StringBuilder(5).append("set ").append(DataSourceWriteOptions$.MODULE$.SPARK_SQL_OPTIMIZED_WRITES().key()).append("=").append(sparkSqlOptimizedWrites$1).toString());
                    .colon.colon structFields = new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("price", (DataType)DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("ts", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("partition", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(674).append("\n               | merge into ").append(tableName).append("\n               | using (\n               |  select 1 as id, 'a1' as name, 10 as price, 1000 as ts, 'p1' as partition, '1' as flag\n               |  union\n               |  select 2 as id, 'a2' as name, 20 as price, 1000 as ts, 'p2' as partition, '1' as flag\n               |  union\n               |  select 3 as id, 'a3' as name, 30 as price, 1000 as ts, 'p3' as partition, '1' as flag\n               | ) s0\n               | on s0.id = ").append(tableName).append(".id\n               | when matched and flag = '1' then update set\n               | id = s0.id, name = s0.name, price = s0.price, ts = s0.ts\n               | when not matched and flag = '1' then insert *\n       ").toString())).stripMargin());
                    $this.validateTableSchema(tableName, (List<StructField>)structFields);
                    $this.checkAnswer(new StringBuilder(43).append("select id, name, price, ts, partition from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "p1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000), "p2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1000), "p3"}))}));
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(353).append("\n               | merge into ").append(tableName).append("\n               | using (\n               |  select 1 as _id, 'a1' as name, 10 as _price, 1001 as _ts, 'p1' as partition\n               | ) s0\n               | on s0._id = ").append(tableName).append(".id\n               | when matched then update set\n               | id = s0._id, name = s0.name, price = s0._price + ").append(tableName).append(".price, ts = s0._ts\n               | ").toString())).stripMargin());
                    $this.validateTableSchema(tableName, (List<StructField>)structFields);
                    $this.checkAnswer(new StringBuilder(43).append("select id, name, price, ts, partition from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1001), "p1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000), "p2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1000), "p3"}))}));
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(575).append("\n               | merge into ").append(tableName).append("\n               | using (\n               |  select * from (\n               |  select 1 as id, 'a1' as name, 10 as price, 1002 as ts, 'p1' as partition\n               |  union all\n               |  select 4 as id, 'a4' as name, 40 as price, 1001 as ts, 'p4' as partition\n               |  )\n               | ) s0\n               | on s0.id = ").append(tableName).append(".id\n               | when matched then update set\n               | id = s0.id, name = s0.name, price = s0.price + ").append(tableName).append(".price, ts = s0.ts\n               | when not matched and s0.id % 2 = 0 then insert *\n       ").toString())).stripMargin());
                    $this.validateTableSchema(tableName, (List<StructField>)structFields);
                    $this.checkAnswer(new StringBuilder(43).append("select id, name, price, ts, partition from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1002), "p1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000), "p2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1000), "p3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)40.0), BoxesRunTime.boxToInteger((int)1001), "p4"}))}));
                    Tuple2<HoodieTableMetaClient, SyncableFileSystemView> tuple2 = HoodieSparkSqlTestBase$.MODULE$.getMetaClientAndFileSystemView(tmp.getCanonicalPath());
                    if (tuple2 == null) {
                        throw new MatchError(tuple2);
                    }
                    HoodieTableMetaClient metaClient = (HoodieTableMetaClient)tuple2._1();
                    SyncableFileSystemView fsv = (SyncableFileSystemView)tuple2._2();
                    Tuple2 tuple22 = new Tuple2((Object)metaClient, (Object)fsv);
                    HoodieTableMetaClient metaClient2 = (HoodieTableMetaClient)tuple22._1();
                    SyncableFileSystemView fsv2 = (SyncableFileSystemView)tuple22._2();
                    ((IterableLike)((TraversableLike)new .colon.colon((Object)"p2", (List)new .colon.colon((Object)"p3", (List)new .colon.colon((Object)"p4", (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)e -> new StringBuilder(10).append("partition=").append((String)e).toString(), Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)partition -> {
                        TestMergeIntoTable.$anonfun$new$7(fsv2, metaClient2, partition);
                        return BoxedUnit.UNIT;
                    });
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(449).append("\n               | merge into ").append(tableName).append("\n               | using (\n               |  select 1 as id, 'a1' as name, 12 as price, 1003 as ts, 'p1' as partition\n               | ) s0\n               | on s0.id = ").append(tableName).append(".id\n               | when matched and s0.id != 1 then update set\n               |    id = s0.id, name = s0.name, price = s0.price, ts = s0.ts\n               | when matched and s0.id = 1 then delete\n               | when not matched then insert *\n       ").toString())).stripMargin());
                    long cnt = $this.spark().sql(new StringBuilder(37).append("select * from ").append(tableName).append(" where partition = 'p1'").toString()).count();
                    $this.assertResult(BoxesRunTime.boxToInteger((int)0), BoxesRunTime.boxToLong((long)cnt), Prettifier$.MODULE$.default(), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 169));
                });
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 39));
        this.test("Test MergeInto with more than once update actions", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$11(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 181));
        this.test("Test Merge Into with Global Index", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.index.type"), (Object)"GLOBAL_BLOOM")}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    String targetTable = $this.generateTableName();
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(362).append("\n             |create table ").append(targetTable).append(" (\n             |  id int,\n             |  version int,\n             |  name string,\n             |  inc_day string\n             |) using hudi\n             |tblproperties (\n             |  type = 'cow',\n             |  primaryKey = 'id'\n             | )\n             |partitioned by (inc_day)\n             |location '").append(tmp.getCanonicalPath()).append("/").append(targetTable).append("'\n             |").toString())).stripMargin());
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(338).append("\n             |merge into ").append(targetTable).append(" as target\n             |using (\n             |select 1 as id, 1 as version, 'str_1' as name, '2023-10-01' as inc_day\n             |) source\n             |on source.id = target.id\n             |when matched then\n             |update set *\n             |when not matched then\n             |insert *\n             |").toString())).stripMargin());
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(338).append("\n             |merge into ").append(targetTable).append(" as target\n             |using (\n             |select 1 as id, 2 as version, 'str_2' as name, '2023-10-01' as inc_day\n             |) source\n             |on source.id = target.id\n             |when matched then\n             |update set *\n             |when not matched then\n             |insert *\n             |").toString())).stripMargin());
                    $this.checkAnswer(new StringBuilder(39).append("select id, version, name, inc_day from ").append(targetTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "str_2", "2023-10-01"}))}));
                    $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(338).append("\n             |merge into ").append(targetTable).append(" as target\n             |using (\n             |select 1 as id, 2 as version, 'str_2' as name, '2023-10-02' as inc_day\n             |) source\n             |on source.id = target.id\n             |when matched then\n             |update set *\n             |when not matched then\n             |insert *\n             |").toString())).stripMargin());
                    $this.checkAnswer(new StringBuilder(39).append("select id, version, name, inc_day from ").append(targetTable).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), BoxesRunTime.boxToInteger((int)2), "str_2", "2023-10-02"}))}));
                });
                return BoxedUnit.UNIT;
            }));
            this.spark().sessionState().conf().unsetConf("hoodie.index.type");
        }, new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 240));
        this.test("Test MergeInto with ignored record", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$18(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 310));
        this.test("Test MergeInto with changing partition and global index", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)updatePartitionPathEnabled -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                $this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.index.type"), (Object)"GLOBAL_SIMPLE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.simple.index.update.partition.path"), (Object)Boolean.toString(updatePartitionPathEnabled))}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
                    TestMergeIntoTable.$anonfun$new$23($this, tmp, updatePartitionPathEnabled$1, tableType);
                    return BoxedUnit.UNIT;
                }));
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 389));
        this.test("Test MergeInto for MOR table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable.$anonfun$new$25(this, tmp);
                return BoxedUnit.UNIT;
            });
        }, new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 472));
        this.test("Test MergeInto with insert only", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable.$anonfun$new$27(this, tmp);
                return BoxedUnit.UNIT;
            });
        }, new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 612));
        this.test("Test MergeInto For PreCombineField", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
            this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable.$anonfun$new$30(this, tmp);
                return BoxedUnit.UNIT;
            }));
        }, new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 668));
        this.test("Test MergeInto with preCombine field expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable.$anonfun$new$33(this, tmp);
                return BoxedUnit.UNIT;
            });
        }, new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 743));
        this.test("Test MergeInto with primaryKey expression", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$36(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 822));
        this.test("Test MergeInto with combination of delete update insert", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$39(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 912));
        this.test("Merge Hudi to Hudi", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
            this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable.$anonfun$new$42(this, tmp);
                return BoxedUnit.UNIT;
            }));
        }, new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 975));
        this.test("Test Different Type of PreCombineField", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$45(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1083));
        this.test("Test MergeInto For MOR With Compaction On", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
            this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable.$anonfun$new$49(this, tmp);
                return BoxedUnit.UNIT;
            }));
        }, new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1143));
        this.test("Test MereInto With Null Fields", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$52(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1204));
        this.test("Test MergeInto With All Kinds Of DataType", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$56(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1250));
        this.test("Test MergeInto with no-full fields source", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$60(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1297));
        this.test("Test partial insert with inline clustering", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$63(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1332));
        this.test("Test Merge Into with target matched columns cast-ed", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestMergeIntoTable.$anonfun$new$67(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1390));
        this.test("Test MergeInto with partial insert", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true, false}))).foreach((Function1 & Serializable & scala.Serializable)sparkSqlOptimizedWrites -> {
            this.withSparkSqlSessionConfig((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key())), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)String.valueOf(DataSourceWriteOptions$.MODULE$.SPARK_SQL_OPTIMIZED_WRITES().key())), (Object)String.valueOf(BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)sparkSqlOptimizedWrites))))}), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable.$anonfun$new$72($this, tmp);
                return BoxedUnit.UNIT;
            })));
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1427));
        this.test("Test MergeInto with partial update and insert", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
            Seq testConfigs = (Seq)new .colon.colon((Object)new Tuple2((Object)"cow", (Object)BoxesRunTime.boxToBoolean((boolean)true)), (List)new .colon.colon((Object)new Tuple2((Object)"cow", (Object)BoxesRunTime.boxToBoolean((boolean)false)), (List)Nil$.MODULE$));
            testConfigs.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                TestMergeIntoTable.$anonfun$new$74(this, x0$3);
                return BoxedUnit.UNIT;
            });
        }, new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1479));
        this.test("Test unresolved columns in Merge Into statement", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable.$anonfun$new$80($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1539));
        this.test("Test no schema evolution in MERGE INTO", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestMergeIntoTable.$anonfun$new$85($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestMergeIntoTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1614));
    }
}

