/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.dml;

import java.io.File;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.avro.Schema;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.HoodieLogFileReader;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001}3A\u0001C\u0005\u0001-!)Q\u0004\u0001C\u0001=!)\u0011\u0005\u0001C\u0001E!)a\u0007\u0001C\u0001o!)1\b\u0001C\u0001y!)q\b\u0001C\u0001\u0001\")\u0011\f\u0001C\u00015\")A\f\u0001C\u0001;\niB+Z:u!\u0006\u0014H/[1m+B$\u0017\r^3G_JlUM]4f\u0013:$xN\u0003\u0002\u000b\u0017\u0005\u0019A-\u001c7\u000b\u00051i\u0011\u0001\u00025vI&T!AD\b\u0002\u0007M\fHN\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0007CB\f7\r[3\u000b\u0003Q\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\f\u0011\u0005aYR\"A\r\u000b\u0005iY\u0011AB2p[6|g.\u0003\u0002\u001d3\t1\u0002j\\8eS\u0016\u001c\u0006/\u0019:l'FdG+Z:u\u0005\u0006\u001cX-\u0001\u0004=S:LGO\u0010\u000b\u0002?A\u0011\u0001\u0005A\u0007\u0002\u0013\u00059C/Z:u!\u0006\u0014H/[1m+B$\u0017\r^3XSRDgj\u001c8Fq&\u001cH/\u001a8u\u0007>dW/\u001c8t)\t\u0019\u0013\u0006\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0003V]&$\b\"\u0002\u0016\u0003\u0001\u0004Y\u0013!\u0003;bE2,G+\u001f9f!\ta3G\u0004\u0002.cA\u0011a&J\u0007\u0002_)\u0011\u0001'F\u0001\u0007yI|w\u000e\u001e \n\u0005I*\u0013A\u0002)sK\u0012,g-\u0003\u00025k\t11\u000b\u001e:j]\u001eT!AM\u0013\u0002#Q,7\u000f\u001e)beRL\u0017\r\\+qI\u0006$X\rF\u0002$qeBQAK\u0002A\u0002-BQAO\u0002A\u0002-\n!\u0003\\8h\t\u0006$\u0018M\u00117pG.4uN]7bi\u0006aB/Z:u!\u0006\u0014H/[1m+B$\u0017\r^3XSRD\u0017J\\:feR\u001cHcA\u0012>}!)!\u0006\u0002a\u0001W!)!\b\u0002a\u0001W\u0005\u0001b/\u00197jI\u0006$X\rT8h\u00052|7m\u001b\u000b\u0006G\u0005\u001b\u0005\n\u0016\u0005\u0006\u0005\u0016\u0001\raK\u0001\tE\u0006\u001cX\rU1uQ\")A)\u0002a\u0001\u000b\u0006\u0011R\r\u001f9fGR,GMT;n\u0019><g)\u001b7f!\t!c)\u0003\u0002HK\t\u0019\u0011J\u001c;\t\u000b%+\u0001\u0019\u0001&\u0002\u001b\rD\u0017M\\4fI\u001aKW\r\u001c3t!\rY\u0005k\u0015\b\u0003\u0019:s!AL'\n\u0003\u0019J!aT\u0013\u0002\u000fA\f7m[1hK&\u0011\u0011K\u0015\u0002\u0004'\u0016\f(BA(&!\rY\u0005k\u000b\u0005\u0006+\u0016\u0001\rAV\u0001\nSN\u0004\u0016M\u001d;jC2\u0004\"\u0001J,\n\u0005a+#a\u0002\"p_2,\u0017M\\\u0001\u001bm\u0006d\u0017\u000eZ1uK\u000ecWo\u001d;fe&tw-\u0012=fGV$X\r\u001a\u000b\u0003GmCQA\u0011\u0004A\u0002-\n!D^1mS\u0012\fG/Z\"p[B\f7\r^5p]\u0016CXmY;uK\u0012$\"a\t0\t\u000b\t;\u0001\u0019A\u0016")
public class TestPartialUpdateForMergeInto
extends HoodieSparkSqlTestBase {
    public void testPartialUpdateWithNonExistentColumns(String tableType) {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestPartialUpdateForMergeInto.$anonfun$testPartialUpdateWithNonExistentColumns$1(this, tableType, tmp);
            return BoxedUnit.UNIT;
        });
    }

    public void testPartialUpdate(String tableType, String logDataBlockFormat) {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestPartialUpdateForMergeInto.$anonfun$testPartialUpdate$1(this, logDataBlockFormat, tableType, tmp);
            return BoxedUnit.UNIT;
        });
    }

    public void testPartialUpdateWithInserts(String tableType, String logDataBlockFormat) {
        this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestPartialUpdateForMergeInto.$anonfun$testPartialUpdateWithInserts$1(this, logDataBlockFormat, tableType, tmp);
            return BoxedUnit.UNIT;
        });
    }

    public void validateLogBlock(String basePath, int expectedNumLogFile, Seq<Seq<String>> changedFields, boolean isPartial) {
        Tuple2<HoodieTableMetaClient, SyncableFileSystemView> tuple2 = HoodieSparkSqlTestBase$.MODULE$.getMetaClientAndFileSystemView(basePath);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)tuple2._1();
        SyncableFileSystemView fsView = (SyncableFileSystemView)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)metaClient, (Object)fsView);
        HoodieTableMetaClient metaClient2 = (HoodieTableMetaClient)tuple22._1();
        SyncableFileSystemView fsView2 = (SyncableFileSystemView)tuple22._2();
        Optional<FileSlice> fileSlice2 = fsView2.getAllFileSlices("").filter(fileSlice -> HoodieTestUtils.getLogFileListFromFileSlice((FileSlice)fileSlice).size() == expectedNumLogFile).findFirst();
        Assertions.assertTrue((boolean)fileSlice2.isPresent());
        java.util.List logFilePathList = HoodieTestUtils.getLogFileListFromFileSlice((FileSlice)fileSlice2.get());
        Collections.sort(logFilePathList);
        Schema avroSchema = new TableSchemaResolver(metaClient2).getTableAvroSchema();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), expectedNumLogFile).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            HoodieLogFileReader logReader = new HoodieLogFileReader(metaClient2.getStorage(), new HoodieLogFile((String)logFilePathList.get(i)), avroSchema, 0x100000, false, false, "id", null);
            Assertions.assertTrue((boolean)logReader.hasNext());
            Map logBlockHeader = logReader.next().getLogBlockHeader();
            Assertions.assertTrue((boolean)logBlockHeader.containsKey(HoodieLogBlock.HeaderMetadataType.SCHEMA));
            if (isPartial) {
                Assertions.assertTrue((boolean)logBlockHeader.containsKey(HoodieLogBlock.HeaderMetadataType.IS_PARTIAL));
                Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString((String)logBlockHeader.get(HoodieLogBlock.HeaderMetadataType.IS_PARTIAL))).toBoolean());
            } else {
                Assertions.assertFalse((boolean)logBlockHeader.containsKey(HoodieLogBlock.HeaderMetadataType.IS_PARTIAL));
            }
            Schema actualSchema = new Schema.Parser().parse((String)logBlockHeader.get(HoodieLogBlock.HeaderMetadataType.SCHEMA));
            Schema expectedSchema = HoodieAvroUtils.addMetadataFields((Schema)HoodieAvroUtils.generateProjectionSchema((Schema)avroSchema, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)changedFields.apply(i)).asJava())), (boolean)false);
            Assertions.assertEquals((Object)expectedSchema, (Object)actualSchema);
        });
    }

    public void validateClusteringExecuted(String basePath) {
        StorageConfiguration storageConf = HoodieTestUtils.getDefaultStorageConf();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(storageConf).setBasePath(basePath).build();
        HoodieInstant lastCommit = (HoodieInstant)metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().get();
        Assertions.assertEquals((Object)"replacecommit", (Object)lastCommit.getAction());
    }

    public void validateCompactionExecuted(String basePath) {
        StorageConfiguration storageConf = HoodieTestUtils.getDefaultStorageConf();
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(storageConf).setBasePath(basePath).build();
        HoodieInstant lastCommit = (HoodieInstant)metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().get();
        Assertions.assertEquals((Object)"commit", (Object)lastCommit.getAction());
        CompactionUtils.getCompactionPlan((HoodieTableMetaClient)metaClient, (String)lastCommit.requestedTime());
    }

    public static final /* synthetic */ void $anonfun$new$10(TestPartialUpdateForMergeInto $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
        $this.spark().sql(new StringBuilder(11).append("set ").append(DataSourceWriteOptions$.MODULE$.ENABLE_MERGE_INTO_PARTIAL_UPDATES().key()).append(" = true").toString());
        $this.spark().sql(new StringBuilder(11).append("set ").append(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key()).append(" = true").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(350).append("\n           |create table ").append(tableName).append(" (\n           | id int,\n           | name string,\n           | price double,\n           | _ts int,\n           | description string\n           |) using hudi\n           |tblproperties(\n           | type ='mor',\n           | primaryKey = 'id',\n           | preCombineField = '_ts'\n           |)\n           |location '").append(basePath).append("'\n        ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(119).append("insert into ").append(tableName).append(" values (1, 'a1', 10, 1000, 'a1: desc1'),").append("(2, 'a2', 20, 1200, 'a2: desc2'), (3, 'a3', 30, 1250, 'a3: desc3')").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(324).append("\n           |merge into ").append(tableName).append(" t0\n           |using ( select 1 as id, 'a1' as name, 12 as price, 1001 as _ts, 'a1: updated' as description\n           |union select 3 as id, 'a3' as name, 25 as price, 1260 as _ts, 'a3: updated' as description) s0\n           |on t0.id = s0.id\n           |when matched then update set *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(46).append("select id, name, price, _ts, description from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1001), "a1: updated"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1200), "a2: desc2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)25.0), BoxesRunTime.boxToInteger((int)1260), "a3: updated"}))}));
        $this.validateLogBlock(basePath, 1, (Seq<Seq<String>>)((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"_ts", (List)new .colon.colon((Object)"description", (List)Nil$.MODULE$)))))), (List)Nil$.MODULE$)), false);
    }

    public static final /* synthetic */ void $anonfun$new$12(TestPartialUpdateForMergeInto $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
        $this.spark().sql(new StringBuilder(11).append("set ").append(DataSourceWriteOptions$.MODULE$.ENABLE_MERGE_INTO_PARTIAL_UPDATES().key()).append(" = true").toString());
        $this.spark().sql(new StringBuilder(11).append("set ").append(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key()).append(" = true").toString());
        $this.spark().sql(new StringBuilder(15).append("set ").append(HoodieIndexConfig.INDEX_TYPE.key()).append(" = INMEMORY").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(350).append("\n           |create table ").append(tableName).append(" (\n           | id int,\n           | name string,\n           | price double,\n           | _ts int,\n           | description string\n           |) using hudi\n           |tblproperties(\n           | type ='mor',\n           | primaryKey = 'id',\n           | preCombineField = '_ts'\n           |)\n           |location '").append(basePath).append("'\n        ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(119).append("insert into ").append(tableName).append(" values (1, 'a1', 10, 1000, 'a1: desc1'),").append("(2, 'a2', 20, 1200, 'a2: desc2'), (3, 'a3', 30, 1250, 'a3: desc3')").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(425).append("\n           |merge into ").append(tableName).append(" t0\n           |using ( select 1 as id, 'a1' as name, 12 as price, 1001 as _ts, 'a1: updated' as description\n           |union select 3 as id, 'a3' as name, 25 as price, 1260 as _ts, 'a3: updated' as description\n           |union select 4 as id, 'a4' as name, 60 as price, 1270 as _ts, 'a4: desc4' as description) s0\n           |on t0.id = s0.id\n           |when not matched then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(46).append("select id, name, price, _ts, description from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "a1: desc1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1200), "a2: desc2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)30.0), BoxesRunTime.boxToInteger((int)1250), "a3: desc3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)60.0), BoxesRunTime.boxToInteger((int)1270), "a4: desc4"}))}));
        $this.validateLogBlock(basePath, 2, (Seq<Seq<String>>)((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"_ts", (List)new .colon.colon((Object)"description", (List)Nil$.MODULE$)))))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)"id", (List)new .colon.colon((Object)"name", (List)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"_ts", (List)new .colon.colon((Object)"description", (List)Nil$.MODULE$)))))), (List)Nil$.MODULE$))), false);
    }

    public static final /* synthetic */ void $anonfun$testPartialUpdateWithNonExistentColumns$1(TestPartialUpdateForMergeInto $this, String tableType$1, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
        $this.spark().sql(new StringBuilder(11).append("set ").append(DataSourceWriteOptions$.MODULE$.ENABLE_MERGE_INTO_PARTIAL_UPDATES().key()).append(" = true").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(347).append("\n           |create table ").append(tableName).append(" (\n           | id int,\n           | name string,\n           | price double,\n           | _ts int,\n           | description string\n           |) using hudi\n           |tblproperties(\n           | type ='").append(tableType$1).append("',\n           | primaryKey = 'id',\n           | preCombineField = '_ts'\n           |)\n           |location '").append(basePath).append("'\n        ").toString())).stripMargin());
        .colon.colon structFields = new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("price", (DataType)DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("_ts", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("description", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
        $this.spark().sql(new StringBuilder(119).append("insert into ").append(tableName).append(" values (1, 'a1', 10, 1000, 'a1: desc1'),").append("(2, 'a2', 20, 1200, 'a2: desc2'), (3, 'a3', 30, 1250, 'a3: desc3')").toString());
        $this.validateTableSchema(tableName, (List<StructField>)structFields);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(326).append("\n           |merge into ").append(tableName).append(" t0\n           |using ( select 1 as id, 'a1' as name, 12.0 as price, 1001 as ts, 'x' as new_col\n           |union select 3 as id, 'a3' as name, 25.0 as price, 1260 as ts, 'y' as new_col) s0\n           |on t0.id = s0.id\n           |when matched then update set price = s0.price, _ts = s0.ts\n           |").toString())).stripMargin());
        $this.validateTableSchema(tableName, (List<StructField>)structFields);
        $this.checkAnswer(new StringBuilder(46).append("select id, name, price, _ts, description from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1001), "a1: desc1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1200), "a2: desc2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)25.0), BoxesRunTime.boxToInteger((int)1260), "a3: desc3"}))}));
        $this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(343).append("\n           |merge into ").append(tableName).append("\n           |using ( select 1 as id, 'a1' as name, 12.0 as price, 1001 as ts, 'x' as new_col\n           |union select 3 as id, 'a3' as name, 25.0 as price, 1260 as ts, 'y' as new_col) s0\n           |on ").append(tableName).append(".id = s0.id\n           |when matched then update set price = s0.price, _ts = s0.ts, new_col = s0.new_col\n           |").toString())).stripMargin(), $this.getExpectedUnresolvedColumnExceptionMessage("new_col", tableName));
    }

    public static final /* synthetic */ void $anonfun$testPartialUpdate$1(TestPartialUpdateForMergeInto $this, String logDataBlockFormat$1, String tableType$2, File tmp) {
        BoxedUnit boxedUnit;
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
        $this.spark().sql(new StringBuilder(11).append("set ").append(DataSourceWriteOptions$.MODULE$.ENABLE_MERGE_INTO_PARTIAL_UPDATES().key()).append(" = true").toString());
        $this.spark().sql(new StringBuilder(7).append("set ").append(HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key()).append(" = ").append(logDataBlockFormat$1).toString());
        $this.spark().sql(new StringBuilder(11).append("set ").append(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key()).append(" = true").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(347).append("\n           |create table ").append(tableName).append(" (\n           | id int,\n           | name string,\n           | price double,\n           | _ts int,\n           | description string\n           |) using hudi\n           |tblproperties(\n           | type ='").append(tableType$2).append("',\n           | primaryKey = 'id',\n           | preCombineField = '_ts'\n           |)\n           |location '").append(basePath).append("'\n        ").toString())).stripMargin());
        .colon.colon structFields = new .colon.colon((Object)new StructField("id", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("name", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("price", (DataType)DoubleType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("_ts", (DataType)IntegerType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)new .colon.colon((Object)new StructField("description", (DataType)StringType$.MODULE$, true, StructField$.MODULE$.apply$default$4()), (List)Nil$.MODULE$)))));
        $this.spark().sql(new StringBuilder(119).append("insert into ").append(tableName).append(" values (1, 'a1', 10, 1000, 'a1: desc1'),").append("(2, 'a2', 20, 1200, 'a2: desc2'), (3, 'a3', 30, 1250, 'a3: desc3')").toString());
        $this.validateTableSchema(tableName, (List<StructField>)structFields);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(294).append("\n           |merge into ").append(tableName).append(" t0\n           |using ( select 1 as id, 'a1' as name, 12.0 as price, 1001 as ts\n           |union select 3 as id, 'a3' as name, 25.0 as price, 1260 as ts) s0\n           |on t0.id = s0.id\n           |when matched then update set price = s0.price, _ts = s0.ts\n           |").toString())).stripMargin());
        $this.validateTableSchema(tableName, (List<StructField>)structFields);
        $this.checkAnswer(new StringBuilder(46).append("select id, name, price, _ts, description from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1001), "a1: desc1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1200), "a2: desc2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)25.0), BoxesRunTime.boxToInteger((int)1260), "a3: desc3"}))}));
        if (tableType$2.equals("mor")) {
            $this.validateLogBlock(basePath, 1, (Seq<Seq<String>>)((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"_ts", (List)Nil$.MODULE$))), (List)Nil$.MODULE$)), true);
        }
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(363).append("\n           |merge into ").append(tableName).append(" t0\n           |using ( select 1 as id, 'a1' as name, 'a1: updated desc1' as new_description, 1023 as _ts\n           |union select 2 as id, 'a2' as name, 'a2: updated desc2' as new_description, 1270 as _ts) s0\n           |on t0.id = s0.id\n           |when matched then update set description = s0.new_description, _ts = s0._ts\n           |").toString())).stripMargin());
        $this.validateTableSchema(tableName, (List<StructField>)structFields);
        $this.checkAnswer(new StringBuilder(46).append("select id, name, price, _ts, description from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1023), "a1: updated desc1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1270), "a2: updated desc2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)25.0), BoxesRunTime.boxToInteger((int)1260), "a3: desc3"}))}));
        if (tableType$2.equals("mor")) {
            $this.validateLogBlock(basePath, 2, (Seq<Seq<String>>)((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"_ts", (List)Nil$.MODULE$))), (List)new .colon.colon((Object)((Seq)new .colon.colon((Object)"_ts", (List)new .colon.colon((Object)"description", (List)Nil$.MODULE$))), (List)Nil$.MODULE$))), true);
            $this.spark().sql(new StringBuilder(8).append("set ").append(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()).append(" = 3").toString());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(314).append("\n             |merge into ").append(tableName).append(" t0\n             |using ( select 2 as id, '_a2' as name, 18.0 as _price, 1275 as _ts\n             |union select 3 as id, '_a3' as name, 28.0 as _price, 1280 as _ts) s0\n             |on t0.id = s0.id\n             |when matched then update set price = s0._price, _ts = s0._ts\n             |").toString())).stripMargin());
            $this.validateCompactionExecuted(basePath);
            $this.validateTableSchema(tableName, (List<StructField>)structFields);
            $this.checkAnswer(new StringBuilder(46).append("select id, name, price, _ts, description from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1023), "a1: updated desc1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)18.0), BoxesRunTime.boxToInteger((int)1275), "a2: updated desc2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)28.0), BoxesRunTime.boxToInteger((int)1280), "a3: desc3"}))}));
            $this.spark().sql(new StringBuilder(11).append("set ").append(HoodieClusteringConfig.INLINE_CLUSTERING.key()).append(" = true").toString());
            $this.spark().sql(new StringBuilder(8).append("set ").append(HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.key()).append(" = 3").toString());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(314).append("\n             |merge into ").append(tableName).append(" t0\n             |using ( select 2 as id, '_a2' as name, 48.0 as _price, 1275 as _ts\n             |union select 3 as id, '_a3' as name, 58.0 as _price, 1280 as _ts) s0\n             |on t0.id = s0.id\n             |when matched then update set price = s0._price, _ts = s0._ts\n             |").toString())).stripMargin());
            $this.validateClusteringExecuted(basePath);
            $this.validateTableSchema(tableName, (List<StructField>)structFields);
            $this.checkAnswer(new StringBuilder(46).append("select id, name, price, _ts, description from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1023), "a1: updated desc1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)48.0), BoxesRunTime.boxToInteger((int)1275), "a2: updated desc2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)58.0), BoxesRunTime.boxToInteger((int)1280), "a3: desc3"}))}));
            $this.spark().sql(new StringBuilder(7).append("set ").append(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.key()).append(" = ").append(HoodieCompactionConfig.INLINE_COMPACT_NUM_DELTA_COMMITS.defaultValue()).toString());
            $this.spark().sql(new StringBuilder(7).append("set ").append(HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.key()).append(" = ").append(HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.defaultValue()).toString());
            boxedUnit = $this.spark().sql(new StringBuilder(7).append("set ").append(HoodieClusteringConfig.INLINE_CLUSTERING.key()).append(" = ").append(HoodieClusteringConfig.INLINE_CLUSTERING.defaultValue()).toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        if (tableType$2.equals("cow")) {
            String tableName2 = $this.generateTableName();
            String basePath2 = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName2).toString();
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(274).append("\n             |create table ").append(tableName2).append(" (\n             | id int,\n             | name string,\n             | price double\n             |) using hudi\n             |tblproperties(\n             | type ='").append(tableType$2).append("',\n             | primaryKey = 'id'\n             |)\n             |location '").append(basePath2).append("'\n        ").toString())).stripMargin());
            $this.spark().sql(new StringBuilder(32).append("insert into ").append(tableName2).append(" values(1, 'a1', 10)").toString());
            $this.spark().sql(new StringBuilder(11).append("set ").append(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key()).append(" = true").toString());
            $this.spark().sql(new StringBuilder(11).append("set ").append(HoodieClusteringConfig.INLINE_CLUSTERING.key()).append(" = true").toString());
            $this.spark().sql(new StringBuilder(8).append("set ").append(HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.key()).append(" = 1").toString());
            $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(205).append("\n             |merge into ").append(tableName2).append(" t0\n             |using ( select 1 as id, 'a2' as name, 12.0 as price) s0\n             |on t0.id = s0.id\n             |when matched then update set price = s0.price\n             |").toString())).stripMargin());
            $this.validateClusteringExecuted(basePath2);
            $this.checkAnswer(new StringBuilder(28).append("select id, name, price from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)12.0)}))}));
            $this.spark().sql(new StringBuilder(7).append("set ").append(HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.key()).append(" = ").append(HoodieClusteringConfig.INLINE_CLUSTERING_MAX_COMMITS.defaultValue()).toString());
            $this.spark().sql(new StringBuilder(7).append("set ").append(HoodieClusteringConfig.INLINE_CLUSTERING.key()).append(" = ").append(HoodieClusteringConfig.INLINE_CLUSTERING.defaultValue()).toString());
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$testPartialUpdateWithInserts$1(TestPartialUpdateForMergeInto $this, String logDataBlockFormat$2, String tableType$3, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringBuilder(8).append("set ").append(HoodieWriteConfig.MERGE_SMALL_FILE_GROUP_CANDIDATES_LIMIT.key()).append(" = 0").toString());
        $this.spark().sql(new StringBuilder(11).append("set ").append(DataSourceWriteOptions$.MODULE$.ENABLE_MERGE_INTO_PARTIAL_UPDATES().key()).append(" = true").toString());
        $this.spark().sql(new StringBuilder(7).append("set ").append(HoodieStorageConfig.LOGFILE_DATA_BLOCK_FORMAT.key()).append(" = ").append(logDataBlockFormat$2).toString());
        $this.spark().sql(new StringBuilder(11).append("set ").append(HoodieReaderConfig.FILE_GROUP_READER_ENABLED.key()).append(" = true").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(347).append("\n           |create table ").append(tableName).append(" (\n           | id int,\n           | name string,\n           | price double,\n           | _ts int,\n           | description string\n           |) using hudi\n           |tblproperties(\n           | type ='").append(tableType$3).append("',\n           | primaryKey = 'id',\n           | preCombineField = '_ts'\n           |)\n           |location '").append(basePath).append("'\n        ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(119).append("insert into ").append(tableName).append(" values (1, 'a1', 10, 1000, 'a1: desc1'),").append("(2, 'a2', 20, 1200, 'a2: desc2'), (3, 'a3', 30, 1250, 'a3: desc3')").toString());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(475).append("\n           |merge into ").append(tableName).append(" t0\n           |using ( select 1 as id, 'a1' as name, 12 as price, 1001 as _ts, '' as description\n           |union select 3 as id, 'a3' as name, 25 as price, 1260 as _ts, '' as description\n           |union select 4 as id, 'a4' as name, 70 as price, 1270 as _ts, 'a4: desc4' as description) s0\n           |on t0.id = s0.id\n           |when matched then update set price = s0.price, _ts = s0._ts\n           |when not matched then insert *\n           |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(46).append("select id, name, price, _ts, description from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)12.0), BoxesRunTime.boxToInteger((int)1001), "a1: desc1"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1200), "a2: desc2"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)25.0), BoxesRunTime.boxToInteger((int)1260), "a3: desc3"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)70.0), BoxesRunTime.boxToInteger((int)1270), "a4: desc4"}))}));
        if (tableType$3.equals("mor")) {
            $this.validateLogBlock(basePath, 1, (Seq<Seq<String>>)((Seq)new .colon.colon((Object)((Seq)new .colon.colon((Object)"price", (List)new .colon.colon((Object)"_ts", (List)Nil$.MODULE$))), (List)Nil$.MODULE$)), true);
            return;
        }
    }

    public static final /* synthetic */ void $anonfun$new$18(TestPartialUpdateForMergeInto $this, int tableVersion$1, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(686).append("\n             | CREATE TABLE ").append(tableName).append(" (\n             |   record_key STRING,\n             |   name STRING,\n             |   age INT,\n             |   department STRING,\n             |   salary DOUBLE,\n             |   ts BIGINT\n             | ) USING hudi\n             | PARTITIONED BY (department)\n             | LOCATION '").append(tmp.getCanonicalPath()).append("'\n             | TBLPROPERTIES (\n             |   type = 'mor',\n             |   hoodie.write.table.version = '").append(tableVersion$1).append("',\n             |   hoodie.index.type = 'GLOBAL_SIMPLE',\n             |   hoodie.index.global.index.enable = 'true',\n             |   hoodie.bloom.index.use.metadata = 'true',\n             |   primaryKey = 'record_key',\n             |   preCombineField = 'ts')").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(460).append("\n             | INSERT INTO ").append(tableName).append("\n             | SELECT * FROM (\n             |   SELECT 'emp_001' as record_key, 'John Doe' as name, 30 as age,\n             |          'Sales' as department, 80000.0 as salary, 1598886000 as ts\n             |   UNION ALL\n             |   SELECT 'emp_002', 'Jane Smith', 28, 'Sales', 75000.0, 1598886001\n             |   UNION ALL\n             |   SELECT 'emp_003', 'Bob Wilson', 35, 'Marketing', 85000.0, 1598886002\n             |)").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(136).append("\n             | UPDATE ").append(tableName).append("\n             | SET\n             |     ts = 1598000000\n             | WHERE record_key = 'emp_001'\n             |").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString("\n             | CREATE OR REPLACE TEMPORARY VIEW source_updates AS\n             | SELECT * FROM (\n             |   SELECT 'emp_001' as record_key, 'John Doe' as name, 30 as age,\n             |          'Engineering' as department, CAST(95000.0 as DOUBLE) as salary, cast(1598886200 as BIGINT) as ts\n             |   UNION ALL\n             |   SELECT 'emp_004', 'Alice Brown', 29, 'Engineering', CAST(82000.0 as DOUBLE), cast(1598886201 as BIGINT)\n             |)")).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(396).append("\n             | MERGE INTO ").append(tableName).append(" t\n             | USING source_updates s\n             | ON t.record_key = s.record_key\n             | WHEN MATCHED THEN\n             |   UPDATE SET\n             |     record_key = s.record_key,\n             |     department = s.department,\n             |     salary = s.salary,\n             |     ts = s.ts\n             | WHEN NOT MATCHED THEN\n             |   INSERT *").toString())).stripMargin());
    }

    public TestPartialUpdateForMergeInto() {
        this.test("Test partial update with COW and Avro log format", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPartialUpdate("cow", "avro"), new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 45));
        this.test("Test partial update with MOR and Avro log format", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPartialUpdate("mor", "avro"), new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 49));
        this.test("Test partial update with MOR and Parquet log format", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPartialUpdate("mor", "parquet"), new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 53));
        this.test("Test partial update and insert with COW and Avro log format", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPartialUpdateWithInserts("cow", "avro"), new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 57));
        this.test("Test partial update and insert with MOR and Avro log format", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPartialUpdateWithInserts("mor", "avro"), new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 61));
        this.test("Test partial update and insert with MOR and Parquet log format", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPartialUpdateWithInserts("mor", "parquet"), new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 65));
        this.test("Test partial update with schema on read enabled", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceReadOptions$.MODULE$.SCHEMA_EVOLUTION_ENABLED().key()), (Object)"true")}), (Function0 & Serializable & scala.Serializable)() -> {
            try {
                this.testPartialUpdate("mor", "parquet");
                throw this.fail("Expected exception to be thrown", new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 73));
            }
            catch (Throwable t) {
                Assertions.assertTrue((boolean)(t instanceof HoodieNotSupportedException));
                return BoxedUnit.UNIT;
            }
        }), new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 69));
        this.test("Test fallback to full update with MOR even if partial updates are enabled", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestPartialUpdateForMergeInto.$anonfun$new$10(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        this.test("Test MERGE INTO with inserts only on MOR table when partial updates are enabled", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestPartialUpdateForMergeInto.$anonfun$new$12(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 128));
        this.test("Test MERGE INTO with partial updates containing non-existent columns on COW table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPartialUpdateWithNonExistentColumns("cow"), new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184));
        this.test("Test MERGE INTO with partial updates containing non-existent columns on MOR table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.testPartialUpdateWithNonExistentColumns("mor"), new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
        this.test("Test MergeInto Exception", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> {
            String tableName = this.generateTableName();
            this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(264).append("\n         |create table ").append(tableName).append(" (\n         | id int,\n         | name string,\n         | price double,\n         | _ts long\n         |) using hudi\n         |tblproperties(\n         | type = 'cow',\n         | primaryKey = 'id',\n         | preCombineField = '_ts'\n         |)").toString())).stripMargin());
            String failedToResolveErrorMessage = "Failed to resolve precombine field `_ts` w/in the source-table output";
            this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(179).append("\n         |merge into ").append(tableName).append(" t0\n         |using ( select 1 as id, 'a1' as name, 12 as price) s0\n         |on t0.id = s0.id\n         |when matched then update set price = s0.price\n      ").toString())).stripMargin(), failedToResolveErrorMessage);
            String tableName2 = this.generateTableName();
            return this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(264).append("\n         |create table ").append(tableName2).append(" (\n         | id int,\n         | name string,\n         | price double,\n         | _ts long\n         |) using hudi\n         |tblproperties(\n         | type = 'mor',\n         | primaryKey = 'id',\n         | preCombineField = '_ts'\n         |)").toString())).stripMargin());
        }, new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 483));
        this.test("Partial updates for table version 6 and 8 handled gracefully in MIT", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{HoodieTableVersion.SIX.versionCode(), HoodieTableVersion.EIGHT.versionCode()}))).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)tableVersion -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestPartialUpdateForMergeInto.$anonfun$new$18(this, tableVersion, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 525));
        this.test("Test MergeInto Partial Updates should fail with CUSTOM payload and merge mode", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.index.type"), (Object)"GLOBAL_SIMPLE"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.write.record.merge.mode"), (Object)"CUSTOM"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.datasource.write.payload.class"), (Object)"org.apache.hudi.common.testutils.reader.HoodieRecordTestPayload")}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                String tableName = $this.generateTableName();
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(463).append("\n             | CREATE TABLE ").append(tableName).append(" (\n             |   record_key STRING,\n             |   name STRING,\n             |   age INT,\n             |   department STRING,\n             |   salary DOUBLE,\n             |   ts BIGINT\n             | ) USING hudi\n             | PARTITIONED BY (department)\n             | LOCATION '").append(tmp.getCanonicalPath()).append("'\n             | TBLPROPERTIES (\n             |   type = 'mor',\n             |   primaryKey = 'record_key',\n             |   preCombineField = 'ts')").toString())).stripMargin());
                $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(460).append("\n             | INSERT INTO ").append(tableName).append("\n             | SELECT * FROM (\n             |   SELECT 'emp_001' as record_key, 'John Doe' as name, 30 as age,\n             |          'Sales' as department, 80000.0 as salary, 1598886000 as ts\n             |   UNION ALL\n             |   SELECT 'emp_002', 'Jane Smith', 28, 'Sales', 75000.0, 1598886001\n             |   UNION ALL\n             |   SELECT 'emp_003', 'Bob Wilson', 35, 'Marketing', 85000.0, 1598886002\n             |)").toString())).stripMargin());
                String failedToResolveError = "MERGE INTO field resolution error: No matching assignment found for target table";
                $this.checkExceptionContain(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(261).append("\n             |merge into ").append(tableName).append(" t0\n             |using ( SELECT 'emp_001' as record_key, 'John Doe' as name, 35 as age, cast(1598886200 as BIGINT) as ts) s0\n             |on t0.record_key = s0.record_key\n             |when matched then update set age = s0.age\n      ").toString())).stripMargin(), failedToResolveError);
            });
            return BoxedUnit.UNIT;
        }), new Position("TestPartialUpdateForMergeInto.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 597));
    }
}

