/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.dml;

import java.io.File;
import java.io.Serializable;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001m1AAA\u0002\u0001!!)q\u0003\u0001C\u00011\t\u0019B+Z:u)&lW\r\u0016:bm\u0016dG+\u00192mK*\u0011A!B\u0001\u0004I6d'B\u0001\u0004\b\u0003\u0011AW\u000fZ5\u000b\u0005!I\u0011aA:rY*\u0011!bC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00195\ta!\u00199bG\",'\"\u0001\b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0005\u0001\t\u0002C\u0001\n\u0016\u001b\u0005\u0019\"B\u0001\u000b\u0006\u0003\u0019\u0019w.\\7p]&\u0011ac\u0005\u0002\u0017\u0011>|G-[3Ta\u0006\u00148nU9m)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012!\u0007\t\u00035\u0001i\u0011a\u0001")
public class TestTimeTravelTable
extends HoodieSparkSqlTestBase {
    public static final /* synthetic */ void $anonfun$new$4(TestTimeTravelTable $this, String tableType$1, File tmp) {
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(349).append("\n             |create table ").append(tableName1).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = '").append(tableType$1).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName1).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName1).append(" values(1, 'a1', 10, 1000)").toString());
        HoodieTableMetaClient metaClient1 = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName1).toString());
        String instant1 = ((HoodieInstant)metaClient1.getActiveTimeline().getAllCommitsTimeline().lastInstant().get()).requestedTime();
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName1).append(" values(1, 'a2', 20, 2000)").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)2000)}))}));
        $this.checkAnswer(new StringBuilder(51).append("select id, name, price, ts from ").append(tableName1).append(" TIMESTAMP AS OF '").append(instant1).append("'").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$7(TestTimeTravelTable $this, String tableType$2, File tmp) {
        String tableName1 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(349).append("\n             |create table ").append(tableName1).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = '").append(tableType$2).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName1).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName1).append(" values(1, 'a1', 10, 1000)").toString());
        HoodieTableMetaClient metaClient1 = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName1).toString());
        String instant1 = ((HoodieInstant)metaClient1.getActiveTimeline().getAllCommitsTimeline().lastInstant().get()).requestedTime();
        String tableName2 = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(322).append("\n             |create table ").append(tableName2).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long,\n             |  dt string\n             |) using hudi\n             | tblproperties (primaryKey = 'id', type = '").append(tableType$2).append("')\n             | partitioned by (dt)\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName2).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(139).append("\n             | insert into ").append(tableName2).append("\n             | select id, name, price, ts, '2022-02-14' as dt\n             | from ").append(tableName1).append(" TIMESTAMP AS OF '").append(instant1).append("'\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2022-02-14"}))}));
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(161).append("\n             | insert into ").append(tableName2).append(" partition(dt = '2022-02-15')\n             | select 2 as id, 'a2' as name, price, ts\n             | from ").append(tableName1).append(" TIMESTAMP AS OF '").append(instant1).append("'\n        ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(36).append("select id, name, price, ts, dt from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2022-02-14"})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), "2022-02-15"}))}));
    }

    public static final /* synthetic */ void $anonfun$new$11(TestTimeTravelTable $this, File tmp$1, String tableType) {
        String tableName = $this.generateTableName();
        String basePath = tmp$1.getCanonicalPath();
        String tableName1 = new StringBuilder(2).append(tableName).append("_1").toString();
        String tableName2 = new StringBuilder(2).append(tableName).append("_2").toString();
        String path1 = new StringBuilder(1).append(basePath).append("/").append(tableName1).toString();
        String path2 = new StringBuilder(1).append(basePath).append("/").append(tableName2).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(348).append("\n             |create table ").append(tableName1).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | location '").append(path1).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(348).append("\n             |create table ").append(tableName2).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = '").append(tableType).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | location '").append(path2).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName1).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName1).append(" values(2, 'a2', 20, 1000)").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName1).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName2).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName2).append(" values(4, 'a4', 20, 1000)").toString());
        $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName2).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        HoodieTableMetaClient metaClient1 = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)path1);
        HoodieTableMetaClient metaClient2 = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)path2);
        String instant1 = ((HoodieInstant)metaClient1.getActiveTimeline().getAllCommitsTimeline().lastInstant().get()).requestedTime();
        String instant2 = ((HoodieInstant)metaClient2.getActiveTimeline().getAllCommitsTimeline().lastInstant().get()).requestedTime();
        String sql = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(189).append("\n             |select id, name, price, ts from ").append(tableName1).append(" TIMESTAMP AS OF '").append(instant1).append("' where id=1\n             |union\n             |select id, name, price, ts from ").append(tableName2).append(" TIMESTAMP AS OF '").append(instant2).append("' where id>1\n             |").toString())).stripMargin();
        $this.checkAnswer(sql, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)3), "a3", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)4), "a4", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$10(TestTimeTravelTable $this, File tmp) {
        ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            TestTimeTravelTable.$anonfun$new$11($this, tmp, tableType);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$13(TestTimeTravelTable $this, File dir) {
        String path = dir.toURI().getPath();
        $this.spark().sql(new StringBuilder(58).append("insert overwrite local directory '").append(path).append("' using parquet select 1").toString());
    }

    public static final /* synthetic */ void $anonfun$new$16(TestTimeTravelTable $this, String tableType$3, File tmp) {
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(349).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | tblproperties (\n             |  type = '").append(tableType$3).append("',\n             |  primaryKey = 'id',\n             |  preCombineField = 'ts'\n             | )\n             | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString());
        String instant1 = ((HoodieInstant)metaClient.getActiveTimeline().getAllCommitsTimeline().lastInstant().get()).requestedTime();
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a2', 20, 2000)").toString());
        $this.checkAnswer(new StringBuilder(70).append("select id, name, price, ts from ").append(tableName).append(" distribute by cast(rand() * 2 as int)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a2", BoxesRunTime.boxToDouble((double)20.0), BoxesRunTime.boxToInteger((int)2000)}))}));
        $this.checkAnswer(new StringBuilder(89).append("select id, name, price, ts from ").append(tableName).append(" TIMESTAMP AS OF '").append(instant1).append("' distribute by cast(rand() * 2 as int)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
    }

    public static final /* synthetic */ void $anonfun$new$19(TestTimeTravelTable $this, File tmp) {
        $this.spark().sql("set hoodie.schema.on.read.enable=true");
        String tableName = $this.generateTableName();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(300).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n           | location '").append(tmp.getCanonicalPath()).append("/").append(tableName).append("'\n       ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString());
        String instant1 = ((HoodieInstant)metaClient.reloadActiveTimeline().getAllCommitsTimeline().lastInstant().get()).requestedTime();
        $this.spark().sql(new StringBuilder(41).append("alter table ").append(tableName).append(" add columns (company string)").toString());
        $this.spark().sql(new StringBuilder(46).append("insert into ").append(tableName).append(" values(2, 'a2', 11, 1100, 'hudi')").toString());
        String instant2 = ((HoodieInstant)metaClient.reloadActiveTimeline().getAllCommitsTimeline().lastInstant().get()).requestedTime();
        $this.spark().sql(new StringBuilder(30).append("alter table ").append(tableName).append(" drop column price").toString());
        Row[] result1 = (Row[])$this.spark().sql(new StringBuilder(43).append("select * from ").append(tableName).append(" timestamp as of ").append(instant1).append(" order by id").toString()).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_commit_time", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_partition_path", "_hoodie_file_name"})).collect();
        $this.checkAnswer(result1, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
        Row[] result2 = (Row[])$this.spark().sql(new StringBuilder(43).append("select * from ").append(tableName).append(" timestamp as of ").append(instant2).append(" order by id").toString()).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_commit_time", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_partition_path", "_hoodie_file_name"})).collect();
        $this.checkAnswer(result2, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToDouble((double)11.0), BoxesRunTime.boxToInteger((int)1100), "hudi"}))}));
        Row[] result3 = (Row[])$this.spark().sql(new StringBuilder(26).append("select * from ").append(tableName).append(" order by id").toString()).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_commit_time", "_hoodie_commit_seqno", "_hoodie_record_key", "_hoodie_partition_path", "_hoodie_file_name"})).collect();
        $this.checkAnswer(result3, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)1000), null})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)2), "a2", BoxesRunTime.boxToInteger((int)1100), "hudi"}))}));
    }

    public TestTimeTravelTable() {
        this.test("Test Insert and Update Record with time travel", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestTimeTravelTable.$anonfun$new$4($this, tableType, tmp);
                return BoxedUnit.UNIT;
            }));
            return BoxedUnit.UNIT;
        }), new Position("TestTimeTravelTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 25));
        this.test("Test Insert Into Records with time travel To new Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestTimeTravelTable.$anonfun$new$7($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestTimeTravelTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        this.test("Test Two Table's Union Join with time travel", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestTimeTravelTable.$anonfun$new$10(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestTimeTravelTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        this.test("Test Unsupported syntax can be parsed", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.checkAnswer("select 1 distribute by 1", (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))}));
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)dir -> {
                TestTimeTravelTable.$anonfun$new$13(this, dir);
                return BoxedUnit.UNIT;
            });
        }, new Position("TestTimeTravelTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 224));
        this.test("Test Select Record with time travel and Repartition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestTimeTravelTable.$anonfun$new$16($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestTimeTravelTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 234));
        this.test("Test Time Travel With Schema Evolution", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withRecordType(this.withRecordType$default$1(), this.withRecordType$default$2(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestTimeTravelTable.$anonfun$new$19(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestTimeTravelTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 277));
    }
}

