/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.feature;

import java.io.File;
import java.io.Serializable;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.cdc.HoodieCDCSupplementalLoggingMode;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameReader;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.apache.spark.sql.types.StructType;
import org.junit.jupiter.api.Assertions;
import org.scalactic.Bool;
import org.scalactic.Bool$;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t4A!\u0002\u0004\u0001'!)!\u0004\u0001C\u00017!)a\u0004\u0001C\u0001?!9\u0011\nAI\u0001\n\u0003Q\u0005\"B+\u0001\t\u00031&A\u0005+fgR\u001cEi\u0011$peN\u0003\u0018M]6T#2S!a\u0002\u0005\u0002\u000f\u0019,\u0017\r^;sK*\u0011\u0011BC\u0001\u0005QV$\u0017N\u0003\u0002\f\u0019\u0005\u00191/\u001d7\u000b\u00055q\u0011!B:qCJ\\'BA\b\u0011\u0003\u0019\t\u0007/Y2iK*\t\u0011#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003C\u0001\u0007G>lWn\u001c8\n\u0005e1\"A\u0006%p_\u0012LWm\u00159be.\u001c\u0016\u000f\u001c+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005a\u0002CA\u000f\u0001\u001b\u00051\u0011\u0001D2eG\u0012\u000bG/\u0019$sC6,G\u0003\u0002\u00113}\u0011\u0003\"!I\u0018\u000f\u0005\tjcBA\u0012-\u001d\t!3F\u0004\u0002&U9\u0011a%K\u0007\u0002O)\u0011\u0001FE\u0001\u0007yI|w\u000e\u001e \n\u0003EI!a\u0004\t\n\u00055q\u0011BA\u0006\r\u0013\tq#\"A\u0004qC\u000e\\\u0017mZ3\n\u0005A\n$!\u0003#bi\u00064%/Y7f\u0015\tq#\u0002C\u00034\u0005\u0001\u0007A'\u0001\u0005cCN,\u0007+\u0019;i!\t)4H\u0004\u00027sA\u0011ae\u000e\u0006\u0002q\u0005)1oY1mC&\u0011!hN\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;o!)qH\u0001a\u0001\u0001\u0006Q1\u000f^1si&tw\rV:\u0011\u0005\u0005\u0013U\"A\u001c\n\u0005\r;$\u0001\u0002'p]\u001eDq!\u0012\u0002\u0011\u0002\u0003\u0007a)\u0001\u0005f]\u0012Lgn\u001a+t!\r\tu\tQ\u0005\u0003\u0011^\u0012aa\u00149uS>t\u0017AF2eG\u0012\u000bG/\u0019$sC6,G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0003-S#A\u0012',\u00035\u0003\"AT*\u000e\u0003=S!\u0001U)\u0002\u0013Ut7\r[3dW\u0016$'B\u0001*8\u0003)\tgN\\8uCRLwN\\\u0005\u0003)>\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\t7o]3si\u000e#5i\u00149D]R$Ra\u0016.]=\u0002\u0004\"!\u0011-\n\u0005e;$\u0001B+oSRDQa\u0017\u0003A\u0002\u0001\nqa\u00193d\t\u0006$\u0018\rC\u0003^\t\u0001\u0007\u0001)A\tfqB,7\r^3e\u0013:\u001cXM\u001d;D]RDQa\u0018\u0003A\u0002\u0001\u000b\u0011#\u001a=qK\u000e$X\rZ+qI\u0006$Xm\u00118u\u0011\u0015\tG\u00011\u0001A\u0003I)\u0007\u0010]3di\u0016$G)\u001a7fi\u0016$7I\u001c;")
public class TestCDCForSparkSQL
extends HoodieSparkSqlTestBase {
    public Dataset<Row> cdcDataFrame(String basePath, long startingTs, Option<Object> endingTs) {
        DataFrameReader reader = this.spark().read().format("hudi").option(DataSourceReadOptions$.MODULE$.QUERY_TYPE().key(), DataSourceReadOptions$.MODULE$.QUERY_TYPE_INCREMENTAL_OPT_VAL()).option(DataSourceReadOptions$.MODULE$.INCREMENTAL_FORMAT().key(), DataSourceReadOptions$.MODULE$.INCREMENTAL_FORMAT_CDC_VAL()).option(DataSourceReadOptions$.MODULE$.START_COMMIT().key(), Long.toString(startingTs));
        endingTs.foreach((Function1 & Serializable & scala.Serializable)ts -> reader.option(DataSourceReadOptions$.MODULE$.END_COMMIT().key(), Long.toString(BoxesRunTime.unboxToLong((Object)ts))));
        return reader.load(basePath);
    }

    public Option<Object> cdcDataFrame$default$3() {
        return None$.MODULE$;
    }

    public void assertCDCOpCnt(Dataset<Row> cdcData, long expectedInsertCnt, long expectedUpdateCnt, long expectedDeletedCnt) {
        Assertions.assertEquals((long)expectedInsertCnt, (long)cdcData.where("op = 'i'").count());
        Assertions.assertEquals((long)expectedUpdateCnt, (long)cdcData.where("op = 'u'").count());
        Assertions.assertEquals((long)expectedDeletedCnt, (long)cdcData.where("op = 'd'").count());
    }

    public static final /* synthetic */ void $anonfun$new$3(TestCDCForSparkSQL $this, String tableType$1, File tmp) {
        String databaseName = "hudi_database";
        $this.spark().sql(new StringBuilder(30).append("create database if not exists ").append(databaseName).toString());
        $this.spark().sql(new StringBuilder(4).append("use ").append(databaseName).toString());
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(515).append("\n             | create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             | ) using hudi\n             | partitioned by (name)\n             | tblproperties (\n             |   'primaryKey' = 'id',\n             |   'preCombineField' = 'ts',\n             |   'hoodie.table.cdc.enabled' = 'true',\n             |   'hoodie.table.cdc.supplemental.logging.mode' = '").append(HoodieCDCSupplementalLoggingMode.DATA_BEFORE_AFTER).append("',\n             |   type = '").append(tableType$1).append("'\n             | )\n             | location '").append(basePath).append("'\n      ").toString())).stripMargin());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        $this.spark().sql(new StringBuilder(60).append("insert into ").append(tableName).append(" values (1, 11, 1000, 'a1'), (2, 12, 1000, 'a2')").toString());
        long $org_scalatest_assert_macro_left = $this.spark().sql(new StringBuilder(30).append("select _hoodie_file_name from ").append(tableName).toString()).distinct().count();
        int $org_scalatest_assert_macro_right = 2;
        Bool $org_scalatest_assert_macro_expr = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right), $org_scalatest_assert_macro_left == (long)$org_scalatest_assert_macro_right, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr, (Object)"", Prettifier$.MODULE$.default(), new Position("TestCDCForSparkSQL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 80));
        Object fgForID1 = ((Row)$this.spark().sql(new StringBuilder(41).append("select _hoodie_file_name from ").append(tableName).append(" where id=1").toString()).head()).get(0);
        String commitTime1 = ((HoodieInstant)metaClient.reloadActiveTimeline().lastInstant().get()).requestedTime();
        Dataset<Row> cdcDataOnly1 = $this.cdcDataFrame(basePath, new StringOps(Predef$.MODULE$.augmentString(commitTime1)).toLong() - 1L, $this.cdcDataFrame$default$3());
        cdcDataOnly1.show(false);
        $this.assertCDCOpCnt(cdcDataOnly1, 2L, 0L, 0L);
        $this.spark().sql(new StringBuilder(25).append("delete from ").append(tableName).append(" where id = 1").toString());
        Dataset<Row> cdcDataOnly2 = $this.cdcDataFrame(basePath, new StringOps(Predef$.MODULE$.augmentString(commitTime1)).toLong(), $this.cdcDataFrame$default$3());
        $this.assertCDCOpCnt(cdcDataOnly2, 0L, 0L, 1L);
        long $org_scalatest_assert_macro_left2 = $this.spark().sql(new StringBuilder(30).append("select _hoodie_file_name from ").append(tableName).toString()).distinct().count();
        int $org_scalatest_assert_macro_right2 = 1;
        Bool $org_scalatest_assert_macro_expr2 = Bool$.MODULE$.binaryMacroBool((Object)BoxesRunTime.boxToLong((long)$org_scalatest_assert_macro_left2), "==", (Object)BoxesRunTime.boxToInteger((int)$org_scalatest_assert_macro_right2), $org_scalatest_assert_macro_left2 == (long)$org_scalatest_assert_macro_right2, Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr2, (Object)"", Prettifier$.MODULE$.default(), new Position("TestCDCForSparkSQL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 90));
        Bool $org_scalatest_assert_macro_expr3 = Bool$.MODULE$.notBool(Bool$.MODULE$.simpleMacroBool(((Row)$this.spark().sql(new StringBuilder(30).append("select _hoodie_file_name from ").append(tableName).toString()).head()).get(0).equals(fgForID1), "TestCDCForSparkSQL.this.spark.sql(scala.StringContext.apply(\"select _hoodie_file_name from \", \"\").s(tableName)).head().get(0).equals(fgForID1)", Prettifier$.MODULE$.default()), Prettifier$.MODULE$.default());
        Assertions$.MODULE$.assertionsHelper().macroAssert($org_scalatest_assert_macro_expr3, (Object)"", Prettifier$.MODULE$.default(), new Position("TestCDCForSparkSQL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 91));
    }

    public static final /* synthetic */ void $anonfun$new$7(TestCDCForSparkSQL $this, String tableType$2, HoodieCDCSupplementalLoggingMode loggingMode$1, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringBuilder(11).append("set ").append(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key()).append("=upsert").toString());
        String string = tableType$2;
        String string2 = "mor";
        String otherTableProperties = !(string != null ? !string.equals(string2) : string2 != null) ? "'hoodie.compact.inline'='true', 'hoodie.compact.inline.max.delta.commits'='2'," : "";
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(528).append("\n               | create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long\n               | ) using hudi\n               | tblproperties (\n               |   'primaryKey' = 'id',\n               |   'preCombineField' = 'ts',\n               |   'hoodie.table.cdc.enabled' = 'true',\n               |   'hoodie.table.cdc.supplemental.logging.mode' = '").append(loggingMode$1.name()).append("',\n               |   ").append(otherTableProperties).append("\n               |   type = '").append(tableType$2).append("'\n               | )\n               | location '").append(basePath).append("'\n        ").toString())).stripMargin());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        $this.spark().sql(new StringBuilder(81).append("insert into ").append(tableName).append(" values (1, 'a1', 11, 1000), (2, 'a2', 12, 1000), (3, 'a3', 13, 1000)").toString());
        String commitTime1 = ((HoodieInstant)metaClient.reloadActiveTimeline().lastInstant().get()).requestedTime();
        Dataset<Row> cdcDataOnly1 = $this.cdcDataFrame(basePath, new StringOps(Predef$.MODULE$.augmentString(commitTime1)).toLong() - 1L, $this.cdcDataFrame$default$3());
        cdcDataOnly1.show(false);
        $this.assertCDCOpCnt(cdcDataOnly1, 3L, 0L, 0L);
        $this.spark().sql(new StringBuilder(42).append("insert into ").append(tableName).append(" values (1, 'a1_v2', 11, 1100)").toString());
        String commitTime2 = ((HoodieInstant)metaClient.reloadActiveTimeline().lastInstant().get()).requestedTime();
        Dataset<Row> cdcDataOnly2 = $this.cdcDataFrame(basePath, new StringOps(Predef$.MODULE$.augmentString(commitTime1)).toLong(), $this.cdcDataFrame$default$3());
        cdcDataOnly2.show(false);
        $this.assertCDCOpCnt(cdcDataOnly2, 0L, 1L, 0L);
        StructType originSchema = $this.spark().read().format("hudi").load(basePath).schema();
        Row[] change2 = (Row[])cdcDataOnly2.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("op"), functions$.MODULE$.from_json(functions$.MODULE$.col("before"), originSchema).as("before"), functions$.MODULE$.from_json(functions$.MODULE$.col("after"), originSchema).as("after")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("op"), functions$.MODULE$.col("after.id"), functions$.MODULE$.col("before.name"), functions$.MODULE$.col("before.price"), functions$.MODULE$.col("after.name"), functions$.MODULE$.col("after.price")})).collect();
        $this.checkAnswer(change2, (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"u", BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToInteger((int)11), "a1_v2", BoxesRunTime.boxToInteger((int)11)}))}));
        $this.spark().sql(new StringBuilder(50).append("update ").append(tableName).append(" set name = 'a2_v2', ts = 1200 where id = 2").toString());
        String commitTime3 = ((HoodieInstant)metaClient.reloadActiveTimeline().lastInstant().get()).requestedTime();
        Dataset<Row> cdcDataOnly3 = $this.cdcDataFrame(basePath, new StringOps(Predef$.MODULE$.augmentString(commitTime2)).toLong(), $this.cdcDataFrame$default$3());
        cdcDataOnly3.show(false);
        $this.assertCDCOpCnt(cdcDataOnly3, 0L, 1L, 0L);
        $this.spark().sql(new StringBuilder(25).append("delete from ").append(tableName).append(" where id = 3").toString());
        String commitTime4 = ((HoodieInstant)metaClient.reloadActiveTimeline().lastInstant().get()).requestedTime();
        Dataset<Row> cdcDataOnly4 = $this.cdcDataFrame(basePath, new StringOps(Predef$.MODULE$.augmentString(commitTime3)).toLong(), $this.cdcDataFrame$default$3());
        cdcDataOnly4.show(false);
        $this.assertCDCOpCnt(cdcDataOnly4, 0L, 0L, 1L);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(557).append("\n               | merge into ").append(tableName).append("\n               | using (\n               |  select * from (\n               |  select 1 as id, 'a1_v3' as name, cast(11 as double) as price, cast(1300 as long) as ts\n               |  union all\n               |  select 4 as id, 'a4' as name, cast(14 as double) as price, cast(1300 as long) as ts\n               |  )\n               | ) s0\n               | on s0.id = ").append(tableName).append(".id\n               | when matched then update set id = s0.id, name = s0.name, price = s0.price, ts = s0.ts\n               | when not matched then insert *\n        ").toString())).stripMargin());
        String commitTime5 = ((HoodieInstant)metaClient.reloadActiveTimeline().lastInstant().get()).requestedTime();
        Dataset<Row> cdcDataOnly5 = $this.cdcDataFrame(basePath, new StringOps(Predef$.MODULE$.augmentString(commitTime4)).toLong(), $this.cdcDataFrame$default$3());
        cdcDataOnly5.show(false);
        $this.assertCDCOpCnt(cdcDataOnly5, 1L, 1L, 0L);
        Row[] change5 = (Row[])cdcDataOnly5.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("op"), functions$.MODULE$.from_json(functions$.MODULE$.col("before"), originSchema).as("before"), functions$.MODULE$.from_json(functions$.MODULE$.col("after"), originSchema).as("after")})).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("op"), functions$.MODULE$.col("after.id"), functions$.MODULE$.col("before.name"), functions$.MODULE$.col("before.price"), functions$.MODULE$.col("after.name"), functions$.MODULE$.col("after.price")})).collect();
        $this.checkAnswer((Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])change5)).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.getInt(1)), (Ordering)Ordering.Int$.MODULE$), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"u", BoxesRunTime.boxToInteger((int)1), "a1_v2", BoxesRunTime.boxToInteger((int)11), "a1_v3", BoxesRunTime.boxToInteger((int)11)})), (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"i", BoxesRunTime.boxToInteger((int)4), null, null, "a4", BoxesRunTime.boxToInteger((int)14)}))}));
        Dataset<Row> totalCdcData = $this.cdcDataFrame(basePath, new StringOps(Predef$.MODULE$.augmentString(commitTime1)).toLong() - 1L, $this.cdcDataFrame$default$3());
        $this.assertCDCOpCnt(totalCdcData, 4L, 3L, 1L);
    }

    public static final /* synthetic */ void $anonfun$new$5(TestCDCForSparkSQL $this, String tableType) {
        ((IterableLike)new .colon.colon((Object)HoodieCDCSupplementalLoggingMode.OP_KEY_ONLY, (List)new .colon.colon((Object)HoodieCDCSupplementalLoggingMode.DATA_BEFORE, (List)new .colon.colon((Object)HoodieCDCSupplementalLoggingMode.DATA_BEFORE_AFTER, (List)Nil$.MODULE$)))).foreach((Function1 & Serializable & scala.Serializable)loggingMode -> {
            $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestCDCForSparkSQL.$anonfun$new$7($this, tableType$2, loggingMode, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$new$12(TestCDCForSparkSQL $this, HoodieCDCSupplementalLoggingMode loggingMode$2, String tableType$3, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(576).append("\n               | create table ").append(tableName).append(" (\n               |  id int,\n               |  name string,\n               |  price double,\n               |  ts long,\n               |  pt string\n               | ) using hudi\n               | partitioned by (pt)\n               | tblproperties (\n               |   'primaryKey' = 'id',\n               |   'preCombineField' = 'ts',\n               |   'hoodie.table.cdc.enabled' = 'true',\n               |   'hoodie.table.cdc.supplemental.logging.mode' = '").append(loggingMode$2.name()).append("',\n               |   'type' = '").append(tableType$3).append("'\n               | )\n               | location '").append(basePath).append("'\n        ").toString())).stripMargin());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)basePath);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(183).append("\n               | insert into ").append(tableName).append(" values\n               | (1, 'a1', 11, 1000, '2021'),\n               | (2, 'a2', 12, 1000, '2022'),\n               | (3, 'a3', 13, 1000, '2022')\n        ").toString())).stripMargin());
        String commitTime1 = ((HoodieInstant)metaClient.reloadActiveTimeline().lastInstant().get()).requestedTime();
        Dataset<Row> cdcDataOnly1 = $this.cdcDataFrame(basePath, new StringOps(Predef$.MODULE$.augmentString(commitTime1)).toLong() - 1L, $this.cdcDataFrame$default$3());
        cdcDataOnly1.show(false);
        $this.assertCDCOpCnt(cdcDataOnly1, 3L, 0L, 0L);
        $this.spark().sql(new StringBuilder(77).append("insert overwrite table ").append(tableName).append(" partition (pt = '2021') values (1, 'a1_v2', 11, 1100)").toString());
        String commitTime2 = ((HoodieInstant)metaClient.reloadActiveTimeline().lastInstant().get()).requestedTime();
        Dataset<Row> cdcDataOnly2 = $this.cdcDataFrame(basePath, new StringOps(Predef$.MODULE$.augmentString(commitTime2)).toLong() - 1L, $this.cdcDataFrame$default$3());
        cdcDataOnly2.show(false);
        $this.assertCDCOpCnt(cdcDataOnly2, 1L, 0L, 1L);
        $this.spark().sql(new StringBuilder(50).append("update ").append(tableName).append(" set name = 'a2_v2', ts = 1200 where id = 2").toString());
        String commitTime3 = ((HoodieInstant)metaClient.reloadActiveTimeline().lastInstant().get()).requestedTime();
        Dataset<Row> cdcDataOnly3 = $this.cdcDataFrame(basePath, new StringOps(Predef$.MODULE$.augmentString(commitTime3)).toLong() - 1L, $this.cdcDataFrame$default$3());
        cdcDataOnly3.show(false);
        $this.assertCDCOpCnt(cdcDataOnly3, 0L, 1L, 0L);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(597).append("\n               | merge into ").append(tableName).append("\n               | using (\n               |  select * from (\n               |  select 1 as id, 'a1_v3' as name, cast(11 as double) as price, cast(1300 as long) as ts, \"2021\" as pt\n               |  union all\n               |  select 4 as id, 'a4' as name, cast(14 as double) as price, cast(1300 as long) as ts, \"2022\" as pt\n               |  )\n               | ) s0\n               | on s0.id = ").append(tableName).append(".id\n               | when matched then update set id = s0.id, name = s0.name, price = s0.price, ts = s0.ts, pt = s0.pt\n               | when not matched then insert *\n        ").toString())).stripMargin());
        String commitTime4 = ((HoodieInstant)metaClient.reloadActiveTimeline().lastInstant().get()).requestedTime();
        Dataset<Row> cdcDataOnly4 = $this.cdcDataFrame(basePath, new StringOps(Predef$.MODULE$.augmentString(commitTime4)).toLong() - 1L, $this.cdcDataFrame$default$3());
        cdcDataOnly4.show(false);
        $this.assertCDCOpCnt(cdcDataOnly4, 1L, 1L, 0L);
        Dataset<Row> totalCdcData = $this.cdcDataFrame(basePath, new StringOps(Predef$.MODULE$.augmentString(commitTime1)).toLong() - 1L, $this.cdcDataFrame$default$3());
        $this.assertCDCOpCnt(totalCdcData, 5L, 2L, 1L);
    }

    public static final /* synthetic */ void $anonfun$new$10(TestCDCForSparkSQL $this, String tableType) {
        ((IterableLike)new .colon.colon((Object)HoodieCDCSupplementalLoggingMode.OP_KEY_ONLY, (List)new .colon.colon((Object)HoodieCDCSupplementalLoggingMode.DATA_BEFORE, (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)loggingMode -> {
            $this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestCDCForSparkSQL.$anonfun$new$12($this, loggingMode, tableType$3, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
    }

    public TestCDCForSparkSQL() {
        this.test("Test delete all records in filegroup", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
            this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
                TestCDCForSparkSQL.$anonfun$new$3($this, tableType, tmp);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        }), new Position("TestCDCForSparkSQL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 52));
        this.test("Test Non-Partitioned Hoodie Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String databaseName = "hudi_database";
            this.spark().sql(new StringBuilder(30).append("create database if not exists ").append(databaseName).toString());
            this.spark().sql(new StringBuilder(4).append("use ").append(databaseName).toString());
            ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
                TestCDCForSparkSQL.$anonfun$new$5(this, tableType);
                return BoxedUnit.UNIT;
            });
            this.spark().sessionState().conf().unsetConf(DataSourceWriteOptions$.MODULE$.SPARK_SQL_INSERT_INTO_OPERATION().key());
        }, new Position("TestCDCForSparkSQL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 99));
        this.test("Test Partitioned Hoodie Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            String databaseName = "hudi_database";
            this.spark().sql(new StringBuilder(30).append("create database if not exists ").append(databaseName).toString());
            this.spark().sql(new StringBuilder(4).append("use ").append(databaseName).toString());
            ((IterableLike)new .colon.colon((Object)"cow", (List)new .colon.colon((Object)"mor", (List)Nil$.MODULE$))).foreach((Function1 & Serializable & scala.Serializable)tableType -> {
                TestCDCForSparkSQL.$anonfun$new$10(this, tableType);
                return BoxedUnit.UNIT;
            });
        }, new Position("TestCDCForSparkSQL.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 226));
    }
}

