/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.feature;

import java.io.File;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001Y2Aa\u0001\u0003\u0001#!)\u0001\u0004\u0001C\u00013!)A\u0004\u0001C\u0001;\t\u0011C+Z:u#V,'/_'fe\u001e,wJ\u001c*fC\u0012|\u0005\u000f^5nSj,G\rV1cY\u0016T!!\u0002\u0004\u0002\u000f\u0019,\u0017\r^;sK*\u0011q\u0001C\u0001\u0005QV$\u0017N\u0003\u0002\n\u0015\u0005\u00191/\u001d7\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001%A\u00111CF\u0007\u0002))\u0011QCB\u0001\u0007G>lWn\u001c8\n\u0005]!\"A\u0006%p_\u0012LWm\u00159be.\u001c\u0016\u000f\u001c+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005Q\u0002CA\u000e\u0001\u001b\u0005!\u0011!E1tg\u0016\u0014H/U;fef\u0014Vm];miR\u0019a\u0004J\u0015\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\tUs\u0017\u000e\u001e\u0005\u0006K\t\u0001\rAJ\u0001\tKb\u0004Xm\u0019;fIB\u0011qdJ\u0005\u0003Q\u0001\u00121!\u00118z\u0011\u0015Q#\u00011\u0001,\u0003%!\u0018M\u00197f!\u0006$\b\u000e\u0005\u0002-g9\u0011Q&\r\t\u0003]\u0001j\u0011a\f\u0006\u0003aA\ta\u0001\u0010:p_Rt\u0014B\u0001\u001a!\u0003\u0019\u0001&/\u001a3fM&\u0011A'\u000e\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005I\u0002\u0003")
public class TestQueryMergeOnReadOptimizedTable
extends HoodieSparkSqlTestBase {
    public void assertQueryResult(Object expected, String tablePath) {
        long actual = this.spark().read().format("org.apache.hudi").option("hoodie.datasource.query.type", "read_optimized").load(tablePath).count();
        this.assertResult(expected, BoxesRunTime.boxToLong((long)actual), Prettifier$.MODULE$.default(), new Position("TestQueryMergeOnReadOptimizedTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 85));
    }

    public static final /* synthetic */ void $anonfun$new$2(TestQueryMergeOnReadOptimizedTable $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(397).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  partition long\n           |) using hudi\n           | partitioned by (partition)\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.max.file.size = 10000");
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000, 1000)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000, 1000)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000, 1000)").toString());
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1000, 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 11 where id = 1").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 21 where id = 2").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 31 where id = 3").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 41 where id = 4").toString());
        $this.assertQueryResult(BoxesRunTime.boxToInteger((int)4), tablePath);
        $this.spark().sql(new StringBuilder(50).append("call run_compaction(op => 'schedule', table => '").append(tableName).append("')").toString()).collect();
        $this.assertQueryResult(BoxesRunTime.boxToInteger((int)4), tablePath);
        $this.spark().sql(new StringBuilder(44).append("insert into ").append(tableName).append(" values(5, 'a5', 10, 1000, 1000)").toString());
        $this.assertQueryResult(BoxesRunTime.boxToInteger((int)5), tablePath);
        $this.spark().sql(new StringBuilder(45).append("call run_compaction(op => 'run', table => '").append(tableName).append("')").toString()).collect();
        $this.assertQueryResult(BoxesRunTime.boxToInteger((int)5), tablePath);
    }

    public TestQueryMergeOnReadOptimizedTable() {
        this.test("Test Query Merge_On_Read Read_Optimized table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & java.io.Serializable & Serializable)tmp -> {
            TestQueryMergeOnReadOptimizedTable.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestQueryMergeOnReadOptimizedTable.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 25));
    }
}

