/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.Serializable;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001q2A\u0001B\u0003\u0001%!)q\u0003\u0001C\u00011!)!\u0004\u0001C\u00057!)q\u0006\u0001C\u0005a\tQB+Z:u\tJ|\u0007\u000fU1si&$\u0018n\u001c8Qe>\u001cW\rZ;sK*\u0011aaB\u0001\naJ|7-\u001a3ve\u0016T!\u0001C\u0005\u0002\t!,H-\u001b\u0006\u0003\u0015-\t1a]9m\u0015\taQ\"A\u0003ta\u0006\u00148N\u0003\u0002\u000f\u001f\u00051\u0011\r]1dQ\u0016T\u0011\u0001E\u0001\u0004_J<7\u0001A\n\u0003\u0001M\u0001\"\u0001F\u000b\u000e\u0003\u0015I!AF\u0003\u00039!{w\u000eZ5f'B\f'o\u001b)s_\u000e,G-\u001e:f)\u0016\u001cHOQ1tK\u00061A(\u001b8jiz\"\u0012!\u0007\t\u0003)\u0001\t!\"\u001b8tKJ$H)\u0019;b)\ta\"\u0005\u0005\u0002\u001eA5\taDC\u0001 \u0003\u0015\u00198-\u00197b\u0013\t\tcD\u0001\u0003V]&$\b\"B\u0012\u0003\u0001\u0004!\u0013!\u0003;bE2,g*Y7f!\t)CF\u0004\u0002'UA\u0011qEH\u0007\u0002Q)\u0011\u0011&E\u0001\u0007yI|w\u000e\u001e \n\u0005-r\u0012A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!a\u000b\u0010\u0002%\u001d,G\u000fV1cY\u0016lU\r^1DY&,g\u000e\u001e\u000b\u0003ci\u0002\"A\r\u001d\u000e\u0003MR!\u0001N\u001b\u0002\u000bQ\f'\r\\3\u000b\u0005Y:\u0014AB2p[6|gN\u0003\u0002\t\u001b%\u0011\u0011h\r\u0002\u0016\u0011>|G-[3UC\ndW-T3uC\u000ec\u0017.\u001a8u\u0011\u0015Y4\u00011\u0001%\u0003%!\u0018M\u00197f!\u0006$\b\u000e")
public class TestDropPartitionProcedure
extends HoodieSparkProcedureTestBase {
    private void insertData(String tableName) {
        this.spark().sql(new StringBuilder(55).append("insert into ").append(tableName).append(" values (1, 'n1', 1, 1, '2019', '08', '31')").toString());
        this.spark().sql(new StringBuilder(55).append("insert into ").append(tableName).append(" values (2, 'n2', 2, 2, '2019', '08', '30')").toString());
        this.spark().sql(new StringBuilder(55).append("insert into ").append(tableName).append(" values (3, 'n3', 3, 3, '2019', '08', '29')").toString());
        this.spark().sql(new StringBuilder(55).append("insert into ").append(tableName).append(" values (4, 'n4', 4, 4, '2019', '07', '31')").toString());
    }

    private HoodieTableMetaClient getTableMetaClient(String tablePath) {
        return HoodieTableMetaClient.builder().setBasePath(tablePath).setConf(HadoopFSUtils.getStorageConf((Configuration)this.spark().sparkContext().hadoopConfiguration())).build();
    }

    public static final /* synthetic */ void $anonfun$new$2(TestDropPartitionProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(431).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  year string,\n           |  month string,\n           |  day string\n           |) using hudi\n           |tblproperties (\n           | primaryKey = 'id',\n           | preCombineField = 'ts'\n           |)\n           |partitioned by(year, month, day)\n           |location '").append(tablePath).append("'\n           |\n     ").toString())).stripMargin());
        $this.insertData(tableName);
        $this.spark().sql(new StringBuilder(69).append("call drop_partition(table => '").append(tableName).append("', partition => 'year=2019/month=08/*')").toString());
        HoodieTableMetaClient metaClient = $this.getTableMetaClient(tablePath);
        HoodieInstant replaceCommitInstant = (HoodieInstant)metaClient.getActiveTimeline().getWriteTimeline().getCompletedReplaceTimeline().getReverseOrderedInstants().findFirst().get();
        Set partitions = metaClient.getActiveTimeline().readReplaceCommitMetadata(replaceCommitInstant).getPartitionToReplaceFileIds().keySet();
        Assertions.assertEquals((int)3, (int)partitions.size());
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("year=2019/month=08"))));
        $this.spark().sql(new StringBuilder(101).append("call run_clean(table => '").append(tableName).append("', clean_policy => 'KEEP_LATEST_FILE_VERSIONS', file_versions_retained => 1)").toString());
        Row[] result = (Row[])$this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString()).collect();
        Assertions.assertEquals((int)1, (int)result.length);
    }

    public static final /* synthetic */ void $anonfun$new$5(TestDropPartitionProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(431).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  year string,\n           |  month string,\n           |  day string\n           |) using hudi\n           |tblproperties (\n           | primaryKey = 'id',\n           | preCombineField = 'ts'\n           |)\n           |partitioned by(year, month, day)\n           |location '").append(tablePath).append("'\n           |\n     ").toString())).stripMargin());
        $this.insertData(tableName);
        $this.spark().sql(new StringBuilder(60).append("call drop_partition(table => '").append(tableName).append("', partition => 'year=2019/*')").toString());
        HoodieTableMetaClient metaClient = $this.getTableMetaClient(tablePath);
        HoodieInstant replaceCommitInstant = (HoodieInstant)metaClient.getActiveTimeline().getWriteTimeline().getCompletedReplaceTimeline().getReverseOrderedInstants().findFirst().get();
        Set partitions = metaClient.getActiveTimeline().readReplaceCommitMetadata(replaceCommitInstant).getPartitionToReplaceFileIds().keySet();
        Assertions.assertEquals((int)4, (int)partitions.size());
        $this.spark().sql(new StringBuilder(101).append("call run_clean(table => '").append(tableName).append("', clean_policy => 'KEEP_LATEST_FILE_VERSIONS', file_versions_retained => 1)").toString());
        Row[] result = (Row[])$this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString()).collect();
        Assertions.assertEquals((int)0, (int)result.length);
    }

    public static final /* synthetic */ void $anonfun$new$7(TestDropPartitionProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(431).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  year string,\n           |  month string,\n           |  day string\n           |) using hudi\n           |tblproperties (\n           | primaryKey = 'id',\n           | preCombineField = 'ts'\n           |)\n           |partitioned by(year, month, day)\n           |location '").append(tablePath).append("'\n           |\n     ").toString())).stripMargin());
        $this.insertData(tableName);
        $this.spark().sql(new StringBuilder(100).append("call drop_partition(table => '").append(tableName).append("', partition => 'year=2019/month=08/day=31,year=2019/month=08/day=30')").toString());
        HoodieTableMetaClient metaClient = $this.getTableMetaClient(tablePath);
        HoodieInstant replaceCommitInstant = (HoodieInstant)metaClient.getActiveTimeline().getWriteTimeline().getCompletedReplaceTimeline().getReverseOrderedInstants().findFirst().get();
        Set partitions = metaClient.getActiveTimeline().readReplaceCommitMetadata(replaceCommitInstant).getPartitionToReplaceFileIds().keySet();
        Assertions.assertEquals((int)2, (int)partitions.size());
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).forall((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.startsWith("year=2019/month=08"))));
        $this.spark().sql(new StringBuilder(101).append("call run_clean(table => '").append(tableName).append("', clean_policy => 'KEEP_LATEST_FILE_VERSIONS', file_versions_retained => 1)").toString());
        Row[] result = (Row[])$this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString()).collect();
        Assertions.assertEquals((int)2, (int)result.length);
    }

    public static final /* synthetic */ void $anonfun$new$10(TestDropPartitionProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(431).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long,\n           |  year string,\n           |  month string,\n           |  day string\n           |) using hudi\n           |tblproperties (\n           | primaryKey = 'id',\n           | preCombineField = 'ts'\n           |)\n           |partitioned by(year, month, day)\n           |location '").append(tablePath).append("'\n           |\n     ").toString())).stripMargin());
        $this.insertData(tableName);
        $this.spark().sql(new StringBuilder(74).append("call drop_partition(table => '").append(tableName).append("', partition => 'year=2019/month=08/day=31')").toString());
        HoodieTableMetaClient metaClient = $this.getTableMetaClient(tablePath);
        HoodieInstant replaceCommitInstant = (HoodieInstant)metaClient.getActiveTimeline().getWriteTimeline().getCompletedReplaceTimeline().getReverseOrderedInstants().findFirst().get();
        Set partitions = metaClient.getActiveTimeline().readReplaceCommitMetadata(replaceCommitInstant).getPartitionToReplaceFileIds().keySet();
        Assertions.assertEquals((int)1, (int)partitions.size());
        Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).forall((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.equals("year=2019/month=08/day=31"))));
        $this.spark().sql(new StringBuilder(101).append("call run_clean(table => '").append(tableName).append("', clean_policy => 'KEEP_LATEST_FILE_VERSIONS', file_versions_retained => 1)").toString());
        Row[] result = (Row[])$this.spark().sql(new StringBuilder(14).append("select * from ").append(tableName).toString()).collect();
        Assertions.assertEquals((int)3, (int)result.length);
    }

    public TestDropPartitionProcedure() {
        this.test("Case1: Test Call drop_partition Procedure For Multiple Partitions: '*' stands for all partitions in leaf partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropPartitionProcedure.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropPartitionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 29));
        this.test("Case2: Test Call drop_partition Procedure For Multiple Partitions: '*' stands for all partitions in middle partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropPartitionProcedure.$anonfun$new$5(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropPartitionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 77));
        this.test("Case3: Test Call drop_partition Procedure For Multiple Partitions: provide partition list", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropPartitionProcedure.$anonfun$new$7(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropPartitionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 124));
        this.test("Case4: Test Call drop_partition Procedure For Single Partition", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestDropPartitionProcedure.$anonfun$new$10(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestDropPartitionProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 172));
    }
}

