/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.Serializable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.junit.jupiter.api.Assertions;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a1AAA\u0002\u0001!!)Q\u0003\u0001C\u0001-\taC+Z:u%Vt'k\u001c7mE\u0006\u001c7.\u00138gY&<\u0007\u000e\u001e+bE2,7+\u001a:wS\u000e,\u0007K]8dK\u0012,(/\u001a\u0006\u0003\t\u0015\t\u0011\u0002\u001d:pG\u0016$WO]3\u000b\u0005\u00199\u0011\u0001\u00025vI&T!\u0001C\u0005\u0002\u0007M\fHN\u0003\u0002\u000b\u0017\u0005)1\u000f]1sW*\u0011A\"D\u0001\u0007CB\f7\r[3\u000b\u00039\t1a\u001c:h\u0007\u0001\u0019\"\u0001A\t\u0011\u0005I\u0019R\"A\u0002\n\u0005Q\u0019!\u0001\b%p_\u0012LWm\u00159be.\u0004&o\\2fIV\u0014X\rV3ti\n\u000b7/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003]\u0001\"A\u0005\u0001")
public class TestRunRollbackInflightTableServiceProcedure
extends HoodieSparkProcedureTestBase {
    public static final /* synthetic */ void $anonfun$new$2(TestRunRollbackInflightTableServiceProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(350).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | options (\n           |  primaryKey ='id',\n           |  type = 'cow',\n           |  preCombineField = 'ts'\n           | )\n           | partitioned by(ts)\n           | location '").append(basePath).append("'\n     ").toString())).stripMargin());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1001)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1002)").toString());
        $this.spark().sql(new StringBuilder(50).append("call run_clustering(table => '").append(tableName).append("', op => 'schedule')").toString());
        $this.spark().sql(new StringBuilder(49).append("call run_clustering(table => '").append(tableName).append("', op => 'execute')").toString());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setBasePath(basePath).setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)$this.spark().sparkContext().hadoopConfiguration())).build();
        HoodieInstant clusteringInstant = (HoodieInstant)metaClient.getActiveTimeline().getCompletedReplaceTimeline().getInstants().get(0);
        metaClient.getActiveTimeline().deleteInstantFileIfExists(clusteringInstant);
        String clusteringInstantTime = clusteringInstant.requestedTime();
        $this.spark().sql(new StringBuilder(75).append("call run_rollback_inflight_tableservice(table => '").append(tableName).append("', pending_instant => '").append(clusteringInstantTime).append("')").toString());
        Assertions.assertTrue((!metaClient.reloadActiveTimeline().getInstants().contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "clustering", clusteringInstantTime)) ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)metaClient.reloadActiveTimeline().getInstants().contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "clustering", clusteringInstantTime)));
    }

    public static final /* synthetic */ void $anonfun$new$4(TestRunRollbackInflightTableServiceProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(380).append("\n             |create table ").append(tableName).append(" (\n             |  id int,\n             |  name string,\n             |  price double,\n             |  ts long\n             |) using hudi\n             | options (\n             |  primaryKey ='id',\n             |  type = 'mor',\n             |  preCombineField = 'ts'\n             | )\n             | partitioned by(ts)\n             | location '").append(basePath).append("'\n         ").toString())).stripMargin());
        $this.spark().sql("set hoodie.parquet.max.file.size = 10000");
        $this.spark().sql("set hoodie.compact.inline=false");
        $this.spark().sql("set hoodie.compact.schedule.inline=false");
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(2, 'a2', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(3, 'a3', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(4, 'a4', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(35).append("update ").append(tableName).append(" set price = 11 where id = 1").toString());
        $this.spark().sql(new StringBuilder(50).append("call run_compaction(op => 'schedule', table => '").append(tableName).append("')").toString());
        $this.spark().sql(new StringBuilder(45).append("call run_compaction(op => 'run', table => '").append(tableName).append("')").toString());
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)$this.spark().sparkContext().hadoopConfiguration())).setBasePath(basePath).build();
        HoodieInstant compactionInstant = (HoodieInstant)metaClient.getActiveTimeline().getReverseOrderedInstants().findFirst().get();
        metaClient.getActiveTimeline().deleteInstantFileIfExists(compactionInstant);
        String compactionInstantTime = compactionInstant.requestedTime();
        $this.spark().sql(new StringBuilder(112).append("call run_rollback_inflight_tableservice(table => '").append(tableName).append("', pending_instant => '").append(compactionInstantTime).append("', delete_request_instant_file => true)").toString());
        Assertions.assertTrue((!metaClient.reloadActiveTimeline().getInstants().contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", compactionInstantTime)) ? 1 : 0) != 0);
        Assertions.assertTrue((!metaClient.reloadActiveTimeline().getInstants().contains(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.REQUESTED, "compaction", compactionInstantTime)) ? 1 : 0) != 0);
    }

    public TestRunRollbackInflightTableServiceProcedure() {
        this.test("Test Call run_rollback_inflight_tableservice Procedure for clustering", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestRunRollbackInflightTableServiceProcedure.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestRunRollbackInflightTableServiceProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 28));
        this.test("Test Call run_rollback_inflight_tableservice Procedure for compaction", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestRunRollbackInflightTableServiceProcedure.$anonfun$new$4(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestRunRollbackInflightTableServiceProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 71));
    }
}

