/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import org.apache.hudi.SparkDatasetMixin;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001-4AAB\u0004\u0001)!)a\u0004\u0001C\u0001?!)\u0011\u0005\u0001C\u0005E!)A\n\u0001C\u0005\u001b\")a\u000b\u0001C\u0005/\")!\f\u0001C\t7\n\u0001B+Z:u)Rc\u0005K]8dK\u0012,(/\u001a\u0006\u0003\u0011%\t\u0011\u0002\u001d:pG\u0016$WO]3\u000b\u0005)Y\u0011\u0001\u00025vI&T!\u0001D\u0007\u0002\u0007M\fHN\u0003\u0002\u000f\u001f\u0005)1\u000f]1sW*\u0011\u0001#E\u0001\u0007CB\f7\r[3\u000b\u0003I\t1a\u001c:h\u0007\u0001\u00192\u0001A\u000b\u001a!\t1r#D\u0001\b\u0013\tArA\u0001\u000fI_>$\u0017.Z*qCJ\\\u0007K]8dK\u0012,(/\u001a+fgR\u0014\u0015m]3\u0011\u0005iaR\"A\u000e\u000b\u0005)y\u0011BA\u000f\u001c\u0005E\u0019\u0006/\u0019:l\t\u0006$\u0018m]3u\u001b&D\u0018N\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0001\u0002\"A\u0006\u0001\u00021]\u0014\u0018\u000e^3SK\u000e|'\u000fZ:G_J\u0004\u0016M\u001d;ji&|g\u000eF\u0003$SMj$\n\u0005\u0002%O5\tQEC\u0001'\u0003\u0015\u00198-\u00197b\u0013\tASE\u0001\u0003V]&$\b\"\u0002\u0016\u0003\u0001\u0004Y\u0013AB2mS\u0016tG\u000fE\u0002-]Aj\u0011!\f\u0006\u0003UmI!aL\u0017\u0003'M\u0003\u0018M]6S\t\u0012;&/\u001b;f\u00072LWM\u001c;\u0011\u0005\u0011\n\u0014B\u0001\u001a&\u0005\u001dqu\u000e\u001e5j]\u001eDQ\u0001\u000e\u0002A\u0002U\nq\u0001Z1uC\u001e+g\u000e\u0005\u00027w5\tqG\u0003\u00029s\u0005IA/Z:ukRLGn\u001d\u0006\u0003um\taaY8n[>t\u0017B\u0001\u001f8\u0005]Aun\u001c3jKR+7\u000f\u001e#bi\u0006<UM\\3sCR|'\u000fC\u0003?\u0005\u0001\u0007q(A\u0005qCJ$\u0018\u000e^5p]B\u0011\u0001i\u0012\b\u0003\u0003\u0016\u0003\"AQ\u0013\u000e\u0003\rS!\u0001R\n\u0002\rq\u0012xn\u001c;?\u0013\t1U%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$&\u0011\u0015Y%\u00011\u0001@\u0003-Ign\u001d;b]R$\u0016.\\3\u0002)\u001d,G\u000fS8pI&,wK]5uK\u000ec\u0017.\u001a8u)\tYc\nC\u0003P\u0007\u0001\u0007\u0001+A\u0002dM\u001e\u0004\"!\u0015+\u000e\u0003IS!aU\u000e\u0002\r\r|gNZ5h\u0013\t)&KA\tI_>$\u0017.Z,sSR,7i\u001c8gS\u001e\f\u0011\"\u001b8jiR\u000b'\r\\3\u0015\u0005\rB\u0006\"B-\u0005\u0001\u0004y\u0014\u0001\u00032bg\u0016\u0004\u0016\r\u001e5\u0002!\u001d,GoQ8oM&<')^5mI\u0016\u0014H\u0003\u0002/dI\u001a\u0004\"!\u00181\u000f\u0005Es\u0016BA0S\u0003EAun\u001c3jK^\u0013\u0018\u000e^3D_:4\u0017nZ\u0005\u0003C\n\u0014qAQ;jY\u0012,'O\u0003\u0002`%\")\u0011,\u0002a\u0001\u007f!)Q-\u0002a\u0001\u007f\u0005IA/\u00192mK:\u000bW.\u001a\u0005\u0006O\u0016\u0001\r\u0001[\u0001\u000bCV$xnQ8n[&$\bC\u0001\u0013j\u0013\tQWEA\u0004C_>dW-\u00198")
public class TestTTLProcedure
extends HoodieSparkProcedureTestBase
implements SparkDatasetMixin {
    @Override
    public Dataset<Row> toDataset(SparkSession spark, java.util.List<HoodieRecord<?>> records) {
        return SparkDatasetMixin.toDataset$(this, spark, records);
    }

    private void writeRecordsForPartition(SparkRDDWriteClient<Nothing$> client, HoodieTestDataGenerator dataGen, String partition, String instantTime) {
        java.util.List records = dataGen.generateInsertsForPartition(instantTime, Predef$.MODULE$.int2Integer(10), partition);
        client.startCommitWithTime(instantTime, "commit");
        client.insert(this.spark().sparkContext().parallelize(((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(records).asScala()).toSeq(), this.spark().sparkContext().parallelize$default$2(), ClassTag$.MODULE$.apply(HoodieRecord.class)).toJavaRDD(), instantTime);
    }

    private SparkRDDWriteClient<Nothing$> getHoodieWriteClient(HoodieWriteConfig cfg) {
        SparkRDDWriteClient writeClient = new SparkRDDWriteClient((HoodieEngineContext)new HoodieSparkEngineContext(new JavaSparkContext(this.spark().sparkContext())), cfg);
        return writeClient;
    }

    private void initTable(String basePath) {
        Properties props = new Properties();
        props.put("hoodie.datasource.write.partitionpath.field", "partition_path");
        props.put("hoodie.datasource.write.keygenerator.class", "org.apache.hudi.keygen.SimpleKeyGenerator");
        props.put(HoodieTableConfig.PARTITION_FIELDS.key(), "partition_path");
        props.put(HoodieTableConfig.RECORDKEY_FIELDS.key(), "_row_key");
        HoodieTestUtils.init((String)basePath, (HoodieTableType)HoodieTableType.COPY_ON_WRITE, (Properties)props);
    }

    public HoodieWriteConfig.Builder getConfigBuilder(String basePath, String tableName, boolean autoCommit) {
        return HoodieWriteConfig.newBuilder().withPath(basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withAutoCommit(autoCommit).withPreCombineField("_row_key").forTable(tableName);
    }

    public static final /* synthetic */ void $anonfun$new$3(TestTTLProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String basePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.initTable(basePath);
        HoodieWriteConfig writeConfig = $this.getConfigBuilder(basePath, tableName, true).build();
        SparkRDDWriteClient<Nothing$> client = $this.getHoodieWriteClient(writeConfig);
        HoodieTestDataGenerator dataGen = new HoodieTestDataGenerator(57069L);
        String[] partitionPaths = dataGen.getPartitionPaths();
        String partitionPath0 = partitionPaths[0];
        String instant0 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)0L);
        $this.writeRecordsForPartition(client, dataGen, partitionPath0, instant0);
        String instant1 = HoodieTestDataGenerator.getCommitTimeAtUTC((long)1000L);
        String partitionPath1 = partitionPaths[1];
        $this.writeRecordsForPartition(client, dataGen, partitionPath1, instant1);
        String currentInstant = client.createNewInstantTime();
        String partitionPath2 = partitionPaths[2];
        $this.writeRecordsForPartition(client, dataGen, partitionPath2, currentInstant);
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(249).append("\n             | create table ").append(tableName).append(" using hudi\n             | location '").append(basePath).append("'\n             | tblproperties (\n             |   primaryKey = '_row_key',\n             |   preCombineField = '_row_key',\n             |   type = 'cow'\n             | )\n             |").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(43).append("call run_ttl(table => '").append(tableName).append("', retain_days => 1)").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)new .colon.colon((Object)partitionPath0, (List)Nil$.MODULE$), (Seq)new .colon.colon((Object)partitionPath1, (List)Nil$.MODULE$)}));
    }

    public TestTTLProcedure() {
        SparkDatasetMixin.$init$(this);
        this.test("Test Call run_ttl Procedure by Table", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withSQLConf((Seq<Tuple2<String, String>>)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"hoodie.partition.ttl.automatic"), (Object)"false")}), (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestTTLProcedure.$anonfun$new$3(this, tmp);
            return BoxedUnit.UNIT;
        })), new Position("TestTTLProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
    }
}

