/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.procedure;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.time.Instant;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.BinaryUtil;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.testutils.HoodieClientTestUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hudi.common.HoodieSparkSqlTestBase$;
import org.apache.spark.sql.hudi.procedure.HoodieSparkProcedureTestBase;
import org.scalactic.Prettifier$;
import org.scalactic.source.Position;
import org.scalatest.Tag;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r4Aa\u0001\u0003\u0001#!)a\u0003\u0001C\u0001/!)\u0011\u0004\u0001C\u00055\tyB+Z:u+B<'/\u00193f\u001fJ$un\u001e8he\u0006$W\r\u0015:pG\u0016$WO]3\u000b\u0005\u00151\u0011!\u00039s_\u000e,G-\u001e:f\u0015\t9\u0001\"\u0001\u0003ik\u0012L'BA\u0005\u000b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0011aA8sO\u000e\u00011C\u0001\u0001\u0013!\t\u0019B#D\u0001\u0005\u0013\t)BA\u0001\u000fI_>$\u0017.Z*qCJ\\\u0007K]8dK\u0012,(/\u001a+fgR\u0014\u0015m]3\u0002\rqJg.\u001b;?)\u0005A\u0002CA\n\u0001\u0003\t\n7o]3siR\u000b'\r\\3WKJ\u001c\u0018n\u001c8Ge>l\u0007K]8qKJ$\u0018PR5mKR\u00191$\t\u0017\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006E\t\u0001\raI\u0001\u000b[\u0016$\u0018m\u00117jK:$\bC\u0001\u0013+\u001b\u0005)#B\u0001\u0014(\u0003\u0015!\u0018M\u00197f\u0015\tA\u0013&\u0001\u0004d_6lwN\u001c\u0006\u0003\u000f1I!aK\u0013\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi\")QF\u0001a\u0001]\u0005Ya/\u001a:tS>t7i\u001c3f!\tar&\u0003\u00021;\t\u0019\u0011J\u001c;)\u0007\t\u0011T\bE\u0002\u001dgUJ!\u0001N\u000f\u0003\rQD'o\\<t!\t14(D\u00018\u0015\tA\u0014(\u0001\u0002j_*\t!(\u0001\u0003kCZ\f\u0017B\u0001\u001f8\u0005-Iu*\u0012=dKB$\u0018n\u001c82\tyq\u0014J\u0019\t\u0003\u007f\u0019s!\u0001\u0011#\u0011\u0005\u0005kR\"\u0001\"\u000b\u0005\r\u0003\u0012A\u0002\u001fs_>$h(\u0003\u0002F;\u00051\u0001K]3eK\u001aL!a\u0012%\u0003\rM#(/\u001b8h\u0015\t)U$M\u0003$\u0015:kv*\u0006\u0002L\u0019V\ta\bB\u0003N!\t\u0007!KA\u0001U\u0013\ty\u0005+A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u0006\u0003#v\ta\u0001\u001e5s_^\u001c\u0018CA*W!\taB+\u0003\u0002V;\t9aj\u001c;iS:<\u0007CA,[\u001d\ta\u0002,\u0003\u0002Z;\u00059\u0001/Y2lC\u001e,\u0017BA.]\u0005%!\u0006N]8xC\ndWM\u0003\u0002Z;E*1EX0a#:\u0011AdX\u0005\u0003#v\tDA\t\u000f\u001eC\n)1oY1mCF\u0012a%\u000e")
public class TestUpgradeOrDowngradeProcedure
extends HoodieSparkProcedureTestBase {
    private void assertTableVersionFromPropertyFile(HoodieTableMetaClient metaClient, int versionCode) throws IOException {
        StoragePath propertyFile = new StoragePath(new StringBuilder(17).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)metaClient.getMetaPath()), "/")).append("hoodie.properties").toString());
        InputStream fsDataInputStream = metaClient.getStorage().open(propertyFile);
        HoodieConfig config = new HoodieConfig();
        config.getProps().load(fsDataInputStream);
        fsDataInputStream.close();
        this.assertResult(Integer.toString(versionCode), config.getString(HoodieTableConfig.VERSION), Prettifier$.MODULE$.default(), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 208));
    }

    public static final /* synthetic */ void $anonfun$new$2(TestUpgradeOrDowngradeProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(299).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.checkExceptionContain(new StringBuilder(33).append("call downgrade_table(table => '").append(tableName).append("')").toString(), "Argument: to_version is required");
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
        $this.assertResult(BoxesRunTime.boxToInteger((int)HoodieTableVersion.EIGHT.versionCode()), BoxesRunTime.boxToInteger((int)metaClient.getTableConfig().getTableVersion().versionCode()), Prettifier$.MODULE$.default(), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 62));
        $this.assertTableVersionFromPropertyFile(metaClient, HoodieTableVersion.EIGHT.versionCode());
        $this.checkAnswer(new StringBuilder(55).append("call downgrade_table(table => '").append(tableName).append("', to_version => 'ZERO')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true}))}));
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        $this.assertResult(BoxesRunTime.boxToInteger((int)HoodieTableVersion.ZERO.versionCode()), BoxesRunTime.boxToInteger((int)metaClient.getTableConfig().getTableVersion().versionCode()), Prettifier$.MODULE$.default(), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 72));
        $this.assertTableVersionFromPropertyFile(metaClient, HoodieTableVersion.ZERO.versionCode());
        $this.checkAnswer(new StringBuilder(52).append("call upgrade_table(table => '").append(tableName).append("', to_version => 'ONE')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true}))}));
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        $this.assertResult(BoxesRunTime.boxToInteger((int)HoodieTableVersion.ONE.versionCode()), BoxesRunTime.boxToInteger((int)metaClient.getTableConfig().getTableVersion().versionCode()), Prettifier$.MODULE$.default(), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 82));
        $this.assertTableVersionFromPropertyFile(metaClient, HoodieTableVersion.ONE.versionCode());
    }

    public static final /* synthetic */ void $anonfun$new$4(TestUpgradeOrDowngradeProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(299).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tablePath).append("'\n           | tblproperties (\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.checkAnswer(new StringBuilder(56).append("call downgrade_table(table => '").append(tableName).append("', to_version => 'THREE')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true}))}));
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
        HoodieStorage storage = metaClient.getStorage();
        $this.assertResult(BoxesRunTime.boxToInteger((int)HoodieTableVersion.THREE.versionCode()), BoxesRunTime.boxToInteger((int)metaClient.getTableConfig().getTableVersion().versionCode()), Prettifier$.MODULE$.default(), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
        StoragePath metaPathDir = new StoragePath(metaClient.getBasePath(), ".hoodie");
        TypedProperties props = ConfigUtils.fetchConfigs((HoodieStorage)storage, (StoragePath)metaPathDir, (String)"hoodie.properties", (String)"hoodie.properties.backup", (int)1, (int)1000);
        props.remove((Object)HoodieTableConfig.TABLE_CHECKSUM.key());
        try {
            OutputStream outputStream = storage.create(new StoragePath(metaPathDir, "hoodie.properties"));
            props.store(outputStream, new StringBuilder(11).append("Updated at ").append(Instant.now()).toString());
            outputStream.close();
        }
        catch (Exception e) {
            throw $this.fail(e, new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
        }
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        $this.assertResult(BoxesRunTime.boxToBoolean((boolean)false), BoxesRunTime.boxToBoolean((boolean)metaClient.getTableConfig().contains(HoodieTableConfig.TABLE_CHECKSUM)), Prettifier$.MODULE$.default(), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 136));
        $this.checkAnswer(new StringBuilder(52).append("call upgrade_table(table => '").append(tableName).append("', to_version => 'SIX')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true}))}));
        metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
        $this.assertResult(BoxesRunTime.boxToInteger((int)HoodieTableVersion.SIX.versionCode()), BoxesRunTime.boxToInteger((int)metaClient.getTableConfig().getTableVersion().versionCode()), Prettifier$.MODULE$.default(), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 140));
        long expectedCheckSum = BinaryUtil.generateChecksum((byte[])StringUtils.getUTF8Bytes((String)tableName));
        $this.assertResult(BoxesRunTime.boxToLong((long)expectedCheckSum), metaClient.getTableConfig().getLong(HoodieTableConfig.TABLE_CHECKSUM), Prettifier$.MODULE$.default(), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 144));
    }

    public static final /* synthetic */ boolean $anonfun$new$7(HoodieInstant f) {
        return HoodieSparkSqlTestBase$.MODULE$.NAME_FORMAT_0_X().matcher(HoodieTestUtils.INSTANT_FILE_NAME_GENERATOR.getFileName(f)).find();
    }

    public static final /* synthetic */ void $anonfun$new$6(TestUpgradeOrDowngradeProcedure $this, File tmp) {
        String tableName = $this.generateTableName();
        String tablePath = new StringBuilder(1).append(tmp.getCanonicalPath()).append("/").append(tableName).toString();
        $this.spark().sql(new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(321).append("\n           |create table ").append(tableName).append(" (\n           |  id int,\n           |  name string,\n           |  price double,\n           |  ts long\n           |) using hudi\n           | location '").append(tablePath).append("'\n           | options (\n           |  type = 'mor',\n           |  primaryKey = 'id',\n           |  preCombineField = 'ts'\n           | )\n       ").toString())).stripMargin());
        $this.spark().sql("set hoodie.compact.inline=true");
        $this.spark().sql("set hoodie.compact.inline.max.delta.commits=1");
        $this.spark().sql("set hoodie.clean.commits.retained = 2");
        $this.spark().sql("set hoodie.keep.min.commits = 3");
        $this.spark().sql("set hoodie.keep.min.commits = 4");
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        $this.spark().sql(new StringBuilder(38).append("insert into ").append(tableName).append(" values(1, 'a1', 10, 1000)").toString());
        HoodieTableMetaClient metaClient = HoodieClientTestUtils.createMetaClient((SparkSession)$this.spark(), (String)tablePath);
        if (((Object)BoxesRunTime.boxToInteger((int)metaClient.getTableConfig().getTableVersion().versionCode())).equals(BoxesRunTime.boxToInteger((int)HoodieTableVersion.EIGHT.versionCode()))) {
            $this.checkAnswer(new StringBuilder(56).append("call downgrade_table(table => '").append(tableName).append("', to_version => 'SEVEN')").toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapBooleanArray(new boolean[]{true}))}));
            metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)metaClient);
            $this.assertResult(BoxesRunTime.boxToInteger((int)HoodieTableVersion.SEVEN.versionCode()), BoxesRunTime.boxToInteger((int)metaClient.getTableConfig().getTableVersion().versionCode()), Prettifier$.MODULE$.default(), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188));
            ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(metaClient.reloadActiveTimeline().getInstants().iterator()).asScala()).forall((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)TestUpgradeOrDowngradeProcedure.$anonfun$new$7(f)));
            $this.checkAnswer(new StringBuilder(32).append("select id, name, price, ts from ").append(tableName).toString(), (Seq<Seq<Object>>)Predef$.MODULE$.wrapRefArray((Object[])new Seq[]{(Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)1), "a1", BoxesRunTime.boxToDouble((double)10.0), BoxesRunTime.boxToInteger((int)1000)}))}));
            return;
        }
    }

    public TestUpgradeOrDowngradeProcedure() {
        this.test("Test Call downgrade_table and upgrade_table Procedure", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestUpgradeOrDowngradeProcedure.$anonfun$new$2(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 36));
        this.test("Test Call upgrade_table from version three", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestUpgradeOrDowngradeProcedure.$anonfun$new$4(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 89));
        this.test("Test downgrade table from version eight to version seven", (Seq<Tag>)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0<Object>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.withTempDir((Function1<File, BoxedUnit>)(Function1 & Serializable & scala.Serializable)tmp -> {
            TestUpgradeOrDowngradeProcedure.$anonfun$new$6(this, tmp);
            return BoxedUnit.UNIT;
        }), new Position("TestUpgradeOrDowngradeProcedure.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 150));
    }
}

