/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.util.Properties;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HiveSyncConfigHolder;
import org.apache.hudi.hive.HiveSyncTool;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.HiveSyncProcedure$;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Tuple4;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001\u0002\t\u0012\u0001\u0001BQA\r\u0001\u0005\u0002MBq!\u000e\u0001C\u0002\u0013%a\u0007\u0003\u0004A\u0001\u0001\u0006Ia\u000e\u0005\b\u0003\u0002\u0011\r\u0011\"\u0003C\u0011\u0019I\u0005\u0001)A\u0005\u0007\")!\n\u0001C!\u0017\")q\n\u0001C!m!)\u0001\u000b\u0001C!\u0005\")\u0011\u000b\u0001C!%\u001e)\u0001.\u0005E\u0001S\u001a)\u0001#\u0005E\u0001U\")!g\u0003C\u0001]\"9qn\u0003b\u0001\n\u0003\u0001\bBB=\fA\u0003%\u0011\u000fC\u0003{\u0017\u0011\u00051PA\tISZ,7+\u001f8d!J|7-\u001a3ve\u0016T!AE\n\u0002\u0015A\u0014xnY3ekJ,7O\u0003\u0002\u0015+\u000591m\\7nC:$'B\u0001\f\u0018\u0003\u0011AW\u000fZ5\u000b\u0005aI\u0012aA:rY*\u0011!dG\u0001\u0006gB\f'o\u001b\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000b\u0001\tS\u0005\u000b\u0017\u0011\u0005\t\u001aS\"A\t\n\u0005\u0011\n\"!\u0004\"bg\u0016\u0004&o\\2fIV\u0014X\r\u0005\u0002#M%\u0011q%\u0005\u0002\u0011!J|7-\u001a3ve\u0016\u0014U/\u001b7eKJ\u0004\"!\u000b\u0016\u000e\u0003UI!aK\u000b\u0003)A\u0013xN^5eKNDun\u001c3jK\u000e{gNZ5h!\ti\u0003'D\u0001/\u0015\ty\u0013$\u0001\u0005j]R,'O\\1m\u0013\t\tdFA\u0004M_\u001e<\u0017N\\4\u0002\rqJg.\u001b;?)\u0005!\u0004C\u0001\u0012\u0001\u0003)\u0001\u0016IU!N\u000bR+%kU\u000b\u0002oA\u0019\u0001hO\u001f\u000e\u0003eR\u0011AO\u0001\u0006g\u000e\fG.Y\u0005\u0003ye\u0012Q!\u0011:sCf\u0004\"A\t \n\u0005}\n\"A\u0005)s_\u000e,G-\u001e:f!\u0006\u0014\u0018-\\3uKJ\f1\u0002U!S\u00036+E+\u0012*TA\u0005Yq*\u0016+Q+R{F+\u0017)F+\u0005\u0019\u0005C\u0001#H\u001b\u0005)%B\u0001$\u0018\u0003\u0015!\u0018\u0010]3t\u0013\tAUI\u0001\u0006TiJ,8\r\u001e+za\u0016\fAbT+U!V#v\fV-Q\u000b\u0002\nQAY;jY\u0012,\u0012\u0001\u0014\t\u0003E5K!AT\t\u0003\u0013A\u0013xnY3ekJ,\u0017A\u00039be\u0006lW\r^3sg\u0006Qq.\u001e;qkR$\u0016\u0010]3\u0002\t\r\fG\u000e\u001c\u000b\u0003'\u000e\u00042\u0001\u0016/`\u001d\t)&L\u0004\u0002W36\tqK\u0003\u0002Y?\u00051AH]8pizJ\u0011AO\u0005\u00037f\nq\u0001]1dW\u0006<W-\u0003\u0002^=\n\u00191+Z9\u000b\u0005mK\u0004C\u00011b\u001b\u00059\u0012B\u00012\u0018\u0005\r\u0011vn\u001e\u0005\u0006I&\u0001\r!Z\u0001\u0005CJ<7\u000f\u0005\u0002#M&\u0011q-\u0005\u0002\u000e!J|7-\u001a3ve\u0016\f%oZ:\u0002#!Kg/Z*z]\u000e\u0004&o\\2fIV\u0014X\r\u0005\u0002#\u0017M\u00111b\u001b\t\u0003q1L!!\\\u001d\u0003\r\u0005s\u0017PU3g)\u0005I\u0017\u0001\u0002(B\u001b\u0016+\u0012!\u001d\t\u0003e^l\u0011a\u001d\u0006\u0003iV\fA\u0001\\1oO*\ta/\u0001\u0003kCZ\f\u0017B\u0001=t\u0005\u0019\u0019FO]5oO\u0006)a*Q'FA\u00059!-^5mI\u0016\u0014X#\u0001?\u0011\tu\f)!J\u0007\u0002}*\u0019q0!\u0001\u0002\u0011\u0019,hn\u0019;j_:T1!a\u0001v\u0003\u0011)H/\u001b7\n\u0007\u0005\u001daP\u0001\u0005TkB\u0004H.[3s\u0001")
public class HiveSyncProcedure
extends BaseProcedure
implements ProcedureBuilder,
ProvidesHoodieConfig {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return HiveSyncProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return HiveSyncProcedure$.MODULE$.NAME();
    }

    public Map<String, String> buildHoodieConfig(HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig.buildHoodieConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable);
    }

    public Map<String, String> buildBucketRescaleHoodieConfig(HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig.buildBucketRescaleHoodieConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable);
    }

    public Map<String, String> buildHoodieInsertConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession, boolean isOverwritePartition, boolean isOverwriteTable, Map<String, Option<String>> insertPartitions, Map<String, String> extraOptions, Option<String> staticOverwritePartitionPathOpt) {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable, (SparkSession)sparkSession, (boolean)isOverwritePartition, (boolean)isOverwriteTable, insertPartitions, extraOptions, staticOverwritePartitionPathOpt);
    }

    public Map<String, Option<String>> buildHoodieInsertConfig$default$5() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$5$((ProvidesHoodieConfig)this);
    }

    public Option<String> buildHoodieInsertConfig$default$7() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$7$((ProvidesHoodieConfig)this);
    }

    public Map<String, String> getDropDupsConfig(boolean useLegacyInsertModeFlow, Map<String, String> incomingParams) {
        return ProvidesHoodieConfig.getDropDupsConfig$((ProvidesHoodieConfig)this, (boolean)useLegacyInsertModeFlow, incomingParams);
    }

    public Tuple4<SaveMode, Object, Object, Option<String>> deduceOverwriteConfig(SparkSession sparkSession, HoodieCatalogTable catalogTable, Map<String, Option<String>> partitionSpec, Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.deduceOverwriteConfig$((ProvidesHoodieConfig)this, (SparkSession)sparkSession, (HoodieCatalogTable)catalogTable, partitionSpec, extraOptions);
    }

    public Map<String, String> buildHoodieDropPartitionsConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, String partitionsToDrop) {
        return ProvidesHoodieConfig.buildHoodieDropPartitionsConfig$((ProvidesHoodieConfig)this, (SparkSession)sparkSession, (HoodieCatalogTable)hoodieCatalogTable, (String)partitionsToDrop);
    }

    public Map<String, String> buildHoodieDeleteTableConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        return ProvidesHoodieConfig.buildHoodieDeleteTableConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable, (SparkSession)sparkSession);
    }

    public HiveSyncConfig buildHiveSyncConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, HoodieTableConfig tableConfig, Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.buildHiveSyncConfig$((ProvidesHoodieConfig)this, (SparkSession)sparkSession, (HoodieCatalogTable)hoodieCatalogTable, (HoodieTableConfig)tableConfig, extraOptions);
    }

    public Map<String, String> buildHiveSyncConfig$default$4() {
        return ProvidesHoodieConfig.buildHiveSyncConfig$default$4$((ProvidesHoodieConfig)this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public Procedure build() {
        return new HiveSyncProcedure();
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        String tableName = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        String metastoreUri = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get();
        String username = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get();
        String password = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[3]).get();
        String useJdbc = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[4]).get();
        String mode = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[5]).get();
        String partitionFields = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[6]).get();
        String partitionExtractorClass = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[7]).get();
        String strategy = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[8]).get();
        String syncIncremental = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[9]).get();
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), tableName);
        Configuration hadoopConf = this.sparkSession().sparkContext().hadoopConfiguration();
        HiveConf hiveConf = new HiveConf();
        SQLConf sqlConf = this.sparkSession().sessionState().conf();
        if (new StringOps(Predef$.MODULE$.augmentString(metastoreUri)).nonEmpty()) {
            hadoopConf.set(HiveConf.ConfVars.METASTOREURIS.varname, metastoreUri);
        }
        if (new StringOps(Predef$.MODULE$.augmentString(username)).nonEmpty()) {
            sqlConf.setConfString(HiveSyncConfig.HIVE_USER.key(), username);
        }
        if (new StringOps(Predef$.MODULE$.augmentString(password)).nonEmpty()) {
            sqlConf.setConfString(HiveSyncConfig.HIVE_PASS.key(), password);
        }
        if (new StringOps(Predef$.MODULE$.augmentString(useJdbc)).nonEmpty()) {
            sqlConf.setConfString(HiveSyncConfig.HIVE_USE_JDBC.key(), useJdbc);
        }
        if (new StringOps(Predef$.MODULE$.augmentString(mode)).nonEmpty()) {
            sqlConf.setConfString(HiveSyncConfigHolder.HIVE_SYNC_MODE.key(), mode);
        }
        if (new StringOps(Predef$.MODULE$.augmentString(partitionFields)).nonEmpty()) {
            sqlConf.setConfString(HoodieSyncConfig.META_SYNC_PARTITION_FIELDS.key(), partitionFields);
        }
        if (new StringOps(Predef$.MODULE$.augmentString(partitionExtractorClass)).nonEmpty()) {
            sqlConf.setConfString(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS.key(), partitionExtractorClass);
        }
        if (new StringOps(Predef$.MODULE$.augmentString(strategy)).nonEmpty()) {
            sqlConf.setConfString(HiveSyncConfigHolder.HIVE_SYNC_TABLE_STRATEGY.key(), strategy);
        }
        if (new StringOps(Predef$.MODULE$.augmentString(syncIncremental)).nonEmpty()) {
            sqlConf.setConfString(HoodieSyncConfig.META_SYNC_INCREMENTAL.key(), syncIncremental);
        }
        hiveConf.addResource(hadoopConf);
        HoodieTableConfig tableConfig = hoodieCatalogTable.tableConfig();
        HiveSyncConfig hiveSyncConfig = this.buildHiveSyncConfig(this.sparkSession(), hoodieCatalogTable, tableConfig, this.buildHiveSyncConfig$default$4());
        try (HiveSyncTool hiveSyncTool = null;){
            try {
                hiveSyncTool = new HiveSyncTool((Properties)hiveSyncConfig.getProps(), (Configuration)hiveConf);
                hiveSyncTool.syncHoodieTable();
            }
            catch (RuntimeException e) {
                throw new HoodieException("hive sync failed", (Throwable)e);
            }
        }
        return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"hive sync success."})), (List)Nil$.MODULE$);
    }

    public HiveSyncProcedure() {
        Logging.$init$((Logging)this);
        ProvidesHoodieConfig.$init$((ProvidesHoodieConfig)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "metastore_uri", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(2, "username", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(3, "password", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(4, "use_jdbc", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(5, "mode", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(6, "partition_fields", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(7, "partition_extractor_class", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(8, "strategy", DataTypes.StringType, ""), ProcedureParameter$.MODULE$.optional(9, "sync_incremental", DataTypes.StringType, "")});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

