/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.UUID;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.UnresolvedAttribute;
import org.apache.spark.sql.catalyst.analysis.UnresolvedFunction;
import org.apache.spark.sql.catalyst.expressions.Abs;
import org.apache.spark.sql.catalyst.expressions.Abs$;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.ArrayContains;
import org.apache.spark.sql.catalyst.expressions.AttributeReference;
import org.apache.spark.sql.catalyst.expressions.BoundReference;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Ceil;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.DateDiff;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass;
import org.apache.spark.sql.catalyst.expressions.DateFormatClass$;
import org.apache.spark.sql.catalyst.expressions.DayOfMonth;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Floor;
import org.apache.spark.sql.catalyst.expressions.GenericInternalRow;
import org.apache.spark.sql.catalyst.expressions.GreaterThan;
import org.apache.spark.sql.catalyst.expressions.GreaterThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Hour;
import org.apache.spark.sql.catalyst.expressions.Hour$;
import org.apache.spark.sql.catalyst.expressions.IsNotNull;
import org.apache.spark.sql.catalyst.expressions.IsNull;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.LessThan;
import org.apache.spark.sql.catalyst.expressions.LessThanOrEqual;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Lower;
import org.apache.spark.sql.catalyst.expressions.MapKeys;
import org.apache.spark.sql.catalyst.expressions.MapValues;
import org.apache.spark.sql.catalyst.expressions.Month;
import org.apache.spark.sql.catalyst.expressions.RLike;
import org.apache.spark.sql.catalyst.expressions.RegExpExtract;
import org.apache.spark.sql.catalyst.expressions.Round;
import org.apache.spark.sql.catalyst.expressions.Round$;
import org.apache.spark.sql.catalyst.expressions.Size$;
import org.apache.spark.sql.catalyst.expressions.SortArray;
import org.apache.spark.sql.catalyst.expressions.StringTrim$;
import org.apache.spark.sql.catalyst.expressions.StringTrimLeft$;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight$;
import org.apache.spark.sql.catalyst.expressions.Substring;
import org.apache.spark.sql.catalyst.expressions.Upper;
import org.apache.spark.sql.catalyst.expressions.Year;
import org.apache.spark.sql.catalyst.util.ArrayBasedMapData$;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class HoodieProcedureFilterUtils$ {
    public static HoodieProcedureFilterUtils$ MODULE$;

    static {
        new HoodieProcedureFilterUtils$();
    }

    public Seq<Row> evaluateFilter(Seq<Row> rows, String filterExpression, StructType schema, SparkSession sparkSession) {
        if (filterExpression == null || filterExpression.trim().isEmpty()) {
            return rows;
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Expression parsedExpr = sparkSession.sessionState().sqlParser().parseExpression(filterExpression);
            return (Seq)rows.filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)HoodieProcedureFilterUtils$.MODULE$.evaluateExpressionOnRow(parsedExpr, row, schema)));
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Seq filteredRows = (Seq)success.value();
            return filteredRows;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw new IllegalArgumentException(new StringBuilder(50).append("Failed to parse or evaluate filter expression '").append(filterExpression).append("': ").append(exception.getMessage()).toString(), exception);
        }
        throw new MatchError((Object)try_);
    }

    private boolean evaluateExpressionOnRow(Expression expression, Row row, StructType schema) {
        GenericInternalRow internalRow = this.convertRowToInternalRow(row, schema);
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Expression attributeBound = (Expression)expression.transform((PartialFunction)new scala.Serializable(schema){
                public static final long serialVersionUID = 0L;
                private final StructType schema$2;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    A1 A1 = x1;
                    if (A1 instanceof UnresolvedAttribute) {
                        UnresolvedAttribute unresolvedAttribute;
                        UnresolvedAttribute unresolvedAttribute2 = (UnresolvedAttribute)A1;
                        try {
                            int fieldIndex = this.schema$2.fieldIndex(unresolvedAttribute2.name());
                            StructField field = this.schema$2.fields()[fieldIndex];
                            unresolvedAttribute = new BoundReference(fieldIndex, field.dataType(), field.nullable());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            unresolvedAttribute = unresolvedAttribute2;
                        }
                        return (B1)unresolvedAttribute;
                    }
                    return (B1)function1.apply(x1);
                }

                public final boolean isDefinedAt(Expression x1) {
                    Expression expression = x1;
                    return expression instanceof UnresolvedAttribute;
                }
                {
                    this.schema$2 = schema$2;
                }
            });
            Expression functionResolved = (Expression)attributeBound.transform((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                    A1 A1 = x2;
                    if (A1 instanceof UnresolvedFunction) {
                        UnresolvedFunction unresolvedFunction = (UnresolvedFunction)A1;
                        String string = ((String)unresolvedFunction.nameParts().head()).toLowerCase();
                        if ("upper".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Upper((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("lower".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Lower((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("length".equals(string) ? true : "len".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Length((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("trim".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)StringTrim$.MODULE$.apply((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("ltrim".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)StringTrimLeft$.MODULE$.apply((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("rtrim".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)StringTrimRight$.MODULE$.apply((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("substring".equals(string) ? true : "substr".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 3) {
                                return (B1)new Substring((Expression)unresolvedFunction.arguments().apply(0), (Expression)unresolvedFunction.arguments().apply(1), (Expression)unresolvedFunction.arguments().apply(2));
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("abs".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Abs((Expression)unresolvedFunction.arguments().head(), Abs$.MODULE$.apply$default$2());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("round".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Round((Expression)unresolvedFunction.arguments().head(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0)), Round$.MODULE$.apply$default$3());
                            }
                            if (unresolvedFunction.arguments().length() == 2) {
                                return (B1)new Round((Expression)unresolvedFunction.arguments().apply(0), (Expression)unresolvedFunction.arguments().apply(1), Round$.MODULE$.apply$default$3());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("ceil".equals(string) ? true : "ceiling".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Ceil((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("floor".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Floor((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("year".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Year((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("month".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Month((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("day".equals(string) ? true : "dayofmonth".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new DayOfMonth((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("hour".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Hour((Expression)unresolvedFunction.arguments().head(), Hour$.MODULE$.apply$default$2());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("size".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)Size$.MODULE$.apply((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("map_keys".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new MapKeys((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("map_values".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new MapValues((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("array_contains".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 2) {
                                return (B1)new ArrayContains((Expression)unresolvedFunction.arguments().head(), (Expression)unresolvedFunction.arguments().apply(1));
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("array_size".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)Size$.MODULE$.apply((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("sort_array".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new SortArray((Expression)unresolvedFunction.arguments().head(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                            }
                            if (unresolvedFunction.arguments().length() == 2) {
                                return (B1)new SortArray((Expression)unresolvedFunction.arguments().head(), (Expression)unresolvedFunction.arguments().apply(1));
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("like".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 2) {
                                return (B1)new Like((Expression)unresolvedFunction.arguments().head(), (Expression)unresolvedFunction.arguments().apply(1), '\\');
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("rlike".equals(string) ? true : "regexp_like".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 2) {
                                return (B1)new RLike((Expression)unresolvedFunction.arguments().head(), (Expression)unresolvedFunction.arguments().apply(1));
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("regexp_extract".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 3) {
                                return (B1)new RegExpExtract((Expression)unresolvedFunction.arguments().head(), (Expression)unresolvedFunction.arguments().apply(1), (Expression)unresolvedFunction.arguments().apply(2));
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("date_format".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 2) {
                                return (B1)new DateFormatClass((Expression)unresolvedFunction.arguments().head(), (Expression)unresolvedFunction.arguments().apply(1), DateFormatClass$.MODULE$.apply$default$3());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("datediff".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 2) {
                                return (B1)new DateDiff((Expression)unresolvedFunction.arguments().head(), (Expression)unresolvedFunction.arguments().apply(1));
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("isnull".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new IsNull((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("isnotnull".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new IsNotNull((Expression)unresolvedFunction.arguments().head());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("coalesce".equals(string)) {
                            if (unresolvedFunction.arguments().nonEmpty()) {
                                return (B1)new Coalesce(unresolvedFunction.arguments());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("string".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Cast((Expression)unresolvedFunction.arguments().head(), (DataType)StringType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("int".equals(string) ? true : "integer".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Cast((Expression)unresolvedFunction.arguments().head(), (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("long".equals(string) ? true : "bigint".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Cast((Expression)unresolvedFunction.arguments().head(), (DataType)LongType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("double".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 1) {
                                return (B1)new Cast((Expression)unresolvedFunction.arguments().head(), (DataType)DoubleType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                            }
                            return (B1)unresolvedFunction;
                        }
                        if ("between".equals(string)) {
                            if (unresolvedFunction.arguments().length() == 3) {
                                Expression expr = (Expression)unresolvedFunction.arguments().apply(0);
                                Expression lower = (Expression)unresolvedFunction.arguments().apply(1);
                                Expression upper = (Expression)unresolvedFunction.arguments().apply(2);
                                return (B1)new And((Expression)new GreaterThanOrEqual(expr, lower), (Expression)new LessThanOrEqual(expr, upper));
                            }
                            return (B1)unresolvedFunction;
                        }
                        return (B1)unresolvedFunction;
                    }
                    return (B1)function1.apply(x2);
                }

                public final boolean isDefinedAt(Expression x2) {
                    Expression expression = x2;
                    return expression instanceof UnresolvedFunction;
                }
            });
            Expression boundExpr = (Expression)functionResolved.transformUp((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends Expression, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                    A1 A1 = x3;
                    if (A1 instanceof EqualTo) {
                        EqualTo equalTo = (EqualTo)A1;
                        return (B1)HoodieProcedureFilterUtils$.MODULE$.org$apache$spark$sql$hudi$command$procedures$HoodieProcedureFilterUtils$$applyTypeCoercion(equalTo.left(), equalTo.right(), (Function2 & Serializable & scala.Serializable)(left, right) -> new EqualTo(left, right), equalTo);
                    }
                    if (A1 instanceof GreaterThan) {
                        GreaterThan greaterThan = (GreaterThan)A1;
                        return (B1)HoodieProcedureFilterUtils$.MODULE$.org$apache$spark$sql$hudi$command$procedures$HoodieProcedureFilterUtils$$applyTypeCoercion(greaterThan.left(), greaterThan.right(), (Function2 & Serializable & scala.Serializable)(left, right) -> new GreaterThan(left, right), greaterThan);
                    }
                    if (A1 instanceof GreaterThanOrEqual) {
                        GreaterThanOrEqual greaterThanOrEqual = (GreaterThanOrEqual)A1;
                        return (B1)HoodieProcedureFilterUtils$.MODULE$.org$apache$spark$sql$hudi$command$procedures$HoodieProcedureFilterUtils$$applyTypeCoercion(greaterThanOrEqual.left(), greaterThanOrEqual.right(), (Function2 & Serializable & scala.Serializable)(left, right) -> new GreaterThanOrEqual(left, right), greaterThanOrEqual);
                    }
                    if (A1 instanceof LessThan) {
                        LessThan lessThan = (LessThan)A1;
                        return (B1)HoodieProcedureFilterUtils$.MODULE$.org$apache$spark$sql$hudi$command$procedures$HoodieProcedureFilterUtils$$applyTypeCoercion(lessThan.left(), lessThan.right(), (Function2 & Serializable & scala.Serializable)(left, right) -> new LessThan(left, right), lessThan);
                    }
                    if (A1 instanceof LessThanOrEqual) {
                        LessThanOrEqual lessThanOrEqual = (LessThanOrEqual)A1;
                        return (B1)HoodieProcedureFilterUtils$.MODULE$.org$apache$spark$sql$hudi$command$procedures$HoodieProcedureFilterUtils$$applyTypeCoercion(lessThanOrEqual.left(), lessThanOrEqual.right(), (Function2 & Serializable & scala.Serializable)(left, right) -> new LessThanOrEqual(left, right), lessThanOrEqual);
                    }
                    return (B1)function1.apply(x3);
                }

                public final boolean isDefinedAt(Expression x3) {
                    Expression expression = x3;
                    if (expression instanceof EqualTo) {
                        return true;
                    }
                    if (expression instanceof GreaterThan) {
                        return true;
                    }
                    if (expression instanceof GreaterThanOrEqual) {
                        return true;
                    }
                    if (expression instanceof LessThan) {
                        return true;
                    }
                    return expression instanceof LessThanOrEqual;
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.spark.sql.catalyst.expressions.Expression org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$2(org.apache.spark.sql.catalyst.expressions.Expression org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$3(org.apache.spark.sql.catalyst.expressions.Expression org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$4(org.apache.spark.sql.catalyst.expressions.Expression org.apache.spark.sql.catalyst.expressions.Expression ), $anonfun$applyOrElse$5(org.apache.spark.sql.catalyst.expressions.Expression org.apache.spark.sql.catalyst.expressions.Expression )}, serializedLambda);
                }
            });
            Object result = boundExpr.eval((InternalRow)internalRow);
            Object object = result;
            if (object == null) {
                return false;
            }
            if (object instanceof Boolean) {
                boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
                return bl;
            }
            String string = object.toString().toLowerCase();
            if ("true".equals(string)) {
                return true;
            }
            if ("false".equals(string)) {
                return false;
            }
            return false;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            boolean result = BoxesRunTime.unboxToBoolean((Object)success.value());
            return result;
        }
        if (try_ instanceof Failure) {
            return false;
        }
        throw new MatchError((Object)try_);
    }

    private GenericInternalRow convertRowToInternalRow(Row row, StructType schema) {
        Object[] values = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                StructField field = (StructField)tuple2._1();
                int index = tuple2._2$mcI$sp();
                if (row.isNullAt(index)) {
                    return null;
                }
                return MODULE$.convertValueToInternal(row.get(index), field.dataType());
            }
            throw new MatchError((Object)tuple2);
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        return new GenericInternalRow(values);
    }

    private Object convertValueToInternal(Object value, DataType dataType) {
        Object object = value;
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            String string = (String)object;
            return UTF8String.fromString((String)string);
        }
        if (object instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)object;
            return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.fromJavaTimestamp(timestamp));
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.fromJavaDate(date));
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.instantToMicros(instant));
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            return BoxesRunTime.boxToInteger((int)DateTimeUtils$.MODULE$.localDateToDays(localDate));
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            return BoxesRunTime.boxToLong((long)DateTimeUtils$.MODULE$.localDateTimeToMicros(localDateTime));
        }
        if (object instanceof Byte) {
            byte by = BoxesRunTime.unboxToByte((Object)object);
            return BoxesRunTime.boxToByte((byte)by);
        }
        if (object instanceof Short) {
            short s = BoxesRunTime.unboxToShort((Object)object);
            return BoxesRunTime.boxToShort((short)s);
        }
        if (object instanceof Integer) {
            int n = BoxesRunTime.unboxToInt((Object)object);
            return BoxesRunTime.boxToInteger((int)n);
        }
        if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            return BoxesRunTime.boxToLong((long)l);
        }
        if (object instanceof Float) {
            float f = BoxesRunTime.unboxToFloat((Object)object);
            return BoxesRunTime.boxToFloat((float)f);
        }
        if (object instanceof Double) {
            double d = BoxesRunTime.unboxToDouble((Object)object);
            return BoxesRunTime.boxToDouble((double)d);
        }
        if (object instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)object;
            return Decimal$.MODULE$.apply(bigDecimal, ((DecimalType)dataType).precision(), ((DecimalType)dataType).scale());
        }
        if (object instanceof scala.math.BigDecimal) {
            scala.math.BigDecimal bigDecimal = (scala.math.BigDecimal)object;
            return Decimal$.MODULE$.apply(bigDecimal, ((DecimalType)dataType).precision(), ((DecimalType)dataType).scale());
        }
        if (object instanceof Boolean) {
            boolean bl = BoxesRunTime.unboxToBoolean((Object)object);
            return BoxesRunTime.boxToBoolean((boolean)bl);
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            return byArray;
        }
        if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
            Object object2 = object;
            ArrayType arrayType = (ArrayType)dataType;
            return Predef$.MODULE$.genericArrayOps(object2).map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.convertValueToInternal(x$1, arrayType.elementType()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
        }
        if (object instanceof List) {
            List list = (List)object;
            ArrayType arrayType = (ArrayType)dataType;
            return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(list).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.convertValueToInternal(x$2, arrayType.elementType()), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
        }
        if (object instanceof Seq) {
            Seq seq = (Seq)object;
            ArrayType arrayType = (ArrayType)dataType;
            return ((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.convertValueToInternal(x$3, arrayType.elementType()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
        }
        if (object instanceof java.util.Map) {
            java.util.Map map = (java.util.Map)object;
            MapType mapType = (MapType)dataType;
            Object[] convertedKeys = (Object[])((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).keys().map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.convertValueToInternal(x$4, mapType.keyType()), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
            Object[] convertedValues = (Object[])((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(map).asScala()).values().map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.convertValueToInternal(x$5, mapType.valueType()), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
            return ArrayBasedMapData$.MODULE$.apply((Object)convertedKeys, (Object)convertedValues);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            MapType mapType = (MapType)dataType;
            Object[] convertedKeys = (Object[])((TraversableOnce)map.keys().map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.convertValueToInternal(x$6, mapType.keyType()), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
            Object[] convertedValues = (Object[])((TraversableOnce)map.values().map((Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.convertValueToInternal(x$7, mapType.valueType()), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Any());
            return ArrayBasedMapData$.MODULE$.apply((Object)convertedKeys, (Object)convertedValues);
        }
        if (object instanceof Row) {
            Row row = (Row)object;
            StructType structType = (StructType)dataType;
            Object[] values = (Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])structType.fields())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    StructField field = (StructField)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    if (row.isNullAt(index)) {
                        return null;
                    }
                    return MODULE$.convertValueToInternal(row.get(index), field.dataType());
                }
                throw new MatchError((Object)tuple2);
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Any()));
            return new GenericInternalRow(values);
        }
        if (object instanceof UTF8String) {
            UTF8String uTF8String = (UTF8String)object;
            return uTF8String;
        }
        if (object instanceof InternalRow) {
            InternalRow internalRow = (InternalRow)object;
            return internalRow;
        }
        if (object instanceof MapData) {
            MapData mapData = (MapData)object;
            return mapData;
        }
        if (object instanceof ArrayData) {
            ArrayData arrayData = (ArrayData)object;
            return arrayData;
        }
        if (object instanceof Decimal) {
            Decimal decimal = (Decimal)object;
            return decimal;
        }
        if (object instanceof UUID) {
            UUID uUID = (UUID)object;
            return UTF8String.fromString((String)uUID.toString());
        }
        return object;
    }

    public Either<String, BoxedUnit> validateFilterExpression(String filterExpression, StructType schema, SparkSession sparkSession) {
        if (filterExpression == null || filterExpression.trim().isEmpty()) {
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        }
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Expression parsedExpr = sparkSession.sessionState().sqlParser().parseExpression(filterExpression);
            Set columnNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])schema.fieldNames())).toSet();
            Set<String> referencedColumns = MODULE$.extractColumnReferences(parsedExpr);
            Set invalidColumns = (Set)referencedColumns.$minus$minus((GenTraversableOnce)columnNames);
            if (invalidColumns.nonEmpty()) {
                return package$.MODULE$.Left().apply((Object)new StringBuilder(48).append("Invalid column references: ").append(invalidColumns.mkString(", ")).append(". Available columns: ").append(columnNames.mkString(", ")).toString());
            }
            return package$.MODULE$.Right().apply((Object)BoxedUnit.UNIT);
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            Either result = (Either)success.value();
            return result;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            return package$.MODULE$.Left().apply((Object)new StringBuilder(27).append("Invalid filter expression: ").append(exception.getMessage()).toString());
        }
        throw new MatchError((Object)try_);
    }

    private Set<String> extractColumnReferences(Expression expression2) {
        Expression expression3 = expression2;
        if (expression3 instanceof AttributeReference) {
            AttributeReference attributeReference = (AttributeReference)expression3;
            return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{attributeReference.name()}));
        }
        if (expression3 instanceof UnresolvedAttribute) {
            UnresolvedAttribute unresolvedAttribute = (UnresolvedAttribute)expression3;
            return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{unresolvedAttribute.name()}));
        }
        return ((TraversableOnce)expression2.children().flatMap((Function1 & Serializable & scala.Serializable)expression -> MODULE$.extractColumnReferences((Expression)expression), Seq$.MODULE$.canBuildFrom())).toSet();
    }

    public <T extends Expression> T org$apache$spark$sql$hudi$command$procedures$HoodieProcedureFilterUtils$$applyTypeCoercion(Expression left, Expression right, Function2<Expression, Expression, T> constructor, T original) {
        Tuple2 tuple2 = new Tuple2((Object)left, (Object)right);
        if (tuple2 != null) {
            Expression boundRef = (Expression)tuple2._1();
            Expression literal = (Expression)tuple2._2();
            if (boundRef instanceof BoundReference) {
                BoundReference boundReference = (BoundReference)boundRef;
                if (literal instanceof Literal) {
                    Literal literal2 = (Literal)literal;
                    DataType dataType = boundReference.dataType();
                    LongType$ longType$ = LongType$.MODULE$;
                    if (!(dataType != null ? !dataType.equals(longType$) : longType$ != null)) {
                        DataType dataType2 = literal2.dataType();
                        IntegerType$ integerType$ = IntegerType$.MODULE$;
                        if (!(dataType2 != null ? !dataType2.equals(integerType$) : integerType$ != null)) {
                            Cast castExpr = new Cast((Expression)boundReference, (DataType)IntegerType$.MODULE$, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
                            return (T)((Expression)constructor.apply((Object)castExpr, (Object)literal2));
                        }
                    }
                }
            }
        }
        return original;
    }

    private HoodieProcedureFilterUtils$() {
        MODULE$ = this;
    }
}

