/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.FileNotFoundException;
import java.util.function.Supplier;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.client.common.HoodieSparkEngineContext;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.SparkMetadataWriterFactory;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.InitMetadataTableProcedure$;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mb\u0001B\n\u0015\u0001\rBQA\u000e\u0001\u0005\u0002]Bq!\u000f\u0001C\u0002\u0013%!\b\u0003\u0004E\u0001\u0001\u0006Ia\u000f\u0005\b\u000b\u0002\u0011\r\u0011\"\u0003G\u0011\u0019i\u0005\u0001)A\u0005\u000f\")a\n\u0001C\u0001u!)q\n\u0001C\u0001\r\")\u0001\u000b\u0001C!#\")q\r\u0001C!Q\u001e)\u0011\u000e\u0006E\u0001U\u001a)1\u0003\u0006E\u0001W\")ag\u0003C\u0001_\"9\u0001o\u0003b\u0001\n\u0003\t\bB\u0002>\fA\u0003%!\u000fC\u0004|\u0017\u0001\u0007I\u0011\u0001?\t\u0013\u0005=1\u00021A\u0005\u0002\u0005E\u0001bBA\u000f\u0017\u0001\u0006K! \u0005\b\u0003?YA\u0011AA\u0011\u0005iIe.\u001b;NKR\fG-\u0019;b)\u0006\u0014G.\u001a)s_\u000e,G-\u001e:f\u0015\t)b#\u0001\u0006qe>\u001cW\rZ;sKNT!a\u0006\r\u0002\u000f\r|W.\\1oI*\u0011\u0011DG\u0001\u0005QV$\u0017N\u0003\u0002\u001c9\u0005\u00191/\u001d7\u000b\u0005uq\u0012!B:qCJ\\'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001c\u0001aE\u0003\u0001I!Z\u0003\u0007\u0005\u0002&M5\tA#\u0003\u0002()\ti!)Y:f!J|7-\u001a3ve\u0016\u0004\"!J\u0015\n\u0005)\"\"\u0001\u0005)s_\u000e,G-\u001e:f\u0005VLG\u000eZ3s!\tac&D\u0001.\u0015\tIb$\u0003\u00020[\t\u00192\u000b]1sW\u0006#\u0017\r\u001d;feN+\b\u000f]8siB\u0011\u0011\u0007N\u0007\u0002e)\u00111\u0007H\u0001\tS:$XM\u001d8bY&\u0011QG\r\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t\u0001\b\u0005\u0002&\u0001\u0005Q\u0001+\u0011*B\u001b\u0016#VIU*\u0016\u0003m\u00022\u0001P B\u001b\u0005i$\"\u0001 \u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001k$!B!se\u0006L\bCA\u0013C\u0013\t\u0019EC\u0001\nQe>\u001cW\rZ;sKB\u000b'/Y7fi\u0016\u0014\u0018a\u0003)B%\u0006kU\tV#S'\u0002\n1bT+U!V#v\fV-Q\u000bV\tq\t\u0005\u0002I\u00176\t\u0011J\u0003\u0002K5\u0005)A/\u001f9fg&\u0011A*\u0013\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001D(V)B+Fk\u0018+Z!\u0016\u0003\u0013A\u00039be\u0006lW\r^3sg\u0006Qq.\u001e;qkR$\u0016\u0010]3\u0002\t\r\fG\u000e\u001c\u000b\u0003%\n\u00042aU._\u001d\t!\u0016L\u0004\u0002V16\taK\u0003\u0002XE\u00051AH]8pizJ\u0011AP\u0005\u00035v\nq\u0001]1dW\u0006<W-\u0003\u0002];\n\u00191+Z9\u000b\u0005ik\u0004CA0a\u001b\u0005Q\u0012BA1\u001b\u0005\r\u0011vn\u001e\u0005\u0006G\"\u0001\r\u0001Z\u0001\u0005CJ<7\u000f\u0005\u0002&K&\u0011a\r\u0006\u0002\u000e!J|7-\u001a3ve\u0016\f%oZ:\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0003a\n!$\u00138ji6+G/\u00193bi\u0006$\u0016M\u00197f!J|7-\u001a3ve\u0016\u0004\"!J\u0006\u0014\u0005-a\u0007C\u0001\u001fn\u0013\tqWH\u0001\u0004B]f\u0014VM\u001a\u000b\u0002U\u0006!a*Q'F+\u0005\u0011\bCA:y\u001b\u0005!(BA;w\u0003\u0011a\u0017M\\4\u000b\u0003]\fAA[1wC&\u0011\u0011\u0010\u001e\u0002\u0007'R\u0014\u0018N\\4\u0002\u000b9\u000bU*\u0012\u0011\u0002+5,G/\u00193bi\u0006\u0014\u0015m]3ESJ,7\r^8ssV\tQ\u0010\u0005\u0003=}\u0006\u0005\u0011BA@>\u0005\u0019y\u0005\u000f^5p]B!\u00111AA\u0006\u001d\u0011\t)!a\u0002\u0011\u0005Uk\u0014bAA\u0005{\u00051\u0001K]3eK\u001aL1!_A\u0007\u0015\r\tI!P\u0001\u001a[\u0016$\u0018\rZ1uC\n\u000b7/\u001a#je\u0016\u001cGo\u001c:z?\u0012*\u0017\u000f\u0006\u0003\u0002\u0014\u0005e\u0001c\u0001\u001f\u0002\u0016%\u0019\u0011qC\u001f\u0003\tUs\u0017\u000e\u001e\u0005\t\u00037\u0001\u0012\u0011!a\u0001{\u0006\u0019\u0001\u0010J\u0019\u0002-5,G/\u00193bi\u0006\u0014\u0015m]3ESJ,7\r^8ss\u0002\nqAY;jY\u0012,'/\u0006\u0002\u0002$A)\u0011QEA\u0018Q5\u0011\u0011q\u0005\u0006\u0005\u0003S\tY#\u0001\u0005gk:\u001cG/[8o\u0015\r\tiC^\u0001\u0005kRLG.\u0003\u0003\u00022\u0005\u001d\"\u0001C*vaBd\u0017.\u001a:")
public class InitMetadataTableProcedure
extends BaseProcedure
implements ProcedureBuilder,
SparkAdapterSupport,
Logging {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public static Supplier<ProcedureBuilder> builder() {
        return InitMetadataTableProcedure$.MODULE$.builder();
    }

    public static void metadataBaseDirectory_$eq(Option<String> option) {
        InitMetadataTableProcedure$.MODULE$.metadataBaseDirectory_$eq(option);
    }

    public static Option<String> metadataBaseDirectory() {
        return InitMetadataTableProcedure$.MODULE$.metadataBaseDirectory();
    }

    public static String NAME() {
        return InitMetadataTableProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        InitMetadataTableProcedure initMetadataTableProcedure = this;
        synchronized (initMetadataTableProcedure) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        BoxedUnit boxedUnit;
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        boolean readOnly = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        String basePath = this.getBasePath(tableName, this.getBasePath$default$2());
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        StoragePath metadataPath = new StoragePath(HoodieTableMetadata.getMetadataTableBasePath((String)basePath));
        try {
            metaClient.getStorage().listDirectEntries(metadataPath);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(new StringBuilder(37).append("Metadata directory (").append(metadataPath.toString()).append(") does not exist.").toString());
        }
        HoodieTimer timer = HoodieTimer.start();
        if (!readOnly) {
            HoodieWriteConfig writeConfig = this.getWriteConfig(basePath);
            boxedUnit = SparkMetadataWriterFactory.create((StorageConfiguration)metaClient.getStorageConf(), (HoodieWriteConfig)writeConfig, (HoodieEngineContext)new HoodieSparkEngineContext(this.jsc()), (HoodieTableConfig)metaClient.getTableConfig());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        String action = readOnly ? "Opened" : "Initialized";
        return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{new StringBuilder(34).append(action).append(" Metadata Table in ").append(metadataPath).append(" (duration=").append((double)timer.endTimer() / 1000.0).append("sec)").toString()})), (List)Nil$.MODULE$);
    }

    @Override
    public InitMetadataTableProcedure build() {
        return new InitMetadataTableProcedure();
    }

    public InitMetadataTableProcedure() {
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "read_only", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false))});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

