/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.avro.Schema;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.DataSourceWriteOptions$;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.HoodieSparkSqlWriter$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.ReaderContextFactory;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.PartitionBucketIndexHashingConfig;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.read.HoodieFileGroupReader;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.config.HoodieIndexConfig;
import org.apache.hudi.config.HoodieInternalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.data.CloseableIteratorListener;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.index.bucket.partition.PartitionBucketIndexCalculator;
import org.apache.hudi.index.bucket.partition.PartitionBucketIndexUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.hudi.ProvidesHoodieConfig;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.PartitionBucketIndexManager$;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=h\u0001B\u000b\u0017\u0001\u0015BQ\u0001\u0012\u0001\u0005\u0002\u0015Cqa\u0012\u0001C\u0002\u0013%\u0001\n\u0003\u0004S\u0001\u0001\u0006I!\u0013\u0005\b'\u0002\u0011\r\u0011\"\u0003U\u0011\u0019Y\u0006\u0001)A\u0005+\")A\f\u0001C\u0001\u0011\")Q\f\u0001C\u0001)\")a\f\u0001C!?\")Q\u000f\u0001C\u0005m\"9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003bBA:\u0001\u0011%\u0011Q\u000f\u0005\b\u0003\u0003\u0003A\u0011BAB\u0011\u001d\t\u0019\f\u0001C\u0005\u0003kCq!!/\u0001\t\u0003\nYlB\u0004\u0002DZA\t!!2\u0007\rU1\u0002\u0012AAd\u0011\u0019!\u0005\u0003\"\u0001\u0002P\"I\u0011\u0011\u001b\tC\u0002\u0013\u0005\u00111\u001b\u0005\t\u00033\u0004\u0002\u0015!\u0003\u0002V\"9\u00111\u001c\t\u0005\u0002\u0005u'a\u0007)beRLG/[8o\u0005V\u001c7.\u001a;J]\u0012,\u00070T1oC\u001e,'O\u0003\u0002\u00181\u0005Q\u0001O]8dK\u0012,(/Z:\u000b\u0005eQ\u0012aB2p[6\fg\u000e\u001a\u0006\u00037q\tA\u0001[;eS*\u0011QDH\u0001\u0004gFd'BA\u0010!\u0003\u0015\u0019\b/\u0019:l\u0015\t\t#%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002G\u0005\u0019qN]4\u0004\u0001M9\u0001A\n\u0016.kez\u0004CA\u0014)\u001b\u00051\u0012BA\u0015\u0017\u00055\u0011\u0015m]3Qe>\u001cW\rZ;sKB\u0011qeK\u0005\u0003YY\u0011\u0001\u0003\u0015:pG\u0016$WO]3Ck&dG-\u001a:\u0011\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014aC3yaJ,7o]5p]NT!A\r\u000f\u0002\u0011\r\fG/\u00197zgRL!\u0001N\u0018\u0003\u001fA\u0013X\rZ5dCR,\u0007*\u001a7qKJ\u0004\"AN\u001c\u000e\u0003iI!\u0001\u000f\u000e\u0003)A\u0013xN^5eKNDun\u001c3jK\u000e{gNZ5h!\tQT(D\u0001<\u0015\tad$\u0001\u0005j]R,'O\\1m\u0013\tq4HA\u0004M_\u001e<\u0017N\\4\u0011\u0005\u0001\u0013U\"A!\u000b\u0005m\u0001\u0013BA\"B\u0005M\u0019\u0006/\u0019:l\u0003\u0012\f\u0007\u000f^3s'V\u0004\bo\u001c:u\u0003\u0019a\u0014N\\5u}Q\ta\t\u0005\u0002(\u0001\u0005Q\u0001+\u0011*B\u001b\u0016#VIU*\u0016\u0003%\u00032AS'P\u001b\u0005Y%\"\u0001'\u0002\u000bM\u001c\u0017\r\\1\n\u00059[%!B!se\u0006L\bCA\u0014Q\u0013\t\tfC\u0001\nQe>\u001cW\rZ;sKB\u000b'/Y7fi\u0016\u0014\u0018a\u0003)B%\u0006kU\tV#S'\u0002\n1bT+U!V#v\fV-Q\u000bV\tQ\u000b\u0005\u0002W36\tqK\u0003\u0002Y9\u0005)A/\u001f9fg&\u0011!l\u0016\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001D(V)B+Fk\u0018+Z!\u0016\u0003\u0013A\u00039be\u0006lW\r^3sg\u0006Qq.\u001e;qkR$\u0016\u0010]3\u0002\t\r\fG\u000e\u001c\u000b\u0003AB\u00042!Y5m\u001d\t\u0011wM\u0004\u0002dM6\tAM\u0003\u0002fI\u00051AH]8pizJ\u0011\u0001T\u0005\u0003Q.\u000bq\u0001]1dW\u0006<W-\u0003\u0002kW\n\u00191+Z9\u000b\u0005!\\\u0005CA7o\u001b\u0005a\u0012BA8\u001d\u0005\r\u0011vn\u001e\u0005\u0006c\"\u0001\rA]\u0001\u0005CJ<7\u000f\u0005\u0002(g&\u0011AO\u0006\u0002\u000e!J|7-\u001a3ve\u0016\f%oZ:\u0002\u001f!\fg\u000e\u001a7f\u001fZ,'o\u001e:ji\u0016$b\u0002Y<\u0002\n\u0005u\u0011QFA\u0019\u0003w\ty\u0004C\u0003y\u0013\u0001\u0007\u00110\u0001\u0004d_:4\u0017n\u001a\t\u0007uz\f\u0019!a\u0001\u000f\u0005md\bCA2L\u0013\ti8*\u0001\u0004Qe\u0016$WMZ\u0005\u0004\u007f\u0006\u0005!aA'ba*\u0011Qp\u0013\t\u0004u\u0006\u0015\u0011\u0002BA\u0004\u0003\u0003\u0011aa\u0015;sS:<\u0007bBA\u0006\u0013\u0001\u0007\u0011QB\u0001\bG>tG/\u001a=u!\u0011\ty!!\u0007\u000e\u0005\u0005E!\u0002BA\n\u0003+\ta!\u001a8hS:,'bAA\f\u0003\u000611m\\7n_:LA!a\u0007\u0002\u0012\t\u0019\u0002j\\8eS\u0016,enZ5oK\u000e{g\u000e^3yi\"9\u0011qD\u0005A\u0002\u0005\u0005\u0012AC7fi\u0006\u001cE.[3oiB!\u00111EA\u0015\u001b\t\t)C\u0003\u0003\u0002(\u0005U\u0011!\u0002;bE2,\u0017\u0002BA\u0016\u0003K\u0011Q\u0003S8pI&,G+\u00192mK6+G/Y\"mS\u0016tG\u000fC\u0004\u00020%\u0001\r!a\u0001\u0002\u0015\u0015D\bO]3tg&|g\u000eC\u0004\u00024%\u0001\r!!\u000e\u0002\u0019\t,8m[3u\u001dVl'-\u001a:\u0011\u0007)\u000b9$C\u0002\u0002:-\u00131!\u00138u\u0011\u001d\ti$\u0003a\u0001\u0003\u0007\tAA];mK\"9\u0011\u0011I\u0005A\u0002\u0005\r\u0013A\u00023ssJ+h\u000eE\u0002K\u0003\u000bJ1!a\u0012L\u0005\u001d\u0011un\u001c7fC:\facZ3u\t&4g-\u001a:f]R\u0004\u0016M\u001d;ji&|gn\u001d\u000b\u0007\u0003\u001b\nY'a\u001c\u0011\u0011\u0005=\u0013\u0011LA\u0002\u00037j!!!\u0015\u000b\t\u0005M\u0013QK\u0001\b[V$\u0018M\u00197f\u0015\r\t9fS\u0001\u000bG>dG.Z2uS>t\u0017bA@\u0002RA!\u0011QLA4\u001b\t\tyF\u0003\u0003\u0002b\u0005\r\u0014\u0001\u00027b]\u001eT!!!\u001a\u0002\t)\fg/Y\u0005\u0005\u0003S\nyFA\u0004J]R,w-\u001a:\t\u000f\u00055$\u00021\u0001\u0002N\u00051a.Z<NCBDq!!\u001d\u000b\u0001\u0004\ti%\u0001\u0004pY\u0012l\u0015\r]\u0001\nQ\u0006tG\r\\3BI\u0012$2\u0002YA<\u0003s\nY(! \u0002\u0000!)\u0001p\u0003a\u0001s\"9\u00111B\u0006A\u0002\u00055\u0001bBA\u0010\u0017\u0001\u0007\u0011\u0011\u0005\u0005\b\u0003_Y\u0001\u0019AA\u0002\u0011\u001d\t\te\u0003a\u0001\u0003\u0007\na\u0002[1oI2,'k\u001c7mE\u0006\u001c7\u000eF\u0004a\u0003\u000b\u000bi+a,\t\u000f\u0005\u001dE\u00021\u0001\u0002\n\u0006YqO]5uK\u000ec\u0017.\u001a8ua\u0011\tY)a'\u0011\r\u00055\u00151SAL\u001b\t\tyIC\u0002\u0002\u0012\u0006\u000baa\u00197jK:$\u0018\u0002BAK\u0003\u001f\u00131c\u00159be.\u0014F\tR,sSR,7\t\\5f]R\u0004B!!'\u0002\u001c2\u0001A\u0001DAO\u0003\u000b\u000b\t\u0011!A\u0003\u0002\u0005}%aA0%cE!\u0011\u0011UAT!\rQ\u00151U\u0005\u0004\u0003K[%a\u0002(pi\"Lgn\u001a\t\u0004\u0015\u0006%\u0016bAAV\u0017\n\u0019\u0011I\\=\t\u000f\u0005}A\u00021\u0001\u0002\"!9\u0011\u0011\u0017\u0007A\u0002\u0005\r\u0011aC5ogR\fg\u000e\u001e+j[\u0016\f\u0001\u0003[1oI2,7\u000b[8x\u0007>tg-[4\u0015\u0007\u0001\f9\fC\u0004\u0002 5\u0001\r!!\t\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0005\u0005u\u0006cA\u0014\u0002@&\u0019\u0011\u0011\u0019\f\u0003\u0013A\u0013xnY3ekJ,\u0017a\u0007)beRLG/[8o\u0005V\u001c7.\u001a;J]\u0012,\u00070T1oC\u001e,'\u000f\u0005\u0002(!M\u0019\u0001#!3\u0011\u0007)\u000bY-C\u0002\u0002N.\u0013a!\u00118z%\u00164GCAAc\u0003\u0011q\u0015)T#\u0016\u0005\u0005U\u0007\u0003BA/\u0003/LA!a\u0002\u0002`\u0005)a*Q'FA\u00059!-^5mI\u0016\u0014XCAAp!\u0015\t\t/a;+\u001b\t\t\u0019O\u0003\u0003\u0002f\u0006\u001d\u0018\u0001\u00034v]\u000e$\u0018n\u001c8\u000b\t\u0005%\u00181M\u0001\u0005kRLG.\u0003\u0003\u0002n\u0006\r(\u0001C*vaBd\u0017.\u001a:")
public class PartitionBucketIndexManager
extends BaseProcedure
implements ProcedureBuilder,
PredicateHelper,
ProvidesHoodieConfig,
SparkAdapterSupport {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private SparkAdapter sparkAdapter;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    public static Supplier<ProcedureBuilder> builder() {
        return PartitionBucketIndexManager$.MODULE$.builder();
    }

    public static String NAME() {
        return PartitionBucketIndexManager$.MODULE$.NAME();
    }

    public scala.collection.immutable.Map<String, String> buildHoodieConfig(HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig.buildHoodieConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable);
    }

    public scala.collection.immutable.Map<String, String> buildBucketRescaleHoodieConfig(HoodieCatalogTable hoodieCatalogTable) {
        return ProvidesHoodieConfig.buildBucketRescaleHoodieConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable);
    }

    public scala.collection.immutable.Map<String, String> buildHoodieInsertConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession, boolean isOverwritePartition, boolean isOverwriteTable, scala.collection.immutable.Map<String, scala.Option<String>> insertPartitions, scala.collection.immutable.Map<String, String> extraOptions, scala.Option<String> staticOverwritePartitionPathOpt) {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable, (SparkSession)sparkSession, (boolean)isOverwritePartition, (boolean)isOverwriteTable, insertPartitions, extraOptions, staticOverwritePartitionPathOpt);
    }

    public scala.collection.immutable.Map<String, scala.Option<String>> buildHoodieInsertConfig$default$5() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$5$((ProvidesHoodieConfig)this);
    }

    public scala.Option<String> buildHoodieInsertConfig$default$7() {
        return ProvidesHoodieConfig.buildHoodieInsertConfig$default$7$((ProvidesHoodieConfig)this);
    }

    public scala.collection.immutable.Map<String, String> getDropDupsConfig(boolean useLegacyInsertModeFlow, scala.collection.immutable.Map<String, String> incomingParams) {
        return ProvidesHoodieConfig.getDropDupsConfig$((ProvidesHoodieConfig)this, (boolean)useLegacyInsertModeFlow, incomingParams);
    }

    public Tuple4<SaveMode, Object, Object, scala.Option<String>> deduceOverwriteConfig(SparkSession sparkSession, HoodieCatalogTable catalogTable, scala.collection.immutable.Map<String, scala.Option<String>> partitionSpec, scala.collection.immutable.Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.deduceOverwriteConfig$((ProvidesHoodieConfig)this, (SparkSession)sparkSession, (HoodieCatalogTable)catalogTable, partitionSpec, extraOptions);
    }

    public scala.collection.immutable.Map<String, String> buildHoodieDropPartitionsConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, String partitionsToDrop) {
        return ProvidesHoodieConfig.buildHoodieDropPartitionsConfig$((ProvidesHoodieConfig)this, (SparkSession)sparkSession, (HoodieCatalogTable)hoodieCatalogTable, (String)partitionsToDrop);
    }

    public scala.collection.immutable.Map<String, String> buildHoodieDeleteTableConfig(HoodieCatalogTable hoodieCatalogTable, SparkSession sparkSession) {
        return ProvidesHoodieConfig.buildHoodieDeleteTableConfig$((ProvidesHoodieConfig)this, (HoodieCatalogTable)hoodieCatalogTable, (SparkSession)sparkSession);
    }

    public HiveSyncConfig buildHiveSyncConfig(SparkSession sparkSession, HoodieCatalogTable hoodieCatalogTable, HoodieTableConfig tableConfig, scala.collection.immutable.Map<String, String> extraOptions) {
        return ProvidesHoodieConfig.buildHiveSyncConfig$((ProvidesHoodieConfig)this, (SparkSession)sparkSession, (HoodieCatalogTable)hoodieCatalogTable, (HoodieTableConfig)tableConfig, extraOptions);
    }

    public scala.collection.immutable.Map<String, String> buildHiveSyncConfig$default$4() {
        return ProvidesHoodieConfig.buildHiveSyncConfig$default$4$((ProvidesHoodieConfig)this);
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public scala.Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public scala.Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        PartitionBucketIndexManager partitionBucketIndexManager = this;
        synchronized (partitionBucketIndexManager) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Object object;
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        String overwrite = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).orNull(Predef$.MODULE$.$conforms());
        int bucketNumber = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get());
        String add = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[3]).orNull(Predef$.MODULE$.$conforms());
        boolean dryRun = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[4]).get());
        String rollback = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[5]).orNull(Predef$.MODULE$.$conforms());
        boolean showConfig = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[6]).get());
        String rule = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[7]).orNull(Predef$.MODULE$.$conforms());
        scala.Option<Object> options = this.getArgValueOrDefault(args, this.PARAMETERS()[8]);
        try {
            HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
            String basePath = hoodieCatalogTable.tableLocation();
            HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
            SparkRDDWriteClient writeClient = HoodieCLIUtils$.MODULE$.createHoodieWriteClient(this.sparkSession(), basePath, Predef$.MODULE$.Map().empty(), Option$.MODULE$.apply((Object)table));
            HoodieEngineContext context = writeClient.getEngineContext();
            scala.collection.immutable.Map config = this.buildBucketRescaleHoodieConfig(hoodieCatalogTable);
            scala.Option<Object> option = options;
            if (option instanceof Some) {
                Some some = (Some)option;
                Object p = some.value();
                config = config.$plus$plus((GenTraversableOnce)HoodieCLIUtils$.MODULE$.extractOptions((String)p));
            } else {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "No options");
            }
            config = config.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.OPERATION().key()), (Object)DataSourceWriteOptions$.MODULE$.BULK_INSERT_OPERATION_OPT_VAL()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieInternalConfig.BULKINSERT_OVERWRITE_OPERATION_TYPE.key()), (Object)WriteOperationType.BUCKET_RESCALE.value()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)DataSourceWriteOptions$.MODULE$.ENABLE_ROW_WRITER().key()), (Object)"true"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieReaderConfig.ENABLE_OPTIMIZED_LOG_BLOCKS_SCAN.key()), (Object)Boolean.toString(writeClient.getConfig().enableOptimizedLogBlocksScan()))})));
            object = showConfig ? this.handleShowConfig(metaClient) : (rollback != null ? this.handleRollback(writeClient, metaClient, rollback) : (overwrite != null ? this.handleOverwrite((scala.collection.immutable.Map<String, String>)config, context, metaClient, overwrite, bucketNumber, rule, dryRun) : (add != null ? this.handleAdd((scala.collection.immutable.Map<String, String>)config, context, metaClient, add, dryRun) : (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"ERROR", "INVALID_OPERATION", "No valid operation specified"})), (List)Nil$.MODULE$))));
        }
        catch (Exception e) {
            throw new HoodieException(e.getMessage(), (Throwable)e);
        }
        return object;
    }

    private Seq<Row> handleOverwrite(scala.collection.immutable.Map<String, String> config, HoodieEngineContext context, HoodieTableMetaClient metaClient, String expression, int bucketNumber, String rule, boolean dryRun) {
        RDD rDD;
        int n;
        StoragePath basePath = metaClient.getBasePath();
        boolean mdtEnable = metaClient.getStorage().exists(new StoragePath(metaClient.getBasePath(), ".hoodie/metadata"));
        java.util.List allPartitions = FSUtils.getAllPartitionPaths((HoodieEngineContext)context, (HoodieTableMetaClient)metaClient, (boolean)mdtEnable);
        boolean usePartitionBucketIndexBefore = PartitionBucketIndexUtils.isPartitionSimpleBucketIndex((StorageConfiguration)context.getStorageConf(), (String)basePath.toString());
        java.util.Map partition2BucketWithLatestHashingConfig = null;
        PartitionBucketIndexCalculator calcWithLatestInstant = null;
        if (usePartitionBucketIndexBefore) {
            PartitionBucketIndexHashingConfig latestHashingConfig = PartitionBucketIndexHashingConfig.loadingLatestHashingConfig((HoodieTableMetaClient)metaClient);
            calcWithLatestInstant = PartitionBucketIndexCalculator.getInstance((String)latestHashingConfig.getExpressions(), (String)latestHashingConfig.getRule(), (int)latestHashingConfig.getDefaultBucketNumber());
            partition2BucketWithLatestHashingConfig = calcWithLatestInstant.getAllBucketNumbers(allPartitions);
        } else {
            ValidationUtils.checkArgument((bucketNumber != -1 ? 1 : 0) != 0);
            partition2BucketWithLatestHashingConfig = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(allPartitions).asScala()).map((Function1 & Serializable & scala.Serializable)partition -> new Tuple2(partition, (Object)new Integer(bucketNumber)), Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
        }
        if (bucketNumber != -1) {
            n = bucketNumber;
        } else if (calcWithLatestInstant != null) {
            n = calcWithLatestInstant.getDefaultBucketNumber();
        } else {
            throw new HoodieException("Please set original bucket number before upgrade to partition bucket level bucket index");
        }
        int defaultBucketNumber = n;
        scala.collection.immutable.Map finalConfig = config.$plus$plus((GenTraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.BUCKET_INDEX_PARTITION_EXPRESSIONS.key()), (Object)expression), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.BUCKET_INDEX_PARTITION_RULE_TYPE.key()), (Object)rule), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HoodieIndexConfig.BUCKET_INDEX_NUM_BUCKETS.key()), (Object)Integer.toString(bucketNumber))})));
        PartitionBucketIndexCalculator calcWithNewExpression = PartitionBucketIndexCalculator.getInstance((String)expression, (String)rule, (int)defaultBucketNumber);
        java.util.Map partition2BucketWithNewHashingConfig = calcWithNewExpression.getAllBucketNumbers(allPartitions);
        scala.collection.mutable.Map<String, Integer> rescalePartitionsMap = this.getDifferentPartitions((scala.collection.mutable.Map<String, Integer>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(partition2BucketWithNewHashingConfig).asScala()), (scala.collection.mutable.Map<String, Integer>)((scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(partition2BucketWithLatestHashingConfig).asScala()));
        if (dryRun) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Dry run OVERWRITE");
            String content = ((TraversableOnce)rescalePartitionsMap.map((Function1 & Serializable & scala.Serializable)entry -> {
                String details = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(34).append("\n             |").append(entry._1()).append(" => ").append(entry._2()).append("\n             |").toString())).stripMargin();
                return details;
            }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom())).toSeq().mkString(";");
            return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"SUCCESS", "DRY_RUN_OVERWRITE", content})), (List)Nil$.MODULE$);
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Perform OVERWRITE with dry-run disabled.");
        Iterable partitionsToRescale = rescalePartitionsMap.keys();
        java.util.Map allFilesMap = FSUtils.getFilesInPartitions((HoodieEngineContext)context, (HoodieTableMetaClient)metaClient, (HoodieMetadataConfig)HoodieMetadataConfig.newBuilder().enable(mdtEnable).build(), (String[])((String[])((TraversableOnce)((TraversableLike)partitionsToRescale.map((Function1 & Serializable & scala.Serializable)relative -> new StoragePath(basePath, relative), Iterable$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)storagePath -> storagePath.toString(), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class))));
        List files = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(allFilesMap.values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)x -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(x).asScala(), Iterable$.MODULE$.canBuildFrom())).toList();
        HoodieTableFileSystemView view = new HoodieTableFileSystemView(metaClient, (HoodieTimeline)metaClient.getActiveTimeline(), (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)files).asJava());
        List allFileSlice = ((TraversableOnce)partitionsToRescale.flatMap((Function1 & Serializable & scala.Serializable)partitionPath -> (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(view.getLatestFileSlices(partitionPath).iterator()).asScala(), Iterable$.MODULE$.canBuildFrom())).toList();
        Schema tableSchemaWithMetaFields = null;
        try {
            tableSchemaWithMetaFields = HoodieAvroUtils.addMetadataFields((Schema)new TableSchemaResolver(metaClient).getTableAvroSchema(false), (boolean)false);
        }
        catch (Exception e) {
            throw new HoodieException("Failed to get table schema during clustering", (Throwable)e);
        }
        ReaderContextFactory readerContextFactory = context.getReaderContextFactory(metaClient);
        StructType sparkSchemaWithMetaFields = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(tableSchemaWithMetaFields);
        if (allFileSlice.isEmpty()) {
            rDD = this.spark().sparkContext().emptyRDD(ClassTag$.MODULE$.apply(InternalRow.class));
        } else {
            SerializableSchema serializableTableSchemaWithMetaFields = new SerializableSchema(tableSchemaWithMetaFields);
            HoodieInstant latestInstantTime = (HoodieInstant)metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().lastInstant().get();
            rDD = this.spark().sparkContext().parallelize((Seq)allFileSlice, allFileSlice.size(), ClassTag$.MODULE$.apply(FileSlice.class)).flatMap((Function1 & Serializable & scala.Serializable)fileSlice -> {
                Schema readerSchema = serializableTableSchemaWithMetaFields.get();
                Option internalSchemaOption = Option.empty();
                boolean enableOptimizedLogBlockScan = new StringOps(Predef$.MODULE$.augmentString((String)config.getOrElse((Object)HoodieReaderConfig.ENABLE_OPTIMIZED_LOG_BLOCKS_SCAN.key(), (Function0 & Serializable & scala.Serializable)() -> (String)HoodieReaderConfig.ENABLE_OPTIMIZED_LOG_BLOCKS_SCAN.defaultValue()))).toBoolean();
                HoodieFileGroupReader fileGroupReader = HoodieFileGroupReader.newBuilder().withReaderContext(readerContextFactory.getContext()).withHoodieTableMetaClient(metaClient).withLatestCommitTime(latestInstantTime.requestedTime()).withFileSlice(fileSlice).withDataSchema(readerSchema).withRequestedSchema(readerSchema).withInternalSchema(internalSchemaOption).withProps(metaClient.getTableConfig().getProps()).withShouldUseRecordPosition(false).withEnableOptimizedLogBlockScan(enableOptimizedLogBlockScan).build();
                ClosableIterator iterator = fileGroupReader.getClosableIterator();
                CloseableIteratorListener.addListener((java.util.Iterator)iterator);
                return (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)iterator).asScala();
            }, ClassTag$.MODULE$.apply(InternalRow.class));
        }
        RDD res = rDD;
        Dataset dataFrame = this.sparkAdapter().getUnsafeUtils().createDataFrameFromRDD(this.sparkSession(), res, sparkSchemaWithMetaFields);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Start to do bucket rescale for ").append(rescalePartitionsMap).toString());
        Tuple6 tuple6 = HoodieSparkSqlWriter$.MODULE$.write(this.sparkSession().sqlContext(), SaveMode.Append, finalConfig, dataFrame, HoodieSparkSqlWriter$.MODULE$.write$default$5(), HoodieSparkSqlWriter$.MODULE$.write$default$6(), HoodieSparkSqlWriter$.MODULE$.write$default$7());
        if (tuple6 == null) {
            throw new MatchError((Object)tuple6);
        }
        boolean success = BoxesRunTime.unboxToBoolean((Object)tuple6._1());
        boolean success2 = success;
        String details = new StringBuilder(40).append("Expression: ").append(expression).append(", Bucket Number: ").append(bucketNumber).append(", Dry Run: ").append(dryRun).toString();
        boolean archived = PartitionBucketIndexHashingConfig.archiveHashingConfigIfNecessary((HoodieTableMetaClient)metaClient);
        return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"SUCCESS", "OVERWRITE", details})), (List)Nil$.MODULE$);
    }

    public scala.collection.mutable.Map<String, Integer> getDifferentPartitions(scala.collection.mutable.Map<String, Integer> newMap, scala.collection.mutable.Map<String, Integer> oldMap) {
        return (scala.collection.mutable.Map)newMap.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionBucketIndexManager.$anonfun$getDifferentPartitions$1(oldMap, x0$1)));
    }

    private Seq<Row> handleAdd(scala.collection.immutable.Map<String, String> config, HoodieEngineContext context, HoodieTableMetaClient metaClient, String expression, boolean dryRun) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Handle Add Expression Operation");
        PartitionBucketIndexHashingConfig hashingConfig = PartitionBucketIndexHashingConfig.loadingLatestHashingConfig((HoodieTableMetaClient)metaClient);
        String latestExpression = hashingConfig.getExpressions();
        return this.handleOverwrite(config, context, metaClient, new StringBuilder(1).append(expression).append(";").append(latestExpression).toString(), hashingConfig.getDefaultBucketNumber(), hashingConfig.getRule(), dryRun);
    }

    private Seq<Row> handleRollback(SparkRDDWriteClient<?> writeClient, HoodieTableMetaClient metaClient, String instantTime) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Handle Add Expression Operation");
        Option hashingConfig = PartitionBucketIndexHashingConfig.loadHashingConfig((HoodieStorage)metaClient.getStorage(), (StoragePath)PartitionBucketIndexHashingConfig.getHashingConfigPath((String)metaClient.getBasePath().toString(), (String)instantTime));
        if (hashingConfig.isPresent()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Start to rollback ").append(instantTime).toString());
            writeClient.getConfig().setValue(HoodieWriteConfig.ROLLBACK_USING_MARKERS_ENABLE, "false");
            writeClient.getConfig().setValue(HoodieIndexConfig.BUCKET_INDEX_PARTITION_EXPRESSIONS, ((PartitionBucketIndexHashingConfig)hashingConfig.get()).getExpressions());
            boolean result = writeClient.rollback(instantTime);
            return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"SUCCESS", "ROLLBACK", new StringBuilder(13).append(result).append(" to rollback ").append(instantTime).toString()})), (List)Nil$.MODULE$);
        }
        return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"FAILED", "ROLLBACK", null})), (List)Nil$.MODULE$);
    }

    private Seq<Row> handleShowConfig(HoodieTableMetaClient metaClient) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Handle showConfig operation");
        java.util.List hashingConfigs = PartitionBucketIndexHashingConfig.getAllHashingConfig((HoodieTableMetaClient)metaClient);
        String res = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(hashingConfigs).asScala()).map((Function1 & Serializable & scala.Serializable)config -> config.toString(), Buffer$.MODULE$.canBuildFrom())).mkString(";");
        return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"SUCCESS", "SHOW_CONFIG", res})), (List)Nil$.MODULE$);
    }

    @Override
    public Procedure build() {
        return new PartitionBucketIndexManager();
    }

    public static final /* synthetic */ boolean $anonfun$getDifferentPartitions$1(scala.collection.mutable.Map oldMap$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String partitionPath = (String)tuple2._1();
            Integer bucketNumber = (Integer)tuple2._2();
            return !oldMap$1.contains((Object)partitionPath) || !BoxesRunTime.equals((Object)oldMap$1.apply((Object)partitionPath), (Object)bucketNumber);
        }
        throw new MatchError((Object)tuple2);
    }

    public PartitionBucketIndexManager() {
        AliasHelper.$init$((AliasHelper)this);
        Logging.$init$((Logging)this);
        PredicateHelper.$init$((PredicateHelper)this);
        ProvidesHoodieConfig.$init$((ProvidesHoodieConfig)this);
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "overwrite", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(2, "bucket_number", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)-1)), ProcedureParameter$.MODULE$.optional(3, "add", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(4, "dry_run", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)true)), ProcedureParameter$.MODULE$.optional(5, "rollback", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(6, "show_config", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(7, "rule", DataTypes.StringType, "regex"), ProcedureParameter$.MODULE$.optional(8, "options", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4())});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("result", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("operation", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("details", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

