/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.client.BaseHoodieTableServiceClient;
import org.apache.hudi.client.SparkRDDWriteClient;
import org.apache.hudi.common.HoodiePendingRollbackInfo;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.table.HoodieSparkTable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.AliasHelper;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.PredicateHelper;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.RunRollbackInflightTableServiceProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd\u0001B\t\u0013\u0001\u0005BQa\u000e\u0001\u0005\u0002aBQA\u000f\u0001\u0005BmBqa\u0010\u0001C\u0002\u0013%\u0001\t\u0003\u0004K\u0001\u0001\u0006I!\u0011\u0005\b\u0017\u0002\u0011\r\u0011\"\u0003M\u0011\u0019\u0019\u0006\u0001)A\u0005\u001b\")A\u000b\u0001C!\u0001\")Q\u000b\u0001C!\u0019\")a\u000b\u0001C!/\")Q\u000e\u0001C\u0005]\u001e9\u0011q\u0006\n\t\u0002\u0005EbAB\t\u0013\u0011\u0003\t\u0019\u0004\u0003\u00048\u0019\u0011\u0005\u00111\b\u0005\n\u0003{a!\u0019!C\u0001\u0003\u007fA\u0001\"!\u0015\rA\u0003%\u0011\u0011\t\u0005\b\u0003'bA\u0011AA+\u0005!\u0012VO\u001c*pY2\u0014\u0017mY6J]\u001ad\u0017n\u001a5u)\u0006\u0014G.Z*feZL7-\u001a)s_\u000e,G-\u001e:f\u0015\t\u0019B#\u0001\u0006qe>\u001cW\rZ;sKNT!!\u0006\f\u0002\u000f\r|W.\\1oI*\u0011q\u0003G\u0001\u0005QV$\u0017N\u0003\u0002\u001a5\u0005\u00191/\u001d7\u000b\u0005ma\u0012!B:qCJ\\'BA\u000f\u001f\u0003\u0019\t\u0007/Y2iK*\tq$A\u0002pe\u001e\u001c\u0001aE\u0003\u0001E\u0019J\u0013\u0007\u0005\u0002$I5\t!#\u0003\u0002&%\ti!)Y:f!J|7-\u001a3ve\u0016\u0004\"aI\u0014\n\u0005!\u0012\"\u0001\u0005)s_\u000e,G-\u001e:f\u0005VLG\u000eZ3s!\tQs&D\u0001,\u0015\taS&A\u0006fqB\u0014Xm]:j_:\u001c(B\u0001\u0018\u0019\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u0019,\u0005=\u0001&/\u001a3jG\u0006$X\rS3ma\u0016\u0014\bC\u0001\u001a6\u001b\u0005\u0019$B\u0001\u001b\u001b\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u001c4\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u001d\u0011\u0005\r\u0002\u0011!\u00022vS2$W#\u0001\u001f\u0011\u0005\rj\u0014B\u0001 \u0013\u0005%\u0001&o\\2fIV\u0014X-\u0001\u0006Q\u0003J\u000bU*\u0012+F%N+\u0012!\u0011\t\u0004\u0005\u0016;U\"A\"\u000b\u0003\u0011\u000bQa]2bY\u0006L!AR\"\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\rB\u0015BA%\u0013\u0005I\u0001&o\\2fIV\u0014X\rU1sC6,G/\u001a:\u0002\u0017A\u000b%+Q'F)\u0016\u00136\u000bI\u0001\f\u001fV#\u0006+\u0016+`)f\u0003V)F\u0001N!\tq\u0015+D\u0001P\u0015\t\u0001\u0006$A\u0003usB,7/\u0003\u0002S\u001f\nQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0019=+F\u000bU+U?RK\u0006+\u0012\u0011\u0002\u0015A\f'/Y7fi\u0016\u00148/\u0001\u0006pkR\u0004X\u000f\u001e+za\u0016\fAaY1mYR\u0011\u0001\f\u001b\t\u00043\u0006$gB\u0001.`\u001d\tYf,D\u0001]\u0015\ti\u0006%\u0001\u0004=e>|GOP\u0005\u0002\t&\u0011\u0001mQ\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00117MA\u0002TKFT!\u0001Y\"\u0011\u0005\u00154W\"\u0001\r\n\u0005\u001dD\"a\u0001*po\")\u0011.\u0003a\u0001U\u0006!\u0011M]4t!\t\u00193.\u0003\u0002m%\ti\u0001K]8dK\u0012,(/Z!sON\f1\u0004Z8S_2d'-Y2l\u001f:LeN\u001a7jO\"$\u0018J\\:uC:$HCB8s\u0003\u001b\t)\u0003\u0005\u0002Ca&\u0011\u0011o\u0011\u0002\u0005+:LG\u000fC\u0003t\u0015\u0001\u0007A/\u0001\u0004dY&,g\u000e\u001e\u0019\u0003kv\u00042A^=|\u001b\u00059(BA:y\u0015\t9B$\u0003\u0002{o\n\u00192\u000b]1sWJ#Ei\u0016:ji\u0016\u001cE.[3oiB\u0011A0 \u0007\u0001\t%q(/!A\u0001\u0002\u000b\u0005qPA\u0002`II\nB!!\u0001\u0002\bA\u0019!)a\u0001\n\u0007\u0005\u00151IA\u0004O_RD\u0017N\\4\u0011\u0007\t\u000bI!C\u0002\u0002\f\r\u00131!\u00118z\u0011\u001d\tyA\u0003a\u0001\u0003#\tq\"\u001b8gY&<\u0007\u000e^%ogR\fg\u000e\u001e\t\u0005\u0003'\t\t#\u0004\u0002\u0002\u0016)!\u0011qCA\r\u0003!!\u0018.\\3mS:,'\u0002BA\u000e\u0003;\tQ\u0001^1cY\u0016T1!a\by\u0003\u0019\u0019w.\\7p]&!\u00111EA\u000b\u00055Aun\u001c3jK&s7\u000f^1oi\"9\u0011q\u0005\u0006A\u0002\u0005%\u0012\u0001D5t\u00072,8\u000f^3sS:<\u0007c\u0001\"\u0002,%\u0019\u0011QF\"\u0003\u000f\t{w\u000e\\3b]\u0006A#+\u001e8S_2d'-Y2l\u0013:4G.[4iiR\u000b'\r\\3TKJ4\u0018nY3Qe>\u001cW\rZ;sKB\u00111\u0005D\n\u0004\u0019\u0005U\u0002c\u0001\"\u00028%\u0019\u0011\u0011H\"\u0003\r\u0005s\u0017PU3g)\t\t\t$\u0001\u0003O\u00036+UCAA!!\u0011\t\u0019%!\u0014\u000e\u0005\u0005\u0015#\u0002BA$\u0003\u0013\nA\u0001\\1oO*\u0011\u00111J\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002P\u0005\u0015#AB*ue&tw-A\u0003O\u00036+\u0005%A\u0004ck&dG-\u001a:\u0016\u0005\u0005]\u0003#BA-\u0003G2SBAA.\u0015\u0011\ti&a\u0018\u0002\u0011\u0019,hn\u0019;j_:TA!!\u0019\u0002J\u0005!Q\u000f^5m\u0013\u0011\t)'a\u0017\u0003\u0011M+\b\u000f\u001d7jKJ\u0004")
public class RunRollbackInflightTableServiceProcedure
extends BaseProcedure
implements ProcedureBuilder,
PredicateHelper {
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Supplier<ProcedureBuilder> builder() {
        return RunRollbackInflightTableServiceProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return RunRollbackInflightTableServiceProcedure$.MODULE$.NAME();
    }

    public Seq<Expression> splitConjunctivePredicates(Expression condition) {
        return PredicateHelper.splitConjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Option<Tuple2<Expression, LogicalPlan>> findExpressionAndTrackLineageDown(Expression exp, LogicalPlan plan) {
        return PredicateHelper.findExpressionAndTrackLineageDown$((PredicateHelper)this, (Expression)exp, (LogicalPlan)plan);
    }

    public Seq<Expression> splitDisjunctivePredicates(Expression condition) {
        return PredicateHelper.splitDisjunctivePredicates$((PredicateHelper)this, (Expression)condition);
    }

    public Expression buildBalancedPredicate(Seq<Expression> expressions, Function2<Expression, Expression, Expression> op) {
        return PredicateHelper.buildBalancedPredicate$((PredicateHelper)this, expressions, op);
    }

    public boolean canEvaluate(Expression expr, LogicalPlan plan) {
        return PredicateHelper.canEvaluate$((PredicateHelper)this, (Expression)expr, (LogicalPlan)plan);
    }

    public boolean canEvaluateWithinJoin(Expression expr) {
        return PredicateHelper.canEvaluateWithinJoin$((PredicateHelper)this, (Expression)expr);
    }

    public Option<Expression> extractPredicatesWithinOutputSet(Expression condition, AttributeSet outputSet) {
        return PredicateHelper.extractPredicatesWithinOutputSet$((PredicateHelper)this, (Expression)condition, (AttributeSet)outputSet);
    }

    public boolean isNullIntolerant(Expression expr) {
        return PredicateHelper.isNullIntolerant$((PredicateHelper)this, (Expression)expr);
    }

    public Seq<Attribute> outputWithNullability(Seq<Attribute> output, Seq<ExprId> nonNullAttrExprIds) {
        return PredicateHelper.outputWithNullability$((PredicateHelper)this, output, nonNullAttrExprIds);
    }

    public boolean isLikelySelective(Expression e) {
        return PredicateHelper.isLikelySelective$((PredicateHelper)this, (Expression)e);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public AttributeMap<Alias> getAliasMap(Project plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Project)plan);
    }

    public AttributeMap<Alias> getAliasMap(Aggregate plan) {
        return AliasHelper.getAliasMap$((AliasHelper)this, (Aggregate)plan);
    }

    public AttributeMap<Alias> getAliasMap(Seq<NamedExpression> exprs) {
        return AliasHelper.getAliasMap$((AliasHelper)this, exprs);
    }

    public Expression replaceAlias(Expression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAlias$((AliasHelper)this, (Expression)expr, aliasMap);
    }

    public NamedExpression replaceAliasButKeepName(NamedExpression expr, AttributeMap<Alias> aliasMap) {
        return AliasHelper.replaceAliasButKeepName$((AliasHelper)this, (NamedExpression)expr, aliasMap);
    }

    public Expression trimAliases(Expression e) {
        return AliasHelper.trimAliases$((AliasHelper)this, (Expression)e);
    }

    public <T extends Expression> T trimNonTopLevelAliases(T e) {
        return (T)AliasHelper.trimNonTopLevelAliases$((AliasHelper)this, e);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public Procedure build() {
        return new RunRollbackInflightTableServiceProcedure();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Seq seq;
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        Option<Object> tablePath = this.getArgValueOrDefault(args, this.PARAMETERS()[1]);
        String pendingInstant = this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get().toString();
        boolean deleteRequestInstantFile = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[3]).get());
        String basePath = this.getBasePath(tableName, tablePath);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)this.jsc().hadoopConfiguration())).setBasePath(basePath).build();
        InstantGenerator instantGenerator = metaClient.getTimelineLayout().getInstantGenerator();
        boolean isClustering = true;
        ObjectRef instant = ObjectRef.create(null);
        HoodieInstant pendingCompactionInstant = instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", pendingInstant);
        org.apache.hudi.common.util.Option pendingClusteringInstant = ClusteringUtils.getInflightClusteringInstant((String)pendingInstant, (HoodieActiveTimeline)metaClient.getActiveTimeline(), (InstantGenerator)metaClient.getTimelineLayout().getInstantGenerator());
        HoodieTimeline timeline = metaClient.getActiveTimeline().getWriteTimeline();
        if (!timeline.containsInstant(pendingCompactionInstant) && !pendingClusteringInstant.isPresent()) {
            throw new RuntimeException(new StringBuilder(35).append("there is no pending instant : [").append(pendingClusteringInstant).append(" | ").append(pendingCompactionInstant).append("]").toString());
        }
        if (timeline.containsInstant(pendingCompactionInstant)) {
            isClustering = false;
            instant.elem = pendingCompactionInstant;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("compaction instant to rollback : ").append((HoodieInstant)instant$1.elem).toString());
        } else {
            isClustering = true;
            instant.elem = (HoodieInstant)pendingClusteringInstant.get();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("clustering instant to rollback : ").append((HoodieInstant)instant$1.elem).toString());
        }
        try (SparkRDDWriteClient client = null;){
            client = HoodieCLIUtils$.MODULE$.createHoodieWriteClient(this.sparkSession(), basePath, Predef$.MODULE$.Map().empty(), tableName);
            long startTs = System.currentTimeMillis();
            this.doRollbackOnInflightInstant(client, (HoodieInstant)instant.elem, isClustering);
            if (deleteRequestInstantFile) {
                HoodieInstant requestInstant = instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, ((HoodieInstant)instant.elem).getAction(), ((HoodieInstant)instant.elem).requestedTime());
                metaClient.getActiveTimeline().deleteInstantFileIfExists(requestInstant);
            }
            long timeCost = System.currentTimeMillis() - startTs;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Finish rollback pending instant: ").append(pendingInstant).append(",").append(" time cost: ").append(timeCost).append(" ms.").toString());
            seq = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{((HoodieInstant)instant.elem).requestedTime(), Long.toString(timeCost)})), (List)Nil$.MODULE$);
        }
        return seq;
    }

    private void doRollbackOnInflightInstant(SparkRDDWriteClient<?> client, HoodieInstant inflightInstant, boolean isClustering) {
        BaseHoodieTableServiceClient tsClient = client.getTableServiceClient();
        HoodieSparkTable table = HoodieSparkTable.create((HoodieWriteConfig)client.getConfig(), (HoodieEngineContext)client.getEngineContext());
        Function<String, org.apache.hudi.common.util.Option<HoodiePendingRollbackInfo>> getPendingRollbackInstantFunc = new Function<String, org.apache.hudi.common.util.Option<HoodiePendingRollbackInfo>>(null, tsClient, table){
            private final BaseHoodieTableServiceClient tsClient$1;
            private final HoodieSparkTable table$1;

            public <V> Function<V, org.apache.hudi.common.util.Option<HoodiePendingRollbackInfo>> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super org.apache.hudi.common.util.Option<HoodiePendingRollbackInfo>, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public org.apache.hudi.common.util.Option<HoodiePendingRollbackInfo> apply(String commitToRollback) {
                return this.tsClient$1.getPendingRollbackInfo(this.table$1.getMetaClient(), commitToRollback, false);
            }
            {
                this.tsClient$1 = tsClient$1;
                this.table$1 = table$1;
            }
        };
        if (isClustering) {
            table.rollbackInflightClustering(inflightInstant, (Function)getPendingRollbackInstantFunc, client.getTransactionManager());
            return;
        }
        table.rollbackInflightCompaction(inflightInstant, (Function)getPendingRollbackInstantFunc, client.getTransactionManager());
    }

    public RunRollbackInflightTableServiceProcedure() {
        AliasHelper.$init$((AliasHelper)this);
        Logging.$init$((Logging)this);
        PredicateHelper.$init$((PredicateHelper)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.optional(0, "table", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.optional(1, "path", DataTypes.StringType, None$.MODULE$), ProcedureParameter$.MODULE$.required(2, "pending_instant", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(3, "delete_request_instant_file", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false))});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("instant", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("time_cost", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));
    }
}

