/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.hudi.client.transaction.lock.StorageLockClient;
import org.apache.hudi.client.transaction.lock.audit.StorageLockProviderAuditService;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.SetAuditLockProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001\u0002\u000b\u0016\u0001\u0011BQ\u0001\f\u0001\u0005\u00025Bqa\f\u0001C\u0002\u0013%\u0001\u0007\u0003\u0004;\u0001\u0001\u0006I!\r\u0005\bw\u0001\u0011\r\u0011\"\u0003=\u0011\u0019\u0019\u0005\u0001)A\u0005{!9A\t\u0001b\u0001\n\u0013)\u0005B\u0002*\u0001A\u0003%a\tC\u0003T\u0001\u0011\u0005\u0001\u0007C\u0003U\u0001\u0011\u0005A\bC\u0003V\u0001\u0011\u0005c\u000bC\u0003m\u0001\u0011%Q\u000eC\u0004\u0002\u0018\u0001!I!!\u0007\t\u000f\u0005u\u0001\u0001\"\u0011\u0002 \u001d9\u0011qE\u000b\t\u0002\u0005%bA\u0002\u000b\u0016\u0011\u0003\tY\u0003\u0003\u0004-\u001f\u0011\u0005\u00111\u0007\u0005\n\u0003ky!\u0019!C\u0001\u0003oA\u0001\"a\u0012\u0010A\u0003%\u0011\u0011\b\u0005\b\u0003\u0013zA\u0011AA&\u0005U\u0019V\r^!vI&$Hj\\2l!J|7-\u001a3ve\u0016T!AF\f\u0002\u0015A\u0014xnY3ekJ,7O\u0003\u0002\u00193\u000591m\\7nC:$'B\u0001\u000e\u001c\u0003\u0011AW\u000fZ5\u000b\u0005qi\u0012aA:rY*\u0011adH\u0001\u0006gB\f'o\u001b\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001)\u0013\u0006\u0005\u0002'O5\tQ#\u0003\u0002)+\ti!)Y:f!J|7-\u001a3ve\u0016\u0004\"A\n\u0016\n\u0005-*\"\u0001\u0005)s_\u000e,G-\u001e:f\u0005VLG\u000eZ3s\u0003\u0019a\u0014N\\5u}Q\ta\u0006\u0005\u0002'\u0001\u0005Q\u0001+\u0011*B\u001b\u0016#VIU*\u0016\u0003E\u00022AM\u001b8\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$!B!se\u0006L\bC\u0001\u00149\u0013\tITC\u0001\nQe>\u001cW\rZ;sKB\u000b'/Y7fi\u0016\u0014\u0018a\u0003)B%\u0006kU\tV#S'\u0002\n1bT+U!V#v\fV-Q\u000bV\tQ\b\u0005\u0002?\u00036\tqH\u0003\u0002A7\u0005)A/\u001f9fg&\u0011!i\u0010\u0002\u000b'R\u0014Xo\u0019;UsB,\u0017\u0001D(V)B+Fk\u0018+Z!\u0016\u0003\u0013!D(C\u0015\u0016\u001bEkX'B!B+%+F\u0001G!\t9\u0005+D\u0001I\u0015\tI%*\u0001\u0005eCR\f'-\u001b8e\u0015\tYE*A\u0004kC\u000e\\7o\u001c8\u000b\u00055s\u0015!\u00034bgR,'\u000f_7m\u0015\u0005y\u0015aA2p[&\u0011\u0011\u000b\u0013\u0002\r\u001f\nTWm\u0019;NCB\u0004XM]\u0001\u000f\u001f\nSUi\u0011+`\u001b\u0006\u0003\u0006+\u0012*!\u0003)\u0001\u0018M]1nKR,'o]\u0001\u000b_V$\b/\u001e;UsB,\u0017\u0001B2bY2$\"aV4\u0011\u0007a\u00037M\u0004\u0002Z=:\u0011!,X\u0007\u00027*\u0011AlI\u0001\u0007yI|w\u000e\u001e \n\u0003QJ!aX\u001a\u0002\u000fA\f7m[1hK&\u0011\u0011M\u0019\u0002\u0004'\u0016\f(BA04!\t!W-D\u0001\u001c\u0013\t17DA\u0002S_^DQ\u0001\u001b\u0006A\u0002%\fA!\u0019:hgB\u0011aE[\u0005\u0003WV\u0011Q\u0002\u0015:pG\u0016$WO]3Be\u001e\u001c\u0018!D:fi\u0006+H-\u001b;Ti\u0006$X\rF\u0003ocr\fi\u0001\u0005\u00023_&\u0011\u0001o\r\u0002\u0005+:LG\u000fC\u0003s\u0017\u0001\u00071/\u0001\u0006nKR\f7\t\\5f]R\u0004\"\u0001\u001e>\u000e\u0003UT!A^<\u0002\u000bQ\f'\r\\3\u000b\u0005aL\u0018AB2p[6|gN\u0003\u0002\u001b?%\u001110\u001e\u0002\u0016\u0011>|G-[3UC\ndW-T3uC\u000ec\u0017.\u001a8u\u0011\u0015i8\u00021\u0001\u007f\u0003!\u0011\u0017m]3QCRD\u0007cA@\u0002\b9!\u0011\u0011AA\u0002!\tQ6'C\u0002\u0002\u0006M\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0005\u0003\u0017\u0011aa\u0015;sS:<'bAA\u0003g!9\u0011qB\u0006A\u0002\u0005E\u0011aB3oC\ndW\r\u001a\t\u0004e\u0005M\u0011bAA\u000bg\t9!i\\8mK\u0006t\u0017!E2sK\u0006$X-Q;eSR\u001cuN\u001c4jOR\u0019a0a\u0007\t\u000f\u0005=A\u00021\u0001\u0002\u0012\u0005)!-^5mIV\u0011\u0011\u0011\u0005\t\u0004M\u0005\r\u0012bAA\u0013+\tI\u0001K]8dK\u0012,(/Z\u0001\u0016'\u0016$\u0018)\u001e3ji2{7m\u001b)s_\u000e,G-\u001e:f!\t1sbE\u0002\u0010\u0003[\u00012AMA\u0018\u0013\r\t\td\r\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u0005%\u0012\u0001\u0002(B\u001b\u0016+\"!!\u000f\u0011\t\u0005m\u0012QI\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005!A.\u00198h\u0015\t\t\u0019%\u0001\u0003kCZ\f\u0017\u0002BA\u0005\u0003{\tQAT!N\u000b\u0002\nqAY;jY\u0012,'/\u0006\u0002\u0002NA)\u0011qJA-S5\u0011\u0011\u0011\u000b\u0006\u0005\u0003'\n)&\u0001\u0005gk:\u001cG/[8o\u0015\u0011\t9&!\u0011\u0002\tU$\u0018\u000e\\\u0005\u0005\u00037\n\tF\u0001\u0005TkB\u0004H.[3s\u0001")
public class SetAuditLockProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.optional(0, "table", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(1, "path", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.required(2, "state", DataTypes.StringType)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("table", DataTypes.StringType, false, Metadata$.MODULE$.empty()), new StructField("audit_state", DataTypes.StringType, false, Metadata$.MODULE$.empty()), new StructField("message", DataTypes.StringType, false, Metadata$.MODULE$.empty())}));
    private final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Supplier<ProcedureBuilder> builder() {
        return SetAuditLockProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return SetAuditLockProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    private ObjectMapper OBJECT_MAPPER() {
        return this.OBJECT_MAPPER;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Seq seq;
        String state;
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        Option<Object> tablePath = this.getArgValueOrDefault(args, this.PARAMETERS()[1]);
        String string = state = ((String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get()).toLowerCase();
        String string2 = "enabled";
        if (string == null ? string2 != null : !string.equals(string2)) {
            String string3 = state;
            String string4 = "disabled";
            if (string3 == null ? string4 != null : !string3.equals(string4)) {
                throw new IllegalArgumentException("State parameter must be 'enabled' or 'disabled'");
            }
        }
        String basePath = this.getBasePath(tableName, tablePath);
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        String displayName = (String)tableName.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)tablePath.get());
        try {
            String string5 = state;
            String string6 = "enabled";
            boolean auditEnabled = !(string5 != null ? !string5.equals(string6) : string6 != null);
            this.setAuditState(metaClient, basePath, auditEnabled);
            String resultState = auditEnabled ? "enabled" : "disabled";
            String message = new StringBuilder(32).append("Lock audit logging successfully ").append(resultState).toString();
            seq = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{displayName, resultState, message})), (List)Nil$.MODULE$);
        }
        catch (Exception e) {
            String errorMessage = new StringBuilder(27).append("Failed to set audit state: ").append(e.getMessage()).toString();
            seq = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{displayName, "error", errorMessage})), (List)Nil$.MODULE$);
        }
        return seq;
    }

    private void setAuditState(HoodieTableMetaClient metaClient, String basePath, boolean enabled) {
        HoodieStorage storage = metaClient.getStorage();
        String lockFolderPath = StorageLockClient.getLockFolderPath((String)basePath);
        StoragePath auditConfigPath = new StoragePath(StorageLockProviderAuditService.getAuditConfigPath((String)basePath));
        Object object = !storage.exists(new StoragePath(lockFolderPath)) ? BoxesRunTime.boxToBoolean((boolean)storage.createDirectory(new StoragePath(lockFolderPath))) : BoxedUnit.UNIT;
        String jsonContent = this.createAuditConfig(enabled);
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try (OutputStream outputStream = storage.create(auditConfigPath, true);){
                outputStream.write(jsonContent.getBytes("UTF-8"));
            }
        });
        if (try_ instanceof Success) {
            return;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable exception = failure.exception();
            throw new RuntimeException(new StringBuilder(39).append("Failed to write audit configuration to ").append(auditConfigPath.toString()).toString(), exception);
        }
        throw new MatchError((Object)try_);
    }

    private String createAuditConfig(boolean enabled) {
        ObjectNode rootNode = this.OBJECT_MAPPER().createObjectNode();
        rootNode.put("STORAGE_LOCK_AUDIT_SERVICE_ENABLED", enabled);
        return this.OBJECT_MAPPER().writeValueAsString((Object)rootNode);
    }

    @Override
    public Procedure build() {
        return new SetAuditLockProcedure();
    }
}

