/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.hudi.client.transaction.lock.audit.StorageLockProviderAuditService;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowAuditLockStatusProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005-c\u0001B\n\u0015\u0001\rBQa\u000b\u0001\u0005\u00021BqA\f\u0001C\u0002\u0013%q\u0006\u0003\u0004:\u0001\u0001\u0006I\u0001\r\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019\u0011\u0005\u0001)A\u0005y!91\t\u0001b\u0001\n\u0013!\u0005BB)\u0001A\u0003%Q\tC\u0003S\u0001\u0011\u0005q\u0006C\u0003T\u0001\u0011\u00051\bC\u0003U\u0001\u0011\u0005S\u000bC\u0003l\u0001\u0011%A\u000eC\u0004\u0002\f\u0001!\t%!\u0004\b\u000f\u0005UA\u0003#\u0001\u0002\u0018\u001911\u0003\u0006E\u0001\u00033Aaa\u000b\b\u0005\u0002\u0005\u0005\u0002\"CA\u0012\u001d\t\u0007I\u0011AA\u0013\u0011!\t)D\u0004Q\u0001\n\u0005\u001d\u0002bBA\u001c\u001d\u0011\u0005\u0011\u0011\b\u0002\u001d'\"|w/Q;eSRdunY6Ti\u0006$Xo\u001d)s_\u000e,G-\u001e:f\u0015\t)b#\u0001\u0006qe>\u001cW\rZ;sKNT!a\u0006\r\u0002\u000f\r|W.\\1oI*\u0011\u0011DG\u0001\u0005QV$\u0017N\u0003\u0002\u001c9\u0005\u00191/\u001d7\u000b\u0005uq\u0012!B:qCJ\\'BA\u0010!\u0003\u0019\t\u0007/Y2iK*\t\u0011%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001I!\u0002\"!\n\u0014\u000e\u0003QI!a\n\u000b\u0003\u001b\t\u000b7/\u001a)s_\u000e,G-\u001e:f!\t)\u0013&\u0003\u0002+)\t\u0001\u0002K]8dK\u0012,(/\u001a\"vS2$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00035\u0002\"!\n\u0001\u0002\u0015A\u000b%+Q'F)\u0016\u00136+F\u00011!\r\tDGN\u0007\u0002e)\t1'A\u0003tG\u0006d\u0017-\u0003\u00026e\t)\u0011I\u001d:bsB\u0011QeN\u0005\u0003qQ\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\u0006Y\u0001+\u0011*B\u001b\u0016#VIU*!\u0003-yU\u000b\u0016)V)~#\u0016\fU#\u0016\u0003q\u0002\"!\u0010!\u000e\u0003yR!a\u0010\u000e\u0002\u000bQL\b/Z:\n\u0005\u0005s$AC*ueV\u001cG\u000fV=qK\u0006aq*\u0016+Q+R{F+\u0017)FA\u0005iqJ\u0011&F\u0007R{V*\u0011)Q\u000bJ+\u0012!\u0012\t\u0003\r>k\u0011a\u0012\u0006\u0003\u0011&\u000b\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003\u0015.\u000bqA[1dWN|gN\u0003\u0002M\u001b\u0006Ia-Y:uKJDX\u000e\u001c\u0006\u0002\u001d\u0006\u00191m\\7\n\u0005A;%\u0001D(cU\u0016\u001cG/T1qa\u0016\u0014\u0018AD(C\u0015\u0016\u001bEkX'B!B+%\u000bI\u0001\u000ba\u0006\u0014\u0018-\\3uKJ\u001c\u0018AC8viB,H\u000fV=qK\u0006!1-\u00197m)\t1f\rE\u0002X?\nt!\u0001W/\u000f\u0005ecV\"\u0001.\u000b\u0005m\u0013\u0013A\u0002\u001fs_>$h(C\u00014\u0013\tq&'A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0001\f'aA*fc*\u0011aL\r\t\u0003G\u0012l\u0011AG\u0005\u0003Kj\u00111AU8x\u0011\u00159'\u00021\u0001i\u0003\u0011\t'oZ:\u0011\u0005\u0015J\u0017B\u00016\u0015\u00055\u0001&o\\2fIV\u0014X-\u0011:hg\u0006\u00012\r[3dW\u0006+H-\u001b;Ti\u0006$Xo\u001d\u000b\u0004[B\\\bCA\u0019o\u0013\ty'GA\u0004C_>dW-\u00198\t\u000bE\\\u0001\u0019\u0001:\u0002\u00155,G/Y\"mS\u0016tG\u000f\u0005\u0002ts6\tAO\u0003\u0002vm\u0006)A/\u00192mK*\u0011q\u000f_\u0001\u0007G>lWn\u001c8\u000b\u0005eq\u0012B\u0001>u\u0005UAun\u001c3jKR\u000b'\r\\3NKR\f7\t\\5f]RDQ\u0001`\u0006A\u0002u\f\u0001BY1tKB\u000bG\u000f\u001b\t\u0004}\u0006\u0015abA@\u0002\u0002A\u0011\u0011LM\u0005\u0004\u0003\u0007\u0011\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\b\u0005%!AB*ue&twMC\u0002\u0002\u0004I\nQAY;jY\u0012,\"!a\u0004\u0011\u0007\u0015\n\t\"C\u0002\u0002\u0014Q\u0011\u0011\u0002\u0015:pG\u0016$WO]3\u00029MCwn^!vI&$Hj\\2l'R\fG/^:Qe>\u001cW\rZ;sKB\u0011QED\n\u0004\u001d\u0005m\u0001cA\u0019\u0002\u001e%\u0019\u0011q\u0004\u001a\u0003\r\u0005s\u0017PU3g)\t\t9\"\u0001\u0003O\u00036+UCAA\u0014!\u0011\tI#a\r\u000e\u0005\u0005-\"\u0002BA\u0017\u0003_\tA\u0001\\1oO*\u0011\u0011\u0011G\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\b\u0005-\u0012!\u0002(B\u001b\u0016\u0003\u0013a\u00022vS2$WM]\u000b\u0003\u0003w\u0001R!!\u0010\u0002H!j!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\tMVt7\r^5p]*!\u0011QIA\u0018\u0003\u0011)H/\u001b7\n\t\u0005%\u0013q\b\u0002\t'V\u0004\b\u000f\\5fe\u0002")
public class ShowAuditLockStatusProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.optional(0, "table", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(1, "path", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4())});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("table", DataTypes.StringType, false, Metadata$.MODULE$.empty()), new StructField("audit_enabled", DataTypes.BooleanType, false, Metadata$.MODULE$.empty()), new StructField("config_path", DataTypes.StringType, false, Metadata$.MODULE$.empty()), new StructField("audit_folder_path", DataTypes.StringType, false, Metadata$.MODULE$.empty())}));
    private final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Supplier<ProcedureBuilder> builder() {
        return ShowAuditLockStatusProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowAuditLockStatusProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    private ObjectMapper OBJECT_MAPPER() {
        return this.OBJECT_MAPPER;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Seq seq;
        super.checkArgs(this.PARAMETERS(), args);
        Option<Object> tableName = this.getArgValueOrDefault(args, this.PARAMETERS()[0]);
        Option<Object> tablePath = this.getArgValueOrDefault(args, this.PARAMETERS()[1]);
        String basePath = this.getBasePath(tableName, tablePath);
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        String displayName = (String)tableName.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1).getOrElse((Function0 & Serializable & scala.Serializable)() -> (String)tablePath.get());
        try {
            boolean auditStatus = this.checkAuditStatus(metaClient, basePath);
            String configPath = StorageLockProviderAuditService.getAuditConfigPath((String)basePath);
            String auditFolderPath = StorageLockProviderAuditService.getAuditFolderPath((String)basePath);
            seq = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{displayName, BoxesRunTime.boxToBoolean((boolean)auditStatus), configPath, auditFolderPath})), (List)Nil$.MODULE$);
        }
        catch (Exception e) {
            String configPath = StorageLockProviderAuditService.getAuditConfigPath((String)basePath);
            String auditFolderPath = StorageLockProviderAuditService.getAuditFolderPath((String)basePath);
            seq = (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{displayName, BoxesRunTime.boxToBoolean((boolean)false), configPath, auditFolderPath})), (List)Nil$.MODULE$);
        }
        return seq;
    }

    private boolean checkAuditStatus(HoodieTableMetaClient metaClient, String basePath) {
        StoragePath auditConfigPath;
        HoodieStorage storage = metaClient.getStorage();
        if (!storage.exists(auditConfigPath = new StoragePath(StorageLockProviderAuditService.getAuditConfigPath((String)basePath)))) {
            return false;
        }
        Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            try (InputStream inputStream = storage.open(auditConfigPath);){
                String configContent = new String(FileIOUtils.readAsByteArray((InputStream)inputStream));
                JsonNode rootNode = this.OBJECT_MAPPER().readTree(configContent);
                JsonNode enabledNode = rootNode.get("STORAGE_LOCK_AUDIT_SERVICE_ENABLED");
                bl = Option$.MODULE$.apply((Object)enabledNode).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.asBoolean(false)));
            }
            return bl;
        });
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            boolean enabled = BoxesRunTime.unboxToBoolean((Object)success.value());
            return enabled;
        }
        if (try_ instanceof Failure) {
            return false;
        }
        throw new MatchError((Object)try_);
    }

    @Override
    public Procedure build() {
        return new ShowAuditLockStatusProcedure();
    }
}

