/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanPartitionMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowCleansProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u00055d\u0001\u0002\f\u0018\u0001\u0019B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\u0006\u0001\u0002!\t!\u0011\u0005\b\t\u0002\u0011\r\u0011\"\u0003F\u0011\u0019a\u0005\u0001)A\u0005\r\"9Q\n\u0001b\u0001\n\u0013q\u0005BB+\u0001A\u0003%q\nC\u0004W\u0001\t\u0007I\u0011\u0002(\t\r]\u0003\u0001\u0015!\u0003P\u0011\u0015A\u0006\u0001\"\u0001F\u0011\u0015I\u0006\u0001\"\u0001O\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015\t\b\u0001\"\u0011s\u0011\u00151\b\u0001\"\u0003x\u0011\u001d\t\t\u0002\u0001C\u0005\u0003'Aq!!\u000e\u0001\t\u0013\t9dB\u0004\u0002>]A\t!a\u0010\u0007\rY9\u0002\u0012AA!\u0011\u0019\u0001\u0015\u0003\"\u0001\u0002J!I\u00111J\tC\u0002\u0013\u0005\u0011Q\n\u0005\t\u00037\n\u0002\u0015!\u0003\u0002P!9\u0011QL\t\u0005\u0002\u0005}#aE*i_^\u001cE.Z1ogB\u0013xnY3ekJ,'B\u0001\r\u001a\u0003)\u0001(o\\2fIV\u0014Xm\u001d\u0006\u00035m\tqaY8n[\u0006tGM\u0003\u0002\u001d;\u0005!\u0001.\u001e3j\u0015\tqr$A\u0002tc2T!\u0001I\u0011\u0002\u000bM\u0004\u0018M]6\u000b\u0005\t\u001a\u0013AB1qC\u000eDWMC\u0001%\u0003\ry'oZ\u0002\u0001'\u0015\u0001qe\u000b\u00184!\tA\u0013&D\u0001\u0018\u0013\tQsCA\u0007CCN,\u0007K]8dK\u0012,(/\u001a\t\u0003Q1J!!L\f\u0003!A\u0013xnY3ekJ,')^5mI\u0016\u0014\bCA\u00182\u001b\u0005\u0001$B\u0001\u000f\"\u0013\t\u0011\u0004GA\nTa\u0006\u00148.\u00113baR,'oU;qa>\u0014H\u000f\u0005\u00025o5\tQG\u0003\u00027?\u0005A\u0011N\u001c;fe:\fG.\u0003\u00029k\t9Aj\\4hS:<\u0017\u0001G5oG2,H-\u001a)beRLG/[8o\u001b\u0016$\u0018\rZ1uCB\u00111HP\u0007\u0002y)\tQ(A\u0003tG\u0006d\u0017-\u0003\u0002@y\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\b\u0006\u0002C\u0007B\u0011\u0001\u0006\u0001\u0005\u0006s\t\u0001\rAO\u0001\u000b!\u0006\u0013\u0016)T#U\u000bJ\u001bV#\u0001$\u0011\u0007m:\u0015*\u0003\u0002Iy\t)\u0011I\u001d:bsB\u0011\u0001FS\u0005\u0003\u0017^\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\u0006Y\u0001+\u0011*B\u001b\u0016#VIU*!\u0003-yU\u000b\u0016)V)~#\u0016\fU#\u0016\u0003=\u0003\"\u0001U*\u000e\u0003ES!AU\u000f\u0002\u000bQL\b/Z:\n\u0005Q\u000b&AC*ueV\u001cG\u000fV=qK\u0006aq*\u0016+Q+R{F+\u0017)FA\u0005q\u0002+\u0011*U\u0013RKuJT0N\u000bR\u000bE)\u0011+B?>+F\u000bU+U?RK\u0006+R\u0001 !\u0006\u0013F+\u0013+J\u001f:{V*\u0012+B\t\u0006#\u0016iX(V)B+Fk\u0018+Z!\u0016\u0003\u0013A\u00039be\u0006lW\r^3sg\u0006Qq.\u001e;qkR$\u0016\u0010]3\u0002\t\r\fG\u000e\u001c\u000b\u000392\u00042!X3i\u001d\tq6M\u0004\u0002`E6\t\u0001M\u0003\u0002bK\u00051AH]8pizJ\u0011!P\u0005\u0003Ir\nq\u0001]1dW\u0006<W-\u0003\u0002gO\n\u00191+Z9\u000b\u0005\u0011d\u0004CA5k\u001b\u0005i\u0012BA6\u001e\u0005\r\u0011vn\u001e\u0005\u0006[.\u0001\rA\\\u0001\u0005CJ<7\u000f\u0005\u0002)_&\u0011\u0001o\u0006\u0002\u000e!J|7-\u001a3ve\u0016\f%oZ:\u0002\u000b\t,\u0018\u000e\u001c3\u0016\u0003M\u0004\"\u0001\u000b;\n\u0005U<\"!\u0003)s_\u000e,G-\u001e:f\u0003y9W\r^\"mK\u0006t7oV5uQB\u000b'\u000f^5uS>tW*\u001a;bI\u0006$\u0018\r\u0006\u0003]q\u0006\u001d\u0001\"B=\u000e\u0001\u0004Q\u0018\u0001\u0003;j[\u0016d\u0017N\\3\u0011\u0007m\f\u0019!D\u0001}\u0015\tIXP\u0003\u0002\u007f\u007f\u0006)A/\u00192mK*\u0019\u0011\u0011\u0001\u0019\u0002\r\r|W.\\8o\u0013\r\t)\u0001 \u0002\u000f\u0011>|G-[3US6,G.\u001b8f\u0011\u001d\tI!\u0004a\u0001\u0003\u0017\tQ\u0001\\5nSR\u00042aOA\u0007\u0013\r\ty\u0001\u0010\u0002\u0004\u0013:$\u0018aD4fiN{'\u000f^3e\u00072,\u0017M\\:\u0015\t\u0005U\u00111\u0007\t\bw\u0005]\u00111DA\u0016\u0013\r\tI\u0002\u0010\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u000b\u0005u\u0011q\u00055\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\tA!\u001e;jY*\u0011\u0011QE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002*\u0005}!!C!se\u0006LH*[:u!\u0019\ti\"a\n\u0002.A\u001910a\f\n\u0007\u0005EBPA\u0007I_>$\u0017.Z%ogR\fg\u000e\u001e\u0005\u0006s:\u0001\rA_\u0001\nO\u0016$8\t\\3b]N$R\u0001XA\u001d\u0003wAQ!_\bA\u0002iDq!!\u0003\u0010\u0001\u0004\tY!A\nTQ><8\t\\3b]N\u0004&o\\2fIV\u0014X\r\u0005\u0002)#M\u0019\u0011#a\u0011\u0011\u0007m\n)%C\u0002\u0002Hq\u0012a!\u00118z%\u00164GCAA \u0003\u0011q\u0015)T#\u0016\u0005\u0005=\u0003\u0003BA)\u0003/j!!a\u0015\u000b\t\u0005U\u00131E\u0001\u0005Y\u0006tw-\u0003\u0003\u0002Z\u0005M#AB*ue&tw-A\u0003O\u00036+\u0005%A\u0004ck&dG-\u001a:\u0016\u0005\u0005\u0005\u0004#BA2\u0003SZSBAA3\u0015\u0011\t9'a\b\u0002\u0011\u0019,hn\u0019;j_:LA!a\u001b\u0002f\tA1+\u001e9qY&,'\u000f")
public class ShowCleansProcedure
extends BaseProcedure
implements ProcedureBuilder,
SparkAdapterSupport,
Logging {
    private final boolean includePartitionMetadata;
    private final ProcedureParameter[] PARAMETERS;
    private final StructType OUTPUT_TYPE;
    private final StructType PARTITION_METADATA_OUTPUT_TYPE;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    public static Supplier<ProcedureBuilder> builder() {
        return ShowCleansProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowCleansProcedure$.MODULE$.NAME();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        ShowCleansProcedure showCleansProcedure = this;
        synchronized (showCleansProcedure) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.sparkAdapter$((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
        }
        return this.sparkAdapter;
    }

    public SparkAdapter sparkAdapter() {
        if (!this.bitmap$0) {
            return this.sparkAdapter$lzycompute();
        }
        return this.sparkAdapter;
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    private StructType PARTITION_METADATA_OUTPUT_TYPE() {
        return this.PARTITION_METADATA_OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        if (this.includePartitionMetadata) {
            return this.PARTITION_METADATA_OUTPUT_TYPE();
        }
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Seq seq;
        Seq activeResults;
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        boolean showArchived = BoxesRunTime.unboxToBoolean((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get());
        String filter = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[3]).get();
        this.validateFilter(filter, this.outputType());
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        Object object = activeResults = this.includePartitionMetadata ? this.getCleansWithPartitionMetadata((HoodieTimeline)metaClient.getActiveTimeline(), limit) : this.getCleans((HoodieTimeline)metaClient.getActiveTimeline(), limit);
        if (showArchived) {
            Seq<Row> archivedResults = this.includePartitionMetadata ? this.getCleansWithPartitionMetadata((HoodieTimeline)metaClient.getArchivedTimeline(), limit) : this.getCleans((HoodieTimeline)metaClient.getArchivedTimeline(), limit);
            seq = (Seq)((IterableLike)((SeqLike)activeResults.$plus$plus(archivedResults, Seq$.MODULE$.canBuildFrom())).sortWith((Function2 & Serializable & scala.Serializable)(a, b) -> BoxesRunTime.boxToBoolean((boolean)ShowCleansProcedure.$anonfun$call$1(a, b)))).take(limit);
        } else {
            seq = activeResults;
        }
        Seq finalResults = seq;
        return this.applyFilter(finalResults, filter, this.outputType());
    }

    @Override
    public Procedure build() {
        return new ShowCleansProcedure(this.includePartitionMetadata);
    }

    private Seq<Row> getCleansWithPartitionMetadata(HoodieTimeline timeline, int limit) {
        ArrayList arrayList;
        ArrayList cleanInstants;
        block3: {
            Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> tuple2;
            block2: {
                tuple2 = this.getSortedCleans(timeline);
                if (tuple2 == null) break block2;
                ArrayList rows = (ArrayList)tuple2._1();
                cleanInstants = (ArrayList)tuple2._2();
                if (rows == null) break block2;
                arrayList = rows;
                if (cleanInstants != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        ArrayList arrayList2 = cleanInstants;
        Tuple2 tuple2 = new Tuple2((Object)arrayList, (Object)arrayList2);
        ArrayList rows = (ArrayList)tuple2._1();
        ArrayList cleanInstants2 = (ArrayList)tuple2._2();
        IntRef rowCount = IntRef.create((int)0);
        ((IterableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)cleanInstants2).asScala()).takeWhile((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ShowCleansProcedure.$anonfun$getCleansWithPartitionMetadata$1(rowCount, limit, x$2)))).foreach((Function1 & Serializable & scala.Serializable)cleanInstant -> {
            ShowCleansProcedure.$anonfun$getCleansWithPartitionMetadata$2(timeline, rowCount, limit, rows, cleanInstant);
            return BoxedUnit.UNIT;
        });
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((List)rows).asScala()).toList();
    }

    private Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> getSortedCleans(HoodieTimeline timeline) {
        ArrayList rows = new ArrayList();
        List cleanInstants = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(timeline.getCleanerTimeline().filterCompletedInstants().getInstants().toArray())).map((Function1 & Serializable & scala.Serializable)instant -> (HoodieInstant)instant, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HoodieInstant.class))))).toList()).asJava();
        ArrayList sortedCleanInstants = new ArrayList(cleanInstants);
        TimelineLayout layout = TimelineLayout.fromVersion((TimelineLayoutVersion)timeline.getTimelineLayoutVersion());
        Collections.sort(sortedCleanInstants, layout.getInstantComparator().requestedTimeOrderedComparator().reversed());
        return new Tuple2(rows, sortedCleanInstants);
    }

    private Seq<Row> getCleans(HoodieTimeline timeline, int limit) {
        ArrayList arrayList;
        ArrayList cleanInstants;
        block3: {
            Tuple2<ArrayList<Row>, ArrayList<HoodieInstant>> tuple2;
            block2: {
                tuple2 = this.getSortedCleans(timeline);
                if (tuple2 == null) break block2;
                ArrayList rows = (ArrayList)tuple2._1();
                cleanInstants = (ArrayList)tuple2._2();
                if (rows == null) break block2;
                arrayList = rows;
                if (cleanInstants != null) break block3;
            }
            throw new MatchError(tuple2);
        }
        ArrayList arrayList2 = cleanInstants;
        Tuple2 tuple2 = new Tuple2((Object)arrayList, (Object)arrayList2);
        ArrayList rows = (ArrayList)tuple2._1();
        ArrayList cleanInstants2 = (ArrayList)tuple2._2();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Math.min(cleanInstants2.size(), limit)).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)i -> {
            HoodieInstant cleanInstant = (HoodieInstant)cleanInstants2.get(i);
            HoodieCleanMetadata cleanMetadata = timeline.readCleanMetadata(cleanInstant);
            return rows.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanInstant.requestedTime(), cleanInstant.getCompletionTime(), cleanInstant.getAction(), cleanMetadata.getStartCleanTime(), BoxesRunTime.boxToLong((long)cleanMetadata.getTimeTakenInMillis()), BoxesRunTime.boxToInteger((int)cleanMetadata.getTotalFilesDeleted()), cleanMetadata.getEarliestCommitToRetain(), cleanMetadata.getLastCompletedCommitTimestamp(), cleanMetadata.getVersion()})));
        });
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((List)rows).asScala()).toList();
    }

    public static final /* synthetic */ boolean $anonfun$call$1(Row a, Row b) {
        return new StringOps(Predef$.MODULE$.augmentString(a.getString(0))).$greater((Object)b.getString(0));
    }

    public static final /* synthetic */ boolean $anonfun$getCleansWithPartitionMetadata$1(IntRef rowCount$1, int limit$1, HoodieInstant x$2) {
        return rowCount$1.elem < limit$1;
    }

    public static final /* synthetic */ boolean $anonfun$getCleansWithPartitionMetadata$3(IntRef rowCount$1, int limit$1, Map.Entry x$3) {
        return rowCount$1.elem < limit$1;
    }

    public static final /* synthetic */ void $anonfun$getCleansWithPartitionMetadata$4(ArrayList rows$1, HoodieInstant cleanInstant$1, HoodieCleanMetadata cleanMetadata$1, IntRef rowCount$1, Map.Entry partitionMetadataEntry) {
        String partitionPath = (String)partitionMetadataEntry.getKey();
        HoodieCleanPartitionMetadata partitionMetadata = (HoodieCleanPartitionMetadata)partitionMetadataEntry.getValue();
        rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanInstant$1.requestedTime(), cleanInstant$1.getCompletionTime(), cleanInstant$1.getAction(), cleanMetadata$1.getStartCleanTime(), partitionPath, partitionMetadata.getPolicy(), BoxesRunTime.boxToInteger((int)partitionMetadata.getDeletePathPatterns().size()), BoxesRunTime.boxToInteger((int)partitionMetadata.getSuccessDeleteFiles().size()), BoxesRunTime.boxToInteger((int)partitionMetadata.getFailedDeleteFiles().size()), partitionMetadata.getIsPartitionDeleted(), BoxesRunTime.boxToLong((long)cleanMetadata$1.getTimeTakenInMillis()), BoxesRunTime.boxToInteger((int)cleanMetadata$1.getTotalFilesDeleted())})));
        ++rowCount$1.elem;
    }

    public static final /* synthetic */ void $anonfun$getCleansWithPartitionMetadata$2(HoodieTimeline timeline$1, IntRef rowCount$1, int limit$1, ArrayList rows$1, HoodieInstant cleanInstant) {
        HoodieCleanMetadata cleanMetadata = timeline$1.readCleanMetadata(cleanInstant);
        ((IterableLike)((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(cleanMetadata.getPartitionMetadata().entrySet()).asScala()).takeWhile((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ShowCleansProcedure.$anonfun$getCleansWithPartitionMetadata$3(rowCount$1, limit$1, x$3)))).foreach((Function1 & Serializable & scala.Serializable)partitionMetadataEntry -> {
            ShowCleansProcedure.$anonfun$getCleansWithPartitionMetadata$4(rows$1, cleanInstant, cleanMetadata, rowCount$1, partitionMetadataEntry);
            return BoxedUnit.UNIT;
        });
    }

    public ShowCleansProcedure(boolean includePartitionMetadata) {
        this.includePartitionMetadata = includePartitionMetadata;
        SparkAdapterSupport.$init$((SparkAdapterSupport)this);
        Logging.$init$((Logging)this);
        this.PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.optional(2, "showArchived", DataTypes.BooleanType, BoxesRunTime.boxToBoolean((boolean)false)), ProcedureParameter$.MODULE$.optional(3, "filter", DataTypes.StringType, "")});
        this.OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("clean_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("state_transition_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("start_clean_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("time_taken_in_millis", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_files_deleted", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("earliest_commit_to_retain", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("last_completed_commit_timestamp", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("version", DataTypes.IntegerType, true, Metadata$.MODULE$.empty())}));
        this.PARTITION_METADATA_OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("clean_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("state_transition_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("start_clean_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("partition_path", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("policy", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("delete_path_patterns", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("success_delete_files", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("failed_delete_files", DataTypes.IntegerType, true, Metadata$.MODULE$.empty()), new StructField("is_partition_deleted", DataTypes.BooleanType, true, Metadata$.MODULE$.empty()), new StructField("time_taken_in_millis", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_files_deleted", DataTypes.IntegerType, true, Metadata$.MODULE$.empty())}));
    }
}

