/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowCommitExtraMetadataProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}c\u0001B\n\u0015\u0001\rBQa\u000b\u0001\u0005\u00021BqA\f\u0001C\u0002\u0013%q\u0006\u0003\u0004:\u0001\u0001\u0006I\u0001\r\u0005\bu\u0001\u0011\r\u0011\"\u0003<\u0011\u0019\u0011\u0005\u0001)A\u0005y!)1\t\u0001C\u0001_!)A\t\u0001C\u0001w!)Q\t\u0001C!\r\")A\f\u0001C!;\")\u0011\r\u0001C\u0005E\")Q\u000f\u0001C\u0005m\"9\u0011\u0011\u0003\u0001\u0005\n\u0005MqaBA\u0015)!\u0005\u00111\u0006\u0004\u0007'QA\t!!\f\t\r-rA\u0011AA\u001b\u0011%\t9D\u0004b\u0001\n\u0003\tI\u0004\u0003\u0005\u0002J9\u0001\u000b\u0011BA\u001e\u0011\u001d\tYE\u0004C\u0001\u0003\u001b\u0012\u0001e\u00155po\u000e{W.\\5u\u000bb$(/Y'fi\u0006$\u0017\r^1Qe>\u001cW\rZ;sK*\u0011QCF\u0001\u000baJ|7-\u001a3ve\u0016\u001c(BA\f\u0019\u0003\u001d\u0019w.\\7b]\u0012T!!\u0007\u000e\u0002\t!,H-\u001b\u0006\u00037q\t1a]9m\u0015\tib$A\u0003ta\u0006\u00148N\u0003\u0002 A\u00051\u0011\r]1dQ\u0016T\u0011!I\u0001\u0004_J<7\u0001A\n\u0004\u0001\u0011B\u0003CA\u0013'\u001b\u0005!\u0012BA\u0014\u0015\u00055\u0011\u0015m]3Qe>\u001cW\rZ;sKB\u0011Q%K\u0005\u0003UQ\u0011\u0001\u0003\u0015:pG\u0016$WO]3Ck&dG-\u001a:\u0002\rqJg.\u001b;?)\u0005i\u0003CA\u0013\u0001\u0003)\u0001\u0016IU!N\u000bR+%kU\u000b\u0002aA\u0019\u0011\u0007\u000e\u001c\u000e\u0003IR\u0011aM\u0001\u0006g\u000e\fG.Y\u0005\u0003kI\u0012Q!\u0011:sCf\u0004\"!J\u001c\n\u0005a\"\"A\u0005)s_\u000e,G-\u001e:f!\u0006\u0014\u0018-\\3uKJ\f1\u0002U!S\u00036+E+\u0012*TA\u0005Yq*\u0016+Q+R{F+\u0017)F+\u0005a\u0004CA\u001fA\u001b\u0005q$BA \u001b\u0003\u0015!\u0018\u0010]3t\u0013\t\teH\u0001\u0006TiJ,8\r\u001e+za\u0016\fAbT+U!V#v\fV-Q\u000b\u0002\n!\u0002]1sC6,G/\u001a:t\u0003)yW\u000f\u001e9viRK\b/Z\u0001\u0005G\u0006dG\u000e\u0006\u0002H/B\u0019\u0001\nU*\u000f\u0005%seB\u0001&N\u001b\u0005Y%B\u0001'#\u0003\u0019a$o\\8u}%\t1'\u0003\u0002Pe\u00059\u0001/Y2lC\u001e,\u0017BA)S\u0005\r\u0019V-\u001d\u0006\u0003\u001fJ\u0002\"\u0001V+\u000e\u0003iI!A\u0016\u000e\u0003\u0007I{w\u000fC\u0003Y\u0011\u0001\u0007\u0011,\u0001\u0003be\u001e\u001c\bCA\u0013[\u0013\tYFCA\u0007Qe>\u001cW\rZ;sK\u0006\u0013xm]\u0001\u0006EVLG\u000eZ\u000b\u0002=B\u0011QeX\u0005\u0003AR\u0011\u0011\u0002\u0015:pG\u0016$WO]3\u0002/\u001d,GoQ8n[&$hi\u001c:MCN$\u0018J\\:uC:$HCA2r!\r\tDMZ\u0005\u0003KJ\u0012aa\u00149uS>t\u0007CA4p\u001b\u0005A'BA5k\u0003!!\u0018.\\3mS:,'BA6m\u0003\u0015!\u0018M\u00197f\u0015\tig.\u0001\u0004d_6lwN\u001c\u0006\u00033yI!\u0001\u001d5\u0003\u001b!{w\u000eZ5f\u0013:\u001cH/\u00198u\u0011\u0015I'\u00021\u0001s!\t97/\u0003\u0002uQ\nq\u0001j\\8eS\u0016$\u0016.\\3mS:,\u0017aE4fi\u000e{W.\\5u\r>\u0014\u0018J\\:uC:$H\u0003B2x{zDQ\u0001_\u0006A\u0002e\f!\"\\3uC\u000ec\u0017.\u001a8u!\tQ80D\u0001k\u0013\ta(NA\u000bI_>$\u0017.\u001a+bE2,W*\u001a;b\u00072LWM\u001c;\t\u000b%\\\u0001\u0019\u0001:\t\r}\\\u0001\u0019AA\u0001\u0003-Ign\u001d;b]R$\u0016.\\3\u0011\t\u0005\r\u00111\u0002\b\u0005\u0003\u000b\t9\u0001\u0005\u0002Ke%\u0019\u0011\u0011\u0002\u001a\u0002\rA\u0013X\rZ3g\u0013\u0011\ti!a\u0004\u0003\rM#(/\u001b8h\u0015\r\tIAM\u0001\u0018O\u0016$\bj\\8eS\u0016\u001cu.\\7ji6+G/\u00193bi\u0006$b!!\u0006\u0002$\u0005\u0015\u0002\u0003B\u0019e\u0003/\u0001B!!\u0007\u0002 5\u0011\u00111\u0004\u0006\u0004\u0003;a\u0017!B7pI\u0016d\u0017\u0002BA\u0011\u00037\u0011A\u0003S8pI&,7i\\7nSRlU\r^1eCR\f\u0007\"B5\r\u0001\u0004\u0011\bBBA\u0014\u0019\u0001\u00071-A\u0007i_>$\u0017.Z%ogR\fg\u000e^\u0001!'\"|woQ8n[&$X\t\u001f;sC6+G/\u00193bi\u0006\u0004&o\\2fIV\u0014X\r\u0005\u0002&\u001dM\u0019a\"a\f\u0011\u0007E\n\t$C\u0002\u00024I\u0012a!\u00118z%\u00164GCAA\u0016\u0003\u0011q\u0015)T#\u0016\u0005\u0005m\u0002\u0003BA\u001f\u0003\u000fj!!a\u0010\u000b\t\u0005\u0005\u00131I\u0001\u0005Y\u0006twM\u0003\u0002\u0002F\u0005!!.\u0019<b\u0013\u0011\ti!a\u0010\u0002\u000b9\u000bU*\u0012\u0011\u0002\u000f\t,\u0018\u000e\u001c3feV\u0011\u0011q\n\t\u0006\u0003#\nY\u0006K\u0007\u0003\u0003'RA!!\u0016\u0002X\u0005Aa-\u001e8di&|gN\u0003\u0003\u0002Z\u0005\r\u0013\u0001B;uS2LA!!\u0018\u0002T\tA1+\u001e9qY&,'\u000f")
public class ShowCommitExtraMetadataProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)100)), ProcedureParameter$.MODULE$.optional(2, "instant_time", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4()), ProcedureParameter$.MODULE$.optional(3, "metadata_key", DataTypes.StringType, ProcedureParameter$.MODULE$.optional$default$4())});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("instant_time", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("metadata_key", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("metadata_value", DataTypes.StringType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowCommitExtraMetadataProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowCommitExtraMetadataProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        Option<HoodieInstant> hoodieInstantOption;
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        Option<Object> instantTime = this.getArgValueOrDefault(args, this.PARAMETERS()[2]);
        Option<Object> metadataKey = this.getArgValueOrDefault(args, this.PARAMETERS()[3]);
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        Option<HoodieInstant> option = hoodieInstantOption = instantTime.isEmpty() ? this.getCommitForLastInstant(timeline) : this.getCommitForInstant(metaClient, timeline, (String)instantTime.get());
        if (hoodieInstantOption.isEmpty()) {
            throw new HoodieException(new StringBuilder(30).append("Commit ").append(instantTime).append(" not found in Commits ").append(timeline).append(".").toString());
        }
        Option<HoodieCommitMetadata> commitMetadataOptional = this.getHoodieCommitMetadata(timeline, hoodieInstantOption);
        if (commitMetadataOptional.isEmpty()) {
            throw new HoodieException(new StringBuilder(45).append("Commit ").append(instantTime).append(" not found commitMetadata in Commits ").append(timeline).append(".").toString());
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)commitMetadataOptional.get();
        String timestamp = ((HoodieInstant)hoodieInstantOption.get()).requestedTime();
        String action = ((HoodieInstant)hoodieInstantOption.get()).getAction();
        Map metadatas = metadataKey.isEmpty() ? meta.getExtraMetadata() : (Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter((scala.collection.mutable.Map)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(meta.getExtraMetadata()).asScala()).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)ShowCommitExtraMetadataProcedure.$anonfun$call$1(metadataKey, r)))).asJava();
        ArrayList rows = new ArrayList();
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metadatas).asScala()).foreach((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)rows.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timestamp, action, r._1(), r._2()})))));
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowCommitExtraMetadataProcedure();
    }

    private Option<HoodieInstant> getCommitForLastInstant(HoodieTimeline timeline) {
        Optional instantOptional = timeline.getReverseOrderedInstants().findFirst();
        if (instantOptional.isPresent()) {
            return Option$.MODULE$.apply(instantOptional.get());
        }
        return Option$.MODULE$.empty();
    }

    private Option<HoodieInstant> getCommitForInstant(HoodieTableMetaClient metaClient, HoodieTimeline timeline, String instantTime) {
        InstantGenerator instantGenerator = metaClient.getTimelineLayout().getInstantGenerator();
        List<Object> instants = Arrays.asList((Object[])new HoodieInstant[]{instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "commit", instantTime), instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "replacecommit", instantTime), instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "clustering", instantTime), instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", instantTime)});
        Option hoodieInstant = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(instants).asScala()).find((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)timeline.containsInstant(i)));
        return hoodieInstant;
    }

    private Option<HoodieCommitMetadata> getHoodieCommitMetadata(HoodieTimeline timeline, Option<HoodieInstant> hoodieInstant) {
        TimelineLayout layout = TimelineLayout.fromVersion((TimelineLayoutVersion)timeline.getTimelineLayoutVersion());
        if (hoodieInstant.isDefined()) {
            if (ClusteringUtils.isClusteringOrReplaceCommitAction((String)((HoodieInstant)hoodieInstant.get()).getAction())) {
                return Option$.MODULE$.apply((Object)timeline.readReplaceCommitMetadata((HoodieInstant)hoodieInstant.get()));
            }
            return Option$.MODULE$.apply((Object)timeline.readCommitMetadata((HoodieInstant)hoodieInstant.get()));
        }
        return Option$.MODULE$.empty();
    }

    public static final /* synthetic */ boolean $anonfun$call$1(Option metadataKey$1, Tuple2 r) {
        return ((String)r._1()).equals(((String)metadataKey$1.get()).trim());
    }
}

