/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hudi.command.procedures;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hudi.HoodieCLIUtils$;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.catalog.HoodieCatalogTable;
import org.apache.spark.sql.hudi.command.procedures.BaseProcedure;
import org.apache.spark.sql.hudi.command.procedures.Procedure;
import org.apache.spark.sql.hudi.command.procedures.ProcedureArgs;
import org.apache.spark.sql.hudi.command.procedures.ProcedureBuilder;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter;
import org.apache.spark.sql.hudi.command.procedures.ProcedureParameter$;
import org.apache.spark.sql.hudi.command.procedures.ShowCommitFilesProcedure$;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]c\u0001\u0002\n\u0014\u0001\tBQA\u000b\u0001\u0005\u0002-Bq!\f\u0001C\u0002\u0013%a\u0006\u0003\u00049\u0001\u0001\u0006Ia\f\u0005\bs\u0001\u0011\r\u0011\"\u0003;\u0011\u0019\t\u0005\u0001)A\u0005w!)!\t\u0001C\u0001]!)1\t\u0001C\u0001u!)A\t\u0001C!\u000b\")1\f\u0001C!9\")\u0001\r\u0001C\u0005C\"9\u0011\u0011\u0002\u0001\u0005\n\u0005-qaBA\u0011'!\u0005\u00111\u0005\u0004\u0007%MA\t!!\n\t\r)jA\u0011AA\u0017\u0011%\ty#\u0004b\u0001\n\u0003\t\t\u0004\u0003\u0005\u0002B5\u0001\u000b\u0011BA\u001a\u0011\u001d\t\u0019%\u0004C\u0001\u0003\u000b\u0012\u0001d\u00155po\u000e{W.\\5u\r&dWm\u001d)s_\u000e,G-\u001e:f\u0015\t!R#\u0001\u0006qe>\u001cW\rZ;sKNT!AF\f\u0002\u000f\r|W.\\1oI*\u0011\u0001$G\u0001\u0005QV$\u0017N\u0003\u0002\u001b7\u0005\u00191/\u001d7\u000b\u0005qi\u0012!B:qCJ\\'B\u0001\u0010 \u0003\u0019\t\u0007/Y2iK*\t\u0001%A\u0002pe\u001e\u001c\u0001aE\u0002\u0001G\u001d\u0002\"\u0001J\u0013\u000e\u0003MI!AJ\n\u0003\u001b\t\u000b7/\u001a)s_\u000e,G-\u001e:f!\t!\u0003&\u0003\u0002*'\t\u0001\u0002K]8dK\u0012,(/\u001a\"vS2$WM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00031\u0002\"\u0001\n\u0001\u0002\u0015A\u000b%+Q'F)\u0016\u00136+F\u00010!\r\u00014'N\u0007\u0002c)\t!'A\u0003tG\u0006d\u0017-\u0003\u00025c\t)\u0011I\u001d:bsB\u0011AEN\u0005\u0003oM\u0011!\u0003\u0015:pG\u0016$WO]3QCJ\fW.\u001a;fe\u0006Y\u0001+\u0011*B\u001b\u0016#VIU*!\u0003-yU\u000b\u0016)V)~#\u0016\fU#\u0016\u0003m\u0002\"\u0001P \u000e\u0003uR!AP\r\u0002\u000bQL\b/Z:\n\u0005\u0001k$AC*ueV\u001cG\u000fV=qK\u0006aq*\u0016+Q+R{F+\u0017)FA\u0005Q\u0001/\u0019:b[\u0016$XM]:\u0002\u0015=,H\u000f];u)f\u0004X-\u0001\u0003dC2dGC\u0001$W!\r9uJ\u0015\b\u0003\u00116s!!\u0013'\u000e\u0003)S!aS\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0011\u0014B\u0001(2\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001U)\u0003\u0007M+\u0017O\u0003\u0002OcA\u00111\u000bV\u0007\u00023%\u0011Q+\u0007\u0002\u0004%><\b\"B,\t\u0001\u0004A\u0016\u0001B1sON\u0004\"\u0001J-\n\u0005i\u001b\"!\u0004)s_\u000e,G-\u001e:f\u0003J<7/A\u0003ck&dG-F\u0001^!\t!c,\u0003\u0002`'\tI\u0001K]8dK\u0012,(/Z\u0001\u0014O\u0016$8i\\7nSR4uN]%ogR\fg\u000e\u001e\u000b\u0005EB4(\u0010E\u00021G\u0016L!\u0001Z\u0019\u0003\r=\u0003H/[8o!\t1g.D\u0001h\u0015\tA\u0017.\u0001\u0005uS6,G.\u001b8f\u0015\tQ7.A\u0003uC\ndWM\u0003\u0002m[\u000611m\\7n_:T!\u0001G\u000f\n\u0005=<'!\u0004%p_\u0012LW-\u00138ti\u0006tG\u000fC\u0003r\u0015\u0001\u0007!/\u0001\u0006nKR\f7\t\\5f]R\u0004\"a\u001d;\u000e\u0003%L!!^5\u0003+!{w\u000eZ5f)\u0006\u0014G.Z'fi\u0006\u001cE.[3oi\")\u0001N\u0003a\u0001oB\u0011a\r_\u0005\u0003s\u001e\u0014a\u0002S8pI&,G+[7fY&tW\rC\u0003|\u0015\u0001\u0007A0A\u0006j]N$\u0018M\u001c;US6,\u0007cA?\u0002\u00049\u0011ap \t\u0003\u0013FJ1!!\u00012\u0003\u0019\u0001&/\u001a3fM&!\u0011QAA\u0004\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011A\u0019\u0002/\u001d,G\u000fS8pI&,7i\\7nSRlU\r^1eCR\fGCBA\u0007\u00037\ti\u0002\u0005\u00031G\u0006=\u0001\u0003BA\t\u0003/i!!a\u0005\u000b\u0007\u0005U1.A\u0003n_\u0012,G.\u0003\u0003\u0002\u001a\u0005M!\u0001\u0006%p_\u0012LWmQ8n[&$X*\u001a;bI\u0006$\u0018\rC\u0003i\u0017\u0001\u0007q\u000f\u0003\u0004\u0002 -\u0001\rAY\u0001\u000eQ>|G-[3J]N$\u0018M\u001c;\u00021MCwn^\"p[6LGOR5mKN\u0004&o\\2fIV\u0014X\r\u0005\u0002%\u001bM\u0019Q\"a\n\u0011\u0007A\nI#C\u0002\u0002,E\u0012a!\u00118z%\u00164GCAA\u0012\u0003\u0011q\u0015)T#\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003\u007fi!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0005Y\u0006twM\u0003\u0002\u0002>\u0005!!.\u0019<b\u0013\u0011\t)!a\u000e\u0002\u000b9\u000bU*\u0012\u0011\u0002\u000f\t,\u0018\u000e\u001c3feV\u0011\u0011q\t\t\u0006\u0003\u0013\n\u0019fJ\u0007\u0003\u0003\u0017RA!!\u0014\u0002P\u0005Aa-\u001e8di&|gN\u0003\u0003\u0002R\u0005m\u0012\u0001B;uS2LA!!\u0016\u0002L\tA1+\u001e9qY&,'\u000f")
public class ShowCommitFilesProcedure
extends BaseProcedure
implements ProcedureBuilder {
    private final ProcedureParameter[] PARAMETERS = (ProcedureParameter[])((Object[])new ProcedureParameter[]{ProcedureParameter$.MODULE$.required(0, "table", DataTypes.StringType), ProcedureParameter$.MODULE$.optional(1, "limit", DataTypes.IntegerType, BoxesRunTime.boxToInteger((int)10)), ProcedureParameter$.MODULE$.required(2, "instant_time", DataTypes.StringType)});
    private final StructType OUTPUT_TYPE = new StructType((StructField[])((Object[])new StructField[]{new StructField("action", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("partition_path", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("file_id", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("previous_commit", DataTypes.StringType, true, Metadata$.MODULE$.empty()), new StructField("total_records_updated", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_records_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_bytes_written", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("total_errors", DataTypes.LongType, true, Metadata$.MODULE$.empty()), new StructField("file_size", DataTypes.LongType, true, Metadata$.MODULE$.empty())}));

    public static Supplier<ProcedureBuilder> builder() {
        return ShowCommitFilesProcedure$.MODULE$.builder();
    }

    public static String NAME() {
        return ShowCommitFilesProcedure$.MODULE$.NAME();
    }

    private ProcedureParameter[] PARAMETERS() {
        return this.PARAMETERS;
    }

    private StructType OUTPUT_TYPE() {
        return this.OUTPUT_TYPE;
    }

    @Override
    public ProcedureParameter[] parameters() {
        return this.PARAMETERS();
    }

    @Override
    public StructType outputType() {
        return this.OUTPUT_TYPE();
    }

    @Override
    public Seq<Row> call(ProcedureArgs args) {
        super.checkArgs(this.PARAMETERS(), args);
        String table = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[0]).get();
        int limit = BoxesRunTime.unboxToInt((Object)this.getArgValueOrDefault(args, this.PARAMETERS()[1]).get());
        String instantTime = (String)this.getArgValueOrDefault(args, this.PARAMETERS()[2]).get();
        HoodieCatalogTable hoodieCatalogTable = HoodieCLIUtils$.MODULE$.getHoodieCatalogTable(this.sparkSession(), table);
        String basePath = hoodieCatalogTable.tableLocation();
        HoodieTableMetaClient metaClient = this.createMetaClient(this.jsc(), basePath);
        HoodieActiveTimeline activeTimeline = metaClient.getActiveTimeline();
        HoodieTimeline timeline = activeTimeline.getCommitsTimeline().filterCompletedInstants();
        Option<HoodieInstant> hoodieInstantOption = this.getCommitForInstant(metaClient, timeline, instantTime);
        Option<HoodieCommitMetadata> commitMetadataOptional = this.getHoodieCommitMetadata(timeline, hoodieInstantOption);
        if (commitMetadataOptional.isEmpty()) {
            throw new HoodieException(new StringBuilder(30).append("Commit ").append(instantTime).append(" not found in Commits ").append(timeline).append(".").toString());
        }
        HoodieCommitMetadata meta = (HoodieCommitMetadata)commitMetadataOptional.get();
        ArrayList rows = new ArrayList();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(meta.getPartitionToWriteStats().entrySet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)entry -> {
            ShowCommitFilesProcedure.$anonfun$call$1(hoodieInstantOption, rows, entry);
            return BoxedUnit.UNIT;
        });
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(rows.stream().limit(limit).toArray())).map((Function1 & Serializable & scala.Serializable)r -> (Row)r, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class))))).toList();
    }

    @Override
    public Procedure build() {
        return new ShowCommitFilesProcedure();
    }

    private Option<HoodieInstant> getCommitForInstant(HoodieTableMetaClient metaClient, HoodieTimeline timeline, String instantTime) {
        InstantGenerator instantGenerator = metaClient.getTimelineLayout().getInstantGenerator();
        List<Object> instants = Arrays.asList((Object[])new HoodieInstant[]{instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "commit", instantTime), instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "replacecommit", instantTime), instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "clustering", instantTime), instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", instantTime)});
        Option hoodieInstant = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(instants).asScala()).find((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)timeline.containsInstant(i)));
        return hoodieInstant;
    }

    private Option<HoodieCommitMetadata> getHoodieCommitMetadata(HoodieTimeline timeline, Option<HoodieInstant> hoodieInstant) {
        TimelineLayout layout = TimelineLayout.fromVersion((TimelineLayoutVersion)timeline.getTimelineLayoutVersion());
        if (hoodieInstant.isDefined()) {
            if (ClusteringUtils.isClusteringOrReplaceCommitAction((String)((HoodieInstant)hoodieInstant.get()).getAction())) {
                return Option$.MODULE$.apply((Object)timeline.readReplaceCommitMetadata((HoodieInstant)hoodieInstant.get()));
            }
            return Option$.MODULE$.apply((Object)timeline.readCommitMetadata((HoodieInstant)hoodieInstant.get()));
        }
        return Option$.MODULE$.empty();
    }

    public static final /* synthetic */ void $anonfun$call$1(Option hoodieInstantOption$1, ArrayList rows$1, Map.Entry entry) {
        String action = ((HoodieInstant)hoodieInstantOption$1.get()).getAction();
        String path = (String)entry.getKey();
        List stats = (List)entry.getValue();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(stats).asScala()).foreach((Function1 & Serializable & scala.Serializable)stat -> BoxesRunTime.boxToBoolean((boolean)rows$1.add(Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{action, path, stat.getFileId(), stat.getPrevCommit(), BoxesRunTime.boxToLong((long)stat.getNumUpdateWrites()), BoxesRunTime.boxToLong((long)stat.getNumWrites()), BoxesRunTime.boxToLong((long)stat.getTotalWriteBytes()), BoxesRunTime.boxToLong((long)stat.getTotalWriteErrors()), BoxesRunTime.boxToLong((long)stat.getFileSizeInBytes())})))));
    }
}

