/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.sync.common.HoodieSyncException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.MessageType;

public abstract class AbstractSyncHoodieClient {
    private static final Logger LOG = LogManager.getLogger(AbstractSyncHoodieClient.class);
    public static final TypeConverter TYPE_CONVERTOR = new TypeConverter(){};
    protected final HoodieTableMetaClient metaClient;
    protected final HoodieTableType tableType;
    protected final FileSystem fs;
    private final String basePath;
    private final boolean assumeDatePartitioning;
    private final boolean useFileListingFromMetadata;
    private final boolean withOperationField;

    @Deprecated
    public AbstractSyncHoodieClient(String basePath, boolean assumeDatePartitioning, boolean useFileListingFromMetadata, boolean verifyMetadataFileListing, boolean withOperationField, FileSystem fs) {
        this(basePath, assumeDatePartitioning, useFileListingFromMetadata, withOperationField, fs);
    }

    public AbstractSyncHoodieClient(String basePath, boolean assumeDatePartitioning, boolean useFileListingFromMetadata, boolean withOperationField, FileSystem fs) {
        this.metaClient = HoodieTableMetaClient.builder().setConf(fs.getConf()).setBasePath(basePath).setLoadActiveTimelineOnLoad(true).build();
        this.tableType = this.metaClient.getTableType();
        this.basePath = basePath;
        this.assumeDatePartitioning = assumeDatePartitioning;
        this.useFileListingFromMetadata = useFileListingFromMetadata;
        this.withOperationField = withOperationField;
        this.fs = fs;
    }

    public abstract void createTable(String var1, MessageType var2, String var3, String var4, String var5, Map<String, String> var6, Map<String, String> var7);

    public abstract boolean doesTableExist(String var1);

    public abstract Option<String> getLastCommitTimeSynced(String var1);

    public abstract void updateLastCommitTimeSynced(String var1);

    public abstract void addPartitionsToTable(String var1, List<String> var2);

    public abstract void updatePartitionsToTable(String var1, List<String> var2);

    public abstract void dropPartitionsToTable(String var1, List<String> var2);

    public void updateTableProperties(String tableName, Map<String, String> tableProperties) {
    }

    public abstract Map<String, String> getTableSchema(String var1);

    public HoodieTableType getTableType() {
        return this.tableType;
    }

    public String getBasePath() {
        return this.metaClient.getBasePath();
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public boolean isBootstrap() {
        return this.metaClient.getTableConfig().getBootstrapBasePath().isPresent();
    }

    public void closeQuietly(ResultSet resultSet, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)"Could not close the statement opened ", (Throwable)e);
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)"Could not close the resultset opened ", (Throwable)e);
        }
    }

    public MessageType getDataSchema() {
        try {
            if (this.withOperationField) {
                return new TableSchemaResolver(this.metaClient, true).getTableParquetSchema();
            }
            return new TableSchemaResolver(this.metaClient).getTableParquetSchema();
        }
        catch (Exception e) {
            throw new HoodieSyncException("Failed to read data schema", e);
        }
    }

    public boolean isDropPartition() {
        try {
            Option hoodieCommitMetadata = this.withOperationField ? new TableSchemaResolver(this.metaClient, true).getLatestCommitMetadata() : new TableSchemaResolver(this.metaClient).getLatestCommitMetadata();
            if (hoodieCommitMetadata.isPresent() && WriteOperationType.DELETE_PARTITION.equals((Object)((HoodieCommitMetadata)hoodieCommitMetadata.get()).getOperationType())) {
                return true;
            }
        }
        catch (Exception e) {
            throw new HoodieSyncException("Failed to get commit metadata", e);
        }
        return false;
    }

    public List<String> getPartitionsWrittenToSince(Option<String> lastCommitTimeSynced) {
        if (!lastCommitTimeSynced.isPresent()) {
            LOG.info((Object)("Last commit time synced is not known, listing all partitions in " + this.basePath + ",FS :" + this.fs));
            HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(this.metaClient.getHadoopConf());
            return FSUtils.getAllPartitionPaths((HoodieEngineContext)engineContext, (String)this.basePath, (boolean)this.useFileListingFromMetadata, (boolean)this.assumeDatePartitioning);
        }
        LOG.info((Object)("Last commit time synced is " + (String)lastCommitTimeSynced.get() + ", Getting commits since then"));
        return TimelineUtils.getPartitionsWritten((HoodieTimeline)this.metaClient.getActiveTimeline().getCommitsTimeline().findInstantsAfter((String)lastCommitTimeSynced.get(), Integer.MAX_VALUE));
    }

    private MessageType readSchemaFromLogFile(Option<HoodieInstant> lastCompactionCommitOpt, Path path) throws Exception {
        MessageType messageType = TableSchemaResolver.readSchemaFromLogFile((FileSystem)this.fs, (Path)path);
        if (messageType == null) {
            LOG.info((Object)("Falling back to read the schema from last compaction " + lastCompactionCommitOpt));
            return new TableSchemaResolver(this.metaClient).readSchemaFromLastCompaction(lastCompactionCommitOpt);
        }
        return messageType;
    }

    public static class PartitionEvent {
        public PartitionEventType eventType;
        public String storagePartition;

        PartitionEvent(PartitionEventType eventType, String storagePartition) {
            this.eventType = eventType;
            this.storagePartition = storagePartition;
        }

        public static PartitionEvent newPartitionAddEvent(String storagePartition) {
            return new PartitionEvent(PartitionEventType.ADD, storagePartition);
        }

        public static PartitionEvent newPartitionUpdateEvent(String storagePartition) {
            return new PartitionEvent(PartitionEventType.UPDATE, storagePartition);
        }

        public static PartitionEvent newPartitionDropEvent(String storagePartition) {
            return new PartitionEvent(PartitionEventType.DROP, storagePartition);
        }

        public static enum PartitionEventType {
            ADD,
            UPDATE,
            DROP;

        }
    }

    public static abstract class TypeConverter
    implements Serializable {
        static final String DEFAULT_TARGET_TYPE = "DECIMAL";
        protected String targetType;

        public TypeConverter() {
            this.targetType = DEFAULT_TARGET_TYPE;
        }

        public TypeConverter(String targetType) {
            ValidationUtils.checkArgument((boolean)Objects.nonNull(targetType));
            this.targetType = targetType;
        }

        public void doConvert(ResultSet resultSet, Map<String, String> schema) throws SQLException {
            schema.put(this.getColumnName(resultSet), this.targetType.equalsIgnoreCase(this.getColumnType(resultSet)) ? this.convert(resultSet) : this.getColumnType(resultSet));
        }

        public String convert(ResultSet resultSet) throws SQLException {
            String columnType = this.getColumnType(resultSet);
            int columnSize = resultSet.getInt("COLUMN_SIZE");
            int decimalDigits = resultSet.getInt("DECIMAL_DIGITS");
            return columnType + String.format("(%s,%s)", columnSize, decimalDigits);
        }

        public String getColumnName(ResultSet resultSet) throws SQLException {
            return resultSet.getString(4);
        }

        public String getColumnType(ResultSet resultSet) throws SQLException {
            return resultSet.getString(6);
        }
    }
}

