/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common.util;

import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.sync.common.AbstractSyncTool;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SyncUtilHelpers {
    private static final Logger LOG = LogManager.getLogger(SyncUtilHelpers.class);

    public static void runHoodieMetaSync(String metaSyncFQCN, TypedProperties props, Configuration hadoopConfig, FileSystem fs, String targetBasePath, String baseFileFormat) {
        try {
            SyncUtilHelpers.instantiateMetaSyncTool(metaSyncFQCN, props, hadoopConfig, fs, targetBasePath, baseFileFormat).syncHoodieTable();
        }
        catch (Throwable e) {
            throw new HoodieException("Could not sync using the meta sync class " + metaSyncFQCN, e);
        }
    }

    static AbstractSyncTool instantiateMetaSyncTool(String metaSyncFQCN, TypedProperties props, Configuration hadoopConfig, FileSystem fs, String targetBasePath, String baseFileFormat) {
        TypedProperties properties = new TypedProperties();
        properties.putAll((Map)props);
        properties.put((Object)HoodieSyncConfig.META_SYNC_BASE_PATH.key(), (Object)targetBasePath);
        properties.put((Object)HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT.key(), (Object)baseFileFormat);
        if (ReflectionUtils.hasConstructor((String)metaSyncFQCN, (Class[])new Class[]{TypedProperties.class, Configuration.class, FileSystem.class})) {
            return (AbstractSyncTool)ReflectionUtils.loadClass((String)metaSyncFQCN, (Class[])new Class[]{TypedProperties.class, Configuration.class, FileSystem.class}, (Object[])new Object[]{properties, hadoopConfig, fs});
        }
        LOG.warn((Object)("Falling back to deprecated constructor for class: " + metaSyncFQCN));
        try {
            return (AbstractSyncTool)ReflectionUtils.loadClass((String)metaSyncFQCN, (Class[])new Class[]{Properties.class, FileSystem.class}, (Object[])new Object[]{properties, fs});
        }
        catch (Throwable t) {
            throw new HoodieException("Could not load meta sync class " + metaSyncFQCN, t);
        }
    }
}

