/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.sync.common.HoodieMetaSyncOperations;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncException;
import org.apache.hudi.sync.common.model.Partition;
import org.apache.hudi.sync.common.model.PartitionEvent;
import org.apache.hudi.sync.common.model.PartitionValueExtractor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.MessageType;

public abstract class HoodieSyncClient
implements HoodieMetaSyncOperations,
AutoCloseable {
    private static final Logger LOG = LogManager.getLogger(HoodieSyncClient.class);
    protected final HoodieSyncConfig config;
    protected final PartitionValueExtractor partitionValueExtractor;
    protected final HoodieTableMetaClient metaClient;

    public HoodieSyncClient(HoodieSyncConfig config) {
        this.config = config;
        this.partitionValueExtractor = (PartitionValueExtractor)ReflectionUtils.loadClass((String)config.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS));
        this.metaClient = HoodieTableMetaClient.builder().setConf(config.getHadoopConf()).setBasePath(config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH)).setLoadActiveTimelineOnLoad(true).build();
    }

    public HoodieTimeline getActiveTimeline() {
        return this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
    }

    public HoodieTableType getTableType() {
        return this.metaClient.getTableType();
    }

    public String getBasePath() {
        return this.metaClient.getBasePathV2().toString();
    }

    public boolean isBootstrap() {
        return this.metaClient.getTableConfig().getBootstrapBasePath().isPresent();
    }

    public Set<String> getDroppedPartitionsSince(Option<String> lastCommitTimeSynced) {
        HoodieActiveTimeline timeline = lastCommitTimeSynced.isPresent() ? TimelineUtils.getCommitsTimelineAfter((HoodieTableMetaClient)this.metaClient, (String)((String)lastCommitTimeSynced.get())) : this.metaClient.getActiveTimeline();
        return new HashSet<String>(TimelineUtils.getDroppedPartitions((HoodieTimeline)timeline));
    }

    @Override
    public MessageType getStorageSchema() {
        try {
            return new TableSchemaResolver(this.metaClient).getTableParquetSchema();
        }
        catch (Exception e) {
            throw new HoodieSyncException("Failed to read schema from storage.", e);
        }
    }

    public List<String> getWrittenPartitionsSince(Option<String> lastCommitTimeSynced) {
        if (!lastCommitTimeSynced.isPresent()) {
            LOG.info((Object)("Last commit time synced is not known, listing all partitions in " + this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH) + ",FS :" + this.config.getHadoopFileSystem()));
            HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(this.metaClient.getHadoopConf());
            return FSUtils.getAllPartitionPaths((HoodieEngineContext)engineContext, (String)this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH), (boolean)this.config.getBoolean(HoodieSyncConfig.META_SYNC_USE_FILE_LISTING_FROM_METADATA), (boolean)this.config.getBoolean(HoodieSyncConfig.META_SYNC_ASSUME_DATE_PARTITION));
        }
        LOG.info((Object)("Last commit time synced is " + (String)lastCommitTimeSynced.get() + ", Getting commits since then"));
        return TimelineUtils.getWrittenPartitions((HoodieTimeline)TimelineUtils.getCommitsTimelineAfter((HoodieTableMetaClient)this.metaClient, (String)((String)lastCommitTimeSynced.get())));
    }

    public List<PartitionEvent> getPartitionEvents(List<Partition> tablePartitions, List<String> partitionStoragePartitions, Set<String> droppedPartitions) {
        HashMap<String, String> paths = new HashMap<String, String>();
        for (Partition tablePartition : tablePartitions) {
            List<String> hivePartitionValues = tablePartition.getValues();
            String fullTablePartitionPath = Path.getPathWithoutSchemeAndAuthority((Path)new Path(tablePartition.getStorageLocation())).toUri().getPath();
            paths.put(String.join((CharSequence)", ", hivePartitionValues), fullTablePartitionPath);
        }
        ArrayList<PartitionEvent> events = new ArrayList<PartitionEvent>();
        for (String storagePartition : partitionStoragePartitions) {
            Path storagePartitionPath = FSUtils.getPartitionPath((String)this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH), (String)storagePartition);
            String fullStoragePartitionPath = Path.getPathWithoutSchemeAndAuthority((Path)storagePartitionPath).toUri().getPath();
            List<String> storagePartitionValues = this.partitionValueExtractor.extractPartitionValuesInPath(storagePartition);
            if (droppedPartitions.contains(storagePartition)) {
                events.add(PartitionEvent.newPartitionDropEvent(storagePartition));
                continue;
            }
            if (storagePartitionValues.isEmpty()) continue;
            String storageValue = String.join((CharSequence)", ", storagePartitionValues);
            if (!paths.containsKey(storageValue)) {
                events.add(PartitionEvent.newPartitionAddEvent(storagePartition));
                continue;
            }
            if (((String)paths.get(storageValue)).equals(fullStoragePartitionPath)) continue;
            events.add(PartitionEvent.newPartitionUpdateEvent(storagePartition));
        }
        return events;
    }
}

