/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common.util;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieMetadataFileSystemView;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class ManifestFileWriter {
    public static final String MANIFEST_FOLDER_NAME = "manifest";
    public static final String MANIFEST_FILE_NAME = "latest-snapshot.csv";
    private static final Logger LOG = LogManager.getLogger(ManifestFileWriter.class);
    private final HoodieTableMetaClient metaClient;
    private final boolean useFileListingFromMetadata;
    private final boolean assumeDatePartitioning;

    private ManifestFileWriter(Configuration hadoopConf, String basePath, boolean useFileListingFromMetadata, boolean assumeDatePartitioning) {
        this.metaClient = HoodieTableMetaClient.builder().setConf(hadoopConf).setBasePath(basePath).setLoadActiveTimelineOnLoad(true).build();
        this.useFileListingFromMetadata = useFileListingFromMetadata;
        this.assumeDatePartitioning = assumeDatePartitioning;
    }

    public synchronized void writeManifestFile() {
        try {
            List baseFiles = ManifestFileWriter.fetchLatestBaseFilesForAllPartitions(this.metaClient, this.useFileListingFromMetadata, this.assumeDatePartitioning).collect(Collectors.toList());
            if (baseFiles.isEmpty()) {
                LOG.warn((Object)"No base file to generate manifest file.");
                return;
            }
            LOG.info((Object)("Writing base file names to manifest file: " + baseFiles.size()));
            Path manifestFilePath = this.getManifestFilePath();
            try (FSDataOutputStream outputStream = this.metaClient.getFs().create(manifestFilePath, true);
                 BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));){
                for (String f : baseFiles) {
                    writer.write(f);
                    writer.write("\n");
                }
            }
        }
        catch (Exception e) {
            throw new HoodieException("Error in writing manifest file.", (Throwable)e);
        }
    }

    public static Stream<String> fetchLatestBaseFilesForAllPartitions(HoodieTableMetaClient metaClient, boolean useFileListingFromMetadata, boolean assumeDatePartitioning) {
        try {
            List partitions = FSUtils.getAllPartitionPaths((HoodieEngineContext)new HoodieLocalEngineContext(metaClient.getHadoopConf()), (String)metaClient.getBasePath(), (boolean)useFileListingFromMetadata, (boolean)assumeDatePartitioning);
            LOG.info((Object)("Retrieve all partitions: " + partitions.size()));
            return partitions.parallelStream().flatMap(p -> {
                Configuration hadoopConf = metaClient.getHadoopConf();
                HoodieLocalEngineContext engContext = new HoodieLocalEngineContext(hadoopConf);
                HoodieMetadataFileSystemView fsView = new HoodieMetadataFileSystemView((HoodieEngineContext)engContext, metaClient, metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants(), HoodieMetadataConfig.newBuilder().enable(useFileListingFromMetadata).withAssumeDatePartitioning(assumeDatePartitioning).build());
                return fsView.getLatestBaseFiles(p).map(BaseFile::getFileName);
            });
        }
        catch (Exception e) {
            throw new HoodieException("Error in fetching latest base files.", (Throwable)e);
        }
    }

    public Path getManifestFolder() {
        return new Path(this.metaClient.getMetaPath(), MANIFEST_FOLDER_NAME);
    }

    public Path getManifestFilePath() {
        return new Path(this.getManifestFolder(), MANIFEST_FILE_NAME);
    }

    public String getManifestSourceUri() {
        return new Path(this.getManifestFolder(), "*").toUri().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Configuration conf;
        private String basePath;
        private boolean useFileListingFromMetadata;
        private boolean assumeDatePartitioning;

        public Builder setConf(Configuration conf) {
            this.conf = conf;
            return this;
        }

        public Builder setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder setUseFileListingFromMetadata(boolean useFileListingFromMetadata) {
            this.useFileListingFromMetadata = useFileListingFromMetadata;
            return this;
        }

        public Builder setAssumeDatePartitioning(boolean assumeDatePartitioning) {
            this.assumeDatePartitioning = assumeDatePartitioning;
            return this;
        }

        public ManifestFileWriter build() {
            ValidationUtils.checkArgument((this.conf != null ? 1 : 0) != 0, (String)"Configuration needs to be set to init ManifestFileGenerator");
            ValidationUtils.checkArgument((this.basePath != null ? 1 : 0) != 0, (String)"basePath needs to be set to init ManifestFileGenerator");
            return new ManifestFileWriter(this.conf, this.basePath, this.useFileListingFromMetadata, this.assumeDatePartitioning);
        }
    }
}

