/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common.util;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncTool;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SyncUtilHelpers {
    private static final Logger LOG = LogManager.getLogger(SyncUtilHelpers.class);

    public static void runHoodieMetaSync(String syncToolClassName, TypedProperties props, Configuration hadoopConfig, FileSystem fs, String targetBasePath, String baseFileFormat) {
        try {
            SyncUtilHelpers.instantiateMetaSyncTool(syncToolClassName, props, hadoopConfig, fs, targetBasePath, baseFileFormat).syncHoodieTable();
        }
        catch (Throwable e) {
            throw new HoodieException("Could not sync using the meta sync class " + syncToolClassName, e);
        }
    }

    static HoodieSyncTool instantiateMetaSyncTool(String syncToolClassName, TypedProperties props, Configuration hadoopConfig, FileSystem fs, String targetBasePath, String baseFileFormat) {
        String tableName;
        TypedProperties properties = new TypedProperties();
        properties.putAll((Map)props);
        properties.put((Object)HoodieSyncConfig.META_SYNC_BASE_PATH.key(), (Object)targetBasePath);
        properties.put((Object)HoodieSyncConfig.META_SYNC_BASE_FILE_FORMAT.key(), (Object)baseFileFormat);
        if (properties.containsKey((Object)HoodieSyncConfig.META_SYNC_TABLE_NAME.key()) && !(tableName = properties.getString(HoodieSyncConfig.META_SYNC_TABLE_NAME.key())).equals(tableName.toLowerCase())) {
            LOG.warn((Object)("Table name \"" + tableName + "\" contains capital letters. Your metastore may automatically convert this to lower case and can cause table not found errors during subsequent syncs."));
        }
        if (ReflectionUtils.hasConstructor((String)syncToolClassName, (Class[])new Class[]{Properties.class, Configuration.class})) {
            return (HoodieSyncTool)ReflectionUtils.loadClass((String)syncToolClassName, (Class[])new Class[]{Properties.class, Configuration.class}, (Object[])new Object[]{properties, hadoopConfig});
        }
        if (ReflectionUtils.hasConstructor((String)syncToolClassName, (Class[])new Class[]{Properties.class})) {
            return (HoodieSyncTool)ReflectionUtils.loadClass((String)syncToolClassName, (Class[])new Class[]{Properties.class}, (Object[])new Object[]{properties});
        }
        if (ReflectionUtils.hasConstructor((String)syncToolClassName, (Class[])new Class[]{TypedProperties.class, Configuration.class, FileSystem.class})) {
            return (HoodieSyncTool)ReflectionUtils.loadClass((String)syncToolClassName, (Class[])new Class[]{TypedProperties.class, Configuration.class, FileSystem.class}, (Object[])new Object[]{properties, hadoopConfig, fs});
        }
        if (ReflectionUtils.hasConstructor((String)syncToolClassName, (Class[])new Class[]{Properties.class, FileSystem.class})) {
            return (HoodieSyncTool)ReflectionUtils.loadClass((String)syncToolClassName, (Class[])new Class[]{Properties.class, FileSystem.class}, (Object[])new Object[]{properties, fs});
        }
        throw new HoodieException("Could not load meta sync class " + syncToolClassName + ": no valid constructor found.");
    }

    public static HoodieException getExceptionFromList(Collection<HoodieException> exceptions) {
        if (exceptions.size() == 1) {
            return exceptions.stream().findFirst().get();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Multiple exceptions during meta sync:\n");
        exceptions.forEach(e -> {
            sb.append(e.getMessage());
            sb.append("\n");
        });
        return new HoodieException(sb.toString());
    }
}

