/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.ParquetTableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.sync.common.HoodieMetaSyncOperations;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.HoodieSyncException;
import org.apache.hudi.sync.common.model.Partition;
import org.apache.hudi.sync.common.model.PartitionEvent;
import org.apache.hudi.sync.common.model.PartitionValueExtractor;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieSyncClient
implements HoodieMetaSyncOperations,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieSyncClient.class);
    protected final HoodieSyncConfig config;
    protected final PartitionValueExtractor partitionValueExtractor;
    protected final HoodieTableMetaClient metaClient;

    public HoodieSyncClient(HoodieSyncConfig config) {
        this.config = config;
        this.partitionValueExtractor = (PartitionValueExtractor)ReflectionUtils.loadClass((String)config.getStringOrDefault(HoodieSyncConfig.META_SYNC_PARTITION_EXTRACTOR_CLASS));
        this.metaClient = HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)config.getHadoopConf())).setBasePath(config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH)).setLoadActiveTimelineOnLoad(true).build();
    }

    public HoodieTimeline getActiveTimeline() {
        return this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
    }

    public HoodieTableType getTableType() {
        return this.metaClient.getTableType();
    }

    public String getBasePath() {
        return this.metaClient.getBasePathV2().toString();
    }

    public boolean isBootstrap() {
        return this.metaClient.getTableConfig().getBootstrapBasePath().isPresent();
    }

    public HoodieTableMetaClient getMetaClient() {
        return this.metaClient;
    }

    public Set<String> getDroppedPartitionsSince(Option<String> lastCommitTimeSynced, Option<String> lastCommitCompletionTimeSynced) {
        return new HashSet<String>(TimelineUtils.getDroppedPartitions((HoodieTableMetaClient)this.metaClient, lastCommitTimeSynced, lastCommitCompletionTimeSynced));
    }

    @Override
    public MessageType getStorageSchema() {
        try {
            return new ParquetTableSchemaResolver(this.metaClient).getTableParquetSchema();
        }
        catch (Exception e) {
            throw new HoodieSyncException("Failed to read schema from storage.", e);
        }
    }

    @Override
    public MessageType getStorageSchema(boolean includeMetadataField) {
        try {
            return new ParquetTableSchemaResolver(this.metaClient).getTableParquetSchema(includeMetadataField);
        }
        catch (Exception e) {
            throw new HoodieSyncException("Failed to read schema from storage.", e);
        }
    }

    public List<String> getAllPartitionPathsOnStorage() {
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        return FSUtils.getAllPartitionPaths((HoodieEngineContext)engineContext, (HoodieStorage)this.metaClient.getStorage(), (String)this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH), (boolean)this.config.getBoolean(HoodieSyncConfig.META_SYNC_USE_FILE_LISTING_FROM_METADATA), (boolean)this.config.getBoolean(HoodieSyncConfig.META_SYNC_ASSUME_DATE_PARTITION));
    }

    public List<String> getWrittenPartitionsSince(Option<String> lastCommitTimeSynced, Option<String> lastCommitCompletionTimeSynced) {
        if (!lastCommitTimeSynced.isPresent()) {
            LOG.info("Last commit time synced is not known, listing all partitions in " + this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH) + ",FS :" + this.config.getHadoopFileSystem());
            return this.getAllPartitionPathsOnStorage();
        }
        LOG.info("Last commit time synced is " + (String)lastCommitTimeSynced.get() + ", Getting commits since then");
        return TimelineUtils.getWrittenPartitions((HoodieTimeline)TimelineUtils.getCommitsTimelineAfter((HoodieTableMetaClient)this.metaClient, (String)((String)lastCommitTimeSynced.get()), lastCommitCompletionTimeSynced));
    }

    public List<PartitionEvent> getPartitionEvents(List<Partition> allPartitionsInMetastore, List<String> allPartitionsOnStorage) {
        Map<String, String> paths = this.getPartitionValuesToPathMapping(allPartitionsInMetastore);
        HashSet<String> partitionsToDrop = new HashSet<String>(paths.keySet());
        ArrayList<PartitionEvent> events = new ArrayList<PartitionEvent>();
        for (String storagePartition : allPartitionsOnStorage) {
            Path storagePartitionPath = HadoopFSUtils.constructAbsolutePathInHadoopPath((String)this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH), (String)storagePartition);
            String fullStoragePartitionPath = Path.getPathWithoutSchemeAndAuthority((Path)storagePartitionPath).toUri().getPath();
            List<String> storagePartitionValues = this.partitionValueExtractor.extractPartitionValuesInPath(storagePartition);
            if (storagePartitionValues.isEmpty()) continue;
            String storageValue2 = String.join((CharSequence)", ", storagePartitionValues);
            partitionsToDrop.remove(storageValue2);
            if (!paths.containsKey(storageValue2)) {
                events.add(PartitionEvent.newPartitionAddEvent(storagePartition));
                continue;
            }
            if (paths.get(storageValue2).equals(fullStoragePartitionPath)) continue;
            events.add(PartitionEvent.newPartitionUpdateEvent(storagePartition));
        }
        partitionsToDrop.forEach(storageValue -> {
            String storagePath = (String)paths.get(storageValue);
            try {
                String relativePath = FSUtils.getRelativePartitionPath((StoragePath)this.metaClient.getBasePathV2(), (StoragePath)new StoragePath(storagePath));
                events.add(PartitionEvent.newPartitionDropEvent(relativePath));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Cannot parse the path stored in the metastore, ignoring it for generating DROP partition event: \"" + storagePath + "\".", (Throwable)e);
            }
        });
        return events;
    }

    public List<PartitionEvent> getPartitionEvents(List<Partition> partitionsInMetastore, List<String> writtenPartitionsOnStorage, Set<String> droppedPartitionsOnStorage) {
        Map<String, String> paths = this.getPartitionValuesToPathMapping(partitionsInMetastore);
        ArrayList<PartitionEvent> events = new ArrayList<PartitionEvent>();
        for (String storagePartition : writtenPartitionsOnStorage) {
            Path storagePartitionPath = HadoopFSUtils.constructAbsolutePathInHadoopPath((String)this.config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH), (String)storagePartition);
            String fullStoragePartitionPath = Path.getPathWithoutSchemeAndAuthority((Path)storagePartitionPath).toUri().getPath();
            List<String> storagePartitionValues = this.partitionValueExtractor.extractPartitionValuesInPath(storagePartition);
            if (droppedPartitionsOnStorage.contains(storagePartition)) {
                events.add(PartitionEvent.newPartitionDropEvent(storagePartition));
                continue;
            }
            if (storagePartitionValues.isEmpty()) continue;
            String storageValue = String.join((CharSequence)", ", storagePartitionValues);
            if (!paths.containsKey(storageValue)) {
                events.add(PartitionEvent.newPartitionAddEvent(storagePartition));
                continue;
            }
            if (paths.get(storageValue).equals(fullStoragePartitionPath)) continue;
            events.add(PartitionEvent.newPartitionUpdateEvent(storagePartition));
        }
        return events;
    }

    private Map<String, String> getPartitionValuesToPathMapping(List<Partition> partitionsInMetastore) {
        HashMap<String, String> paths = new HashMap<String, String>();
        for (Partition tablePartition : partitionsInMetastore) {
            List<String> hivePartitionValues = tablePartition.getValues();
            String fullTablePartitionPath = Path.getPathWithoutSchemeAndAuthority((Path)new Path(tablePartition.getStorageLocation())).toUri().getPath();
            paths.put(String.join((CharSequence)", ", hivePartitionValues), fullTablePartitionPath);
        }
        return paths;
    }
}

