/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.sync.common.HoodieSyncException;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.MessageType;

public abstract class AbstractSyncHoodieClient {
    private static final Logger LOG = LogManager.getLogger(AbstractSyncHoodieClient.class);
    protected final HoodieTableMetaClient metaClient;
    protected HoodieTimeline activeTimeline;
    protected final HoodieTableType tableType;
    protected final FileSystem fs;
    private String basePath;
    private boolean assumeDatePartitioning;

    public AbstractSyncHoodieClient(String basePath, boolean assumeDatePartitioning, FileSystem fs) {
        this.metaClient = new HoodieTableMetaClient(fs.getConf(), basePath, true);
        this.tableType = this.metaClient.getTableType();
        this.basePath = basePath;
        this.assumeDatePartitioning = assumeDatePartitioning;
        this.fs = fs;
        this.activeTimeline = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
    }

    public abstract void createTable(String var1, MessageType var2, String var3, String var4, String var5);

    public abstract boolean doesTableExist(String var1);

    public abstract Option<String> getLastCommitTimeSynced(String var1);

    public abstract void updateLastCommitTimeSynced(String var1);

    public abstract void addPartitionsToTable(String var1, List<String> var2);

    public abstract void updatePartitionsToTable(String var1, List<String> var2);

    public abstract Map<String, String> getTableSchema(String var1);

    public HoodieTimeline getActiveTimeline() {
        return this.activeTimeline;
    }

    public HoodieTableType getTableType() {
        return this.tableType;
    }

    public String getBasePath() {
        return this.metaClient.getBasePath();
    }

    public FileSystem getFs() {
        return this.fs;
    }

    public void closeQuietly(ResultSet resultSet, Statement stmt) {
        try {
            if (stmt != null) {
                stmt.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)"Could not close the statement opened ", (Throwable)e);
        }
        try {
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException e) {
            LOG.warn((Object)"Could not close the resultset opened ", (Throwable)e);
        }
    }

    public MessageType getDataSchema() {
        try {
            return new TableSchemaResolver(this.metaClient).getTableParquetSchema();
        }
        catch (Exception e) {
            throw new HoodieSyncException("Failed to read data schema", e);
        }
    }

    public List<String> getPartitionsWrittenToSince(Option<String> lastCommitTimeSynced) {
        if (!lastCommitTimeSynced.isPresent()) {
            LOG.info((Object)("Last commit time synced is not known, listing all partitions in " + this.basePath + ",FS :" + this.fs));
            try {
                return FSUtils.getAllPartitionPaths((FileSystem)this.fs, (String)this.basePath, (boolean)this.assumeDatePartitioning);
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to list all partitions in " + this.basePath, e);
            }
        }
        LOG.info((Object)("Last commit time synced is " + (String)lastCommitTimeSynced.get() + ", Getting commits since then"));
        HoodieTimeline timelineToSync = this.activeTimeline.findInstantsAfter((String)lastCommitTimeSynced.get(), Integer.MAX_VALUE);
        return timelineToSync.getInstants().map(s -> {
            try {
                return (HoodieCommitMetadata)HoodieCommitMetadata.fromBytes((byte[])((byte[])this.activeTimeline.getInstantDetails(s).get()), HoodieCommitMetadata.class);
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to get partitions written since " + lastCommitTimeSynced, e);
            }
        }).flatMap(s -> s.getPartitionToWriteStats().keySet().stream()).distinct().collect(Collectors.toList());
    }

    private MessageType readSchemaFromLogFile(Option<HoodieInstant> lastCompactionCommitOpt, Path path) throws Exception {
        MessageType messageType = TableSchemaResolver.readSchemaFromLogFile((FileSystem)this.fs, (Path)path);
        if (messageType == null) {
            LOG.info((Object)("Falling back to read the schema from last compaction " + lastCompactionCommitOpt));
            return new TableSchemaResolver(this.metaClient).readSchemaFromLastCompaction(lastCompactionCommitOpt);
        }
        return messageType;
    }

    public static class PartitionEvent {
        public PartitionEventType eventType;
        public String storagePartition;

        PartitionEvent(PartitionEventType eventType, String storagePartition) {
            this.eventType = eventType;
            this.storagePartition = storagePartition;
        }

        public static PartitionEvent newPartitionAddEvent(String storagePartition) {
            return new PartitionEvent(PartitionEventType.ADD, storagePartition);
        }

        public static PartitionEvent newPartitionUpdateEvent(String storagePartition) {
            return new PartitionEvent(PartitionEventType.UPDATE, storagePartition);
        }

        public static enum PartitionEventType {
            ADD,
            UPDATE;

        }
    }
}

