/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common.util;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieMetadataFileSystemView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManifestFileWriter {
    public static final String MANIFEST_FOLDER_NAME = "manifest";
    public static final String ABSOLUTE_PATH_MANIFEST_FOLDER_NAME = "absolute-path-manifest";
    public static final String MANIFEST_FILE_NAME = "latest-snapshot.csv";
    private static final Logger LOG = LoggerFactory.getLogger(ManifestFileWriter.class);
    private final HoodieTableMetaClient metaClient;
    private final boolean useFileListingFromMetadata;

    private ManifestFileWriter(HoodieTableMetaClient metaClient, boolean useFileListingFromMetadata) {
        this.metaClient = metaClient;
        this.useFileListingFromMetadata = useFileListingFromMetadata;
    }

    public synchronized void writeManifestFile(boolean useAbsolutePath) {
        try {
            List baseFiles = ManifestFileWriter.fetchLatestBaseFilesForAllPartitions(this.metaClient, this.useFileListingFromMetadata, useAbsolutePath).collect(Collectors.toList());
            if (baseFiles.isEmpty()) {
                LOG.warn("No base file to generate manifest file.");
                return;
            }
            LOG.info("Writing base file names to manifest file: " + baseFiles.size());
            Path manifestFilePath = this.getManifestFilePath(useAbsolutePath);
            try (FSDataOutputStream outputStream = this.metaClient.getFs().create(manifestFilePath, true);
                 BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8));){
                for (String f : baseFiles) {
                    writer.write(f);
                    writer.write("\n");
                }
            }
        }
        catch (Exception e) {
            throw new HoodieException("Error in writing manifest file.", (Throwable)e);
        }
    }

    public static Stream<String> fetchLatestBaseFilesForAllPartitions(HoodieTableMetaClient metaClient, boolean useFileListingFromMetadata, boolean useAbsolutePath) {
        try {
            List partitions = FSUtils.getAllPartitionPaths((HoodieEngineContext)new HoodieLocalEngineContext(metaClient.getHadoopConf()), (String)metaClient.getBasePath(), (boolean)useFileListingFromMetadata);
            LOG.info("Retrieve all partitions: " + partitions.size());
            Configuration hadoopConf = metaClient.getHadoopConf();
            HoodieLocalEngineContext engContext = new HoodieLocalEngineContext(hadoopConf);
            HoodieMetadataFileSystemView fsView = new HoodieMetadataFileSystemView((HoodieEngineContext)engContext, metaClient, metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants(), HoodieMetadataConfig.newBuilder().enable(useFileListingFromMetadata).build());
            return partitions.parallelStream().flatMap(partition -> fsView.getLatestBaseFiles(partition).map(useAbsolutePath ? BaseFile::getPath : BaseFile::getFileName));
        }
        catch (Exception e) {
            throw new HoodieException("Error in fetching latest base files.", (Throwable)e);
        }
    }

    public Path getManifestFolder(boolean useAbsolutePath) {
        return new Path(this.metaClient.getMetaPath(), useAbsolutePath ? ABSOLUTE_PATH_MANIFEST_FOLDER_NAME : MANIFEST_FOLDER_NAME);
    }

    public Path getManifestFilePath(boolean useAbsolutePath) {
        return new Path(this.getManifestFolder(useAbsolutePath), MANIFEST_FILE_NAME);
    }

    public String getManifestSourceUri(boolean useAbsolutePath) {
        return new Path(this.getManifestFolder(useAbsolutePath), "*").toUri().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean useFileListingFromMetadata;
        private HoodieTableMetaClient metaClient;

        public Builder setUseFileListingFromMetadata(boolean useFileListingFromMetadata) {
            this.useFileListingFromMetadata = useFileListingFromMetadata;
            return this;
        }

        public Builder setMetaClient(HoodieTableMetaClient metaClient) {
            this.metaClient = metaClient;
            return this;
        }

        public ManifestFileWriter build() {
            ValidationUtils.checkArgument((this.metaClient != null ? 1 : 0) != 0, (String)"MetaClient needs to be set to init ManifestFileGenerator");
            return new ManifestFileWriter(this.metaClient, this.useFileListingFromMetadata);
        }
    }
}

