/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common;

import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.HadoopConfigUtils;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.sync.common.HoodieSyncConfig;
import org.apache.hudi.sync.common.metrics.HoodieMetaSyncMetrics;

public abstract class HoodieSyncTool
implements AutoCloseable {
    protected Properties props;
    protected Configuration hadoopConf;
    protected HoodieMetaSyncMetrics metrics;

    public HoodieSyncTool(Properties props) {
        this(props, HadoopConfigUtils.createHadoopConf((Properties)props));
    }

    public HoodieSyncTool(Properties props, Configuration hadoopConf) {
        this.props = props;
        this.hadoopConf = hadoopConf;
        this.metrics = new HoodieMetaSyncMetrics(new HoodieSyncConfig(props, hadoopConf), this.getClass().getSimpleName());
    }

    @Deprecated
    public HoodieSyncTool(TypedProperties props, Configuration conf, FileSystem fs) {
        this((Properties)props, conf);
    }

    @Deprecated
    public HoodieSyncTool(Properties props, FileSystem fileSystem) {
        this(props, fileSystem.getConf());
    }

    public abstract void syncHoodieTable();

    @Override
    public void close() throws Exception {
    }

    protected static HoodieTableMetaClient buildMetaClient(HoodieSyncConfig config) {
        return HoodieTableMetaClient.builder().setConf(HadoopFSUtils.getStorageConfWithCopy((Configuration)config.getHadoopConf())).setBasePath(config.getString(HoodieSyncConfig.META_SYNC_BASE_PATH)).setLoadActiveTimelineOnLoad(true).build();
    }
}

