/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sync.common.model;

import java.util.Objects;
import org.apache.hudi.common.util.Option;

public class FieldSchema {
    private final String name;
    private String type;
    private Option<String> comment;

    public FieldSchema(String name, String type) {
        this(name, type, (Option<String>)Option.empty());
    }

    public FieldSchema(String name, String type, String comment) {
        this(name, type, (Option<String>)Option.ofNullable((Object)comment));
    }

    public FieldSchema(String name, String type, Option<String> comment) {
        this.name = name;
        this.type = type;
        this.comment = comment;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public Option<String> getComment() {
        return this.comment;
    }

    public String getCommentOrEmpty() {
        return (String)this.comment.orElse((Object)"");
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setComment(Option<String> comment) {
        this.comment = comment;
    }

    public void setComment(String comment) {
        this.comment = Option.ofNullable((Object)comment);
    }

    public boolean updateComment(FieldSchema another) {
        if (Objects.equals(this.name, another.getName()) && !Objects.equals(this.getCommentOrEmpty(), another.getCommentOrEmpty())) {
            this.setComment(another.getComment());
            return true;
        }
        return false;
    }
}

