/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.hudi.org.apache.avro.Conversions;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.UnresolvedUnionException;
import org.apache.hudi.org.apache.avro.data.TimeConversions;
import org.apache.hudi.org.apache.avro.generic.GenericData;
import org.apache.hudi.org.apache.avro.generic.GenericFixed;

public class ConvertingGenericData
extends GenericData {
    private static final Conversions.DecimalConversion DECIMAL_CONVERSION = new Conversions.DecimalConversion();
    private static final Conversions.UUIDConversion UUID_CONVERSION = new Conversions.UUIDConversion();
    private static final TimeConversions.DateConversion DATE_CONVERSION = new TimeConversions.DateConversion();
    private static final TimeConversions.TimeMicrosConversion TIME_MICROS_CONVERSION = new TimeConversions.TimeMicrosConversion();
    private static final TimeConversions.TimestampMicrosConversion TIMESTAMP_MICROS_CONVERSION = new TimeConversions.TimestampMicrosConversion();
    public static final GenericData INSTANCE = new ConvertingGenericData();

    private ConvertingGenericData() {
        this.addLogicalTypeConversion(DECIMAL_CONVERSION);
        this.addLogicalTypeConversion(UUID_CONVERSION);
        this.addLogicalTypeConversion(DATE_CONVERSION);
        this.addLogicalTypeConversion(TIME_MICROS_CONVERSION);
        this.addLogicalTypeConversion(TIMESTAMP_MICROS_CONVERSION);
    }

    @Override
    public boolean validate(Schema schema, Object datum) {
        switch (schema.getType()) {
            case RECORD: {
                if (!this.isRecord(datum)) {
                    return false;
                }
                for (Schema.Field f : schema.getFields()) {
                    if (this.validate(f.schema(), this.getField(datum, f.name(), f.pos()))) continue;
                    return false;
                }
                return true;
            }
            case ENUM: {
                if (!this.isEnum(datum)) {
                    return false;
                }
                return schema.getEnumSymbols().contains(datum.toString());
            }
            case ARRAY: {
                if (!this.isArray(datum)) {
                    return false;
                }
                for (Object element : this.getArrayAsCollection(datum)) {
                    if (this.validate(schema.getElementType(), element)) continue;
                    return false;
                }
                return true;
            }
            case MAP: {
                if (!this.isMap(datum)) {
                    return false;
                }
                Map map = (Map)datum;
                for (Map.Entry entry : map.entrySet()) {
                    if (this.validate(schema.getValueType(), entry.getValue())) continue;
                    return false;
                }
                return true;
            }
            case UNION: {
                try {
                    int i = this.resolveUnion(schema, datum);
                    return this.validate(schema.getTypes().get(i), datum);
                }
                catch (UnresolvedUnionException e) {
                    return false;
                }
            }
            case FIXED: {
                return datum instanceof GenericFixed && ((GenericFixed)datum).bytes().length == schema.getFixedSize() || DECIMAL_CONVERSION.getConvertedType().isInstance(datum);
            }
            case STRING: {
                return this.isString(datum) || UUID_CONVERSION.getConvertedType().isInstance(datum);
            }
            case BYTES: {
                return this.isBytes(datum) || DECIMAL_CONVERSION.getConvertedType().isInstance(datum);
            }
            case INT: {
                return this.isInteger(datum) || DATE_CONVERSION.getConvertedType().isInstance(datum);
            }
            case LONG: {
                return this.isLong(datum) || TIME_MICROS_CONVERSION.getConvertedType().isInstance(datum) || TIMESTAMP_MICROS_CONVERSION.getConvertedType().isInstance(datum);
            }
            case FLOAT: {
                return this.isFloat(datum);
            }
            case DOUBLE: {
                return this.isDouble(datum);
            }
            case BOOLEAN: {
                return this.isBoolean(datum);
            }
            case NULL: {
                return datum == null;
            }
        }
        return false;
    }

    @Override
    public int compare(Object o1, Object o2, Schema s) {
        if (s.getType() == Schema.Type.BYTES && o1 instanceof byte[] && o2 instanceof byte[]) {
            return super.compare(ByteBuffer.wrap((byte[])o1), ByteBuffer.wrap((byte[])o2), s);
        }
        return super.compare(o1, o2, s);
    }
}

