/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericRecord;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;

public class EventTimeAvroPayload
extends DefaultHoodieRecordPayload {
    public EventTimeAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public EventTimeAvroPayload(Option<GenericRecord> record) {
        this(record.isPresent() ? record.get() : null, Integer.valueOf(0));
    }

    @Override
    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord currentValue, Schema schema, Properties properties) throws IOException {
        if (this.recordBytes.length == 0 || this.isDeletedRecord) {
            return Option.empty();
        }
        GenericRecord incomingRecord = HoodieAvroUtils.bytesToAvro(this.recordBytes, schema);
        if (!this.needUpdatingPersistedRecord(currentValue, incomingRecord, properties)) {
            return Option.of(currentValue);
        }
        return Option.of(incomingRecord);
    }

    @Override
    public Option<IndexedRecord> getInsertValue(Schema schema, Properties properties) throws IOException {
        if (this.recordBytes.length == 0 || this.isDeletedRecord) {
            return Option.empty();
        }
        return Option.of(HoodieAvroUtils.bytesToAvro(this.recordBytes, schema));
    }

    @Override
    public Option<Map<String, String>> getMetadata() {
        return Option.empty();
    }
}

