/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.util.JsonUtils;
import org.apache.hudi.storage.StoragePath;

public class HoodieWriteStat
extends HoodieReadStats {
    public static final String NULL_COMMIT = "null";
    private String fileId;
    private String path;
    private Map<String, Long> cdcStats;
    private String prevCommit;
    private long numWrites;
    private long numUpdateWrites;
    private long totalWriteBytes;
    private long totalWriteErrors;
    @Nullable
    private String tempPath;
    @Nullable
    private String partitionPath;
    private long fileSizeInBytes;
    @Nullable
    private Long minEventTime;
    @Nullable
    private Long maxEventTime;
    @Nullable
    private String prevBaseFile;
    @Nullable
    private RuntimeStats runtimeStats;

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setPrevCommit(String prevCommit) {
        this.prevCommit = prevCommit;
    }

    public void setNumWrites(long numWrites) {
        this.numWrites = numWrites;
    }

    public void setNumDeletes(long numDeletes) {
        this.numDeletes = numDeletes;
    }

    public void setNumUpdateWrites(long numUpdateWrites) {
        this.numUpdateWrites = numUpdateWrites;
    }

    public void setNumInserts(long numInserts) {
        this.numInserts = numInserts;
    }

    public long getTotalWriteBytes() {
        return this.totalWriteBytes;
    }

    public void setTotalWriteBytes(long totalWriteBytes) {
        this.totalWriteBytes = totalWriteBytes;
    }

    public long getTotalWriteErrors() {
        return this.totalWriteErrors;
    }

    public void setTotalWriteErrors(long totalWriteErrors) {
        this.totalWriteErrors = totalWriteErrors;
    }

    public String getPrevCommit() {
        return this.prevCommit;
    }

    public long getNumWrites() {
        return this.numWrites;
    }

    public long getNumUpdateWrites() {
        return this.numUpdateWrites;
    }

    public String getFileId() {
        return this.fileId;
    }

    public String getPath() {
        return this.path;
    }

    @Nullable
    public Map<String, Long> getCdcStats() {
        return this.cdcStats;
    }

    public void setCdcStats(Map<String, Long> cdcStats) {
        this.cdcStats = cdcStats;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public void setPartitionPath(String partitionPath) {
        this.partitionPath = partitionPath;
    }

    public void setTempPath(String tempPath) {
        this.tempPath = tempPath;
    }

    public String getTempPath() {
        return this.tempPath;
    }

    public long getFileSizeInBytes() {
        return this.fileSizeInBytes;
    }

    public void setFileSizeInBytes(long fileSizeInBytes) {
        this.fileSizeInBytes = fileSizeInBytes;
    }

    public String getPrevBaseFile() {
        return this.prevBaseFile;
    }

    public void setPrevBaseFile(String prevBaseFile) {
        this.prevBaseFile = prevBaseFile;
    }

    public Long getMinEventTime() {
        return this.minEventTime;
    }

    public void setMinEventTime(Long minEventTime) {
        this.minEventTime = this.minEventTime == null ? minEventTime : Long.valueOf(Math.min(minEventTime, this.minEventTime));
    }

    public Long getMaxEventTime() {
        return this.maxEventTime;
    }

    public void setMaxEventTime(Long maxEventTime) {
        this.maxEventTime = this.maxEventTime == null ? maxEventTime : Long.valueOf(Math.max(maxEventTime, this.maxEventTime));
    }

    @Nullable
    public RuntimeStats getRuntimeStats() {
        return this.runtimeStats;
    }

    public void setRuntimeStats(@Nullable RuntimeStats runtimeStats) {
        this.runtimeStats = runtimeStats;
    }

    public void setPath(StoragePath basePath, StoragePath path) {
        this.path = path.toString().replace(basePath + "/", "");
    }

    public String toString() {
        return "HoodieWriteStat{fileId='" + this.fileId + '\'' + ", path='" + this.path + '\'' + ", prevCommit='" + this.prevCommit + '\'' + ", prevBaseFile=" + this.prevBaseFile + '\'' + ", numWrites=" + this.numWrites + ", numDeletes=" + this.numDeletes + ", numUpdateWrites=" + this.numUpdateWrites + ", totalWriteBytes=" + this.totalWriteBytes + ", totalWriteErrors=" + this.totalWriteErrors + ", tempPath='" + this.tempPath + '\'' + ", cdcStats='" + JsonUtils.toString(this.cdcStats) + '\'' + ", partitionPath='" + this.partitionPath + '\'' + ", totalLogRecords=" + this.totalLogRecords + ", totalLogFilesCompacted=" + this.totalLogFilesCompacted + ", totalLogSizeCompacted=" + this.totalLogSizeCompacted + ", totalUpdatedRecordsCompacted=" + this.totalUpdatedRecordsCompacted + ", totalLogBlocks=" + this.totalLogBlocks + ", totalCorruptLogBlock=" + this.totalCorruptLogBlock + ", totalRollbackBlocks=" + this.totalRollbackBlocks + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieWriteStat that = (HoodieWriteStat)o;
        if (!this.path.equals(that.path)) {
            return false;
        }
        return this.prevCommit.equals(that.prevCommit);
    }

    public int hashCode() {
        int result = this.path.hashCode();
        result = 31 * result + this.prevCommit.hashCode();
        return result;
    }

    public static class RuntimeStats
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private long totalScanTime;
        private long totalUpsertTime;
        private long totalCreateTime;

        public long getTotalScanTime() {
            return this.totalScanTime;
        }

        public void setTotalScanTime(long totalScanTime) {
            this.totalScanTime = totalScanTime;
        }

        public long getTotalUpsertTime() {
            return this.totalUpsertTime;
        }

        public void setTotalUpsertTime(long totalUpsertTime) {
            this.totalUpsertTime = totalUpsertTime;
        }

        public long getTotalCreateTime() {
            return this.totalCreateTime;
        }

        public void setTotalCreateTime(long totalCreateTime) {
            this.totalCreateTime = totalCreateTime;
        }
    }
}

