/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.read;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.model.DeleteRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.KeySpec;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieDeleteBlock;
import org.apache.hudi.common.table.read.HoodieBaseFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieFileGroupRecordBuffer;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.Pair;

public class HoodieKeyBasedFileGroupRecordBuffer<T>
extends HoodieBaseFileGroupRecordBuffer<T> {
    public HoodieKeyBasedFileGroupRecordBuffer(HoodieReaderContext<T> readerContext, HoodieTableMetaClient hoodieTableMetaClient, RecordMergeMode recordMergeMode, Option<String> partitionNameOverrideOpt, Option<String[]> partitionPathFieldOpt, TypedProperties props, HoodieReadStats readStats) {
        super(readerContext, hoodieTableMetaClient, recordMergeMode, partitionNameOverrideOpt, partitionPathFieldOpt, props, readStats);
    }

    @Override
    public HoodieFileGroupRecordBuffer.BufferType getBufferType() {
        return HoodieFileGroupRecordBuffer.BufferType.KEY_BASED_MERGE;
    }

    @Override
    public void processDataBlock(HoodieDataBlock dataBlock, Option<KeySpec> keySpecOpt) throws IOException {
        Pair recordsIteratorSchemaPair = this.getRecordsIterator(dataBlock, keySpecOpt);
        if (dataBlock.containsPartialUpdates()) {
            this.enablePartialMerging = true;
        }
        try (ClosableIterator recordIterator = recordsIteratorSchemaPair.getLeft();){
            while (recordIterator.hasNext()) {
                Object nextRecord = recordIterator.next();
                Map<String, Object> metadata = this.readerContext.generateMetadataForRecord(nextRecord, recordsIteratorSchemaPair.getRight());
                String recordKey = (String)metadata.get("_0");
                this.processNextDataRecord(nextRecord, metadata, (Serializable)((Object)recordKey));
            }
        }
    }

    @Override
    public void processNextDataRecord(T record, Map<String, Object> metadata, Serializable recordKey) throws IOException {
        Pair existingRecordMetadataPair = (Pair)this.records.get(recordKey);
        Option<Pair<Option<T>, Map<String, Object>>> mergedRecordAndMetadata = this.doProcessNextDataRecord(record, metadata, existingRecordMetadataPair);
        if (mergedRecordAndMetadata.isPresent()) {
            this.records.put(recordKey, Pair.of(mergedRecordAndMetadata.get().getLeft().isPresent() ? Option.ofNullable(this.readerContext.seal(mergedRecordAndMetadata.get().getLeft().get())) : Option.empty(), mergedRecordAndMetadata.get().getRight()));
        }
    }

    @Override
    public void processDeleteBlock(HoodieDeleteBlock deleteBlock) throws IOException {
        Iterator it = Arrays.stream(deleteBlock.getRecordsToDelete()).iterator();
        while (it.hasNext()) {
            DeleteRecord record = (DeleteRecord)it.next();
            String recordKey = record.getRecordKey();
            this.processNextDeletedRecord(record, (Serializable)((Object)recordKey));
        }
    }

    @Override
    public void processNextDeletedRecord(DeleteRecord deleteRecord, Serializable recordKey) {
        Pair existingRecordMetadataPair = (Pair)this.records.get(recordKey);
        Option<DeleteRecord> recordOpt = this.doProcessNextDeletedRecord(deleteRecord, existingRecordMetadataPair);
        if (recordOpt.isPresent()) {
            this.records.put(recordKey, Pair.of(Option.empty(), this.readerContext.generateMetadataForRecord((String)((Object)recordKey), recordOpt.get().getPartitionPath(), recordOpt.get().getOrderingValue(), this.orderingFieldTypeOpt)));
        }
    }

    @Override
    public boolean containsLogRecord(String recordKey) {
        return this.records.containsKey(recordKey);
    }

    protected boolean hasNextBaseRecord(T baseRecord) throws IOException {
        String recordKey = this.readerContext.getRecordKey(baseRecord, this.readerSchema);
        Pair logRecordInfo = (Pair)this.records.remove(recordKey);
        return this.hasNextBaseRecord(baseRecord, logRecordInfo);
    }

    @Override
    protected boolean doHasNext() throws IOException {
        ValidationUtils.checkState(this.baseFileIterator != null, "Base file iterator has not been set yet");
        while (this.baseFileIterator.hasNext()) {
            if (!this.hasNextBaseRecord(this.baseFileIterator.next())) continue;
            return true;
        }
        return this.hasNextLogRecord();
    }
}

