/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.dto;

import org.apache.hudi.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.hudi.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.hudi.common.table.timeline.dto.FilePathDTO;
import org.apache.hudi.storage.StoragePathInfo;

@JsonIgnoreProperties(ignoreUnknown=true)
public class FileStatusDTO {
    @JsonProperty(value="path")
    FilePathDTO path;
    @JsonProperty(value="length")
    long length;
    @JsonProperty(value="isdir")
    boolean isdir;
    @JsonProperty(value="blockReplication")
    short blockReplication;
    @JsonProperty(value="blocksize")
    long blocksize;
    @JsonProperty(value="modificationTime")
    long modificationTime;

    public static FileStatusDTO fromStoragePathInfo(StoragePathInfo pathInfo) {
        if (null == pathInfo) {
            return null;
        }
        FileStatusDTO dto = new FileStatusDTO();
        dto.path = FilePathDTO.fromStoragePath(pathInfo.getPath());
        dto.length = pathInfo.getLength();
        dto.blocksize = pathInfo.getBlockSize();
        dto.isdir = pathInfo.isDirectory();
        dto.modificationTime = pathInfo.getModificationTime();
        return dto;
    }

    public static StoragePathInfo toStoragePathInfo(FileStatusDTO dto) {
        if (null == dto) {
            return null;
        }
        return new StoragePathInfo(FilePathDTO.toStoragePath(dto.path), dto.length, dto.isdir, dto.blockReplication, dto.blocksize, dto.modificationTime);
    }
}

