/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.v1;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.timeline.TimelineUtils;
import org.apache.hudi.common.table.timeline.versioning.v1.BaseTimelineV1;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantFileNameGeneratorV1;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveTimelineV1
extends BaseTimelineV1
implements HoodieActiveTimeline {
    public static final Set<String> VALID_EXTENSIONS_IN_ACTIVE_TIMELINE = new HashSet<String>(Arrays.asList(".commit", ".inflight", ".commit.requested", ".deltacommit", ".deltacommit.inflight", ".deltacommit.requested", ".savepoint", ".savepoint.inflight", ".clean", ".clean.requested", ".clean.inflight", INFLIGHT_COMPACTION_EXTENSION, REQUESTED_COMPACTION_EXTENSION, ".restore.requested", ".restore.inflight", ".restore", INFLIGHT_LOG_COMPACTION_EXTENSION, REQUESTED_LOG_COMPACTION_EXTENSION, ".rollback", ".rollback.requested", ".rollback.inflight", ".replacecommit.requested", ".replacecommit.inflight", ".replacecommit", ".indexing.requested", ".indexing.inflight", ".indexing", ".schemacommit.requested", ".schemacommit.inflight", ".schemacommit"));
    private static final Logger LOG = LoggerFactory.getLogger(ActiveTimelineV1.class);
    protected HoodieTableMetaClient metaClient;
    private final InstantFileNameGenerator instantFileNameGenerator = new InstantFileNameGeneratorV1();

    protected ActiveTimelineV1(HoodieTableMetaClient metaClient, Set<String> includedExtensions, boolean applyLayoutFilters) {
        try {
            this.setInstants(metaClient.scanHoodieInstantsFromFileSystem(metaClient.getTimelinePath(), includedExtensions, applyLayoutFilters));
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to scan metadata", e);
        }
        this.metaClient = metaClient;
        this.details = this::getInstantDetails;
        LOG.info("Loaded instants upto : " + this.lastInstant());
    }

    public ActiveTimelineV1(HoodieTableMetaClient metaClient) {
        this(metaClient, Collections.unmodifiableSet(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE), true);
    }

    public ActiveTimelineV1(HoodieTableMetaClient metaClient, boolean applyLayoutFilter) {
        this(metaClient, Collections.unmodifiableSet(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE), applyLayoutFilter);
    }

    @Deprecated
    public ActiveTimelineV1() {
    }

    @Deprecated
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    @Override
    public Set<String> getValidExtensionsInActiveTimeline() {
        return Collections.unmodifiableSet(VALID_EXTENSIONS_IN_ACTIVE_TIMELINE);
    }

    @Override
    public void createCompleteInstant(HoodieInstant instant) {
        LOG.info("Creating a new complete instant " + instant);
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.empty(), false);
    }

    @Override
    public void createNewInstant(HoodieInstant instant) {
        LOG.info("Creating a new instant " + instant);
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), Option.empty(), false);
    }

    @Override
    public void createRequestedCommitWithReplaceMetadata(String instantTime, String actionType) {
        try {
            HoodieInstant instant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, actionType, instantTime);
            LOG.info("Creating a new instant " + instant);
            this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), TimelineMetadataUtils.serializeRequestedReplaceMetadata(new HoodieRequestedReplaceMetadata()), false);
        }
        catch (IOException e) {
            throw new HoodieIOException("Error create requested replace commit ", e);
        }
    }

    @Override
    public void saveAsComplete(HoodieInstant instant, Option<byte[]> data) {
        LOG.info("Marking instant complete " + instant);
        ValidationUtils.checkArgument(instant.isInflight(), "Could not mark an already completed instant as complete again " + instant);
        this.transitionState(instant, this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, instant.getAction(), instant.requestedTime()), data);
        LOG.info("Completed " + instant);
    }

    @Override
    public void saveAsComplete(boolean shouldLock, HoodieInstant instant, Option<byte[]> data) {
        this.saveAsComplete(instant, data);
    }

    @Override
    public HoodieInstant revertToInflight(HoodieInstant instant) {
        LOG.info("Reverting instant to inflight " + instant);
        HoodieInstant inflight = TimelineUtils.getInflightInstant(instant, this.metaClient);
        this.revertCompleteToInflight(instant, inflight);
        LOG.info("Reverted " + instant + " to inflight " + inflight);
        return inflight;
    }

    @Override
    public void deleteInflight(HoodieInstant instant) {
        ValidationUtils.checkArgument(instant.isInflight());
        this.deleteInstantFile(instant);
    }

    @Override
    public void deletePending(HoodieInstant instant) {
        ValidationUtils.checkArgument(!instant.isCompleted());
        this.deleteInstantFile(instant);
    }

    @Override
    public void deleteCompletedRollback(HoodieInstant instant) {
        ValidationUtils.checkArgument(instant.isCompleted());
        this.deleteInstantFile(instant);
    }

    @Override
    public void deleteEmptyInstantIfExists(HoodieInstant instant) {
        ValidationUtils.checkArgument(this.isEmpty(instant));
        this.deleteInstantFileIfExists(instant);
    }

    @Override
    public void deleteCompactionRequested(HoodieInstant instant) {
        ValidationUtils.checkArgument(instant.isRequested());
        ValidationUtils.checkArgument(Objects.equals(instant.getAction(), "compaction"));
        this.deleteInstantFile(instant);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void deleteInstantFileIfExists(HoodieInstant instant) {
        LOG.info("Deleting instant " + instant);
        StoragePath commitFilePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(instant));
        try {
            if (this.metaClient.getStorage().exists(commitFilePath)) {
                boolean result = this.metaClient.getStorage().deleteFile(commitFilePath);
                if (!result) throw new HoodieIOException("Could not delete instant " + instant + " with path " + commitFilePath);
                LOG.info("Removed instant " + instant);
                return;
            } else {
                LOG.warn("The commit " + commitFilePath + " to remove does not exist");
            }
            return;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not remove commit " + commitFilePath, e);
        }
    }

    private void deleteInstantFile(HoodieInstant instant) {
        LOG.info("Deleting instant " + instant);
        StoragePath inFlightCommitFilePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(instant));
        try {
            boolean result = this.metaClient.getStorage().deleteFile(inFlightCommitFilePath);
            if (!result) {
                throw new HoodieIOException("Could not delete instant " + instant + " with path " + inFlightCommitFilePath);
            }
            LOG.info("Removed instant " + instant);
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not remove inflight commit " + inFlightCommitFilePath, e);
        }
    }

    @Override
    public Option<byte[]> getInstantDetails(HoodieInstant instant) {
        StoragePath detailPath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(instant));
        return this.readDataFromPath(detailPath);
    }

    @Override
    public Option<Pair<HoodieInstant, HoodieCommitMetadata>> getLastCommitMetadataWithValidSchema() {
        return Option.fromJavaOptional(this.getCommitMetadataStream().filter((? super T instantCommitMetadataPair) -> WriteOperationType.canUpdateSchema(((HoodieCommitMetadata)instantCommitMetadataPair.getRight()).getOperationType()) && !StringUtils.isNullOrEmpty(((HoodieCommitMetadata)instantCommitMetadataPair.getValue()).getMetadata("schema"))).findFirst());
    }

    @Override
    public Option<Pair<HoodieInstant, HoodieCommitMetadata>> getLastCommitMetadataWithValidData() {
        return Option.fromJavaOptional(this.getCommitMetadataStream().filter((? super T instantCommitMetadataPair) -> !((HoodieCommitMetadata)instantCommitMetadataPair.getValue()).getFileIdAndRelativePaths().isEmpty()).findFirst());
    }

    private Stream<Pair<HoodieInstant, HoodieCommitMetadata>> getCommitMetadataStream() {
        return this.getCommitsTimeline().filterCompletedInstants().getInstantsAsStream().sorted(Comparator.comparing(HoodieInstant::requestedTime).reversed()).map(instant -> {
            try {
                HoodieCommitMetadata commitMetadata = this.metaClient.getCommitMetadataSerDe().deserialize((HoodieInstant)instant, this.getInstantDetails((HoodieInstant)instant).get(), HoodieCommitMetadata.class);
                return Pair.of(instant, commitMetadata);
            }
            catch (IOException e) {
                throw new HoodieIOException(String.format("Failed to fetch HoodieCommitMetadata for instant (%s)", instant), e);
            }
        });
    }

    @Override
    public Option<byte[]> readCleanerInfoAsBytes(HoodieInstant instant) {
        return this.readDataFromPath(this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(instant)));
    }

    @Override
    public Option<byte[]> readRollbackInfoAsBytes(HoodieInstant instant) {
        return this.readDataFromPath(this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(instant)));
    }

    @Override
    public Option<byte[]> readRestoreInfoAsBytes(HoodieInstant instant) {
        return this.readDataFromPath(new StoragePath(this.metaClient.getTimelinePath(), this.instantFileNameGenerator.getFileName(instant)));
    }

    @Override
    public Option<byte[]> readCompactionPlanAsBytes(HoodieInstant instant) {
        return this.readDataFromPath(new StoragePath(this.metaClient.getTimelinePath(), this.instantFileNameGenerator.getFileName(instant)));
    }

    @Override
    public Option<byte[]> readIndexPlanAsBytes(HoodieInstant instant) {
        return this.readDataFromPath(new StoragePath(this.metaClient.getTimelinePath(), this.instantFileNameGenerator.getFileName(instant)));
    }

    @Override
    public HoodieInstant revertInstantFromInflightToRequested(HoodieInstant inflightInstant) {
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant requestedInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, inflightInstant.getAction(), inflightInstant.requestedTime());
        if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            this.transitionState(inflightInstant, requestedInstant, Option.empty());
        } else {
            this.deleteInflight(inflightInstant);
        }
        return requestedInstant;
    }

    @Override
    public HoodieInstant revertLogCompactionInflightToRequested(HoodieInstant inflightInstant) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("logcompaction"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant requestedInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "logcompaction", inflightInstant.requestedTime());
        if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            this.transitionState(inflightInstant, requestedInstant, Option.empty());
        } else {
            this.deleteInflight(inflightInstant);
        }
        return requestedInstant;
    }

    @Override
    public HoodieInstant transitionCompactionRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("compaction"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "compaction", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflightInstant, Option.empty());
        return inflightInstant;
    }

    @Override
    public HoodieInstant transitionLogCompactionRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("logcompaction"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "logcompaction", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflightInstant, Option.empty());
        return inflightInstant;
    }

    @Override
    public HoodieInstant transitionCompactionInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("compaction"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "commit", inflightInstant.requestedTime());
        this.transitionState(inflightInstant, commitInstant, data);
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionLogCompactionInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("logcompaction"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "deltacommit", inflightInstant.requestedTime());
        this.transitionState(inflightInstant, commitInstant, data);
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionCleanInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("clean"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "clean", inflightInstant.requestedTime());
        this.transitionState(inflightInstant, commitInstant, data);
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionCleanRequestedToInflight(HoodieInstant requestedInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("clean"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflight = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "clean", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflight, data);
        return inflight;
    }

    @Override
    public HoodieInstant transitionRollbackInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("rollback"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "rollback", inflightInstant.requestedTime());
        this.transitionState(inflightInstant, commitInstant, data);
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionRollbackRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("rollback"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflight = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "rollback", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflight, Option.empty());
        return inflight;
    }

    @Override
    public HoodieInstant transitionRestoreRequestedToInflight(HoodieInstant requestedInstant) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("restore"), "Transition to inflight requested for a restore instant with diff action " + requestedInstant.toString());
        ValidationUtils.checkArgument(requestedInstant.isRequested(), "Transition to inflight requested for an instant not in requested state " + requestedInstant.toString());
        HoodieInstant inflight = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "restore", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflight, Option.empty());
        return inflight;
    }

    @Override
    public HoodieInstant transitionReplaceRequestedToInflight(HoodieInstant requestedInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("replacecommit"));
        ValidationUtils.checkArgument(requestedInstant.isRequested());
        HoodieInstant inflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "replacecommit", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflightInstant, data);
        return inflightInstant;
    }

    @Override
    public HoodieInstant transitionClusterRequestedToInflight(HoodieInstant requestedInstant, Option<byte[]> data) {
        return this.transitionReplaceRequestedToInflight(requestedInstant, data);
    }

    @Override
    public HoodieInstant transitionReplaceInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("replacecommit"));
        ValidationUtils.checkArgument(inflightInstant.isInflight());
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "replacecommit", inflightInstant.requestedTime());
        this.transitionState(inflightInstant, commitInstant, data);
        return commitInstant;
    }

    @Override
    public HoodieInstant transitionClusterInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, Option<byte[]> data) {
        return this.transitionReplaceInflightToComplete(shouldLock, inflightInstant, data);
    }

    private void transitionState(HoodieInstant fromInstant, HoodieInstant toInstant, Option<byte[]> data) {
        this.transitionState(fromInstant, toInstant, data, false);
    }

    protected void transitionState(HoodieInstant fromInstant, HoodieInstant toInstant, Option<byte[]> data, boolean allowRedundantTransitions) {
        ValidationUtils.checkArgument(fromInstant.requestedTime().equals(toInstant.requestedTime()), String.format("%s and %s are not consistent when transition state.", fromInstant, toInstant));
        try {
            HoodieStorage storage = this.metaClient.getStorage();
            if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
                this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(fromInstant), data, allowRedundantTransitions);
                StoragePath fromInstantPath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(fromInstant));
                StoragePath toInstantPath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(toInstant));
                boolean success = storage.rename(fromInstantPath, toInstantPath);
                if (!success) {
                    throw new HoodieIOException("Could not rename " + fromInstantPath + " to " + toInstantPath);
                }
            } else {
                ValidationUtils.checkArgument(storage.exists(this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(fromInstant))), "File " + this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(fromInstant)) + " does not exist!");
                if (allowRedundantTransitions) {
                    FileIOUtils.createFileInPath(storage, this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(toInstant)), data);
                } else {
                    storage.createImmutableFileInPath(this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(toInstant)), data);
                }
                LOG.info("Create new file for toInstant ?" + this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(toInstant)));
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not complete " + fromInstant, e);
        }
    }

    protected void revertCompleteToInflight(HoodieInstant completed, HoodieInstant inflight) {
        ValidationUtils.checkArgument(completed.requestedTime().equals(inflight.requestedTime()));
        StoragePath inFlightCommitFilePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(inflight));
        StoragePath commitFilePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(completed));
        try {
            if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
                boolean success;
                if (!this.metaClient.getStorage().exists(inFlightCommitFilePath) && !(success = this.metaClient.getStorage().rename(commitFilePath, inFlightCommitFilePath))) {
                    throw new HoodieIOException("Could not rename " + commitFilePath + " to " + inFlightCommitFilePath);
                }
            } else {
                StoragePath requestedInstantFilePath = this.getInstantFileNamePath(this.instantFileNameGenerator.getFileName(this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, inflight.getAction(), inflight.requestedTime())));
                if (!this.metaClient.getStorage().exists(requestedInstantFilePath)) {
                    this.metaClient.getStorage().create(requestedInstantFilePath, false).close();
                }
                if (!this.metaClient.getStorage().exists(inFlightCommitFilePath)) {
                    this.metaClient.getStorage().create(inFlightCommitFilePath, false).close();
                }
                boolean success = this.metaClient.getStorage().deleteFile(commitFilePath);
                ValidationUtils.checkArgument(success, "State Reverting failed");
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not complete revert " + completed, e);
        }
    }

    private StoragePath getInstantFileNamePath(String fileName) {
        return new StoragePath(fileName.contains("schemacommit") ? this.metaClient.getSchemaFolderName() : this.metaClient.getTimelinePath().toString(), fileName);
    }

    @Override
    public void transitionRequestedToInflight(String commitType, String inFlightInstant) {
        HoodieInstant requested = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, commitType, inFlightInstant);
        this.transitionRequestedToInflight(requested, Option.empty(), false);
    }

    @Override
    public void transitionRequestedToInflight(HoodieInstant requested, Option<byte[]> content) {
        this.transitionRequestedToInflight(requested, content, false);
    }

    @Override
    public void transitionRequestedToInflight(HoodieInstant requested, Option<byte[]> content, boolean allowRedundantTransitions) {
        HoodieInstant inflight = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, requested.getAction(), requested.requestedTime());
        ValidationUtils.checkArgument(requested.isRequested(), "Instant " + requested + " in wrong state");
        this.transitionState(requested, inflight, content, allowRedundantTransitions);
    }

    @Override
    public void saveToCompactionRequested(HoodieInstant instant, Option<byte[]> content) {
        this.saveToCompactionRequested(instant, content, false);
    }

    @Override
    public void saveToCompactionRequested(HoodieInstant instant, Option<byte[]> content, boolean overwrite) {
        ValidationUtils.checkArgument(instant.getAction().equals("compaction"));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), content, overwrite);
    }

    @Override
    public void saveToLogCompactionRequested(HoodieInstant instant, Option<byte[]> content) {
        this.saveToLogCompactionRequested(instant, content, false);
    }

    @Override
    public void saveToLogCompactionRequested(HoodieInstant instant, Option<byte[]> content, boolean overwrite) {
        ValidationUtils.checkArgument(instant.getAction().equals("logcompaction"));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), content, overwrite);
    }

    @Override
    public void saveToPendingReplaceCommit(HoodieInstant instant, Option<byte[]> content) {
        ValidationUtils.checkArgument(instant.getAction().equals("replacecommit"));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), content, false);
    }

    @Override
    public void saveToPendingClusterCommit(HoodieInstant instant, Option<byte[]> content) {
        this.saveToPendingReplaceCommit(instant, content);
    }

    @Override
    public void saveToCleanRequested(HoodieInstant instant, Option<byte[]> content) {
        ValidationUtils.checkArgument(instant.getAction().equals("clean"));
        ValidationUtils.checkArgument(instant.getState().equals((Object)HoodieInstant.State.REQUESTED));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), content, false);
    }

    @Override
    public void saveToRollbackRequested(HoodieInstant instant, Option<byte[]> content) {
        ValidationUtils.checkArgument(instant.getAction().equals("rollback"));
        ValidationUtils.checkArgument(instant.getState().equals((Object)HoodieInstant.State.REQUESTED));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), content, false);
    }

    @Override
    public void saveToRestoreRequested(HoodieInstant instant, Option<byte[]> content) {
        ValidationUtils.checkArgument(instant.getAction().equals("restore"));
        ValidationUtils.checkArgument(instant.getState().equals((Object)HoodieInstant.State.REQUESTED));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), content, false);
    }

    @Override
    public HoodieInstant transitionIndexRequestedToInflight(HoodieInstant requestedInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(requestedInstant.getAction().equals("indexing"), String.format("%s is not equal to %s action", requestedInstant.getAction(), "indexing"));
        ValidationUtils.checkArgument(requestedInstant.isRequested(), String.format("Instant %s not in requested state", requestedInstant.requestedTime()));
        HoodieInstant inflightInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "indexing", requestedInstant.requestedTime());
        this.transitionState(requestedInstant, inflightInstant, data);
        return inflightInstant;
    }

    @Override
    public HoodieInstant transitionIndexInflightToComplete(boolean shouldLock, HoodieInstant inflightInstant, Option<byte[]> data) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("indexing"), String.format("%s is not equal to %s action", inflightInstant.getAction(), "indexing"));
        ValidationUtils.checkArgument(inflightInstant.isInflight(), String.format("Instant %s not inflight", inflightInstant.requestedTime()));
        HoodieInstant commitInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.COMPLETED, "indexing", inflightInstant.requestedTime());
        this.transitionState(inflightInstant, commitInstant, data);
        return commitInstant;
    }

    @Override
    public HoodieInstant revertIndexInflightToRequested(HoodieInstant inflightInstant) {
        ValidationUtils.checkArgument(inflightInstant.getAction().equals("indexing"), String.format("%s is not equal to %s action", inflightInstant.getAction(), "indexing"));
        ValidationUtils.checkArgument(inflightInstant.isInflight(), String.format("Instant %s not inflight", inflightInstant.requestedTime()));
        HoodieInstant requestedInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "indexing", inflightInstant.requestedTime());
        if (this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            this.transitionState(inflightInstant, requestedInstant, Option.empty());
        } else {
            this.deleteInflight(inflightInstant);
        }
        return requestedInstant;
    }

    @Override
    public void saveToPendingIndexAction(HoodieInstant instant, Option<byte[]> content) {
        ValidationUtils.checkArgument(instant.getAction().equals("indexing"), String.format("%s is not equal to %s action", instant.getAction(), "indexing"));
        this.createFileInMetaPath(this.instantFileNameGenerator.getFileName(instant), content, false);
    }

    public void createFileInMetaPath(String filename, Option<byte[]> content, boolean allowOverwrite) {
        StoragePath fullPath = this.getInstantFileNamePath(filename);
        if (allowOverwrite || this.metaClient.getTimelineLayoutVersion().isNullVersion()) {
            FileIOUtils.createFileInPath(this.metaClient.getStorage(this.metaClient.getTimelinePath()), fullPath, content);
        } else {
            this.metaClient.getStorage(this.metaClient.getTimelinePath()).createImmutableFileInPath(fullPath, content);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Option<byte[]> readDataFromPath(StoragePath detailPath) {
        try (InputStream is = this.metaClient.getStorage().open(detailPath);){
            Option<byte[]> option = Option.of(FileIOUtils.readAsByteArray(is));
            return option;
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not read commit details from " + detailPath, e);
        }
    }

    @Override
    public HoodieActiveTimeline reload() {
        return new ActiveTimelineV1(this.metaClient);
    }

    @Override
    public void copyInstant(HoodieInstant instant, StoragePath dstDir) {
        StoragePath srcPath = new StoragePath(this.metaClient.getTimelinePath(), this.instantFileNameGenerator.getFileName(instant));
        StoragePath dstPath = new StoragePath(dstDir, this.instantFileNameGenerator.getFileName(instant));
        try {
            HoodieStorage storage = this.metaClient.getStorage();
            storage.createDirectory(dstDir);
            FileIOUtils.copy(storage, srcPath, storage, dstPath, false, true);
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not copy instant from " + srcPath + " to " + dstPath, e);
        }
    }

    @Override
    public Set<String> getValidExtensions() {
        return Collections.emptySet();
    }
}

