/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.model.BootstrapBaseFileMapping;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.IncrementalTimelineSyncFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieTableFileSystemView
extends IncrementalTimelineSyncFileSystemView {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieTableFileSystemView.class);
    protected Map<String, List<HoodieFileGroup>> partitionToFileGroupsMap;
    protected Map<HoodieFileGroupId, Pair<String, CompactionOperation>> fgIdToPendingCompaction;
    protected Map<HoodieFileGroupId, Pair<String, CompactionOperation>> fgIdToPendingLogCompaction;
    protected Map<HoodieFileGroupId, BootstrapBaseFileMapping> fgIdToBootstrapBaseFile;
    protected Map<HoodieFileGroupId, HoodieInstant> fgIdToReplaceInstants;
    protected Map<HoodieFileGroupId, HoodieInstant> fgIdToPendingClustering;
    private boolean closed = false;

    HoodieTableFileSystemView(boolean enableIncrementalTimelineSync) {
        super(enableIncrementalTimelineSync);
    }

    public HoodieTableFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline) {
        this(metaClient, visibleActiveTimeline, false);
    }

    public HoodieTableFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, boolean enableIncrementalTimelineSync) {
        super(enableIncrementalTimelineSync);
        this.init(metaClient, visibleActiveTimeline);
    }

    @Override
    public void init(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline) {
        this.partitionToFileGroupsMap = this.createPartitionToFileGroups();
        super.init(metaClient, visibleActiveTimeline);
    }

    public void init(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, List<StoragePathInfo> pathInfoList) {
        this.init(metaClient, visibleActiveTimeline);
        this.addFilesToView(pathInfoList);
    }

    @Override
    protected void resetViewState() {
    }

    protected Map<String, List<HoodieFileGroup>> createPartitionToFileGroups() {
        return new ConcurrentHashMap<String, List<HoodieFileGroup>>();
    }

    protected Map<HoodieFileGroupId, Pair<String, CompactionOperation>> createFileIdToPendingCompactionMap(Map<HoodieFileGroupId, Pair<String, CompactionOperation>> fileIdToPendingCompaction) {
        return new ConcurrentHashMap<HoodieFileGroupId, Pair<String, CompactionOperation>>(fileIdToPendingCompaction);
    }

    protected Map<HoodieFileGroupId, Pair<String, CompactionOperation>> createFileIdToPendingLogCompactionMap(Map<HoodieFileGroupId, Pair<String, CompactionOperation>> fileIdToPendingLogCompaction) {
        return new ConcurrentHashMap<HoodieFileGroupId, Pair<String, CompactionOperation>>(fileIdToPendingLogCompaction);
    }

    protected Map<HoodieFileGroupId, BootstrapBaseFileMapping> createFileIdToBootstrapBaseFileMap(Map<HoodieFileGroupId, BootstrapBaseFileMapping> fileGroupIdBootstrapBaseFileMap) {
        return new ConcurrentHashMap<HoodieFileGroupId, BootstrapBaseFileMapping>(fileGroupIdBootstrapBaseFileMap);
    }

    protected Map<HoodieFileGroupId, HoodieInstant> createFileIdToReplaceInstantMap(Map<HoodieFileGroupId, HoodieInstant> replacedFileGroups) {
        return new ConcurrentHashMap<HoodieFileGroupId, HoodieInstant>(replacedFileGroups);
    }

    protected Map<HoodieFileGroupId, HoodieInstant> createFileIdToPendingClusteringMap(Map<HoodieFileGroupId, HoodieInstant> fileGroupsInClustering) {
        return new ConcurrentHashMap<HoodieFileGroupId, HoodieInstant>(fileGroupsInClustering);
    }

    public HoodieTableFileSystemView(HoodieTableMetaClient metaClient, HoodieTimeline visibleActiveTimeline, List<StoragePathInfo> pathInfoList) {
        this(metaClient, visibleActiveTimeline);
        this.addFilesToView(pathInfoList);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    @Override
    protected boolean isPendingCompactionScheduledForFileId(HoodieFileGroupId fgId) {
        return this.fgIdToPendingCompaction.containsKey(fgId);
    }

    @Override
    protected void resetPendingCompactionOperations(Stream<Pair<String, CompactionOperation>> operations) {
        this.fgIdToPendingCompaction = this.createFileIdToPendingCompactionMap(operations.map(entry -> Pair.of(((CompactionOperation)entry.getValue()).getFileGroupId(), Pair.of(entry.getKey(), entry.getValue()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
    }

    @Override
    protected void addPendingCompactionOperations(Stream<Pair<String, CompactionOperation>> operations) {
        operations.forEach(opInstantPair -> {
            ValidationUtils.checkArgument(!this.fgIdToPendingCompaction.containsKey(((CompactionOperation)opInstantPair.getValue()).getFileGroupId()), "Duplicate FileGroupId found in pending compaction operations. FgId :" + ((CompactionOperation)opInstantPair.getValue()).getFileGroupId());
            this.fgIdToPendingCompaction.put(((CompactionOperation)opInstantPair.getValue()).getFileGroupId(), Pair.of(opInstantPair.getKey(), opInstantPair.getValue()));
        });
    }

    @Override
    protected void removePendingCompactionOperations(Stream<Pair<String, CompactionOperation>> operations) {
        operations.forEach(opInstantPair -> {
            ValidationUtils.checkArgument(this.fgIdToPendingCompaction.containsKey(((CompactionOperation)opInstantPair.getValue()).getFileGroupId()), "Trying to remove a FileGroupId which is not found in pending compaction operations. FgId :" + ((CompactionOperation)opInstantPair.getValue()).getFileGroupId());
            this.fgIdToPendingCompaction.remove(((CompactionOperation)opInstantPair.getValue()).getFileGroupId());
        });
    }

    @Override
    protected boolean isPendingLogCompactionScheduledForFileId(HoodieFileGroupId fgId) {
        return this.fgIdToPendingLogCompaction.containsKey(fgId);
    }

    @Override
    protected void resetPendingLogCompactionOperations(Stream<Pair<String, CompactionOperation>> operations) {
        this.fgIdToPendingLogCompaction = this.createFileIdToPendingLogCompactionMap(operations.map(entry -> Pair.of(((CompactionOperation)entry.getValue()).getFileGroupId(), Pair.of(entry.getKey(), entry.getValue()))).collect(Collectors.toMap(Pair::getKey, Pair::getValue)));
    }

    @Override
    protected void addPendingLogCompactionOperations(Stream<Pair<String, CompactionOperation>> operations) {
        operations.forEach(opInstantPair -> {
            ValidationUtils.checkArgument(!this.fgIdToPendingLogCompaction.containsKey(((CompactionOperation)opInstantPair.getValue()).getFileGroupId()), "Duplicate FileGroupId found in pending log compaction operations. FgId :" + ((CompactionOperation)opInstantPair.getValue()).getFileGroupId());
            this.fgIdToPendingLogCompaction.put(((CompactionOperation)opInstantPair.getValue()).getFileGroupId(), Pair.of(opInstantPair.getKey(), opInstantPair.getValue()));
        });
    }

    @Override
    protected void removePendingLogCompactionOperations(Stream<Pair<String, CompactionOperation>> operations) {
        operations.forEach(opInstantPair -> {
            ValidationUtils.checkArgument(this.fgIdToPendingLogCompaction.containsKey(((CompactionOperation)opInstantPair.getValue()).getFileGroupId()), "Trying to remove a FileGroupId which is not found in pending log compaction operations. FgId :" + ((CompactionOperation)opInstantPair.getValue()).getFileGroupId());
            this.fgIdToPendingLogCompaction.remove(((CompactionOperation)opInstantPair.getValue()).getFileGroupId());
        });
    }

    @Override
    protected boolean isPendingClusteringScheduledForFileId(HoodieFileGroupId fgId) {
        return this.fgIdToPendingClustering.containsKey(fgId);
    }

    @Override
    protected Option<HoodieInstant> getPendingClusteringInstant(HoodieFileGroupId fgId) {
        return Option.ofNullable(this.fgIdToPendingClustering.get(fgId));
    }

    @Override
    protected Stream<Pair<HoodieFileGroupId, HoodieInstant>> fetchFileGroupsInPendingClustering() {
        return this.fgIdToPendingClustering.entrySet().stream().map(entry -> Pair.of(entry.getKey(), entry.getValue()));
    }

    @Override
    void resetFileGroupsInPendingClustering(Map<HoodieFileGroupId, HoodieInstant> fgIdToInstantMap) {
        this.fgIdToPendingClustering = this.createFileIdToPendingClusteringMap(fgIdToInstantMap);
    }

    @Override
    void addFileGroupsInPendingClustering(Stream<Pair<HoodieFileGroupId, HoodieInstant>> fileGroups) {
        fileGroups.forEach(fileGroupInstantPair -> {
            ValidationUtils.checkArgument(this.fgIdToPendingClustering.containsKey(fileGroupInstantPair.getLeft()), "Trying to add a FileGroupId which is already in pending clustering operation. FgId :" + fileGroupInstantPair.getLeft() + ", new instant: " + fileGroupInstantPair.getRight() + ", existing instant " + this.fgIdToPendingClustering.get(fileGroupInstantPair.getLeft()));
            this.fgIdToPendingClustering.put((HoodieFileGroupId)fileGroupInstantPair.getLeft(), (HoodieInstant)fileGroupInstantPair.getRight());
        });
    }

    @Override
    void removeFileGroupsInPendingClustering(Stream<Pair<HoodieFileGroupId, HoodieInstant>> fileGroups) {
        fileGroups.forEach(fileGroupInstantPair -> {
            ValidationUtils.checkArgument(this.fgIdToPendingClustering.containsKey(fileGroupInstantPair.getLeft()), "Trying to remove a FileGroupId which is not found in pending clustering operation. FgId :" + fileGroupInstantPair.getLeft() + ", new instant: " + fileGroupInstantPair.getRight());
            this.fgIdToPendingClustering.remove(fileGroupInstantPair.getLeft());
        });
    }

    @Override
    Stream<HoodieFileGroup> fetchAllStoredFileGroups(String partition) {
        List<HoodieFileGroup> fileGroups = this.partitionToFileGroupsMap.get(partition);
        if (fileGroups == null || fileGroups.isEmpty()) {
            LOG.warn("Partition: {} is not available in store", (Object)partition);
            return Stream.empty();
        }
        return new ArrayList(this.partitionToFileGroupsMap.get(partition)).stream();
    }

    public Stream<HoodieFileGroup> getAllFileGroups() {
        return this.fetchAllStoredFileGroups();
    }

    @Override
    Stream<Pair<String, CompactionOperation>> fetchPendingCompactionOperations() {
        return this.fgIdToPendingCompaction.values().stream();
    }

    @Override
    Stream<Pair<String, CompactionOperation>> fetchPendingLogCompactionOperations() {
        return this.fgIdToPendingLogCompaction.values().stream();
    }

    @Override
    protected boolean isBootstrapBaseFilePresentForFileId(HoodieFileGroupId fgId) {
        return this.fgIdToBootstrapBaseFile.containsKey(fgId);
    }

    @Override
    void resetBootstrapBaseFileMapping(Stream<BootstrapBaseFileMapping> bootstrapBaseFileStream) {
        this.fgIdToBootstrapBaseFile = this.createFileIdToBootstrapBaseFileMap(bootstrapBaseFileStream.collect(Collectors.toMap(BootstrapBaseFileMapping::getFileGroupId, x -> x)));
    }

    @Override
    void addBootstrapBaseFileMapping(Stream<BootstrapBaseFileMapping> bootstrapBaseFileStream) {
        bootstrapBaseFileStream.forEach(bootstrapBaseFile -> {
            ValidationUtils.checkArgument(!this.fgIdToBootstrapBaseFile.containsKey(bootstrapBaseFile.getFileGroupId()), "Duplicate FileGroupId found in bootstrap base file mapping. FgId :" + bootstrapBaseFile.getFileGroupId());
            this.fgIdToBootstrapBaseFile.put(bootstrapBaseFile.getFileGroupId(), (BootstrapBaseFileMapping)bootstrapBaseFile);
        });
    }

    @Override
    void removeBootstrapBaseFileMapping(Stream<BootstrapBaseFileMapping> bootstrapBaseFileStream) {
        bootstrapBaseFileStream.forEach(bootstrapBaseFile -> {
            ValidationUtils.checkArgument(this.fgIdToBootstrapBaseFile.containsKey(bootstrapBaseFile.getFileGroupId()), "Trying to remove a FileGroupId which is not found in bootstrap base file mapping. FgId :" + bootstrapBaseFile.getFileGroupId());
            this.fgIdToBootstrapBaseFile.remove(bootstrapBaseFile.getFileGroupId());
        });
    }

    @Override
    protected Option<BootstrapBaseFileMapping> getBootstrapBaseFile(HoodieFileGroupId fileGroupId) {
        return Option.ofNullable(this.fgIdToBootstrapBaseFile.get(fileGroupId));
    }

    @Override
    Stream<BootstrapBaseFileMapping> fetchBootstrapBaseFiles() {
        return this.fgIdToBootstrapBaseFile.values().stream();
    }

    @Override
    protected Option<Pair<String, CompactionOperation>> getPendingCompactionOperationWithInstant(HoodieFileGroupId fgId) {
        return Option.ofNullable(this.fgIdToPendingCompaction.get(fgId));
    }

    @Override
    protected Option<Pair<String, CompactionOperation>> getPendingLogCompactionOperationWithInstant(HoodieFileGroupId fgId) {
        return Option.ofNullable(this.fgIdToPendingLogCompaction.get(fgId));
    }

    @Override
    protected boolean isPartitionAvailableInStore(String partitionPath) {
        return this.partitionToFileGroupsMap.containsKey(partitionPath);
    }

    @Override
    protected void storePartitionView(String partitionPath, List<HoodieFileGroup> fileGroups) {
        LOG.debug("Adding file-groups for partition :" + partitionPath + ", #FileGroups=" + fileGroups.size());
        ArrayList<HoodieFileGroup> newList = new ArrayList<HoodieFileGroup>(fileGroups);
        this.partitionToFileGroupsMap.put(partitionPath, newList);
    }

    @Override
    public Stream<HoodieFileGroup> fetchAllStoredFileGroups() {
        return this.partitionToFileGroupsMap.values().stream().flatMap(Collection::stream);
    }

    @Override
    protected void resetReplacedFileGroups(Map<HoodieFileGroupId, HoodieInstant> replacedFileGroups) {
        this.fgIdToReplaceInstants = this.createFileIdToReplaceInstantMap(replacedFileGroups);
    }

    @Override
    protected void addReplacedFileGroups(Map<HoodieFileGroupId, HoodieInstant> replacedFileGroups) {
        this.fgIdToReplaceInstants.putAll(replacedFileGroups);
    }

    @Override
    protected void removeReplacedFileIdsAtInstants(Set<String> instants) {
        this.fgIdToReplaceInstants.entrySet().removeIf(entry -> instants.contains(((HoodieInstant)entry.getValue()).requestedTime()));
    }

    @Override
    protected boolean hasReplacedFilesInPartition(String partitionPath) {
        return this.fgIdToReplaceInstants.keySet().stream().anyMatch(fg -> fg.getPartitionPath().equals(partitionPath));
    }

    @Override
    protected Option<HoodieInstant> getReplaceInstant(HoodieFileGroupId fileGroupId) {
        return Option.ofNullable(this.fgIdToReplaceInstants.get(fileGroupId));
    }

    @Override
    public void close() {
        super.close();
        this.fgIdToPendingCompaction = null;
        this.fgIdToPendingLogCompaction = null;
        this.partitionToFileGroupsMap = null;
        this.fgIdToBootstrapBaseFile = null;
        this.fgIdToReplaceInstants = null;
        this.fgIdToPendingClustering = null;
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }
}

